/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.paho.mqttv5.common.packet;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.eclipse.paho.mqttv5.common.MqttException;
import org.eclipse.paho.mqttv5.common.packet.MqttAck;
import org.eclipse.paho.mqttv5.common.packet.MqttProperties;

public class MqttConnAck
extends MqttAck {
    public static final String KEY = "Con";
    private static final int[] validReturnCodes;
    private static final Byte[] validProperties;
    private boolean sessionPresent;
    private MqttProperties properties;

    static {
        int[] nArray = new int[20];
        nArray[1] = 128;
        nArray[2] = 129;
        nArray[3] = 130;
        nArray[4] = 131;
        nArray[5] = 132;
        nArray[6] = 133;
        nArray[7] = 134;
        nArray[8] = 135;
        nArray[9] = 136;
        nArray[10] = 137;
        nArray[11] = 138;
        nArray[12] = 140;
        nArray[13] = 144;
        nArray[14] = 149;
        nArray[15] = 151;
        nArray[16] = 154;
        nArray[17] = 156;
        nArray[18] = 157;
        nArray[19] = 159;
        validReturnCodes = nArray;
        validProperties = new Byte[]{(byte)17, (byte)33, (byte)36, (byte)37, (byte)39, (byte)18, (byte)34, (byte)40, (byte)41, (byte)42, (byte)19, (byte)26, (byte)28, (byte)21, (byte)22, (byte)31, (byte)38};
    }

    public MqttConnAck(byte[] variableHeader) throws IOException, MqttException {
        super((byte)2);
        this.properties = new MqttProperties(validProperties);
        ByteArrayInputStream bais = new ByteArrayInputStream(variableHeader);
        DataInputStream dis = new DataInputStream(bais);
        this.sessionPresent = (dis.readUnsignedByte() & 1) == 1;
        this.reasonCode = dis.readUnsignedByte();
        this.validateReturnCode(this.reasonCode, validReturnCodes);
        this.properties.decodeProperties(dis);
        dis.close();
    }

    public MqttConnAck(boolean sessionPresent, int returnCode, MqttProperties properties) throws MqttException {
        super((byte)2);
        this.properties = properties != null ? properties : new MqttProperties();
        this.properties.setValidProperties(validProperties);
        this.sessionPresent = sessionPresent;
        this.validateReturnCode(returnCode, validReturnCodes);
        this.reasonCode = returnCode;
    }

    @Override
    protected byte[] getVariableHeader() throws MqttException {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(baos);
            int connectAchnowledgeFlag = 0;
            if (this.sessionPresent) {
                connectAchnowledgeFlag = (byte)(connectAchnowledgeFlag | 1);
            }
            dos.write(connectAchnowledgeFlag);
            dos.write((byte)this.reasonCode);
            byte[] identifierValueFieldsByteArray = this.properties.encodeProperties();
            dos.write(identifierValueFieldsByteArray);
            dos.flush();
            return baos.toByteArray();
        }
        catch (IOException ioe) {
            throw new MqttException(ioe);
        }
    }

    @Override
    public boolean isMessageIdRequired() {
        return false;
    }

    @Override
    public String getKey() {
        return KEY;
    }

    public boolean getSessionPresent() {
        return this.sessionPresent;
    }

    public void setSessionPresent(boolean sessionPresent) {
        this.sessionPresent = sessionPresent;
    }

    public int getReturnCode() {
        return this.reasonCode;
    }

    public void setReturnCode(int returnCode) {
        this.reasonCode = returnCode;
    }

    @Override
    public MqttProperties getProperties() {
        return this.properties;
    }

    public static int[] getValidreturncodes() {
        return validReturnCodes;
    }

    @Override
    public String toString() {
        return "MqttConnAck [returnCode=" + this.reasonCode + ", sessionPresent=" + this.sessionPresent + ", properties=" + this.properties + "]";
    }
}

