/*
 * Copyright (c) 2019 the Eclipse Milo Authors
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 */

package org.eclipse.milo.opcua.sdk.server.nodes;

import org.eclipse.milo.opcua.sdk.core.Reference;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;

/**
 * @deprecated create a {@link org.eclipse.milo.opcua.sdk.server.model.nodes.variables.PropertyTypeNode} instead.
 */
@Deprecated
public class UaPropertyNode extends UaVariableNode {

    public UaPropertyNode(
        UaNodeContext context,
        NodeId nodeId,
        QualifiedName browseName,
        LocalizedText displayName) {

        super(context, nodeId, browseName, displayName);

        addReference(new Reference(
            nodeId,
            Identifiers.HasTypeDefinition,
            Identifiers.PropertyType.expanded(),
            true
        ));
    }

}
