/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.nodes.delegates;

import org.eclipse.milo.opcua.sdk.server.api.nodes.ReferenceTypeNode;
import org.eclipse.milo.opcua.sdk.server.nodes.AttributeContext;
import org.eclipse.milo.opcua.sdk.server.nodes.delegates.GetSetBase;
import org.eclipse.milo.opcua.sdk.server.util.AttributeUtil;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;

public interface GetSetReferenceTypeNode
extends GetSetBase {
    default public DataValue getReferenceTypeAttribute(AttributeContext context, ReferenceTypeNode node, AttributeId attributeId) throws UaException {
        switch (attributeId) {
            case IsAbstract: {
                return AttributeUtil.dv(this.getIsAbstract(context, node));
            }
            case Symmetric: {
                return AttributeUtil.dv(this.getSymmetric(context, node));
            }
            case InverseName: {
                return AttributeUtil.dv(this.getInverseName(context, node));
            }
        }
        return this.getBaseAttribute(context, node, attributeId);
    }

    default public void setReferenceTypeAttribute(AttributeContext context, ReferenceTypeNode node, AttributeId attributeId, DataValue value) throws UaException {
        switch (attributeId) {
            case IsAbstract: {
                this.setIsAbstract(context, node, (Boolean)AttributeUtil.extract(value));
                break;
            }
            case Symmetric: {
                this.setSymmetric(context, node, (Boolean)AttributeUtil.extract(value));
                break;
            }
            case InverseName: {
                this.setInverseName(context, node, (LocalizedText)AttributeUtil.extract(value));
                break;
            }
            default: {
                this.setBaseAttribute(context, node, attributeId, value);
            }
        }
    }

    default public Boolean getIsAbstract(AttributeContext context, ReferenceTypeNode node) throws UaException {
        return node.getIsAbstract();
    }

    default public Boolean getSymmetric(AttributeContext context, ReferenceTypeNode node) throws UaException {
        return node.getSymmetric();
    }

    default public LocalizedText getInverseName(AttributeContext context, ReferenceTypeNode node) throws UaException {
        return node.getInverseName();
    }

    default public void setIsAbstract(AttributeContext context, ReferenceTypeNode node, Boolean isAbstract) throws UaException {
        node.setIsAbstract(isAbstract);
    }

    default public void setSymmetric(AttributeContext context, ReferenceTypeNode node, Boolean symmetric) throws UaException {
        node.setSymmetric(symmetric);
    }

    default public void setInverseName(AttributeContext context, ReferenceTypeNode node, LocalizedText inverseName) throws UaException {
        node.setInverseName(inverseName);
    }
}

