/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.events.conversions;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.eclipse.milo.opcua.stack.core.BuiltinDataType;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;

final class NodeIdConversions {
    private NodeIdConversions() {
    }

    @Nonnull
    static ExpandedNodeId nodeIdToExpandedNodeId(@Nonnull NodeId nodeId) {
        return nodeId.expanded();
    }

    @Nonnull
    static String nodeIdToString(@Nonnull NodeId nodeId) {
        return nodeId.toParseableString();
    }

    @Nullable
    static Object convert(@Nonnull Object o, BuiltinDataType targetType, boolean implicit) {
        if (o instanceof NodeId) {
            NodeId nodeId = (NodeId)o;
            return implicit ? NodeIdConversions.implicitConversion(nodeId, targetType) : NodeIdConversions.explicitConversion(nodeId, targetType);
        }
        return null;
    }

    @Nullable
    static Object explicitConversion(@Nonnull NodeId nodeId, BuiltinDataType targetType) {
        return NodeIdConversions.implicitConversion(nodeId, targetType);
    }

    @Nullable
    static Object implicitConversion(@Nonnull NodeId nodeId, BuiltinDataType targetType) {
        switch (targetType) {
            case ExpandedNodeId: {
                return NodeIdConversions.nodeIdToExpandedNodeId(nodeId);
            }
            case String: {
                return NodeIdConversions.nodeIdToString(nodeId);
            }
        }
        return null;
    }
}

