/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.leshan.server.redis.serialization;

import com.eclipsesource.json.Json;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.InvalidParameterSpecException;
import java.util.Arrays;
import org.eclipse.leshan.core.util.Hex;
import org.eclipse.leshan.server.security.SecurityInfo;

public class SecurityInfoSerDes {
    public static byte[] serialize(SecurityInfo s) {
        JsonObject o = Json.object();
        o.set("ep", s.getEndpoint());
        if (s.getIdentity() != null) {
            o.set("id", s.getIdentity());
        }
        if (s.getPreSharedKey() != null) {
            o.set("psk", Hex.encodeHexString((byte[])s.getPreSharedKey()));
        }
        if (s.getRawPublicKey() != null) {
            JsonObject rpk = new JsonObject();
            ECPublicKey ecPublicKey = (ECPublicKey)s.getRawPublicKey();
            byte[] x = ecPublicKey.getW().getAffineX().toByteArray();
            if (x[0] == 0) {
                x = Arrays.copyOfRange(x, 1, x.length);
            }
            rpk.add("x", Hex.encodeHexString((byte[])x));
            byte[] y = ecPublicKey.getW().getAffineY().toByteArray();
            if (y[0] == 0) {
                y = Arrays.copyOfRange(y, 1, y.length);
            }
            rpk.add("y", Hex.encodeHexString((byte[])y));
            ecPublicKey.getParams();
            rpk.add("params", ecPublicKey.getParams().toString().split(" ")[0]);
            o.set("rpk", (JsonValue)rpk);
        }
        if (s.useX509Cert()) {
            o.set("x509", true);
        }
        return o.toString().getBytes();
    }

    public static SecurityInfo deserialize(byte[] data) {
        SecurityInfo i;
        JsonObject o = (JsonObject)Json.parse((String)new String(data));
        String ep = o.getString("ep", null);
        if (o.get("psk") != null) {
            i = SecurityInfo.newPreSharedKeyInfo((String)ep, (String)o.getString("id", null), (byte[])Hex.decodeHex((char[])o.getString("psk", null).toCharArray()));
        } else if (o.get("x509") != null) {
            i = SecurityInfo.newX509CertInfo((String)ep);
        } else {
            PublicKey key;
            JsonObject rpk = (JsonObject)o.get("rpk");
            try {
                byte[] x = Hex.decodeHex((char[])rpk.getString("x", null).toCharArray());
                byte[] y = Hex.decodeHex((char[])rpk.getString("y", null).toCharArray());
                String params = rpk.getString("params", null);
                AlgorithmParameters algoParameters = AlgorithmParameters.getInstance("EC");
                algoParameters.init(new ECGenParameterSpec(params));
                ECParameterSpec parameterSpec = algoParameters.getParameterSpec(ECParameterSpec.class);
                ECPublicKeySpec keySpec = new ECPublicKeySpec(new ECPoint(new BigInteger(x), new BigInteger(y)), parameterSpec);
                key = KeyFactory.getInstance("EC").generatePublic(keySpec);
            }
            catch (IllegalArgumentException | NoSuchAlgorithmException | InvalidKeySpecException | InvalidParameterSpecException e) {
                throw new IllegalStateException("Invalid security info content", e);
            }
            i = SecurityInfo.newRawPublicKeyInfo((String)ep, (PublicKey)key);
        }
        return i;
    }
}

