/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.leshan.server.redis.serialization;

import com.eclipsesource.json.Json;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.californium.core.coap.Request;
import org.eclipse.californium.core.network.serialization.DataParser;
import org.eclipse.californium.core.network.serialization.DataSerializer;
import org.eclipse.californium.core.network.serialization.UdpDataParser;
import org.eclipse.californium.core.network.serialization.UdpDataSerializer;
import org.eclipse.californium.core.observe.Observation;
import org.eclipse.californium.elements.EndpointContext;
import org.eclipse.leshan.core.util.Hex;
import org.eclipse.leshan.server.redis.serialization.EndpointContextSerDes;

public class ObservationSerDes {
    private static final DataSerializer serializer = new UdpDataSerializer();
    private static final DataParser parser = new UdpDataParser();

    public static byte[] serialize(Observation obs) {
        JsonObject o = Json.object();
        o.set("request", Hex.encodeHexString((byte[])ObservationSerDes.serializer.serializeRequest((Request)obs.getRequest()).bytes));
        if (obs.getContext() != null) {
            o.set("peer", (JsonValue)EndpointContextSerDes.serialize(obs.getContext()));
        } else {
            o.set("peer", (JsonValue)EndpointContextSerDes.serialize(obs.getRequest().getDestinationContext()));
        }
        if (obs.getRequest().getUserContext() != null) {
            JsonObject ctxObject = Json.object();
            for (Map.Entry e : obs.getRequest().getUserContext().entrySet()) {
                ctxObject.set((String)e.getKey(), (String)e.getValue());
            }
            o.set("context", (JsonValue)ctxObject);
        }
        return o.toString().getBytes();
    }

    public static Observation deserialize(byte[] data) {
        JsonObject v = (JsonObject)Json.parse((String)new String(data));
        EndpointContext endpointContext = EndpointContextSerDes.deserialize(v.get("peer").asObject());
        byte[] req = Hex.decodeHex((char[])v.getString("request", null).toCharArray());
        Request request = (Request)parser.parseMessage(req);
        request.setDestinationContext(endpointContext);
        JsonValue ctxValue = v.get("context");
        if (ctxValue != null) {
            HashMap<String, String> context = new HashMap<String, String>();
            JsonObject ctxObject = (JsonObject)ctxValue;
            for (String name : ctxObject.names()) {
                context.put(name, ctxObject.getString(name, null));
            }
            request.setUserContext(context);
        }
        return new Observation(request, endpointContext);
    }
}

