/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.leshan.server.redis;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Random;
import org.eclipse.leshan.core.util.Hex;
import org.eclipse.leshan.server.redis.JedisLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.Transaction;
import redis.clients.jedis.params.SetParams;

public class SingleInstanceJedisLock
implements JedisLock {
    private static final Logger LOG = LoggerFactory.getLogger(SingleInstanceJedisLock.class);
    protected final int DEFAULT_RANDOM_SIZE = 10;
    protected final int DEFAULT_VALUE_SIZE = 18;
    private final Random random = new Random();
    private final int expiration;
    private final long maxTime;
    private final long iterationTime;

    public SingleInstanceJedisLock() {
        this(500, 5000L, 10L);
    }

    public SingleInstanceJedisLock(int expiration, long maxTime, long iterationTime) {
        this.expiration = expiration;
        this.maxTime = maxTime;
        this.iterationTime = iterationTime;
    }

    @Override
    public byte[] acquire(Jedis j, byte[] lockKey) throws IllegalStateException {
        long start = System.currentTimeMillis();
        byte[] randomLockValue = this.generateLockValue(this.random, System.currentTimeMillis());
        while (!"OK".equals(j.set(lockKey, randomLockValue, SetParams.setParams().nx().px((long)this.expiration)))) {
            if (System.currentTimeMillis() - start > this.maxTime) {
                throw new IllegalStateException(String.format("Could not acquire a lock from redis after waiting for %dms", this.maxTime));
            }
            try {
                Thread.sleep(this.iterationTime);
            }
            catch (InterruptedException interruptedException) {}
        }
        return randomLockValue;
    }

    @Override
    public void release(Jedis j, byte[] lockKey, byte[] lockValue) {
        if (lockValue != null) {
            j.watch((byte[][])new byte[][]{lockKey});
            byte[] previousLockValue = j.get(lockKey);
            if (Arrays.equals(previousLockValue, lockValue)) {
                boolean succeed;
                Transaction transaction = j.multi();
                transaction.del(lockKey);
                boolean bl = succeed = transaction.exec() != null;
                if (!succeed) {
                    LOG.warn("Failed to release lock for key {}/{}, meaning the key probably expired because of acquiring the lock for too long {}ms (expiration at {}ms)", new Object[]{new String(lockKey), Hex.encodeHexString((byte[])lockValue), System.currentTimeMillis() - this.extractTime(lockValue), this.expiration});
                }
            } else {
                LOG.warn("Nothing to release for key {}/{}, meaning the key probably expired because of acquiring the lock for too long {}ms (expiration at {}ms)", new Object[]{new String(lockKey), Hex.encodeHexString((byte[])lockValue), System.currentTimeMillis() - this.extractTime(lockValue), this.expiration});
                j.unwatch();
            }
        } else {
            LOG.warn("Trying to release a lock for {} with a null value", (Object)new String(lockKey));
        }
    }

    protected byte[] generateLockValue(Random r, long timestamp) {
        ByteBuffer buffer = ByteBuffer.allocate(18);
        buffer.putLong(timestamp);
        byte[] randomLockValue = new byte[10];
        r.nextBytes(randomLockValue);
        buffer.put(randomLockValue);
        return buffer.array();
    }

    protected long extractTime(byte[] value) {
        ByteBuffer buffer = ByteBuffer.wrap(value);
        return buffer.getLong();
    }
}

