/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.leshan.server.californium.observation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.coap.Request;
import org.eclipse.californium.core.coap.Response;
import org.eclipse.californium.core.coap.Token;
import org.eclipse.californium.core.network.Endpoint;
import org.eclipse.californium.core.observe.NotificationListener;
import org.eclipse.californium.core.observe.ObservationStore;
import org.eclipse.californium.elements.EndpointContext;
import org.eclipse.leshan.core.ResponseCode;
import org.eclipse.leshan.core.californium.EndpointContextUtil;
import org.eclipse.leshan.core.californium.ResponseCodeUtil;
import org.eclipse.leshan.core.model.LwM2mModel;
import org.eclipse.leshan.core.node.LwM2mPath;
import org.eclipse.leshan.core.node.TimestampedLwM2mNode;
import org.eclipse.leshan.core.node.codec.CodecException;
import org.eclipse.leshan.core.node.codec.LwM2mDecoder;
import org.eclipse.leshan.core.observation.CompositeObservation;
import org.eclipse.leshan.core.observation.Observation;
import org.eclipse.leshan.core.observation.SingleObservation;
import org.eclipse.leshan.core.request.ContentFormat;
import org.eclipse.leshan.core.request.Identity;
import org.eclipse.leshan.core.request.exception.InvalidResponseException;
import org.eclipse.leshan.core.response.AbstractLwM2mResponse;
import org.eclipse.leshan.core.response.ObserveCompositeResponse;
import org.eclipse.leshan.core.response.ObserveResponse;
import org.eclipse.leshan.core.util.Hex;
import org.eclipse.leshan.server.californium.registration.CaliforniumRegistrationStore;
import org.eclipse.leshan.server.model.LwM2mModelProvider;
import org.eclipse.leshan.server.observation.ObservationListener;
import org.eclipse.leshan.server.observation.ObservationService;
import org.eclipse.leshan.server.registration.Registration;
import org.eclipse.leshan.server.registration.RegistrationUpdate;
import org.eclipse.leshan.server.registration.UpdatedRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObservationServiceImpl
implements ObservationService,
NotificationListener {
    private final Logger LOG = LoggerFactory.getLogger(ObservationServiceImpl.class);
    private final CaliforniumRegistrationStore registrationStore;
    private final LwM2mModelProvider modelProvider;
    private final LwM2mDecoder decoder;
    private Endpoint secureEndpoint;
    private Endpoint nonSecureEndpoint;
    private final boolean updateRegistrationOnNotification;
    private final List<ObservationListener> listeners = new CopyOnWriteArrayList<ObservationListener>();

    public ObservationServiceImpl(CaliforniumRegistrationStore store, LwM2mModelProvider modelProvider, LwM2mDecoder decoder) {
        this(store, modelProvider, decoder, false);
    }

    public ObservationServiceImpl(CaliforniumRegistrationStore store, LwM2mModelProvider modelProvider, LwM2mDecoder decoder, boolean updateRegistrationOnNotification) {
        this.registrationStore = store;
        this.modelProvider = modelProvider;
        this.decoder = decoder;
        this.updateRegistrationOnNotification = updateRegistrationOnNotification;
    }

    public void addObservation(Registration registration, Observation observation) {
        for (Observation existing : this.registrationStore.addObservation(registration.getId(), observation)) {
            this.cancel(existing);
        }
        for (ObservationListener listener : this.listeners) {
            listener.newObservation(observation, registration);
        }
    }

    public void setNonSecureEndpoint(Endpoint endpoint) {
        this.nonSecureEndpoint = endpoint;
    }

    public void setSecureEndpoint(Endpoint endpoint) {
        this.secureEndpoint = endpoint;
    }

    public int cancelObservations(Registration registration) {
        String registrationId = registration.getId();
        if (registrationId == null) {
            return 0;
        }
        Collection observations = this.registrationStore.removeObservations(registrationId);
        if (observations == null) {
            return 0;
        }
        for (Observation observation : observations) {
            this.cancel(observation);
        }
        return observations.size();
    }

    public int cancelObservations(Registration registration, String nodePath) {
        if (registration == null || registration.getId() == null || nodePath == null || nodePath.isEmpty()) {
            return 0;
        }
        Set<Observation> observations = this.getObservations(registration.getId(), nodePath);
        for (Observation observation : observations) {
            this.cancelObservation(observation);
        }
        return observations.size();
    }

    public int cancelCompositeObservations(Registration registration, String[] nodePaths) {
        if (registration == null || registration.getId() == null || nodePaths == null || nodePaths.length == 0) {
            return 0;
        }
        Set<Observation> observations = this.getCompositeObservations(registration.getId(), nodePaths);
        for (Observation observation : observations) {
            this.cancelObservation(observation);
        }
        return observations.size();
    }

    public void cancelObservation(Observation observation) {
        if (observation == null) {
            return;
        }
        this.registrationStore.removeObservation(observation.getRegistrationId(), observation.getId());
        this.cancel(observation);
    }

    private void cancel(Observation observation) {
        Token token = new Token(observation.getId());
        if (this.secureEndpoint != null) {
            this.secureEndpoint.cancelObservation(token);
        }
        if (this.nonSecureEndpoint != null) {
            this.nonSecureEndpoint.cancelObservation(token);
        }
        for (ObservationListener listener : this.listeners) {
            listener.cancelled(observation);
        }
    }

    public Set<Observation> getObservations(Registration registration) {
        return this.getObservations(registration.getId());
    }

    private Set<Observation> getObservations(String registrationId) {
        if (registrationId == null) {
            return Collections.emptySet();
        }
        return new HashSet<Observation>(this.registrationStore.getObservations(registrationId));
    }

    private Set<Observation> getCompositeObservations(String registrationId, String[] nodePaths) {
        if (registrationId == null || nodePaths == null) {
            return Collections.emptySet();
        }
        ArrayList<LwM2mPath> lwPaths = new ArrayList<LwM2mPath>(nodePaths.length);
        for (int i = 0; i < nodePaths.length; ++i) {
            lwPaths.add(new LwM2mPath(nodePaths[i]));
        }
        HashSet<Observation> result = new HashSet<Observation>();
        for (Observation obs : this.getObservations(registrationId)) {
            if (!(obs instanceof CompositeObservation) || !lwPaths.equals(((CompositeObservation)obs).getPaths())) continue;
            result.add(obs);
        }
        return result;
    }

    private Set<Observation> getObservations(String registrationId, String nodePath) {
        if (registrationId == null || nodePath == null) {
            return Collections.emptySet();
        }
        HashSet<Observation> result = new HashSet<Observation>();
        LwM2mPath lwPath = new LwM2mPath(nodePath);
        for (Observation obs : this.getObservations(registrationId)) {
            if (!(obs instanceof SingleObservation) || !lwPath.equals((Object)((SingleObservation)obs).getPath())) continue;
            result.add(obs);
        }
        return result;
    }

    public ObservationStore getObservationStore() {
        return this.registrationStore;
    }

    public void addListener(ObservationListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(ObservationListener listener) {
        this.listeners.remove(listener);
    }

    public void onNotification(Request coapRequest, Response coapResponse) {
        block15: {
            Registration registration;
            this.LOG.trace("notification received for request {}: {}", (Object)coapRequest, (Object)coapResponse);
            if (this.listeners.isEmpty()) {
                return;
            }
            String regid = (String)coapRequest.getUserContext().get("leshan-regId");
            Observation observation = this.registrationStore.getObservation(regid, coapResponse.getToken().getBytes());
            if (observation == null) {
                this.LOG.error("Unexpected error: Unable to find observation with token {} for registration {}", (Object)coapResponse.getToken(), (Object)regid);
                return;
            }
            if (this.updateRegistrationOnNotification) {
                Identity obsIdentity = EndpointContextUtil.extractIdentity((EndpointContext)coapResponse.getSourceContext());
                RegistrationUpdate regUpdate = new RegistrationUpdate(observation.getRegistrationId(), obsIdentity, null, null, null, null, null, null);
                UpdatedRegistration updatedRegistration = this.registrationStore.updateRegistration(regUpdate);
                if (updatedRegistration == null || updatedRegistration.getUpdatedRegistration() == null) {
                    this.LOG.error("Unexpected error: There is no registration with id {} for this observation {}", (Object)observation.getRegistrationId(), (Object)observation);
                    return;
                }
                registration = updatedRegistration.getUpdatedRegistration();
            } else {
                registration = this.registrationStore.getRegistration(observation.getRegistrationId());
                if (registration == null) {
                    this.LOG.error("Unexpected error: There is no registration with id {} for this observation {}", (Object)observation.getRegistrationId(), (Object)observation);
                    return;
                }
            }
            try {
                LwM2mModel model = this.modelProvider.getObjectModel(registration);
                AbstractLwM2mResponse response = this.createObserveResponse(observation, model, coapResponse);
                if (response == null) break block15;
                for (ObservationListener listener : this.listeners) {
                    if (observation instanceof SingleObservation && response instanceof ObserveResponse) {
                        listener.onResponse((SingleObservation)observation, registration, (ObserveResponse)response);
                    }
                    if (!(observation instanceof CompositeObservation) || !(response instanceof ObserveCompositeResponse)) continue;
                    listener.onResponse((CompositeObservation)observation, registration, (ObserveCompositeResponse)response);
                }
            }
            catch (InvalidResponseException e) {
                if (this.LOG.isDebugEnabled()) {
                    this.LOG.debug(String.format("Invalid notification for observation [%s]", observation), (Throwable)e);
                }
                for (ObservationListener listener : this.listeners) {
                    listener.onError(observation, registration, (Exception)((Object)e));
                }
            }
            catch (RuntimeException e) {
                if (this.LOG.isErrorEnabled()) {
                    this.LOG.error(String.format("Unable to handle notification for observation [%s]", observation), (Throwable)e);
                }
                for (ObservationListener listener : this.listeners) {
                    listener.onError(observation, registration, (Exception)e);
                }
            }
        }
    }

    private AbstractLwM2mResponse createObserveResponse(Observation observation, LwM2mModel model, Response coapResponse) {
        if (coapResponse.getCode() != CoAP.ResponseCode.CHANGED && coapResponse.getCode() != CoAP.ResponseCode.CONTENT) {
            throw new InvalidResponseException("Unexpected response code [%s] for %s", new Object[]{coapResponse.getCode(), observation});
        }
        ContentFormat contentFormat = null;
        if (coapResponse.getOptions().hasContentFormat()) {
            contentFormat = ContentFormat.fromCode((int)coapResponse.getOptions().getContentFormat());
        }
        try {
            ResponseCode responseCode = ResponseCodeUtil.toLwM2mResponseCode((CoAP.ResponseCode)coapResponse.getCode());
            if (observation instanceof SingleObservation) {
                SingleObservation singleObservation = (SingleObservation)observation;
                List timestampedNodes = this.decoder.decodeTimestampedData(coapResponse.getPayload(), contentFormat, singleObservation.getPath(), model);
                if (timestampedNodes.size() == 1 && !((TimestampedLwM2mNode)timestampedNodes.get(0)).isTimestamped()) {
                    return new ObserveResponse(responseCode, ((TimestampedLwM2mNode)timestampedNodes.get(0)).getNode(), null, singleObservation, null, (Object)coapResponse);
                }
                return new ObserveResponse(responseCode, null, timestampedNodes, singleObservation, null, (Object)coapResponse);
            }
            if (observation instanceof CompositeObservation) {
                CompositeObservation compositeObservation = (CompositeObservation)observation;
                Map nodes = this.decoder.decodeNodes(coapResponse.getPayload(), contentFormat, compositeObservation.getPaths(), model);
                return new ObserveCompositeResponse(responseCode, nodes, null, (Object)coapResponse, compositeObservation);
            }
            throw new IllegalStateException("observation must be a CompositeObservation or a SingleObservation but was " + observation == null ? null : observation.getClass().getSimpleName());
        }
        catch (CodecException e) {
            if (this.LOG.isDebugEnabled()) {
                byte[] payload = coapResponse.getPayload() == null ? new byte[]{} : coapResponse.getPayload();
                this.LOG.debug(String.format("Unable to decode notification payload [%s] of observation [%s] ", Hex.encodeHexString((byte[])payload), observation), (Throwable)e);
            }
            throw new InvalidResponseException((Throwable)e, "Unable to decode notification payload  of observation [%s] ", new Object[]{observation});
        }
    }
}

