/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.leshan.server.californium;

import com.upokecenter.cbor.CBORObject;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.californium.cose.AlgorithmID;
import org.eclipse.californium.cose.CoseException;
import org.eclipse.leshan.core.californium.oscore.cf.OscoreParameters;
import org.eclipse.leshan.core.californium.oscore.cf.OscoreStore;
import org.eclipse.leshan.core.oscore.OscoreIdentity;
import org.eclipse.leshan.core.request.Identity;
import org.eclipse.leshan.core.util.Validate;
import org.eclipse.leshan.server.registration.Registration;
import org.eclipse.leshan.server.registration.RegistrationStore;
import org.eclipse.leshan.server.security.SecurityInfo;
import org.eclipse.leshan.server.security.SecurityStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LwM2mOscoreStore
implements OscoreStore {
    private static final Logger LOG = LoggerFactory.getLogger(LwM2mOscoreStore.class);
    private final SecurityStore securityStore;
    private final RegistrationStore registrationStore;

    public LwM2mOscoreStore(SecurityStore securityStore, RegistrationStore registrationStore) {
        Validate.notNull((Object)securityStore);
        Validate.notNull((Object)registrationStore);
        this.securityStore = securityStore;
        this.registrationStore = registrationStore;
    }

    public OscoreParameters getOscoreParameters(byte[] recipientID) {
        OscoreIdentity oscoreIdentity = new OscoreIdentity(recipientID);
        SecurityInfo securityInfo = this.securityStore.getByOscoreIdentity(oscoreIdentity);
        if (securityInfo == null || !securityInfo.useOSCORE()) {
            return null;
        }
        try {
            return new OscoreParameters(securityInfo.getOscoreSetting().getSenderId(), securityInfo.getOscoreSetting().getRecipientId(), securityInfo.getOscoreSetting().getMasterSecret(), AlgorithmID.FromCBOR((CBORObject)CBORObject.FromObject((int)securityInfo.getOscoreSetting().getAeadAlgorithm().getValue())), AlgorithmID.FromCBOR((CBORObject)CBORObject.FromObject((int)securityInfo.getOscoreSetting().getHkdfAlgorithm().getValue())), securityInfo.getOscoreSetting().getMasterSalt().length == 0 ? null : securityInfo.getOscoreSetting().getMasterSalt());
        }
        catch (CoseException e) {
            LOG.error("Unable to create OscoreParameters from OoscoreSetting %s", (Object)securityInfo.getOscoreSetting(), (Object)e);
            return null;
        }
    }

    public byte[] getRecipientId(String uri) {
        try {
            URI foreignPeerUri = new URI(uri);
            InetSocketAddress foreignPeerAddress = new InetSocketAddress(foreignPeerUri.getHost(), foreignPeerUri.getPort());
            Registration registration = this.registrationStore.getRegistrationByAdress(foreignPeerAddress);
            Identity identity = registration.getIdentity();
            if (identity.isOSCORE()) {
                return identity.getOscoreIdentity().getRecipientId();
            }
        }
        catch (IllegalArgumentException | SecurityException | URISyntaxException e) {
            LOG.error("Unable to extract InetScocketAddress from uri %s", (Object)uri, (Object)e);
            return null;
        }
        return null;
    }
}

