/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.map;

import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.bag.MutableBag;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.function.Function0;
import org.eclipse.collections.api.block.function.Function2;
import org.eclipse.collections.api.block.function.primitive.DoubleFunction;
import org.eclipse.collections.api.block.function.primitive.FloatFunction;
import org.eclipse.collections.api.block.function.primitive.IntFunction;
import org.eclipse.collections.api.block.function.primitive.LongFunction;
import org.eclipse.collections.api.block.predicate.Predicate;
import org.eclipse.collections.api.block.predicate.Predicate2;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.block.procedure.Procedure2;
import org.eclipse.collections.api.collection.MutableCollection;
import org.eclipse.collections.api.map.MutableMap;
import org.eclipse.collections.api.map.MutableMapIterable;
import org.eclipse.collections.api.map.primitive.MutableObjectDoubleMap;
import org.eclipse.collections.api.map.primitive.MutableObjectLongMap;
import org.eclipse.collections.api.multimap.MutableMultimap;
import org.eclipse.collections.api.partition.PartitionMutableCollection;
import org.eclipse.collections.api.tuple.Pair;
import org.eclipse.collections.impl.collection.AbstractSynchronizedRichIterable;
import org.eclipse.collections.impl.tuple.AbstractImmutableEntry;
import org.eclipse.collections.impl.utility.Iterate;
import org.eclipse.collections.impl.utility.LazyIterate;

public abstract class AbstractSynchronizedMapIterable<K, V>
extends AbstractSynchronizedRichIterable<V>
implements MutableMapIterable<K, V> {
    protected AbstractSynchronizedMapIterable(MutableMapIterable<K, V> delegate) {
        super(delegate, (Object)null);
    }

    protected AbstractSynchronizedMapIterable(MutableMapIterable<K, V> delegate, Object lock) {
        super(delegate, lock);
    }

    protected MutableMapIterable<K, V> getDelegate() {
        return (MutableMapIterable)super.getDelegate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V get(Object key) {
        Object object = this.lock;
        synchronized (object) {
            return (V)this.getDelegate().get(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V getIfAbsent(K key, Function0<? extends V> function) {
        Object object = this.lock;
        synchronized (object) {
            return (V)this.getDelegate().getIfAbsent(key, function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V getIfAbsentValue(K key, V value) {
        Object object = this.lock;
        synchronized (object) {
            return (V)this.getDelegate().getIfAbsentValue(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <P> V getIfAbsentWith(K key, Function<? super P, ? extends V> function, P parameter) {
        Object object = this.lock;
        synchronized (object) {
            return (V)this.getDelegate().getIfAbsentWith(key, function, parameter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <A> A ifPresentApply(K key, Function<? super V, ? extends A> function) {
        Object object = this.lock;
        synchronized (object) {
            return (A)this.getDelegate().ifPresentApply(key, function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsKey(Object key) {
        Object object = this.lock;
        synchronized (object) {
            return this.getDelegate().containsKey(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsValue(Object value) {
        Object object = this.lock;
        synchronized (object) {
            return this.getDelegate().containsValue(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forEachValue(Procedure<? super V> procedure) {
        Object object = this.lock;
        synchronized (object) {
            this.getDelegate().forEachValue(procedure);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forEachKey(Procedure<? super K> procedure) {
        Object object = this.lock;
        synchronized (object) {
            this.getDelegate().forEachKey(procedure);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forEachKeyValue(Procedure2<? super K, ? super V> procedure2) {
        Object object = this.lock;
        synchronized (object) {
            this.getDelegate().forEachKeyValue(procedure2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Pair<K, V> detect(Predicate2<? super K, ? super V> predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.getDelegate().detect(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<Pair<K, V>> detectOptional(Predicate2<? super K, ? super V> predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.getDelegate().detectOptional(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V getIfAbsentPut(K key, Function0<? extends V> function) {
        Object object = this.lock;
        synchronized (object) {
            return (V)this.getDelegate().getIfAbsentPut(key, function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V getIfAbsentPut(K key, V value) {
        Object object = this.lock;
        synchronized (object) {
            return (V)this.getDelegate().getIfAbsentPut(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V getIfAbsentPutWithKey(K key, Function<? super K, ? extends V> function) {
        Object object = this.lock;
        synchronized (object) {
            return (V)this.getDelegate().getIfAbsentPutWithKey(key, function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <P> V getIfAbsentPutWith(K key, Function<? super P, ? extends V> function, P parameter) {
        Object object = this.lock;
        synchronized (object) {
            return (V)this.getDelegate().getIfAbsentPutWith(key, function, parameter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V put(K key, V value) {
        Object object = this.lock;
        synchronized (object) {
            return (V)this.getDelegate().put(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V remove(Object key) {
        Object object = this.lock;
        synchronized (object) {
            return (V)this.getDelegate().remove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V removeKey(K key) {
        Object object = this.lock;
        synchronized (object) {
            return (V)this.getDelegate().removeKey(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putAll(Map<? extends K, ? extends V> map) {
        Object object = this.lock;
        synchronized (object) {
            this.getDelegate().putAll(map);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.lock;
        synchronized (object) {
            this.getDelegate().clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V putPair(Pair<K, V> keyValuePair) {
        Object object = this.lock;
        synchronized (object) {
            return (V)this.put(keyValuePair.getOne(), keyValuePair.getTwo());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V add(Pair<K, V> keyValuePair) {
        Object object = this.lock;
        synchronized (object) {
            return this.putPair(keyValuePair);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V updateValue(K key, Function0<? extends V> factory, Function<? super V, ? extends V> function) {
        Object object = this.lock;
        synchronized (object) {
            return (V)this.getDelegate().updateValue(key, factory, function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <P> V updateValueWith(K key, Function0<? extends V> factory, Function2<? super V, ? super P, ? extends V> function, P parameter) {
        Object object = this.lock;
        synchronized (object) {
            return (V)this.getDelegate().updateValueWith(key, factory, function, parameter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <VV> MutableMapIterable<VV, V> groupByUniqueKey(Function<? super V, ? extends VV> function) {
        Object object = this.lock;
        synchronized (object) {
            return this.getDelegate().groupByUniqueKey(function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <KK, VV> MutableMap<KK, VV> aggregateInPlaceBy(Function<? super V, ? extends KK> groupBy, Function0<? extends VV> zeroValueFactory, Procedure2<? super VV, ? super V> mutatingAggregator) {
        Object object = this.lock;
        synchronized (object) {
            return this.getDelegate().aggregateInPlaceBy(groupBy, zeroValueFactory, mutatingAggregator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <KK, VV> MutableMap<KK, VV> aggregateBy(Function<? super V, ? extends KK> groupBy, Function0<? extends VV> zeroValueFactory, Function2<? super VV, ? super V, ? extends VV> nonMutatingAggregator) {
        Object object = this.lock;
        synchronized (object) {
            return this.getDelegate().aggregateBy(groupBy, zeroValueFactory, nonMutatingAggregator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RichIterable<Pair<K, V>> keyValuesView() {
        Object object = this.lock;
        synchronized (object) {
            Set entries = this.getDelegate().entrySet();
            Collection pairs = Iterate.collect(entries, AbstractImmutableEntry.getPairFunction());
            return LazyIterate.adapt(pairs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <V1> MutableObjectLongMap<V1> sumByInt(Function<? super V, ? extends V1> groupBy, IntFunction<? super V> function) {
        Object object = this.lock;
        synchronized (object) {
            return this.getDelegate().sumByInt(groupBy, function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <V1> MutableObjectDoubleMap<V1> sumByFloat(Function<? super V, ? extends V1> groupBy, FloatFunction<? super V> function) {
        Object object = this.lock;
        synchronized (object) {
            return this.getDelegate().sumByFloat(groupBy, function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <V1> MutableObjectLongMap<V1> sumByLong(Function<? super V, ? extends V1> groupBy, LongFunction<? super V> function) {
        Object object = this.lock;
        synchronized (object) {
            return this.getDelegate().sumByLong(groupBy, function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <V1> MutableObjectDoubleMap<V1> sumByDouble(Function<? super V, ? extends V1> groupBy, DoubleFunction<? super V> function) {
        Object object = this.lock;
        synchronized (object) {
            return this.getDelegate().sumByDouble(groupBy, function);
        }
    }

    @Override
    public <V1> MutableMultimap<V1, V> groupBy(Function<? super V, ? extends V1> function) {
        return (MutableMultimap)super.groupBy(function);
    }

    @Override
    public <V1> MutableMultimap<V1, V> groupByEach(Function<? super V, ? extends Iterable<V1>> function) {
        return (MutableMultimap)super.groupByEach(function);
    }

    @Override
    public <S> MutableCollection<Pair<V, S>> zip(Iterable<S> that) {
        return (MutableCollection)super.zip(that);
    }

    @Override
    public MutableCollection<Pair<V, Integer>> zipWithIndex() {
        return (MutableCollection)super.zipWithIndex();
    }

    @Override
    public MutableCollection<V> select(Predicate<? super V> predicate) {
        return (MutableCollection)super.select(predicate);
    }

    @Override
    public <S> MutableCollection<S> selectInstancesOf(Class<S> clazz) {
        return (MutableCollection)super.selectInstancesOf(clazz);
    }

    @Override
    public <P> MutableCollection<V> selectWith(Predicate2<? super V, ? super P> predicate, P parameter) {
        return (MutableCollection)super.selectWith(predicate, parameter);
    }

    @Override
    public <P> MutableCollection<V> rejectWith(Predicate2<? super V, ? super P> predicate, P parameter) {
        return (MutableCollection)super.rejectWith(predicate, parameter);
    }

    @Override
    public PartitionMutableCollection<V> partition(Predicate<? super V> predicate) {
        return (PartitionMutableCollection)super.partition(predicate);
    }

    @Override
    public <V1> MutableBag<V1> countBy(Function<? super V, ? extends V1> function) {
        return (MutableBag)super.countBy(function);
    }

    @Override
    public <V1, P> MutableBag<V1> countByWith(Function2<? super V, ? super P, ? extends V1> function, P parameter) {
        return (MutableBag)super.countByWith(function, parameter);
    }

    @Override
    public MutableCollection<V> reject(Predicate<? super V> predicate) {
        return (MutableCollection)super.reject(predicate);
    }

    public MutableMapIterable<K, V> tap(Procedure<? super V> procedure) {
        return (MutableMapIterable)super.tap(procedure);
    }
}

