/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.common.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class LineParsingIterator
implements Iterator<List<String>> {
    private BufferedReader reader;
    private String currentLine = null;
    private Parseable parsingStrategy;
    private static final Parseable TAB_SEPARATED_STRATEGY = new Parseable(){

        @Override
        public List<String> parseLine(String line) {
            return Arrays.asList(line.split("[\t]"));
        }
    };

    public LineParsingIterator(Reader reader) {
        this(reader, TAB_SEPARATED_STRATEGY);
    }

    public LineParsingIterator(Reader reader, Parseable parsingStrategy) {
        this.reader = new BufferedReader(reader);
        if (parsingStrategy == null) {
            throw new IllegalArgumentException("parsingStrategy must not be null");
        }
        this.parsingStrategy = parsingStrategy;
        this.readNextLine();
    }

    private void readNextLine() {
        try {
            this.currentLine = this.reader.readLine();
        }
        catch (IOException e) {
            this.currentLine = null;
            e.printStackTrace();
        }
    }

    private List<String> parseLine(String line) {
        return this.parsingStrategy.parseLine(line);
    }

    @Override
    public final List<String> next() {
        List<String> object = this.parseLine(this.currentLine);
        this.readNextLine();
        return object;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final boolean hasNext() {
        return this.currentLine != null;
    }

    public static interface Parseable {
        public List<String> parseLine(String var1);
    }
}

