/*
 * Decompiled with CFR 0.152.
 */
package org.oclc.oai.harvester2.verb;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathExpressionException;
import org.oclc.oai.harvester2.verb.HarvesterVerb;
import org.xml.sax.SAXException;

public class ListRecords
extends HarvesterVerb {
    public ListRecords() {
    }

    public ListRecords(String baseURL, String from, String until, String set, String metadataPrefix) throws IOException, ParserConfigurationException, SAXException, XPathExpressionException {
        super(ListRecords.getRequestURL(baseURL, from, until, set, metadataPrefix));
    }

    public ListRecords(String baseURL, String resumptionToken) throws IOException, ParserConfigurationException, SAXException, XPathExpressionException {
        super(ListRecords.getRequestURL(baseURL, resumptionToken));
    }

    public String getResumptionToken() throws XPathExpressionException, NoSuchFieldException {
        String schemaLocation = this.getSchemaLocation();
        if (schemaLocation.contains("http://www.openarchives.org/OAI/2.0/ http://www.openarchives.org/OAI/2.0/OAI-PMH.xsd")) {
            return this.getSingleString("/oai20:OAI-PMH/oai20:ListRecords/oai20:resumptionToken");
        }
        if (schemaLocation.contains("http://www.openarchives.org/OAI/1.1/OAI_ListRecords http://www.openarchives.org/OAI/1.1/OAI_ListRecords.xsd")) {
            return this.getSingleString("/oai11_ListRecords:ListRecords/oai11_ListRecords:resumptionToken");
        }
        throw new NoSuchFieldException(schemaLocation);
    }

    private static String getRequestURL(String baseURL, String from, String until, String set, String metadataPrefix) {
        StringBuilder requestURL = new StringBuilder(baseURL);
        requestURL.append("?verb=ListRecords");
        if (from != null) {
            requestURL.append("&from=").append(from);
        }
        if (until != null) {
            requestURL.append("&until=").append(until);
        }
        if (set != null) {
            requestURL.append("&set=").append(set);
        }
        requestURL.append("&metadataPrefix=").append(metadataPrefix);
        return requestURL.toString();
    }

    private static String getRequestURL(String baseURL, String resumptionToken) throws UnsupportedEncodingException {
        StringBuilder requestURL = new StringBuilder(baseURL);
        requestURL.append("?verb=ListRecords");
        requestURL.append("&resumptionToken=").append(URLEncoder.encode(resumptionToken, "UTF-8"));
        return requestURL.toString();
    }
}

