/*
 * Decompiled with CFR 0.152.
 */
package org.oclc.oai.harvester2.verb;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Date;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;
import java.util.zip.ZipInputStream;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.oclc.oai.harvester2.verb.OAINamespaceContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public abstract class HarvesterVerb {
    private static final Logger log = LoggerFactory.getLogger(HarvesterVerb.class);
    public static final String SCHEMA_LOCATION_V2_0 = "http://www.openarchives.org/OAI/2.0/ http://www.openarchives.org/OAI/2.0/OAI-PMH.xsd";
    public static final String SCHEMA_LOCATION_V1_1_GET_RECORD = "http://www.openarchives.org/OAI/1.1/OAI_GetRecord http://www.openarchives.org/OAI/1.1/OAI_GetRecord.xsd";
    public static final String SCHEMA_LOCATION_V1_1_IDENTIFY = "http://www.openarchives.org/OAI/1.1/OAI_Identify http://www.openarchives.org/OAI/1.1/OAI_Identify.xsd";
    public static final String SCHEMA_LOCATION_V1_1_LIST_IDENTIFIERS = "http://www.openarchives.org/OAI/1.1/OAI_ListIdentifiers http://www.openarchives.org/OAI/1.1/OAI_ListIdentifiers.xsd";
    public static final String SCHEMA_LOCATION_V1_1_LIST_METADATA_FORMATS = "http://www.openarchives.org/OAI/1.1/OAI_ListMetadataFormats http://www.openarchives.org/OAI/1.1/OAI_ListMetadataFormats.xsd";
    public static final String SCHEMA_LOCATION_V1_1_LIST_RECORDS = "http://www.openarchives.org/OAI/1.1/OAI_ListRecords http://www.openarchives.org/OAI/1.1/OAI_ListRecords.xsd";
    public static final String SCHEMA_LOCATION_V1_1_LIST_SETS = "http://www.openarchives.org/OAI/1.1/OAI_ListSets http://www.openarchives.org/OAI/1.1/OAI_ListSets.xsd";
    private Document doc = null;
    private String schemaLocation = null;
    private String requestURL = null;
    private static final ThreadLocal<DocumentBuilderFactory> builderFactory = new ThreadLocal<DocumentBuilderFactory>(){

        @Override
        public DocumentBuilderFactory initialValue() {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            return factory;
        }
    };
    private static final ThreadLocal<TransformerFactory> transformerFactory = new ThreadLocal<TransformerFactory>(){

        @Override
        public TransformerFactory initialValue() {
            return TransformerFactory.newInstance();
        }
    };
    private static final ThreadLocal<XPath> xpath = new ThreadLocal<XPath>(){

        @Override
        public XPath initialValue() {
            XPathFactory fucktory = XPathFactory.newInstance();
            XPath xpath = fucktory.newXPath();
            try {
                xpath.setNamespaceContext(new OAINamespaceContext((DocumentBuilderFactory)builderFactory.get()));
            }
            catch (ParserConfigurationException e) {
                log.error("Cannot set namespace context", (Throwable)e);
            }
            return xpath;
        }
    };

    public Document getDocument() {
        return this.doc;
    }

    public String getSchemaLocation() {
        return this.schemaLocation;
    }

    public NodeList getErrors() throws XPathExpressionException {
        if (SCHEMA_LOCATION_V2_0.equals(this.getSchemaLocation())) {
            return this.getNodeList("/oai20:OAI-PMH/oai20:error");
        }
        return null;
    }

    public String getRequestURL() {
        return this.requestURL;
    }

    public HarvesterVerb() {
    }

    public HarvesterVerb(String requestURL) throws IOException, ParserConfigurationException, SAXException, XPathExpressionException {
        this.harvest(requestURL);
    }

    private void harvest(String requestURL) throws IOException, ParserConfigurationException, SAXException, XPathExpressionException {
        InputStream in;
        int responseCode;
        this.requestURL = requestURL;
        log.debug("requestURL=" + requestURL);
        URL url = new URL(requestURL);
        HttpURLConnection con = null;
        do {
            con = (HttpURLConnection)url.openConnection();
            con.setRequestProperty("User-Agent", "OAIHarvester/2.0");
            con.setRequestProperty("Accept-Encoding", "compress, gzip, identify");
            try {
                responseCode = con.getResponseCode();
                log.debug("responseCode=" + responseCode);
            }
            catch (FileNotFoundException e) {
                log.info(requestURL, (Throwable)e);
                responseCode = 503;
            }
            if (responseCode != 503) continue;
            long retrySeconds = con.getHeaderFieldInt("Retry-After", -1);
            if (retrySeconds == -1L) {
                long now = new Date().getTime();
                long retryDate = con.getHeaderFieldDate("Retry-After", now);
                retrySeconds = retryDate - now;
            }
            if (retrySeconds == 0L) {
                throw new FileNotFoundException("Bad URL?");
            }
            System.err.println("Server response: Retry-After=" + retrySeconds);
            if (retrySeconds <= 0L) continue;
            try {
                Thread.sleep(retrySeconds * 1000L);
            }
            catch (InterruptedException ex) {
                log.error("Error while sleeping", (Throwable)ex);
            }
        } while (responseCode == 503);
        String contentEncoding = con.getHeaderField("Content-Encoding");
        log.debug("contentEncoding=" + contentEncoding);
        if ("compress".equals(contentEncoding)) {
            ZipInputStream zis = new ZipInputStream(con.getInputStream());
            zis.getNextEntry();
            in = zis;
        } else {
            in = "gzip".equals(contentEncoding) ? new GZIPInputStream(con.getInputStream()) : ("deflate".equals(contentEncoding) ? new InflaterInputStream(con.getInputStream()) : con.getInputStream());
        }
        InputSource data = new InputSource(in);
        this.doc = builderFactory.get().newDocumentBuilder().parse(data);
        String schemaLoc = this.getSingleString("/*/@xsi:schemaLocation");
        this.schemaLocation = schemaLoc.trim().replaceAll("\\s+", " ");
    }

    public String getSingleString(String xpath) throws XPathExpressionException {
        return this.getSingleString(this.getDocument(), xpath);
    }

    public String getSingleString(Node node, String expression) throws XPathExpressionException {
        return xpath.get().evaluate(expression, node);
    }

    public NodeList getNodeList(String expression) throws XPathExpressionException {
        return (NodeList)xpath.get().evaluate(expression, this.getDocument(), XPathConstants.NODESET);
    }

    public String toString() {
        DOMSource input = new DOMSource(this.getDocument());
        StringWriter sw = new StringWriter();
        StreamResult output = new StreamResult(sw);
        try {
            Transformer idTransformer = transformerFactory.get().newTransformer();
            idTransformer.setOutputProperty("omit-xml-declaration", "yes");
            idTransformer.transform(input, output);
            return sw.toString();
        }
        catch (TransformerException e) {
            return e.getMessage();
        }
    }
}

