/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.rule.builder;

import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import org.drools.compiler.compiler.RuleBuildError;
import org.drools.compiler.compiler.RuleBuildWarning;
import org.drools.compiler.lang.descr.AndDescr;
import org.drools.compiler.lang.descr.AnnotationDescr;
import org.drools.compiler.lang.descr.AttributeDescr;
import org.drools.compiler.lang.descr.EntryPointDescr;
import org.drools.compiler.lang.descr.PatternDescr;
import org.drools.compiler.lang.descr.QueryDescr;
import org.drools.compiler.lang.descr.RuleDescr;
import org.drools.compiler.rule.builder.ConsequenceBuilder;
import org.drools.compiler.rule.builder.RuleBuildContext;
import org.drools.compiler.rule.builder.RuleConditionBuilder;
import org.drools.compiler.rule.builder.dialect.mvel.MVELObjectExpressionBuilder;
import org.drools.core.base.EnabledBoolean;
import org.drools.core.base.SalienceInteger;
import org.drools.core.base.mvel.MVELObjectExpression;
import org.drools.core.definitions.rule.impl.RuleImpl;
import org.drools.core.factmodel.AnnotationDefinition;
import org.drools.core.rule.GroupElement;
import org.drools.core.rule.Pattern;
import org.drools.core.spi.Salience;
import org.drools.core.time.TimeUtils;
import org.drools.core.time.impl.CronExpression;
import org.drools.core.time.impl.CronTimer;
import org.drools.core.time.impl.ExpressionIntervalTimer;
import org.drools.core.time.impl.IntervalTimer;
import org.drools.core.time.impl.Timer;
import org.drools.core.util.DateUtils;
import org.drools.core.util.MVELSafeHelper;
import org.drools.core.util.StringUtils;
import org.kie.api.definition.rule.ActivationListener;
import org.kie.api.definition.rule.All;
import org.kie.api.definition.rule.Direct;
import org.kie.api.definition.rule.Propagation;
import org.kie.api.definition.rule.Unit;
import org.kie.soup.project.datamodel.commons.types.TypeResolver;

public class RuleBuilder {
    private RuleBuilder() {
    }

    public static void preProcess(RuleBuildContext context) {
        RuleDescr ruleDescr = context.getRuleDescr();
        if (null != ruleDescr.getParentName() && null != context.getPkg().getRule(ruleDescr.getParentName())) {
            context.getRule().setParent(context.getPkg().getRule(ruleDescr.getParentName()));
        }
        RuleBuilder.parseUnitAnnotations(context, context.getRule(), ruleDescr);
        RuleBuilder.buildMetaAttributes(context);
        if (context.getRuleDescr() instanceof QueryDescr) {
            context.getDialect().getQueryBuilder().build(context, (QueryDescr)context.getRuleDescr());
        }
        context.initRule();
    }

    public static void build(RuleBuildContext context) {
        RuleDescr ruleDescr = context.getRuleDescr();
        RuleConditionBuilder builder = (RuleConditionBuilder)context.getDialect().getBuilder(ruleDescr.getLhs().getClass());
        if (builder == null) {
            throw new RuntimeException("BUG: builder not found for descriptor class " + ruleDescr.getLhs().getClass());
        }
        Pattern prefixPattern = context.getPrefixPattern();
        GroupElement ce = (GroupElement)builder.build(context, RuleBuilder.getLhsForRuleUnit(context.getRule(), ruleDescr.getLhs()), prefixPattern);
        context.getRule().setLhs(ce);
        RuleBuilder.buildAttributes(context);
        if (!(ruleDescr instanceof QueryDescr)) {
            ConsequenceBuilder consequenceBuilder = context.getDialect().getConsequenceBuilder();
            consequenceBuilder.build(context, "default");
            for (String name : ruleDescr.getNamedConsequences().keySet()) {
                consequenceBuilder.build(context, name);
            }
        }
    }

    private static AndDescr getLhsForRuleUnit(RuleImpl rule, AndDescr lhs) {
        if (rule.hasRuleUnit()) {
            PatternDescr unitPattern = new PatternDescr(rule.getRuleUnitClassName(), "$$unit");
            unitPattern.setSource(EntryPointDescr.RULE_UNIT_ENTRY_POINT_DESCR);
            unitPattern.setResource(rule.getResource());
            lhs.getDescrs().add(0, unitPattern);
        }
        return lhs;
    }

    public static void buildMetaAttributes(RuleBuildContext context) {
        RuleImpl rule = context.getRule();
        for (String metaAttr : context.getRuleDescr().getAnnotationNames()) {
            AnnotationDescr ad = context.getRuleDescr().getAnnotation(metaAttr);
            String adFqn = ad.getFullyQualifiedName();
            if (adFqn != null) {
                AnnotationDefinition annotationDefinition;
                try {
                    annotationDefinition = AnnotationDefinition.build((Class)context.getDialect().getTypeResolver().resolveType(adFqn), ad.getValueMap(), (TypeResolver)context.getDialect().getTypeResolver());
                }
                catch (NoSuchMethodException e) {
                    throw new RuntimeException(e);
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException(e);
                }
                if (annotationDefinition.getValues().size() == 1 && annotationDefinition.getValues().containsKey("value")) {
                    rule.addMetaAttribute(metaAttr, annotationDefinition.getPropertyValue("value"));
                    continue;
                }
                HashMap<String, Object> map = new HashMap<String, Object>(annotationDefinition.getValues().size());
                for (String key : annotationDefinition.getValues().keySet()) {
                    map.put(key, annotationDefinition.getPropertyValue(key));
                }
                rule.addMetaAttribute(metaAttr, map);
                continue;
            }
            if (ad.hasValue()) {
                if (ad.getValues().size() == 1) {
                    rule.addMetaAttribute(metaAttr, RuleBuilder.resolveValue(ad.getSingleValueAsString()));
                    continue;
                }
                rule.addMetaAttribute(metaAttr, ad.getValueMap());
                continue;
            }
            rule.addMetaAttribute(metaAttr, null);
        }
    }

    private static Object resolveValue(String value) {
        Object result = value;
        try {
            result = MVELSafeHelper.getEvaluator().eval(value);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public static void buildAttributes(RuleBuildContext context) {
        RuleImpl rule = context.getRule();
        RuleDescr ruleDescr = context.getRuleDescr();
        boolean enforceEager = false;
        for (AttributeDescr attributeDescr : ruleDescr.getAttributes().values()) {
            String name;
            switch (name = attributeDescr.getName()) {
                case "no-loop": {
                    rule.setNoLoop(RuleBuilder.getBooleanValue(attributeDescr, true));
                    enforceEager = true;
                    break;
                }
                case "auto-focus": {
                    rule.setAutoFocus(RuleBuilder.getBooleanValue(attributeDescr, true));
                    break;
                }
                case "agenda-group": {
                    if (StringUtils.isEmpty((CharSequence)rule.getRuleFlowGroup())) {
                        rule.setAgendaGroup(attributeDescr.getValue());
                        break;
                    }
                    if (!rule.getRuleFlowGroup().equals(attributeDescr.getValue())) break;
                    RuleBuildWarning warn = new RuleBuildWarning(rule, context.getParentDescr(), null, "Both an agenda-group ( " + attributeDescr.getValue() + " ) and a ruleflow-group ( " + rule.getRuleFlowGroup() + " ) are defined for rule " + rule.getName() + ". Since version 6.x the two concepts have been unified, the ruleflow-group name will override the agenda-group. ");
                    context.addWarning(warn);
                    break;
                }
                case "activation-group": {
                    rule.setActivationGroup(attributeDescr.getValue());
                    break;
                }
                case "ruleflow-group": {
                    rule.setRuleFlowGroup(attributeDescr.getValue());
                    if (!rule.getAgendaGroup().equals("MAIN") && !rule.getAgendaGroup().equals(attributeDescr.getValue())) {
                        RuleBuildWarning warn = new RuleBuildWarning(rule, context.getParentDescr(), null, "Both an agenda-group ( " + attributeDescr.getValue() + " ) and a ruleflow-group ( " + rule.getRuleFlowGroup() + " ) are defined for rule " + rule.getName() + ". Since version 6.x the two concepts have been unified, the ruleflow-group name will override the agenda-group. ");
                        context.addWarning(warn);
                    }
                    rule.setAgendaGroup(attributeDescr.getValue());
                    break;
                }
                case "lock-on-active": {
                    boolean lockOnActive = RuleBuilder.getBooleanValue(attributeDescr, true);
                    rule.setLockOnActive(lockOnActive);
                    enforceEager |= lockOnActive;
                    break;
                }
                case "duration": 
                case "timer": {
                    String duration = attributeDescr.getValue();
                    RuleBuilder.buildTimer(rule, duration, context);
                    break;
                }
                case "calendars": {
                    RuleBuilder.buildCalendars(rule, attributeDescr.getValue(), context);
                    break;
                }
                case "date-effective": {
                    RuleBuildError err;
                    Calendar cal;
                    Date date;
                    try {
                        date = DateUtils.parseDate((String)attributeDescr.getValue());
                        cal = Calendar.getInstance();
                        cal.setTime(date);
                        rule.setDateEffective(cal);
                    }
                    catch (Exception e) {
                        err = new RuleBuildError(rule, context.getParentDescr(), null, "Wrong date-effective value: " + e.getMessage());
                        context.addError(err);
                    }
                    break;
                }
                case "date-expires": {
                    RuleBuildError err;
                    Calendar cal;
                    Date date;
                    try {
                        date = DateUtils.parseDate((String)attributeDescr.getValue());
                        cal = Calendar.getInstance();
                        cal.setTime(date);
                        rule.setDateExpires(cal);
                        break;
                    }
                    catch (Exception e) {
                        err = new RuleBuildError(rule, context.getParentDescr(), null, "Wrong date-expires value: " + e.getMessage());
                        context.addError(err);
                    }
                }
            }
        }
        RuleBuilder.buildSalience(context);
        RuleBuilder.buildEnabled(context);
        RuleBuilder.parseAnnotation(context, rule, ruleDescr, enforceEager);
    }

    private static void parseAnnotation(RuleBuildContext context, RuleImpl rule, RuleDescr ruleDescr, boolean enforceEager) {
        try {
            ActivationListener activationListener = ruleDescr.getTypedAnnotation(ActivationListener.class);
            if (activationListener != null) {
                rule.setActivationListener(MVELSafeHelper.getEvaluator().evalToString(activationListener.value()));
            }
            if (enforceEager) {
                rule.setEager(true);
            } else {
                Propagation propagation = ruleDescr.getTypedAnnotation(Propagation.class);
                if (propagation != null) {
                    if (propagation.value() == Propagation.Type.IMMEDIATE) {
                        rule.setDataDriven(true);
                    } else if (propagation.value() == Propagation.Type.EAGER) {
                        rule.setEager(true);
                    }
                }
            }
            Direct direct = ruleDescr.getTypedAnnotation(Direct.class);
            if (direct != null && direct.value()) {
                rule.setActivationListener("direct");
            }
            rule.setAllMatches(ruleDescr.hasAnnotation(All.class));
        }
        catch (Exception e) {
            RuleBuildError err = new RuleBuildError(rule, context.getParentDescr(), null, e.getMessage());
            context.addError(err);
        }
    }

    private static void parseUnitAnnotations(RuleBuildContext context, RuleImpl rule, RuleDescr ruleDescr) {
        try {
            Unit unit = ruleDescr.getTypedAnnotation(Unit.class);
            if (unit != null) {
                rule.setRuleUnitClass(unit.value());
            }
        }
        catch (Exception e) {
            RuleBuildError err = new RuleBuildError(rule, context.getParentDescr(), null, e.getMessage());
            context.addError(err);
        }
    }

    private static boolean getBooleanValue(AttributeDescr attributeDescr, boolean defaultValue) {
        return attributeDescr.getValue() == null || "".equals(attributeDescr.getValue().trim()) ? defaultValue : Boolean.valueOf(attributeDescr.getValue());
    }

    private static void buildEnabled(RuleBuildContext context) {
        String enabledText = context.getRuleDescr().getEnabled();
        if (enabledText != null) {
            if ("true".equalsIgnoreCase(enabledText.trim()) || "false".equalsIgnoreCase(enabledText.trim())) {
                if (Boolean.parseBoolean(enabledText)) {
                    context.getRule().setEnabled(EnabledBoolean.ENABLED_TRUE);
                } else {
                    context.getRule().setEnabled(EnabledBoolean.ENABLED_FALSE);
                }
            } else {
                context.getDialect().getEnabledBuilder().build(context);
            }
        }
    }

    private static void buildSalience(RuleBuildContext context) {
        String salienceText = context.getRuleDescr().getSalience();
        if (salienceText != null && !salienceText.equals("")) {
            try {
                SalienceInteger salience = new SalienceInteger(Integer.parseInt(salienceText));
                context.getRule().setSalience((Salience)salience);
            }
            catch (Exception e) {
                context.getDialect().getSalienceBuilder().build(context);
            }
        }
    }

    private static void buildCalendars(RuleImpl rule, String calendarsString, RuleBuildContext context) {
        Object val = null;
        try {
            val = MVELSafeHelper.getEvaluator().eval(calendarsString);
            String[] calNames = null;
            if (val instanceof List) {
                calNames = ((List)val).toArray(new String[((List)val).size()]);
            } else if (val instanceof String) {
                calNames = new String[]{(String)val};
            } else {
                RuleBuildError err = new RuleBuildError(rule, context.getParentDescr(), null, "Calendars attribute did not return a String or String[] '" + val + "'");
                context.addError(err);
            }
            if (calNames != null) {
                rule.setCalendars(calNames);
            }
        }
        catch (Exception e) {
            RuleBuildError err = new RuleBuildError(rule, context.getParentDescr(), null, "Unable to build Calendars attribute '" + val + "'" + e.getMessage());
            context.addError(err);
        }
    }

    private static void buildTimer(RuleImpl rule, String timerString, RuleBuildContext context) {
        CronTimer timer;
        if (timerString.indexOf(40) >= 0) {
            timerString = timerString.substring(timerString.indexOf(40) + 1, timerString.lastIndexOf(41)).trim();
        }
        int colonPos = timerString.indexOf(":");
        int semicolonPos = timerString.indexOf(";");
        String protocol = "int";
        if (colonPos == -1) {
            if (timerString.startsWith("int") || timerString.startsWith("cron") || timerString.startsWith("expr")) {
                RuleBuildError err = new RuleBuildError(rule, context.getParentDescr(), null, "Incorrect timer definition '" + timerString + "' - missing colon?");
                context.addError(err);
                return;
            }
        } else {
            protocol = timerString.substring(0, colonPos);
        }
        String startDate = RuleBuilder.extractParam(timerString, "start");
        String endDate = RuleBuilder.extractParam(timerString, "end");
        String repeatLimitString = RuleBuilder.extractParam(timerString, "repeat-limit");
        int repeatLimit = repeatLimitString != null ? Integer.parseInt(repeatLimitString) : -1;
        String body = timerString.substring(colonPos + 1, semicolonPos > 0 ? semicolonPos : timerString.length()).trim();
        if ("cron".equals(protocol)) {
            try {
                timer = new CronTimer(RuleBuilder.createMVELExpr(startDate, context), RuleBuilder.createMVELExpr(endDate, context), repeatLimit, new CronExpression(body));
            }
            catch (ParseException e) {
                RuleBuildError err = new RuleBuildError(rule, context.getParentDescr(), null, "Unable to build set timer '" + timerString + "'");
                context.addError(err);
                return;
            }
        }
        if ("int".equals(protocol)) {
            String[] times = body.trim().split("\\s");
            long delay = 0L;
            long period = 0L;
            if (times.length > 2) {
                RuleBuildError err = new RuleBuildError(rule, context.getParentDescr(), null, "Incorrect number of arguments for interval timer '" + timerString + "'");
                context.addError(err);
                return;
            }
            try {
                if (times.length == 1) {
                    delay = TimeUtils.parseTimeString((String)times[0]);
                } else {
                    delay = TimeUtils.parseTimeString((String)times[0]);
                    period = TimeUtils.parseTimeString((String)times[1]);
                }
            }
            catch (RuntimeException e) {
                RuleBuildError err = new RuleBuildError(rule, context.getParentDescr(), null, "Incorrect timer definition '" + timerString + "' " + e.getMessage());
                context.addError(err);
                return;
            }
            timer = new IntervalTimer(RuleBuilder.createMVELExpr(startDate, context), RuleBuilder.createMVELExpr(endDate, context), repeatLimit, delay, period);
        } else if ("expr".equals(protocol)) {
            StringTokenizer tok = new StringTokenizer(body = body.trim(), ",;");
            if (tok.countTokens() > 2) {
                RuleBuildError err = new RuleBuildError(rule, context.getParentDescr(), null, "Incorrect number of arguments for expression timer '" + timerString + "'");
                context.addError(err);
                return;
            }
            MVELObjectExpression times = MVELObjectExpressionBuilder.build(tok.nextToken().trim(), context);
            MVELObjectExpression period = tok.hasMoreTokens() ? MVELObjectExpressionBuilder.build(tok.nextToken().trim(), context) : MVELObjectExpressionBuilder.build("0", context);
            timer = new ExpressionIntervalTimer(RuleBuilder.createMVELExpr(startDate, context), RuleBuilder.createMVELExpr(endDate, context), repeatLimit, times, period);
        } else {
            RuleBuildError err = new RuleBuildError(rule, context.getParentDescr(), null, "Protocol for timer does not exist '" + timerString + "'");
            context.addError(err);
            return;
        }
        rule.setTimer((Timer)timer);
    }

    private static String extractParam(String timerString, String name) {
        int paramPos = timerString.indexOf(name);
        if (paramPos < 0) {
            return null;
        }
        int equalsPos = timerString.indexOf(61, paramPos);
        int sepPos = timerString.indexOf(44, equalsPos);
        int endPos = sepPos > 0 ? sepPos : timerString.length();
        return timerString.substring(equalsPos + 1, endPos).trim();
    }

    private static MVELObjectExpression createMVELExpr(String expr, RuleBuildContext context) {
        if (expr == null) {
            return null;
        }
        try {
            DateUtils.parseDate((String)expr);
            expr = "\"" + expr + "\"";
        }
        catch (Exception exception) {
            // empty catch block
        }
        return MVELObjectExpressionBuilder.build(expr, context);
    }
}

