/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.sms4j.starter.config;

import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import java.util.List;
import java.util.Map;
import org.dromara.sms4j.aliyun.config.AlibabaFactory;
import org.dromara.sms4j.api.SmsBlend;
import org.dromara.sms4j.api.proxy.RestrictedProcess;
import org.dromara.sms4j.api.universal.SupplierConfig;
import org.dromara.sms4j.cloopen.config.CloopenFactory;
import org.dromara.sms4j.comm.enumerate.ConfigType;
import org.dromara.sms4j.comm.utils.SmsUtils;
import org.dromara.sms4j.core.factory.SmsFactory;
import org.dromara.sms4j.core.proxy.SmsInvocationHandler;
import org.dromara.sms4j.ctyun.config.CtyunFactory;
import org.dromara.sms4j.emay.config.EmayFactory;
import org.dromara.sms4j.huawei.config.HuaweiFactory;
import org.dromara.sms4j.jdcloud.config.JdCloudFactory;
import org.dromara.sms4j.lianlu.config.LianLuFactory;
import org.dromara.sms4j.netease.config.NeteaseFactory;
import org.dromara.sms4j.provider.config.SmsConfig;
import org.dromara.sms4j.provider.factory.BaseProviderFactory;
import org.dromara.sms4j.provider.factory.ProviderFactoryHolder;
import org.dromara.sms4j.starter.aop.SpringRestrictedProcess;
import org.dromara.sms4j.tencent.config.TencentFactory;
import org.dromara.sms4j.unisms.config.UniFactory;
import org.dromara.sms4j.yunpian.config.YunPianFactory;
import org.dromara.sms4j.zhutong.config.ZhutongFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmsBlendsInitializer {
    private static final Logger log = LoggerFactory.getLogger(SmsBlendsInitializer.class);
    private List<BaseProviderFactory<? extends SmsBlend, ? extends SupplierConfig>> factoryList;
    private final SmsConfig smsConfig;
    private final Map<String, Map<String, Object>> blends;

    public SmsBlendsInitializer(List<BaseProviderFactory<? extends SmsBlend, ? extends SupplierConfig>> factoryList, SmsConfig smsConfig, Map<String, Map<String, Object>> blends) {
        this.factoryList = factoryList;
        this.smsConfig = smsConfig;
        this.blends = blends;
        this.onApplicationEvent();
    }

    public void onApplicationEvent() {
        this.registerDefaultFactory();
        ProviderFactoryHolder.registerFactory(this.factoryList);
        if (ConfigType.YAML.equals((Object)this.smsConfig.getConfigType())) {
            for (String configId : this.blends.keySet()) {
                Map<String, Object> configMap = this.blends.get(configId);
                Object supplierObj = configMap.get("supplier");
                String supplier = supplierObj == null ? "" : String.valueOf(supplierObj);
                BaseProviderFactory providerFactory = ProviderFactoryHolder.requireForSupplier((String)(supplier = StrUtil.isEmpty((CharSequence)supplier) ? configId : supplier));
                if (providerFactory == null) {
                    log.warn("\u521b\u5efa\"{}\"\u7684\u77ed\u4fe1\u670d\u52a1\u5931\u8d25\uff0c\u672a\u627e\u5230\u4f9b\u5e94\u5546\u4e3a\"{}\"\u7684\u670d\u52a1", (Object)configId, (Object)supplier);
                    continue;
                }
                configMap.put("config-id", configId);
                SmsUtils.replaceKeysSeperator(configMap, (String)"-", (String)"_");
                JSONObject configJson = new JSONObject(configMap);
                SupplierConfig supplierConfig = (SupplierConfig)JSONUtil.toBean((JSONObject)configJson, (Class)providerFactory.getConfigClass());
                if (Boolean.TRUE.equals(this.smsConfig.getRestricted())) {
                    SmsFactory.createRestrictedSmsBlend((SupplierConfig)supplierConfig);
                    continue;
                }
                SmsFactory.createSmsBlend((SupplierConfig)supplierConfig);
            }
        }
        SmsInvocationHandler.setRestrictedProcess((RestrictedProcess)new SpringRestrictedProcess());
    }

    private void registerDefaultFactory() {
        ProviderFactoryHolder.registerFactory((BaseProviderFactory)AlibabaFactory.instance());
        ProviderFactoryHolder.registerFactory((BaseProviderFactory)CloopenFactory.instance());
        ProviderFactoryHolder.registerFactory((BaseProviderFactory)CtyunFactory.instance());
        ProviderFactoryHolder.registerFactory((BaseProviderFactory)EmayFactory.instance());
        ProviderFactoryHolder.registerFactory((BaseProviderFactory)HuaweiFactory.instance());
        ProviderFactoryHolder.registerFactory((BaseProviderFactory)NeteaseFactory.instance());
        ProviderFactoryHolder.registerFactory((BaseProviderFactory)TencentFactory.instance());
        ProviderFactoryHolder.registerFactory((BaseProviderFactory)UniFactory.instance());
        ProviderFactoryHolder.registerFactory((BaseProviderFactory)YunPianFactory.instance());
        ProviderFactoryHolder.registerFactory((BaseProviderFactory)ZhutongFactory.instance());
        ProviderFactoryHolder.registerFactory((BaseProviderFactory)LianLuFactory.instance());
        if (SmsUtils.isClassExists((String)"com.jdcloud.sdk.auth.CredentialsProvider")) {
            ProviderFactoryHolder.registerFactory((BaseProviderFactory)JdCloudFactory.instance());
        }
    }
}

