/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.sms4j.starter.config;

import org.dromara.sms4j.provider.config.SmsBanner;
import org.dromara.sms4j.provider.config.SmsConfig;
import org.dromara.sms4j.provider.factory.BeanFactory;
import org.dromara.sms4j.starter.utils.ConfigUtils;
import org.dromara.sms4j.starter.utils.SmsSpringUtils;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.event.EventListener;
import org.springframework.core.env.Environment;

public class SmsMainConfig {
    @Bean
    public SmsSpringUtils smsSpringUtil(DefaultListableBeanFactory defaultListableBeanFactory) {
        return new SmsSpringUtils(defaultListableBeanFactory);
    }

    @Bean
    @ConfigurationProperties(prefix="sms")
    protected SmsConfig smsConfig() {
        return BeanFactory.getSmsConfig();
    }

    @Bean(value={"smsConfigUtil"})
    @Lazy
    protected ConfigUtils configUtil(Environment environment) {
        return new ConfigUtils(environment);
    }

    @EventListener
    void init(ContextRefreshedEvent event) {
        if (BeanFactory.getSmsConfig().getIsPrint().booleanValue()) {
            SmsBanner.PrintBanner((String)"V 3.0.3");
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SmsMainConfig)) {
            return false;
        }
        SmsMainConfig other = (SmsMainConfig)o;
        return other.canEqual(this);
    }

    protected boolean canEqual(Object other) {
        return other instanceof SmsMainConfig;
    }

    public int hashCode() {
        boolean result = true;
        return 1;
    }

    public String toString() {
        return "SmsMainConfig()";
    }
}

