/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.convert.out.fo;

import java.util.List;
import org.docx4j.UnitsOfMeasurement;
import org.docx4j.convert.out.common.AbstractWmlConversionContext;
import org.docx4j.convert.out.common.Writer;
import org.docx4j.convert.out.common.writer.AbstractTableWriter;
import org.docx4j.convert.out.common.writer.AbstractTableWriterModel;
import org.docx4j.convert.out.fo.XsltFOFunctions;
import org.docx4j.model.properties.Property;
import org.docx4j.model.properties.table.tc.TextDir;
import org.docx4j.model.table.TableModelCell;
import org.docx4j.wml.TcPr;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableWriter
extends AbstractTableWriter {
    protected static final Logger logger = LoggerFactory.getLogger(TableWriter.class);
    protected static final String TABLE_BORDER_MODEL = "border-collapse";

    protected Element createNode(Document doc, int nodeType) {
        Element ret = null;
        switch (nodeType) {
            case 0: {
                ret = doc.createElementNS("http://www.w3.org/1999/XSL/Format", "fo:table");
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                ret = doc.createElementNS("http://www.w3.org/1999/XSL/Format", "fo:table-column");
                break;
            }
            case 3: {
                ret = doc.createElementNS("http://www.w3.org/1999/XSL/Format", "fo:table-header");
                break;
            }
            case 4: {
                ret = doc.createElementNS("http://www.w3.org/1999/XSL/Format", "fo:table-row");
                break;
            }
            case 5: {
                ret = doc.createElementNS("http://www.w3.org/1999/XSL/Format", "fo:table-cell");
                break;
            }
            case 6: {
                ret = doc.createElementNS("http://www.w3.org/1999/XSL/Format", "fo:table-body");
                break;
            }
            case 7: {
                ret = doc.createElementNS("http://www.w3.org/1999/XSL/Format", "fo:table-row");
                break;
            }
            case 8: {
                ret = doc.createElementNS("http://www.w3.org/1999/XSL/Format", "fo:table-cell");
            }
        }
        return ret;
    }

    protected void applyAttributes(AbstractWmlConversionContext context, List<Property> properties, Element element) {
        XsltFOFunctions.applyFoAttributes(properties, element);
    }

    protected void applyTableCustomAttributes(AbstractWmlConversionContext context, AbstractTableWriterModel table, Writer.TransformState transformState, Element tableRoot) {
        int cellSpacing;
        int n = cellSpacing = table.getEffectiveTableStyle().getTblPr() != null && table.getEffectiveTableStyle().getTblPr().getTblCellSpacing() != null && table.getEffectiveTableStyle().getTblPr().getTblCellSpacing().getW() != null ? table.getEffectiveTableStyle().getTblPr().getTblCellSpacing().getW().intValue() : 0;
        if (cellSpacing > 0) {
            tableRoot.setAttribute(TABLE_BORDER_MODEL, "separate");
            tableRoot.setAttribute("border-separation", UnitsOfMeasurement.twipToBest((int)(cellSpacing * 2)));
        } else {
            tableRoot.setAttribute(TABLE_BORDER_MODEL, "collapse");
        }
        if (table.getTableWidth() > 0) {
            tableRoot.setAttribute("width", UnitsOfMeasurement.twipToBest((int)table.getTableWidth()));
        }
        if (table.getEffectiveTableStyle().getTblPr() != null && table.getEffectiveTableStyle().getTblPr().getBidiVisual() != null && table.getEffectiveTableStyle().getTblPr().getBidiVisual().isVal()) {
            tableRoot.setAttribute("writing-mode", "rl-tb");
        }
    }

    protected void applyColumnCustomAttributes(AbstractWmlConversionContext context, AbstractTableWriterModel table, Writer.TransformState transformState, Element column, int columnIndex, int columnWidth) {
        column.setAttribute("column-number", Integer.toString(columnIndex + 1));
        if (columnWidth > -1) {
            column.setAttribute("column-width", UnitsOfMeasurement.twipToBest((int)columnWidth));
        }
    }

    protected void applyTableCellCustomAttributes(AbstractWmlConversionContext context, AbstractTableWriterModel table, Writer.TransformState transformState, TableModelCell tableCell, Element cellNode, boolean isHeader, boolean isDummyCell) {
        if (isDummyCell) {
            cellNode.setAttribute("border-style", "none");
            cellNode.setAttribute("background-color", "transparent");
            cellNode.appendChild(cellNode.getOwnerDocument().createElementNS("http://www.w3.org/1999/XSL/Format", "fo:block"));
            return;
        }
        if (tableCell.getExtraCols() > 0) {
            cellNode.setAttribute("number-columns-spanned", Integer.toString(tableCell.getExtraCols() + 1));
        }
        if (tableCell.getExtraRows() > 0) {
            cellNode.setAttribute("number-rows-spanned", Integer.toString(tableCell.getExtraRows() + 1));
        }
    }

    protected void applyTableRowContainerCustomAttributes(AbstractWmlConversionContext context, AbstractTableWriterModel table, Writer.TransformState transformState, Element rowContainer, boolean isHeader) {
        rowContainer.setAttribute("start-indent", "0in");
    }

    protected Element interposeBlockContainer(Document doc, Element cellNode, TcPr tcPr) {
        if (tcPr == null || tcPr.getTextDirection() == null) {
            return cellNode;
        }
        Element ret = doc.createElementNS("http://www.w3.org/1999/XSL/Format", "fo:block-container");
        TextDir textDir = new TextDir(tcPr.getTextDirection());
        textDir.setXslFO(ret);
        cellNode.appendChild(ret);
        if (cellNode.hasAttribute("reference-orientation")) {
            cellNode.removeAttribute("reference-orientation");
        }
        return ret;
    }
}

