/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.convert.out.fo;

import java.util.Map;
import org.docx4j.XmlUtils;
import org.docx4j.convert.out.FORenderer;
import org.docx4j.convert.out.FOSettings;
import org.docx4j.convert.out.common.AbstractConversionContext;
import org.docx4j.convert.out.common.AbstractWmlConversionContext;
import org.docx4j.convert.out.common.ConversionSectionWrapper;
import org.docx4j.convert.out.fo.FOPictWriterNoWrapImpl;
import org.docx4j.convert.out.fo.renderers.AbstractFORenderer;
import org.docx4j.model.structure.PageDimensions;
import org.docx4j.vml.VmlShapeElements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FOPictWriterFloatAvoided
extends FOPictWriterNoWrapImpl {
    protected static Logger log = LoggerFactory.getLogger(FOPictWriterFloatAvoided.class);

    @Override
    public Node handleVTextBoxWrapped(AbstractWmlConversionContext context, Node modelContent, Document doc, VmlShapeElements shape, Map<String, String> props) {
        String mso_position_vertical_relative = props.get("mso-position-vertical-relative");
        String mso_position_vertical = props.get("mso-position-vertical");
        String position = props.get("position");
        ConversionSectionWrapper csw = context.getSections().getCurrentSection();
        PageDimensions pageDimensions = csw.getPageDimensions();
        int writableWidthTwips = pageDimensions.getWritableWidthTwips();
        float writableWidthPts = writableWidthTwips / 20;
        int writableHeightTwips = pageDimensions.getWritableHeightTwips();
        float writableHeightPts = writableHeightTwips / 20;
        FORenderer foRenderer = ((FOSettings)context.getConversionSettings()).getCustomFoRenderer();
        log.debug(foRenderer.getClass().getName());
        log.debug("textbox - wrapped text");
        if (mso_position_vertical_relative != null && mso_position_vertical_relative.equals("text")) {
            Element ret = doc.createElementNS(XSL_FO, "block");
            this.setBorders(ret);
            String margin_top = props.get("margin-top");
            if (margin_top == null) {
                log.error("margin top prop not found.  What to do?");
                XmlUtils.treeCopy((NodeList)modelContent.getChildNodes(), (Node)ret);
                return ret;
            }
            float marginTop = this.parsePtsVal(margin_top);
            if (marginTop <= 0.0f) {
                this.marginTopZeroCase(props, ret, writableWidthPts);
                XmlUtils.treeCopy((NodeList)modelContent.getChildNodes(), (Node)ret);
            } else {
                ret = doc.createElementNS(XSL_FO, "table");
                if (!this.marginTopPositiveCase(foRenderer, props, doc, ret, writableWidthPts, modelContent.getChildNodes())) {
                    ret = doc.createElementNS(XSL_FO, "block");
                    this.setBorders(ret);
                    XmlUtils.treeCopy((NodeList)modelContent.getChildNodes(), (Node)ret);
                }
            }
            log.debug(XmlUtils.w3CDomNodeToString((Node)ret));
            return ret;
        }
        return context.getMessageWriter().message((AbstractConversionContext)context, "TODO for fo:float INcapable renderer, support no-wrap + mso-position-vertical-relative=" + mso_position_vertical_relative);
    }

    private void marginTopZeroCase(Map<String, String> props, Element ret, float widthPts) {
        String mso_position_horizontal_relative = props.get("mso-position-horizontal-relative");
        String mso_position_horizontal = props.get("mso-position-horizontal");
        if (mso_position_horizontal_relative == null) {
            log.warn("No support for mso_position_horizontal_relative==null");
        } else if (!mso_position_horizontal_relative.equals("text")) {
            log.warn("No support for mso_position_horizontal_relative==" + mso_position_horizontal_relative.equals("text"));
        } else {
            float boxWidth = this.parsePtsVal(props.get("width"));
            if (mso_position_horizontal == null) {
                log.warn("No support for mso_position_horizontal==null");
            } else if (mso_position_horizontal.equals("left")) {
                ret.setAttribute("margin-left", "0pt");
                int marginRight = Math.round(widthPts - boxWidth);
                ret.setAttribute("margin-right", marginRight + "pt");
            } else if (mso_position_horizontal.equals("center")) {
                int marginLeft = Math.round((widthPts - boxWidth) / 2.0f);
                ret.setAttribute("margin-left", marginLeft + "pt");
                ret.setAttribute("margin-right", marginLeft + "pt");
            } else if (mso_position_horizontal.equals("right")) {
                ret.setAttribute("margin-right", "0pt");
                int marginLeft = Math.round(widthPts - boxWidth);
                ret.setAttribute("margin-left", marginLeft + "pt");
            } else if (mso_position_horizontal.equals("absolute")) {
                ret.setAttribute("margin-left", props.get("margin-left"));
                float ml = this.parsePtsVal(props.get("margin-left"));
                int mRight = Math.round(widthPts - (boxWidth + ml));
                ret.setAttribute("margin-right", mRight + "pt");
            }
        }
    }

    private boolean marginTopPositiveCase(FORenderer foRenderer, Map<String, String> props, Document doc, Element ret, float widthPts, NodeList childNodes) {
        String mso_position_horizontal_relative = props.get("mso-position-horizontal-relative");
        String mso_position_horizontal = props.get("mso-position-horizontal");
        if (mso_position_horizontal_relative == null) {
            log.warn("No support for mso_position_horizontal_relative==null");
            return false;
        }
        if (!mso_position_horizontal_relative.equals("text")) {
            log.warn("No support for mso_position_horizontal_relative==" + mso_position_horizontal_relative.equals("text"));
            return false;
        }
        float boxWidth = this.parsePtsVal(props.get("width"));
        if (mso_position_horizontal == null) {
            log.warn("No support for mso_position_horizontal==null");
            return false;
        }
        float ml = this.parsePtsVal(props.get("margin-left"));
        if (mso_position_horizontal.equals("absolute")) {
            mso_position_horizontal = (double)(ml / widthPts) < 0.334 ? "left" : ((double)(ml / widthPts) < 0.665 ? "right" : "center");
        }
        if (mso_position_horizontal.equals("left")) {
            Element tcol1 = doc.createElementNS(XSL_FO, "table-column");
            ret.appendChild(tcol1);
            tcol1.setAttribute("column-number", "1");
            int col1W = Math.round(ml + boxWidth);
            tcol1.setAttribute("column-width", col1W + "pt");
            Element tcol2 = doc.createElementNS(XSL_FO, "table-column");
            ret.appendChild(tcol2);
            tcol2.setAttribute("column-number", "2");
            int col2W = Math.round(widthPts - (float)col1W);
            tcol2.setAttribute("column-width", col2W + "pt");
            Element tbody = doc.createElementNS(XSL_FO, "table-body");
            ret.appendChild(tbody);
            Element trow = doc.createElementNS(XSL_FO, "table-row");
            tbody.appendChild(trow);
            Element tc1 = doc.createElementNS(XSL_FO, "table-cell");
            trow.appendChild(tc1);
            Element block = doc.createElementNS(XSL_FO, "block");
            this.setBorders(block);
            tc1.appendChild(block);
            XmlUtils.treeCopy((NodeList)childNodes, (Node)block);
            Element tc2 = doc.createElementNS(XSL_FO, "table-cell");
            trow.appendChild(tc2);
            Element placeholder = doc.createElementNS(XSL_FO, "block");
            placeholder.setTextContent("#TEXTBOX#");
            tc2.appendChild(placeholder);
            if (foRenderer instanceof AbstractFORenderer) {
                ((AbstractFORenderer)foRenderer).TEXTBOX_POSTPROCESSING_REQUIRED = true;
            } else {
                log.warn("TODO: implement TEXTBOX_POSTPROCESSING_REQUIRED for " + foRenderer.getClass().getName());
            }
            return true;
        }
        if (mso_position_horizontal.equals("center")) {
            log.warn("Can't support mso_position_horizontal:center");
            return false;
        }
        if (mso_position_horizontal.equals("right")) {
            Element tcol1 = doc.createElementNS(XSL_FO, "table-column");
            ret.appendChild(tcol1);
            tcol1.setAttribute("column-number", "1");
            int col1W = Math.round(widthPts - boxWidth);
            tcol1.setAttribute("column-width", col1W + "pt");
            Element tcol2 = doc.createElementNS(XSL_FO, "table-column");
            ret.appendChild(tcol2);
            tcol2.setAttribute("column-number", "2");
            int col2W = Math.round(boxWidth);
            tcol2.setAttribute("column-width", col2W + "pt");
            Element tbody = doc.createElementNS(XSL_FO, "table-body");
            ret.appendChild(tbody);
            Element trow = doc.createElementNS(XSL_FO, "table-row");
            tbody.appendChild(trow);
            Element tc1 = doc.createElementNS(XSL_FO, "table-cell");
            trow.appendChild(tc1);
            Element placeholder = doc.createElementNS(XSL_FO, "block");
            placeholder.setTextContent("#TEXTBOX#");
            tc1.appendChild(placeholder);
            Element tc2 = doc.createElementNS(XSL_FO, "table-cell");
            trow.appendChild(tc2);
            Element block = doc.createElementNS(XSL_FO, "block");
            this.setBorders(block);
            tc2.appendChild(block);
            XmlUtils.treeCopy((NodeList)childNodes, (Node)block);
            if (foRenderer instanceof AbstractFORenderer) {
                ((AbstractFORenderer)foRenderer).TEXTBOX_POSTPROCESSING_REQUIRED = true;
            } else {
                log.warn("TODO: implement TEXTBOX_POSTPROCESSING_REQUIRED for " + foRenderer.getClass().getName());
            }
            return true;
        }
        return false;
    }
}

