/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.convert.out.fo;

import java.util.HashMap;
import java.util.Map;
import javax.xml.transform.TransformerException;
import org.docx4j.XmlUtils;
import org.docx4j.convert.out.common.AbstractConversionContext;
import org.docx4j.convert.out.common.AbstractWmlConversionContext;
import org.docx4j.convert.out.common.Writer;
import org.docx4j.convert.out.common.writer.AbstractPictWriter;
import org.docx4j.vml.CTShapetype;
import org.docx4j.vml.CTTextbox;
import org.docx4j.vml.VmlAllCoreAttributes;
import org.docx4j.vml.VmlShapeElements;
import org.docx4j.vml.wordprocessingDrawing.CTWrap;
import org.docx4j.vml.wordprocessingDrawing.STVerticalAnchor;
import org.docx4j.vml.wordprocessingDrawing.STWrapType;
import org.docx4j.wml.Pict;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FOPictWriterAbstract
extends AbstractPictWriter {
    protected static Logger log = LoggerFactory.getLogger(FOPictWriterAbstract.class);
    protected static String XSL_FO = "http://www.w3.org/1999/XSL/Format";

    public Node toNode(AbstractWmlConversionContext context, Object unmarshalledNode, Node modelContent, Writer.TransformState state, Document doc) throws TransformerException {
        String position;
        Pict pict = (Pict)unmarshalledNode;
        VmlShapeElements shape = null;
        for (Object o : pict.getAnyAndAny()) {
            if (!((o = XmlUtils.unwrap(o)) instanceof VmlShapeElements) || o instanceof CTShapetype) continue;
            shape = (VmlShapeElements)o;
            log.debug("Found " + shape.getClass().getName());
            break;
        }
        if (shape == null) {
            return context.getMessageWriter().message((AbstractConversionContext)context, "Couldn't find v:shape (or v:rectangle etc) in w:pict.");
        }
        CTTextbox textBox = null;
        CTWrap w10Wrap = null;
        for (Object o : shape.getEGShapeElements()) {
            if ((o = XmlUtils.unwrap(o)) instanceof CTTextbox) {
                textBox = (CTTextbox)o;
            }
            if (!(o instanceof CTWrap)) continue;
            w10Wrap = (CTWrap)o;
        }
        if (textBox == null) {
            return context.getMessageWriter().message((AbstractConversionContext)context, "Couldn't find v:textbox in w:shape.");
        }
        Map<String, String> props = null;
        if (!(shape instanceof VmlAllCoreAttributes)) {
            log.warn(shape.getClass().getName() + " does not implement VmlAllCoreAttributes, so can't access @style if present");
            return context.getMessageWriter().message((AbstractConversionContext)context, shape.getClass().getName() + " does not implement VmlAllCoreAttributes, so can't access @style if present");
        }
        props = this.getProperties(((VmlAllCoreAttributes)shape).getStyle());
        boolean wrap = true;
        if (w10Wrap != null) {
            if (w10Wrap.getType() != null) {
                if (w10Wrap.getType().equals((Object)STWrapType.SQUARE) || w10Wrap.getType().equals((Object)STWrapType.TIGHT) || w10Wrap.getType().equals((Object)STWrapType.THROUGH)) {
                    return this.handleVTextBoxWrapped(context, modelContent, doc, shape, props);
                }
                if (w10Wrap.getType().equals((Object)STWrapType.TOP_AND_BOTTOM)) {
                    log.warn("TODO: Add support for STWrapType.TOP_AND_BOTTOM");
                } else if (w10Wrap.getType().equals((Object)STWrapType.NONE)) {
                    return this.handleVTextBoxNoWrap(context, modelContent, doc, shape, props);
                }
            }
            if (w10Wrap.getAnchory() != null && w10Wrap.getAnchory().equals((Object)STVerticalAnchor.PAGE)) {
                return this.handleVTextBoxNoWrap(context, modelContent, doc, shape, props);
            }
        }
        if ((position = props.get("position")) != null && position.equals("absolute")) {
            return this.handleVTextBoxNoWrap(context, modelContent, doc, shape, props);
        }
        if (props.get("mso-position-horizontal-relative") != null && props.get("mso-position-horizontal-relative").equals("char")) {
            log.warn("TODO: No support for mso-position-horizontal-relative:char77");
        }
        return this.handleVTextBoxWrapped(context, modelContent, doc, shape, props);
    }

    public abstract Node handleVTextBoxNoWrap(AbstractWmlConversionContext var1, Node var2, Document var3, VmlShapeElements var4, Map<String, String> var5);

    public abstract Node handleVTextBoxWrapped(AbstractWmlConversionContext var1, Node var2, Document var3, VmlShapeElements var4, Map<String, String> var5);

    protected void setBorders(Element ret) {
        ret.setAttribute("border-left-style", "solid");
        ret.setAttribute("border-top-style", "solid");
        ret.setAttribute("border-bottom-style", "solid");
        ret.setAttribute("border-right-style", "solid");
    }

    private Map<String, String> getProperties(String s) {
        if (log.isDebugEnabled()) {
            log.debug(s);
        }
        HashMap<String, String> map = new HashMap<String, String>();
        if (s == null) {
            log.warn("shape has no @style");
            return map;
        }
        for (String entry : s.split(";")) {
            String[] parts = entry.split(":");
            assert (parts.length == 2) : "Invalid entry: " + entry;
            map.put(parts[0], parts[1]);
        }
        return map;
    }

    protected float parsePtsVal(String pts) {
        if (pts == null) {
            log.warn("No val!");
            return -99.0f;
        }
        if (pts.contains("pt")) {
            pts = pts.substring(0, pts.indexOf("pt"));
            return Float.parseFloat(pts);
        }
        if (pts.equals("0")) {
            return 0.0f;
        }
        log.warn("Unit is not points! " + pts);
        return -99.0f;
    }
}

