/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.sql.method;

import java.util.List;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.store.rdbms.mapping.java.JavaTypeMapping;
import org.datanucleus.store.rdbms.sql.expression.AggregateNumericExpression;
import org.datanucleus.store.rdbms.sql.expression.SQLExpression;
import org.datanucleus.store.rdbms.sql.method.SimpleNumericAggregateMethod;

public class SumFunction
extends SimpleNumericAggregateMethod {
    @Override
    protected String getFunctionName() {
        return "SUM";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public SQLExpression getExpression(SQLExpression expr, List args) {
        if (expr != null) throw new NucleusException(LOCALISER.msg("060002", (Object)this.getFunctionName(), (Object)expr));
        if (args == null || args.size() != 1) {
            throw new NucleusException(this.getFunctionName() + " is only supported with a single argument");
        }
        JavaTypeMapping m = null;
        if (args.get(0) instanceof SQLExpression) {
            SQLExpression argExpr = (SQLExpression)args.get(0);
            Class cls = argExpr.getJavaTypeMapping().getJavaType();
            if (cls == Integer.class || cls == Short.class || cls == Long.class) {
                m = this.getMappingForClass(Long.class);
                return new AggregateNumericExpression(this.stmt, m, this.getFunctionName(), args);
            } else {
                if (!Number.class.isAssignableFrom(cls)) throw new NucleusUserException("Cannot perform static SUM with arg of type " + cls.getName());
                m = this.getMappingForClass(argExpr.getJavaTypeMapping().getJavaType());
            }
            return new AggregateNumericExpression(this.stmt, m, this.getFunctionName(), args);
        } else {
            m = this.getMappingForClass(this.getClassForMapping());
        }
        return new AggregateNumericExpression(this.stmt, m, this.getFunctionName(), args);
    }

    @Override
    protected Class getClassForMapping() {
        return Double.TYPE;
    }
}

