/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.server;

import java.io.IOException;
import java.util.Collections;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.cometd.bayeux.server.ServerSession;
import org.cometd.server.BayeuxServerImpl;
import org.cometd.server.ServerSessionImpl;
import org.cometd.server.transport.AbstractHttpTransport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CometDServlet
extends HttpServlet {
    private static final long serialVersionUID = 3637310585741732936L;
    protected final Logger _logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private BayeuxServerImpl _bayeux;

    public void init() throws ServletException {
        try {
            boolean export = false;
            this._bayeux = (BayeuxServerImpl)((Object)this.getServletContext().getAttribute("org.cometd.bayeux"));
            if (this._bayeux == null) {
                export = true;
                this._bayeux = this.newBayeuxServer();
                for (String initParamName : Collections.list(this.getInitParameterNames())) {
                    this._bayeux.setOption(initParamName, this.getInitParameter(initParamName));
                }
                this._bayeux.setOption(ServletContext.class.getName(), this.getServletContext());
            }
            this._bayeux.start();
            if (export) {
                this.getServletContext().setAttribute("org.cometd.bayeux", (Object)this._bayeux);
            }
        }
        catch (Exception x) {
            throw new ServletException((Throwable)x);
        }
    }

    public BayeuxServerImpl getBayeux() {
        return this._bayeux;
    }

    protected BayeuxServerImpl newBayeuxServer() {
        return new BayeuxServerImpl();
    }

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if ("OPTIONS".equals(request.getMethod())) {
            this.serviceOptions(request, response);
            return;
        }
        AbstractHttpTransport transport = this._bayeux.findHttpTransport(request);
        if (transport == null) {
            response.sendError(400, "Unknown Bayeux Transport");
        } else {
            transport.handle(request, response);
        }
    }

    protected void serviceOptions(HttpServletRequest request, HttpServletResponse response) {
    }

    public void destroy() {
        for (ServerSession session : this._bayeux.getSessions()) {
            ((ServerSessionImpl)session).destroyScheduler();
        }
        try {
            this._bayeux.stop();
        }
        catch (Exception x) {
            if (this._logger.isDebugEnabled()) {
                this._logger.debug("", (Throwable)x);
            }
        }
        finally {
            this._bayeux = null;
            this.getServletContext().removeAttribute("org.cometd.bayeux");
        }
    }
}

