/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.graph;

import com.google.common.collect.HashMultiset;
import com.google.common.collect.Multiset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.sonar.graph.Cycle;
import org.sonar.graph.Edge;
import org.sonar.graph.FeedbackEdge;

public final class FeedbackCycle
implements Iterable<FeedbackEdge>,
Comparable<FeedbackCycle> {
    private List<FeedbackEdge> orderedFeedbackEdges = new ArrayList<FeedbackEdge>();
    private int totalOccurrencesOfEdgesInCycle = 0;
    private final Cycle cycle;

    private FeedbackCycle(Cycle cycle) {
        this.cycle = cycle;
    }

    private void add(FeedbackEdge feedbackEdge) {
        this.orderedFeedbackEdges.add(feedbackEdge);
    }

    public static List<FeedbackCycle> buildFeedbackCycles(Set<Cycle> cycles) {
        Multiset<Edge> edgesBag = FeedbackCycle.createBagWithAllEdgesOfCycles(cycles);
        ArrayList<FeedbackCycle> feedbackCycles = new ArrayList<FeedbackCycle>();
        for (Cycle cycle : cycles) {
            FeedbackCycle feedbackCycle = new FeedbackCycle(cycle);
            int totalOccurrences = 0;
            for (Edge edge : cycle.getEdges()) {
                FeedbackEdge feedbackEdge = new FeedbackEdge(edge, edgesBag.count((Object)edge));
                feedbackCycle.add(feedbackEdge);
                totalOccurrences += feedbackEdge.getOccurences();
            }
            feedbackCycle.setTotalOccurrencesOfEdgesInCycle(totalOccurrences);
            Collections.sort(feedbackCycle.orderedFeedbackEdges);
            feedbackCycles.add(feedbackCycle);
        }
        Collections.sort(feedbackCycles);
        return feedbackCycles;
    }

    private static Multiset<Edge> createBagWithAllEdgesOfCycles(Set<Cycle> cycles) {
        HashMultiset edgesBag = HashMultiset.create();
        for (Cycle cycle : cycles) {
            for (Edge edge : cycle.getEdges()) {
                edgesBag.add((Object)edge);
            }
        }
        return edgesBag;
    }

    private void setTotalOccurrencesOfEdgesInCycle(int totalOccurrencesOfEdgesInCycle) {
        this.totalOccurrencesOfEdgesInCycle = totalOccurrencesOfEdgesInCycle;
    }

    public int getTotalOccurrencesOfEdgesInCycle() {
        return this.totalOccurrencesOfEdgesInCycle;
    }

    @Override
    public Iterator<FeedbackEdge> iterator() {
        return this.orderedFeedbackEdges.iterator();
    }

    @Override
    public int compareTo(FeedbackCycle feedbackCycle) {
        if (this.getTotalOccurrencesOfEdgesInCycle() < feedbackCycle.getTotalOccurrencesOfEdgesInCycle()) {
            return -1;
        }
        if (this.getTotalOccurrencesOfEdgesInCycle() == feedbackCycle.getTotalOccurrencesOfEdgesInCycle()) {
            if (this.cycle.size() == feedbackCycle.cycle.size()) {
                return this.orderedFeedbackEdges.get(0).compareTo(feedbackCycle.orderedFeedbackEdges.get(0));
            }
            return this.cycle.size() - feedbackCycle.cycle.size();
        }
        return 1;
    }

    public Cycle getCycle() {
        return this.cycle;
    }
}

