/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.graph;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.sonar.graph.Cycle;
import org.sonar.graph.DirectedGraphAccessor;
import org.sonar.graph.Edge;
import org.sonar.graph.MaximumCyclesToFoundException;

public class CycleDetector<V> {
    private Set<V> vertices;
    private DirectedGraphAccessor<V, ? extends Edge> graph;
    private Set<V> analyzedVertices;
    private Set<Cycle> cycles = new HashSet<Cycle>();
    private Set<Edge> edgesToExclude;
    private long searchCyclesCalls = 0L;
    private int maxSearchDepth = -1;
    private boolean maxSearchDepthActivated = false;
    private int maxCyclesToFound = Integer.MAX_VALUE;

    public CycleDetector(DirectedGraphAccessor<V, ? extends Edge> graph, Collection<V> vertices) {
        this.init(graph, vertices, new HashSet<Edge>());
    }

    public CycleDetector(DirectedGraphAccessor<V, ? extends Edge> graph, Collection<V> vertices, Set<Edge> edgesToExclude) {
        this.init(graph, vertices, edgesToExclude);
    }

    public CycleDetector(DirectedGraphAccessor<V, ? extends Edge> graph) {
        this.init(graph, graph.getVertices(), new HashSet<Edge>());
    }

    public CycleDetector(DirectedGraphAccessor<V, ? extends Edge> graph, Set<Edge> edgesToExclude) {
        this.init(graph, graph.getVertices(), edgesToExclude);
    }

    private void init(DirectedGraphAccessor<V, ? extends Edge> graph, Collection<V> vertices, Set<Edge> edgesToExclude) {
        this.graph = graph;
        this.vertices = new HashSet<V>(vertices);
        this.analyzedVertices = new HashSet<V>();
        this.edgesToExclude = edgesToExclude;
    }

    public Set<Cycle> detectCycles() {
        this.run();
        return this.getCycles();
    }

    public Set<Cycle> detectCyclesWithUpperLimit(int maxCyclesToFound) {
        this.maxCyclesToFound = maxCyclesToFound;
        this.run();
        return this.getCycles();
    }

    public Set<Cycle> detectCyclesWithMaxSearchDepth(int maxSearchDepth) {
        if (maxSearchDepth > 1) {
            this.maxSearchDepthActivated = true;
            this.maxSearchDepth = maxSearchDepth;
        }
        this.run();
        return this.getCycles();
    }

    private void run() {
        if (!this.cycles.isEmpty()) {
            throw new IllegalStateException("Cycle detection can't be executed twice on the same CycleDetector object.");
        }
        try {
            for (V vertex : this.vertices) {
                if (!this.maxSearchDepthActivated && this.analyzedVertices.contains(vertex)) continue;
                HashSet tmpAnalyzedVertices = new HashSet();
                this.searchCycles(vertex, new ArrayList(), tmpAnalyzedVertices);
                this.analyzedVertices.addAll(tmpAnalyzedVertices);
            }
        }
        catch (MaximumCyclesToFoundException maximumCyclesToFoundException) {
            // empty catch block
        }
    }

    private void searchCycles(V fromVertex, List<V> path, Set<V> tmpAnalyzedVertices) {
        ++this.searchCyclesCalls;
        path.add(fromVertex);
        tmpAnalyzedVertices.add(fromVertex);
        for (Edge edge : this.graph.getOutgoingEdges(fromVertex)) {
            Object toVertex = edge.getTo();
            if (this.edgesToExclude.contains(edge) || !this.vertices.contains(toVertex) || !this.maxSearchDepthActivated && this.analyzedVertices.contains(toVertex)) continue;
            if (path.contains(toVertex)) {
                path.add(toVertex);
                List<V> cyclePath = path.subList(path.indexOf(toVertex), path.size());
                Cycle cycle = this.convertListOfVerticesToCycle(cyclePath);
                this.cycles.add(cycle);
                if (this.cycles.size() >= this.maxCyclesToFound) {
                    throw new MaximumCyclesToFoundException();
                }
                path.remove(path.size() - 1);
                continue;
            }
            if (this.maxSearchDepthActivated && (!this.maxSearchDepthActivated || path.size() >= this.maxSearchDepth)) continue;
            this.searchCycles(toVertex, path, tmpAnalyzedVertices);
        }
        path.remove(path.size() - 1);
    }

    private Cycle convertListOfVerticesToCycle(List<V> vertices) {
        V firstVertex;
        ArrayList<Edge> edges = new ArrayList<Edge>();
        V from = firstVertex = vertices.get(0);
        for (int index = 1; index < vertices.size(); ++index) {
            V to = vertices.get(index);
            edges.add(this.graph.getEdge(from, to));
            from = to;
        }
        return new Cycle(edges);
    }

    public Set<Cycle> getCycles() {
        return this.cycles;
    }

    public boolean isAcyclicGraph() {
        return this.cycles.isEmpty();
    }

    public long getSearchCyclesCalls() {
        return this.searchCyclesCalls;
    }
}

