/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.jaxb2.shared.filters;

import java.util.ArrayList;
import java.util.List;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.mojo.jaxb2.AbstractJaxbMojo;
import org.codehaus.mojo.jaxb2.shared.Validate;
import org.codehaus.mojo.jaxb2.shared.filters.Filter;

public abstract class AbstractFilter<T>
implements Filter<T> {
    protected static final String TOSTRING_INDENT = "|        ";
    protected Log log;
    private List<DelayedLogMessage> delayedLogMessages = new ArrayList<DelayedLogMessage>();
    private boolean processNullValues;

    protected AbstractFilter() {
        this.setProcessNullValues(false);
    }

    protected final void validateDiSetterCalledBeforeInitialization(String setterPropertyName) {
        Validate.isTrue(this.log == null, "DI Setters should only be called before initializing. Stray call: [" + setterPropertyName + "]");
    }

    protected final void addDelayedLogMessage(String logLevel, String message) {
        this.delayedLogMessages.add(new DelayedLogMessage(logLevel, message));
    }

    protected final void setProcessNullValues(boolean processNullValues) {
        this.validateDiSetterCalledBeforeInitialization("processNullValues");
        this.processNullValues = processNullValues;
    }

    @Override
    public final void initialize(Log log) {
        Validate.notNull(log, "log");
        this.log = log;
        if (this.delayedLogMessages.size() > 0) {
            for (DelayedLogMessage current : this.delayedLogMessages) {
                if (current.logLevel.equalsIgnoreCase("warn") && log.isWarnEnabled()) {
                    log.warn((CharSequence)current.message);
                    continue;
                }
                if (current.logLevel.equals("info") && log.isInfoEnabled()) {
                    log.info((CharSequence)current.message);
                    continue;
                }
                if (!log.isDebugEnabled()) continue;
                log.debug((CharSequence)current.message);
            }
            this.delayedLogMessages.clear();
        }
        this.onInitialize();
    }

    @Override
    public boolean isInitialized() {
        return this.log != null;
    }

    protected void onInitialize() {
    }

    @Override
    public final boolean accept(T candidate) throws IllegalStateException {
        if (this.log == null) {
            throw new IllegalStateException("Filter [" + this.getClass().getSimpleName() + "] not initialized before use.");
        }
        if (candidate == null) {
            boolean toReturn = false;
            if (this.processNullValues) {
                toReturn = this.onNullCandidate();
            } else if (this.log.isDebugEnabled()) {
                this.log.debug((CharSequence)("Received null candidate, and Filter [" + this.getClass().getSimpleName() + "] is configured not to match nulls."));
            }
            return toReturn;
        }
        return this.onCandidate(candidate);
    }

    protected boolean onNullCandidate() {
        if (this.log.isDebugEnabled()) {
            this.log.debug((CharSequence)("Filter [" + this.getClass().getSimpleName() + "] is configured to matchAtLeastOnce processing null candidate values, but no implementation is supplied."));
        }
        return false;
    }

    protected abstract boolean onCandidate(T var1);

    public String toString() {
        return "Filter [" + this.getClass().getSimpleName() + "]" + AbstractJaxbMojo.NEWLINE + TOSTRING_INDENT + "Processes nulls: [" + this.processNullValues + "]" + AbstractJaxbMojo.NEWLINE;
    }

    class DelayedLogMessage {
        String message;
        String logLevel;

        public DelayedLogMessage(String logLevel, String message) {
            this.logLevel = logLevel;
            this.message = message;
        }
    }
}

