/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util.os.unix;

import com.izforge.izpack.util.FileExecutor;
import com.izforge.izpack.util.os.unix.ShellScript;
import com.izforge.izpack.util.os.unix.UnixConstants;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.StringReader;
import java.io.Writer;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnixHelper {
    public static String whichCommand = FileExecutor.getExecOutput(new String[]{"/usr/bin/env", "which", "which"}, false).trim();
    public static final String VERSION = "$Revision$";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<String> getEtcPasswdArray() {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = "";
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new FileReader(UnixConstants.etcPasswd));
            while ((string = bufferedReader.readLine()) != null) {
                arrayList.add(string);
            }
        }
        catch (Exception exception) {
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (Exception exception) {}
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<String> getYpPasswdArray() {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = "";
        BufferedReader bufferedReader = null;
        String string2 = UnixHelper.getYpCatCommand();
        if (string2 != null && string2.length() > 0) {
            try {
                bufferedReader = new BufferedReader(new StringReader(FileExecutor.getExecOutput(new String[]{string2, "passwd"})));
                while ((string = bufferedReader.readLine()) != null) {
                    arrayList.add(string);
                }
            }
            catch (Exception exception) {
            }
            finally {
                try {
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        return arrayList;
    }

    public static boolean kdeIsInstalled() {
        FileExecutor fileExecutor = new FileExecutor();
        String[] stringArray = new String[2];
        int n = fileExecutor.executeCommand(new String[]{"/usr/bin/env", "kwin", "--version"}, stringArray);
        return n == 0;
    }

    public static String getWhichCommand() {
        return whichCommand;
    }

    public static String getCpCommand() {
        return FileExecutor.getExecOutput(new String[]{UnixHelper.getWhichCommand(), "cp"}).trim();
    }

    public static String getSuCommand() {
        return FileExecutor.getExecOutput(new String[]{UnixHelper.getWhichCommand(), "su"}).trim();
    }

    public static String getRmCommand() {
        return FileExecutor.getExecOutput(new String[]{whichCommand, "rm"}).trim();
    }

    public static String getYpCatCommand() {
        return FileExecutor.getExecOutput(new String[]{whichCommand, "ypcat"}).trim();
    }

    public static String getCustomCommand(String string) {
        return FileExecutor.getExecOutput(new String[]{whichCommand, string}).trim();
    }

    public static void main(String[] stringArray) {
        System.out.println("Hallo from " + UnixHelper.class.getName() + VERSION);
        System.out.println("WhichCommand: '" + UnixHelper.getWhichCommand() + "'");
        System.out.println("SuCommand: " + UnixHelper.getSuCommand());
        System.out.println("RmCommand: " + UnixHelper.getRmCommand());
        System.out.println("CopyCommand: " + UnixHelper.getCpCommand());
        System.out.println("YpCommand: " + UnixHelper.getYpCatCommand());
        System.out.println("CustomCommand: " + UnixHelper.getCustomCommand("cat"));
        File file = null;
        try {
            file = File.createTempFile(UnixHelper.class.getName(), Long.toString(System.currentTimeMillis()) + ".tmp");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        System.out.println("Tempfile: " + file.toString());
        System.out.println("TempfileName: " + file.getName());
        String string = System.getProperty("user.name");
        if ("root".equals(string)) {
            Object object;
            try {
                object = new BufferedWriter(new FileWriter(file));
                ((Writer)object).write("Hallo");
                ((BufferedWriter)object).flush();
                ((BufferedWriter)object).close();
                if (file.exists()) {
                    System.out.println("Wrote: " + file + ">>Hallo");
                } else {
                    System.out.println("Could not Wrote: " + file + "Hallo");
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            object = "/home/marc.eppelmann" + File.separator + "Desktop" + File.separator + file.getName();
            System.out.println("Copy: " + file.toString() + " to " + (String)object);
            ShellScript shellScript = new ShellScript("bash");
            shellScript.append(UnixHelper.getSuCommand() + " " + "marc.eppelmann" + " " + "-c" + " " + "\"" + UnixHelper.getCpCommand() + " " + file.toString() + " " + (String)object + "\"");
            String string2 = "/tmp/x.21.21";
            try {
                string2 = File.createTempFile(UnixHelper.class.getName(), Long.toString(System.currentTimeMillis()) + ".sh").toString();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            shellScript.write(string2);
            shellScript.exec();
        } else {
            System.out.println("Your name: '" + string + "' is not 'root'. But this is a test for the user root.");
        }
    }
}

