/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util;

import com.izforge.izpack.util.Debug;
import com.izforge.izpack.util.FileUtil;
import com.izforge.izpack.util.OsVersionConstants;
import com.izforge.izpack.util.StringConstants;
import com.izforge.izpack.util.StringTool;
import java.io.File;
import java.io.IOException;

public final class OsVersion
implements OsVersionConstants,
StringConstants {
    public static final String OS_NAME = System.getProperty("os.name");
    public static final String OS_ARCH = System.getProperty("os.arch");
    public static final String OS_VERSION = System.getProperty("os.version");
    public static final boolean IS_X86 = StringTool.startsWithIgnoreCase(OS_ARCH, "x86") || StringTool.startsWithIgnoreCase(OS_ARCH, "i386");
    public static final boolean IS_PPC = StringTool.startsWithIgnoreCase(OS_ARCH, "ppc");
    public static final boolean IS_SPARC = StringTool.startsWithIgnoreCase(OS_ARCH, "sparc");
    public static final boolean IS_FREEBSD = StringTool.startsWithIgnoreCase(OS_NAME, "FreeBSD");
    public static final boolean IS_LINUX = StringTool.startsWithIgnoreCase(OS_NAME, "Linux");
    public static final boolean IS_HPUX = StringTool.startsWithIgnoreCase(OS_NAME, "HP-UX");
    public static final boolean IS_AIX = StringTool.startsWithIgnoreCase(OS_NAME, "AIX");
    public static final boolean IS_SUNOS = StringTool.startsWithIgnoreCase(OS_NAME, "SunOS") || StringTool.startsWithIgnoreCase(OS_NAME, "Solaris");
    public static final boolean IS_SUNOS_X86 = IS_SUNOS && IS_X86;
    public static final boolean IS_SUNOS_SPARC = IS_SUNOS && IS_SPARC;
    public static final boolean IS_OS2 = StringTool.startsWith(OS_NAME, "OS/2");
    public static final boolean IS_MAC = StringTool.startsWith(OS_NAME, "Mac");
    public static final boolean IS_OSX = StringTool.startsWithIgnoreCase(OS_NAME, "mac os x");
    public static final boolean IS_WINDOWS = StringTool.startsWith(OS_NAME, "Windows");
    public static final boolean IS_WINDOWS_XP = IS_WINDOWS && OS_VERSION.equals("5.1");
    public static final boolean IS_WINDOWS_2003 = IS_WINDOWS && OS_VERSION.equals("5.2");
    public static final boolean IS_WINDOWS_VISTA = IS_WINDOWS && OS_VERSION.equals("6.0");
    public static final boolean IS_WINDOWS_7 = IS_WINDOWS && OS_VERSION.equals("6.1");
    public static final boolean IS_UNIX = !IS_OS2 && !IS_WINDOWS;
    public static final boolean IS_REDHAT_LINUX = IS_LINUX && (FileUtil.fileContains(OsVersion.getReleaseFileName(), "RedHat") || FileUtil.fileContains(OsVersion.getReleaseFileName(), "Red Hat"));
    public static final boolean IS_FEDORA_LINUX = IS_LINUX && FileUtil.fileContains(OsVersion.getReleaseFileName(), "Fedora");
    public static final boolean IS_MANDRAKE_LINUX = IS_LINUX && FileUtil.fileContains(OsVersion.getReleaseFileName(), "Mandrake");
    public static final boolean IS_MANDRIVA_LINUX = IS_LINUX && FileUtil.fileContains(OsVersion.getReleaseFileName(), "Mandriva") || IS_MANDRAKE_LINUX;
    public static final boolean IS_SUSE_LINUX = IS_LINUX && FileUtil.fileContains(OsVersion.getReleaseFileName(), "SuSE", true);
    public static final boolean IS_DEBIAN_LINUX = IS_LINUX && FileUtil.fileContains("/proc/version", "Debian") || IS_LINUX && new File("/etc/debian_version").exists();

    private static String getReleaseFileName() {
        String string = "";
        File[] fileArray = new File("/etc").listFiles();
        if (fileArray != null) {
            for (File file : fileArray) {
                if (!file.isFile() || !file.getName().endsWith("-release")) continue;
                string = file.toString();
                return string;
            }
        }
        return string;
    }

    private static String getLinuxDistribution() {
        String string = null;
        if (IS_SUSE_LINUX) {
            try {
                string = "SuSE Linux\n" + StringTool.stringArrayListToString(FileUtil.getFileContent(OsVersion.getReleaseFileName()));
            }
            catch (IOException iOException) {}
        } else if (IS_REDHAT_LINUX) {
            try {
                string = "RedHat Linux\n" + StringTool.stringArrayListToString(FileUtil.getFileContent(OsVersion.getReleaseFileName()));
            }
            catch (IOException iOException) {}
        } else if (IS_FEDORA_LINUX) {
            try {
                string = "Fedora Linux\n" + StringTool.stringArrayListToString(FileUtil.getFileContent(OsVersion.getReleaseFileName()));
            }
            catch (IOException iOException) {}
        } else if (IS_MANDRAKE_LINUX) {
            try {
                string = "Mandrake Linux\n" + StringTool.stringArrayListToString(FileUtil.getFileContent(OsVersion.getReleaseFileName()));
            }
            catch (IOException iOException) {}
        } else if (IS_MANDRIVA_LINUX) {
            try {
                string = "Mandriva Linux\n" + StringTool.stringArrayListToString(FileUtil.getFileContent(OsVersion.getReleaseFileName()));
            }
            catch (IOException iOException) {}
        } else if (IS_DEBIAN_LINUX) {
            try {
                string = "Debian Linux\n" + StringTool.stringArrayListToString(FileUtil.getFileContent("/etc/debian_version"));
            }
            catch (IOException iOException) {}
        } else {
            try {
                string = "Unknown Linux Distribution\n" + StringTool.stringArrayListToString(FileUtil.getFileContent(OsVersion.getReleaseFileName()));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return string;
    }

    public static String getOsDetails() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("OS_NAME=").append(OS_NAME).append("\n");
        if (IS_UNIX) {
            if (IS_LINUX) {
                stringBuffer.append(OsVersion.getLinuxDistribution()).append("\n");
            } else {
                try {
                    stringBuffer.append(FileUtil.getFileContent(OsVersion.getReleaseFileName())).append("\n");
                }
                catch (IOException iOException) {
                    Debug.log("Unable to get release file contents in 'getOsDetails'.");
                }
            }
        }
        if (IS_WINDOWS) {
            stringBuffer.append(System.getProperty("os.name")).append(" ").append(System.getProperty("sun.os.patch.level", "")).append("\n");
        }
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        System.out.println(OsVersion.getOsDetails());
    }
}

