/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.uninstaller;

import com.izforge.izpack.installer.PrivilegedRunner;
import com.izforge.izpack.uninstaller.SelfModifier;
import com.izforge.izpack.uninstaller.UninstallerConsole;
import com.izforge.izpack.uninstaller.UninstallerFrame;
import com.izforge.izpack.util.Housekeeper;
import com.izforge.izpack.util.OsVersion;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class Uninstaller {
    public static void main(String[] stringArray) {
        Uninstaller.checkForPrivilegedExecution();
        boolean bl = false;
        for (String string : stringArray) {
            if (!string.equals("-c")) continue;
            bl = true;
        }
        if (bl) {
            System.out.println("Command line uninstaller.\n");
        }
        try {
            Class<Uninstaller> clazz = Uninstaller.class;
            Method method = bl ? clazz.getMethod("cmduninstall", String[].class) : clazz.getMethod("uninstall", String[].class);
            new SelfModifier(method).invoke(stringArray);
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
            exception.printStackTrace();
            System.err.println("Unable to exec java as a subprocess.");
            System.err.println("The uninstall may not fully complete.");
            Uninstaller.uninstall(stringArray);
        }
    }

    private static File getInstallPath() {
        try {
            InputStream inputStream = Uninstaller.class.getResourceAsStream("/install.log");
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            String string = bufferedReader.readLine();
            bufferedReader.close();
            return new File(string);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    private static void checkForPrivilegedExecution() {
        if (PrivilegedRunner.isPrivilegedMode()) {
            return;
        }
        if (Uninstaller.elevationShouldBeInvestigated()) {
            PrivilegedRunner privilegedRunner = new PrivilegedRunner();
            if (privilegedRunner.isPlatformSupported() && Uninstaller.isElevationNeeded()) {
                try {
                    if (privilegedRunner.relaunchWithElevatedRights() != 0) {
                        throw new RuntimeException("Launching an uninstaller with elevated permissions failed.");
                    }
                    System.exit(0);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    JOptionPane.showMessageDialog(null, "The uninstaller could not launch itself with administrator permissions.\nThe uninstallation will still continue but you may encounter problems due to insufficient permissions.");
                }
            } else if (!privilegedRunner.isPlatformSupported()) {
                JOptionPane.showMessageDialog(null, "This uninstaller should be run by an administrator.\nThe uninstallation will still continue but you may encounter problems due to insufficient permissions.");
            }
        }
    }

    private static boolean elevationShouldBeInvestigated() {
        return Uninstaller.class.getResource("/exec-admin") != null || OsVersion.IS_WINDOWS && !new PrivilegedRunner().canWriteToProgramFiles();
    }

    public static void cmduninstall(String[] stringArray) {
        try {
            UninstallerConsole uninstallerConsole = new UninstallerConsole();
            boolean bl = false;
            for (String string : stringArray) {
                if (!string.equals("-f")) continue;
                bl = true;
            }
            System.out.println("Force deletion: " + bl);
            uninstallerConsole.runUninstall(bl);
        }
        catch (Exception exception) {
            System.err.println("- Error -");
            exception.printStackTrace();
            Housekeeper.getInstance().shutDown(0);
        }
    }

    public static void uninstall(final String[] stringArray) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                try {
                    boolean bl = true;
                    boolean bl2 = false;
                    for (String string : stringArray) {
                        if (string.equals("-f")) {
                            bl2 = true;
                            continue;
                        }
                        if (!string.equals("-x")) continue;
                        bl = false;
                    }
                    UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                    new UninstallerFrame(bl, bl2);
                }
                catch (Exception exception) {
                    System.err.println("- Error -");
                    exception.printStackTrace();
                    Housekeeper.getInstance().shutDown(0);
                }
            }
        });
    }

    private static boolean isElevationNeeded() {
        return !Uninstaller.getInstallPath().canWrite();
    }
}

