/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer;

import com.izforge.izpack.util.OsVersion;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrivilegedRunner {
    private boolean vetoed = false;

    public PrivilegedRunner() {
    }

    public PrivilegedRunner(boolean bl) {
        this.vetoed = bl;
    }

    public boolean isVetoed() {
        return this.vetoed;
    }

    public boolean isPlatformSupported() {
        return OsVersion.IS_MAC || OsVersion.IS_UNIX || OsVersion.IS_WINDOWS;
    }

    public boolean isElevationNeeded() {
        if (this.vetoed) {
            return false;
        }
        if (OsVersion.IS_WINDOWS) {
            return !PrivilegedRunner.isPrivilegedMode() && !this.canWriteToProgramFiles();
        }
        return !System.getProperty("user.name").equals("root");
    }

    public boolean canWriteToProgramFiles() {
        try {
            File file;
            String string = System.getenv("ProgramFiles");
            if (string == null) {
                string = "C:\\Program Files";
            }
            if ((file = new File(string, "foo.txt")).createNewFile()) {
                file.delete();
                return true;
            }
            return false;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public int relaunchWithElevatedRights() throws IOException, InterruptedException {
        String string = this.getJavaCommand();
        String string2 = this.getInstallerJar();
        ProcessBuilder processBuilder = new ProcessBuilder(this.getElevator(string, string2));
        processBuilder.environment().put("izpack.mode", "privileged");
        return processBuilder.start().waitFor();
    }

    private List<String> getElevator(String string, String string2) throws IOException, InterruptedException {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (OsVersion.IS_OSX) {
            arrayList.add(this.extractMacElevator().getCanonicalPath());
            arrayList.add(string);
            arrayList.add("-jar");
            arrayList.add(string2);
        } else if (OsVersion.IS_UNIX) {
            arrayList.add("xterm");
            arrayList.add("-title");
            arrayList.add("Installer");
            arrayList.add("-e");
            arrayList.add("sudo");
            arrayList.add(string);
            arrayList.add("-jar");
            arrayList.add(string2);
        } else if (OsVersion.IS_WINDOWS) {
            arrayList.add("wscript");
            arrayList.add(this.extractVistaElevator().getCanonicalPath());
            arrayList.add(string);
            arrayList.add("-Dizpack.mode=privileged");
            arrayList.add("-jar");
            arrayList.add(string2);
        }
        return arrayList;
    }

    private File extractVistaElevator() throws IOException {
        String string = System.getProperty("java.io.tmpdir") + File.separator + "Installer.js";
        File file = new File(string);
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        InputStream inputStream = this.getClass().getResourceAsStream("/com/izforge/izpack/installer/elevate.js");
        this.copyStream(fileOutputStream, inputStream);
        inputStream.close();
        fileOutputStream.close();
        file.deleteOnExit();
        return file;
    }

    private File extractMacElevator() throws IOException, InterruptedException {
        String string = System.getProperty("java.io.tmpdir") + File.separator + "Installer";
        File file = new File(string);
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        InputStream inputStream = this.getClass().getResourceAsStream("/com/izforge/izpack/installer/run-with-privileges-on-osx");
        this.copyStream(fileOutputStream, inputStream);
        inputStream.close();
        fileOutputStream.close();
        this.makeExecutable(string);
        file.deleteOnExit();
        return file;
    }

    private void makeExecutable(String string) throws InterruptedException, IOException {
        new ProcessBuilder("/bin/chmod", "+x", string).start().waitFor();
    }

    private void copyStream(OutputStream outputStream, InputStream inputStream) throws IOException {
        byte[] byArray = new byte[1024];
        int n = 0;
        while ((n = inputStream.read(byArray)) >= 0) {
            outputStream.write(byArray, 0, n);
        }
    }

    private String getInstallerJar() {
        try {
            URI uRI = this.getClass().getProtectionDomain().getCodeSource().getLocation().toURI();
            if (!"file".equals(uRI.getScheme())) {
                throw new Exception("Unexpected scheme in JAR file URI: " + uRI);
            }
            return new File(uRI.getSchemeSpecificPart()).getCanonicalPath();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private String getJavaCommand() {
        return System.getProperty("java.home") + File.separator + "bin" + File.separator + this.getJavaExecutable();
    }

    private String getJavaExecutable() {
        if (OsVersion.IS_WINDOWS) {
            return "javaw.exe";
        }
        return "java";
    }

    public static boolean isPrivilegedMode() {
        return "privileged".equals(System.getenv("izpack.mode")) || "privileged".equals(System.getProperty("izpack.mode"));
    }
}

