/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.shaded.dataflow.expression;

import java.util.ArrayList;
import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.PolyNull;
import org.checkerframework.shaded.dataflow.expression.ArrayAccess;
import org.checkerframework.shaded.dataflow.expression.ArrayCreation;
import org.checkerframework.shaded.dataflow.expression.BinaryOperation;
import org.checkerframework.shaded.dataflow.expression.ClassName;
import org.checkerframework.shaded.dataflow.expression.FieldAccess;
import org.checkerframework.shaded.dataflow.expression.JavaExpression;
import org.checkerframework.shaded.dataflow.expression.JavaExpressionVisitor;
import org.checkerframework.shaded.dataflow.expression.LocalVariable;
import org.checkerframework.shaded.dataflow.expression.MethodCall;
import org.checkerframework.shaded.dataflow.expression.ThisReference;
import org.checkerframework.shaded.dataflow.expression.UnaryOperation;
import org.checkerframework.shaded.dataflow.expression.Unknown;
import org.checkerframework.shaded.dataflow.expression.ValueLiteral;

public abstract class JavaExpressionConverter
extends JavaExpressionVisitor<JavaExpression, Void> {
    public JavaExpression convert(JavaExpression javaExpr) {
        return (JavaExpression)super.visit(javaExpr, null);
    }

    public List<@PolyNull JavaExpression> convert(List<@PolyNull JavaExpression> list) {
        ArrayList<@PolyNull JavaExpression> newList = new ArrayList<JavaExpression>();
        for (JavaExpression expression : list) {
            if (expression == null) {
                newList.add(null);
                continue;
            }
            newList.add(this.convert(expression));
        }
        return newList;
    }

    @Override
    protected JavaExpression visitArrayAccess(ArrayAccess arrayAccessExpr, Void unused) {
        JavaExpression array = this.convert(arrayAccessExpr.getArray());
        JavaExpression index = this.convert(arrayAccessExpr.getIndex());
        return new ArrayAccess(arrayAccessExpr.type, array, index);
    }

    @Override
    protected JavaExpression visitArrayCreation(ArrayCreation arrayCreationExpr, Void unused) {
        List<@Nullable JavaExpression> dims = this.convert(arrayCreationExpr.getDimensions());
        List<JavaExpression> inits = this.convert(arrayCreationExpr.getInitializers());
        return new ArrayCreation(arrayCreationExpr.getType(), dims, inits);
    }

    @Override
    protected JavaExpression visitBinaryOperation(BinaryOperation binaryOpExpr, Void unused) {
        JavaExpression left = this.convert(binaryOpExpr.getLeft());
        JavaExpression right = this.convert(binaryOpExpr.getRight());
        return new BinaryOperation(binaryOpExpr.getType(), binaryOpExpr.getOperationKind(), left, right);
    }

    @Override
    protected JavaExpression visitClassName(ClassName classNameExpr, Void unused) {
        return classNameExpr;
    }

    @Override
    protected JavaExpression visitFieldAccess(FieldAccess fieldAccessExpr, Void unused) {
        JavaExpression receiver = this.convert(fieldAccessExpr.getReceiver());
        return new FieldAccess(receiver, fieldAccessExpr.getType(), fieldAccessExpr.getField());
    }

    @Override
    protected JavaExpression visitLocalVariable(LocalVariable localVarExpr, Void unused) {
        return localVarExpr;
    }

    @Override
    protected JavaExpression visitMethodCall(MethodCall methodCallExpr, Void unused) {
        JavaExpression receiver = this.convert(methodCallExpr.getReceiver());
        List<JavaExpression> args = this.convert(methodCallExpr.getArguments());
        return new MethodCall(methodCallExpr.getType(), methodCallExpr.getElement(), receiver, args);
    }

    @Override
    protected JavaExpression visitThisReference(ThisReference thisExpr, Void unused) {
        return thisExpr;
    }

    @Override
    protected JavaExpression visitUnaryOperation(UnaryOperation unaryOpExpr, Void unused) {
        JavaExpression operand = this.convert(unaryOpExpr.getOperand());
        return new UnaryOperation(unaryOpExpr.getType(), unaryOpExpr.getOperationKind(), operand);
    }

    @Override
    protected JavaExpression visitUnknown(Unknown unknownExpr, Void unused) {
        return unknownExpr;
    }

    @Override
    protected JavaExpression visitValueLiteral(ValueLiteral literalExpr, Void unused) {
        return literalExpr;
    }
}

