/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.spin.impl.json.jackson;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.jayway.jsonpath.InvalidPathException;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.camunda.commons.utils.EnsureUtil;
import org.camunda.spin.SpinList;
import org.camunda.spin.impl.SpinListImpl;
import org.camunda.spin.impl.json.jackson.JacksonJsonLogger;
import org.camunda.spin.impl.json.jackson.format.JacksonJsonDataFormat;
import org.camunda.spin.impl.json.jackson.format.JacksonJsonDataFormatMapper;
import org.camunda.spin.impl.json.jackson.query.JacksonJsonPathQuery;
import org.camunda.spin.json.SpinJsonNode;
import org.camunda.spin.json.SpinJsonPathQuery;

public class JacksonJsonNode
extends SpinJsonNode {
    private static final JacksonJsonLogger LOG = JacksonJsonLogger.JSON_TREE_LOGGER;
    protected final JsonNode jsonNode;
    protected final JacksonJsonDataFormat dataFormat;

    public JacksonJsonNode(JsonNode jsonNode, JacksonJsonDataFormat dataFormat) {
        this.jsonNode = jsonNode;
        this.dataFormat = dataFormat;
    }

    public String getDataFormatName() {
        return this.dataFormat.getName();
    }

    public JsonNode unwrap() {
        return this.jsonNode;
    }

    public String toString() {
        StringWriter writer = new StringWriter();
        this.writeToWriter(writer);
        return writer.toString();
    }

    public void writeToWriter(Writer writer) {
        this.dataFormat.getWriter().writeToWriter(writer, this.jsonNode);
    }

    protected Integer getCorrectIndex(Integer index) {
        Integer size = this.jsonNode.size();
        Integer newIndex = index;
        if (index < 0) {
            newIndex = size + index;
        }
        if (newIndex < 0) {
            throw LOG.indexOutOfBounds(index, size);
        }
        if (index > size) {
            throw LOG.indexOutOfBounds(index, size);
        }
        return newIndex;
    }

    public Integer indexOf(Object searchObject) {
        EnsureUtil.ensureNotNull((String)"searchObject", (Object)searchObject);
        if (this.isArray().booleanValue()) {
            Integer i = 0;
            JsonNode node = this.dataFormat.createJsonNode(searchObject);
            Iterator nodeIterator = this.jsonNode.elements();
            while (nodeIterator.hasNext()) {
                JsonNode n = (JsonNode)nodeIterator.next();
                if (n.equals((Object)node)) {
                    return i;
                }
                Integer n2 = i;
                Integer n3 = i = Integer.valueOf(i + 1);
            }
            throw LOG.unableToFindProperty(node.asText());
        }
        throw LOG.unableToGetIndex(this.jsonNode.getNodeType().name());
    }

    public Integer lastIndexOf(Object searchObject) {
        EnsureUtil.ensureNotNull((String)"searchObject", (Object)searchObject);
        if (this.isArray().booleanValue()) {
            Integer i = 0;
            Integer j = -1;
            JsonNode node = this.dataFormat.createJsonNode(searchObject);
            Iterator nodeIterator = this.jsonNode.elements();
            while (nodeIterator.hasNext()) {
                JsonNode n = (JsonNode)nodeIterator.next();
                if (n.equals((Object)node)) {
                    j = i;
                }
                Integer n2 = i;
                Integer n3 = i = Integer.valueOf(i + 1);
            }
            if (j == -1) {
                throw LOG.unableToFindProperty(node.getNodeType().name());
            }
            return j;
        }
        throw LOG.unableToGetIndex(this.jsonNode.getNodeType().name());
    }

    public boolean isObject() {
        return this.jsonNode.isObject();
    }

    public boolean hasProp(String name) {
        return this.jsonNode.has(name);
    }

    public SpinJsonNode prop(String name) {
        EnsureUtil.ensureNotNull((String)"name", (Object)name);
        if (this.jsonNode.has(name)) {
            JsonNode property = this.jsonNode.get(name);
            return this.dataFormat.createWrapperInstance(property);
        }
        throw LOG.unableToFindProperty(name);
    }

    public SpinJsonNode prop(String name, String newProperty) {
        ObjectNode node = (ObjectNode)this.jsonNode;
        node.put(name, newProperty);
        return this;
    }

    public SpinJsonNode prop(String name, Number newProperty) {
        ObjectNode node = (ObjectNode)this.jsonNode;
        if (newProperty == null) {
            node.putNull(name);
        } else if (newProperty instanceof Long) {
            node.put(name, newProperty.longValue());
        } else if (newProperty instanceof Integer) {
            node.put(name, newProperty.intValue());
        } else if (newProperty instanceof Float) {
            node.put(name, newProperty.floatValue());
        } else {
            node.put(name, newProperty.floatValue());
        }
        return this;
    }

    public SpinJsonNode prop(String name, int newProperty) {
        return this.prop(name, (Number)newProperty);
    }

    public SpinJsonNode prop(String name, float newProperty) {
        return this.prop(name, Float.valueOf(newProperty));
    }

    public SpinJsonNode prop(String name, long newProperty) {
        return this.prop(name, (Number)newProperty);
    }

    public SpinJsonNode prop(String name, boolean newProperty) {
        return this.prop(name, (Boolean)newProperty);
    }

    public SpinJsonNode prop(String name, Boolean newProperty) {
        ObjectNode node = (ObjectNode)this.jsonNode;
        node.put(name, newProperty);
        return this;
    }

    public SpinJsonNode prop(String name, List<Object> newProperty) {
        ObjectNode node = (ObjectNode)this.jsonNode;
        node.set(name, this.dataFormat.createJsonNode(newProperty));
        return this;
    }

    public SpinJsonNode prop(String name, Map<String, Object> newProperty) {
        ObjectNode node = (ObjectNode)this.jsonNode;
        node.set(name, this.dataFormat.createJsonNode(newProperty));
        return this;
    }

    public SpinJsonNode prop(String name, SpinJsonNode newProperty) {
        ObjectNode node = (ObjectNode)this.jsonNode;
        if (newProperty != null) {
            node.set(name, (JsonNode)newProperty.unwrap());
        } else {
            node.putNull(name);
        }
        return this;
    }

    public SpinJsonNode deleteProp(String name) {
        EnsureUtil.ensureNotNull((String)"name", (Object)name);
        if (this.jsonNode.has(name)) {
            ObjectNode node = (ObjectNode)this.jsonNode;
            node.remove(name);
            return this;
        }
        throw LOG.unableToFindProperty(name);
    }

    public SpinJsonNode deleteProp(List<String> names) {
        EnsureUtil.ensureNotNull((String)"names", names);
        for (String name : names) {
            this.deleteProp(name);
        }
        return this;
    }

    public SpinJsonNode append(Object property) {
        EnsureUtil.ensureNotNull((String)"property", (Object)property);
        if (this.jsonNode.isArray()) {
            ArrayNode node = (ArrayNode)this.jsonNode;
            node.add(this.dataFormat.createJsonNode(property));
            return this;
        }
        throw LOG.unableToModifyNode(this.jsonNode.getNodeType().name());
    }

    public SpinJsonNode insertAt(int index, Object property) {
        EnsureUtil.ensureNotNull((String)"property", (Object)property);
        if (this.jsonNode.isArray()) {
            index = this.getCorrectIndex(index);
            ArrayNode node = (ArrayNode)this.jsonNode;
            node.insert(index, this.dataFormat.createJsonNode(property));
            return this;
        }
        throw LOG.unableToModifyNode(this.jsonNode.getNodeType().name());
    }

    public SpinJsonNode insertBefore(Object searchObject, Object insertObject) {
        EnsureUtil.ensureNotNull((String)"searchObject", (Object)searchObject);
        EnsureUtil.ensureNotNull((String)"insertObject", (Object)insertObject);
        if (this.isArray().booleanValue()) {
            Integer i = this.indexOf(searchObject);
            return this.insertAt(i, insertObject);
        }
        throw LOG.unableToCreateNode(this.jsonNode.getNodeType().name());
    }

    public SpinJsonNode insertAfter(Object searchObject, Object insertObject) {
        EnsureUtil.ensureNotNull((String)"searchObject", (Object)searchObject);
        EnsureUtil.ensureNotNull((String)"insertObject", (Object)insertObject);
        if (this.isArray().booleanValue()) {
            Integer i = this.indexOf(searchObject);
            return this.insertAt(i + 1, insertObject);
        }
        throw LOG.unableToCreateNode(this.jsonNode.getNodeType().name());
    }

    public SpinJsonNode remove(Object property) {
        return this.removeAt(this.indexOf(property));
    }

    public SpinJsonNode removeLast(Object property) {
        return this.removeAt(this.lastIndexOf(property));
    }

    public SpinJsonNode removeAt(int index) {
        if (this.isArray().booleanValue()) {
            ArrayNode node = (ArrayNode)this.jsonNode;
            node.remove(this.getCorrectIndex(index).intValue());
            return this;
        }
        throw LOG.unableToModifyNode(this.jsonNode.getNodeType().name());
    }

    public Boolean isBoolean() {
        return this.jsonNode.isBoolean();
    }

    public Boolean boolValue() {
        if (this.jsonNode.isBoolean()) {
            return this.jsonNode.booleanValue();
        }
        throw LOG.unableToParseValue(Boolean.class.getSimpleName(), this.jsonNode.getNodeType());
    }

    public Boolean isNumber() {
        return this.jsonNode.isNumber();
    }

    public Number numberValue() {
        if (this.jsonNode.isNumber()) {
            return this.jsonNode.numberValue();
        }
        throw LOG.unableToParseValue(Number.class.getSimpleName(), this.jsonNode.getNodeType());
    }

    public Boolean isString() {
        return this.jsonNode.isTextual();
    }

    public String stringValue() {
        if (this.jsonNode.isTextual()) {
            return this.jsonNode.textValue();
        }
        throw LOG.unableToParseValue(String.class.getSimpleName(), this.jsonNode.getNodeType());
    }

    public Boolean isNull() {
        return this.jsonNode.isNull();
    }

    public Boolean isValue() {
        return this.jsonNode.isValueNode();
    }

    public Object value() {
        if (this.jsonNode.isBoolean()) {
            return this.jsonNode.booleanValue();
        }
        if (this.jsonNode.isNumber()) {
            return this.jsonNode.numberValue();
        }
        if (this.jsonNode.isTextual()) {
            return this.jsonNode.textValue();
        }
        if (this.jsonNode.isNull()) {
            return null;
        }
        throw LOG.unableToParseValue("String/Number/Boolean/Null", this.jsonNode.getNodeType());
    }

    public Boolean isArray() {
        return this.jsonNode.isArray();
    }

    public SpinList<SpinJsonNode> elements() {
        if (this.jsonNode.isArray()) {
            Iterator iterator = this.jsonNode.elements();
            SpinListImpl list = new SpinListImpl();
            while (iterator.hasNext()) {
                SpinJsonNode node = this.dataFormat.createWrapperInstance(iterator.next());
                list.add((Object)node);
            }
            return list;
        }
        throw LOG.unableToParseValue(SpinList.class.getSimpleName(), this.jsonNode.getNodeType());
    }

    public List<String> fieldNames() {
        if (this.jsonNode.isContainerNode()) {
            Iterator iterator = this.jsonNode.fieldNames();
            ArrayList<String> list = new ArrayList<String>();
            while (iterator.hasNext()) {
                list.add((String)iterator.next());
            }
            return list;
        }
        throw LOG.unableToParseValue("Array/Object", this.jsonNode.getNodeType());
    }

    public JsonNodeType getNodeType() {
        return this.jsonNode.getNodeType();
    }

    public SpinJsonPathQuery jsonPath(String expression) {
        EnsureUtil.ensureNotNull((String)"expression", (Object)expression);
        try {
            JsonPath query = JsonPath.compile((String)expression, (Predicate[])new Predicate[0]);
            return new JacksonJsonPathQuery(this, query, this.dataFormat);
        }
        catch (InvalidPathException pex) {
            throw LOG.unableToCompileJsonPathExpression(expression, (Exception)((Object)pex));
        }
        catch (IllegalArgumentException aex) {
            throw LOG.unableToCompileJsonPathExpression(expression, aex);
        }
    }

    public <C> C mapTo(Class<C> type) {
        JacksonJsonDataFormatMapper mapper = this.dataFormat.getMapper();
        return (C)mapper.mapInternalToJava(this.jsonNode, type);
    }

    public <C> C mapTo(String type) {
        JacksonJsonDataFormatMapper mapper = this.dataFormat.getMapper();
        return (C)mapper.mapInternalToJava(this.jsonNode, type);
    }

    public <C> C mapTo(JavaType type) {
        JacksonJsonDataFormatMapper mapper = this.dataFormat.getMapper();
        return mapper.mapInternalToJava((Object)this.jsonNode, type);
    }
}

