/*
 * Decompiled with CFR 0.152.
 */
package camundafeel.de.odysseus.el.tree.impl.ast;

import camundafeel.de.odysseus.el.misc.BooleanOperations;
import camundafeel.de.odysseus.el.misc.NumberOperations;
import camundafeel.de.odysseus.el.misc.TypeConverter;
import camundafeel.de.odysseus.el.tree.Bindings;
import camundafeel.de.odysseus.el.tree.impl.ast.AstNode;
import camundafeel.de.odysseus.el.tree.impl.ast.AstRightValue;
import camundafeel.javax.el.ELContext;
import camundafeel.javax.el.ELException;

public class AstUnary
extends AstRightValue {
    public static final Operator EMPTY = new SimpleOperator(){

        public Object apply(TypeConverter converter, Object o) {
            return BooleanOperations.empty(converter, o);
        }

        public String toString() {
            return "empty";
        }
    };
    public static final Operator NEG = new SimpleOperator(){

        public Object apply(TypeConverter converter, Object o) {
            return NumberOperations.neg(converter, o);
        }

        public String toString() {
            return "-";
        }
    };
    public static final Operator NOT = new SimpleOperator(){

        public Object apply(TypeConverter converter, Object o) {
            return converter.convert(o, Boolean.class) == false;
        }

        public String toString() {
            return "!";
        }
    };
    private final Operator operator;
    private final AstNode child;

    public AstUnary(AstNode child, Operator operator) {
        this.child = child;
        this.operator = operator;
    }

    public Operator getOperator() {
        return this.operator;
    }

    public Object eval(Bindings bindings, ELContext context) throws ELException {
        return this.operator.eval(bindings, context, this.child);
    }

    public String toString() {
        return "'" + this.operator.toString() + "'";
    }

    public void appendStructure(StringBuilder b, Bindings bindings) {
        b.append(this.operator);
        b.append(' ');
        this.child.appendStructure(b, bindings);
    }

    public int getCardinality() {
        return 1;
    }

    public AstNode getChild(int i) {
        return i == 0 ? this.child : null;
    }

    public static abstract class SimpleOperator
    implements Operator {
        public Object eval(Bindings bindings, ELContext context, AstNode node) {
            return this.apply(bindings, node.eval(bindings, context));
        }

        protected abstract Object apply(TypeConverter var1, Object var2);
    }

    public static interface Operator {
        public Object eval(Bindings var1, ELContext var2, AstNode var3);
    }
}

