/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd;

import java.util.ArrayList;
import org.camunda.bpm.engine.BadUserRequestException;
import org.camunda.bpm.engine.authorization.BatchPermissions;
import org.camunda.bpm.engine.batch.Batch;
import org.camunda.bpm.engine.impl.batch.BatchConfiguration;
import org.camunda.bpm.engine.impl.batch.BatchElementConfiguration;
import org.camunda.bpm.engine.impl.batch.SetRetriesBatchConfiguration;
import org.camunda.bpm.engine.impl.batch.builder.BatchBuilder;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.PropertyChange;
import org.camunda.bpm.engine.impl.util.EnsureUtil;

public abstract class AbstractSetJobsRetriesBatchCmd
implements Command<Batch> {
    protected int retries;

    @Override
    public Batch execute(CommandContext commandContext) {
        BatchElementConfiguration elementConfiguration = this.collectJobIds(commandContext);
        EnsureUtil.ensureNotEmpty(BadUserRequestException.class, "jobIds", elementConfiguration.getIds());
        EnsureUtil.ensureGreaterThanOrEqual("Retries count", this.retries, 0L);
        return new BatchBuilder(commandContext).config(this.getConfiguration(elementConfiguration)).type("set-job-retries").permission(BatchPermissions.CREATE_BATCH_SET_JOB_RETRIES).operationLogHandler(this::writeUserOperationLog).build();
    }

    protected void writeUserOperationLog(CommandContext commandContext, int numInstances) {
        ArrayList<PropertyChange> propertyChanges = new ArrayList<PropertyChange>();
        propertyChanges.add(new PropertyChange("nrOfInstances", null, numInstances));
        propertyChanges.add(new PropertyChange("async", null, true));
        propertyChanges.add(new PropertyChange("retries", null, this.retries));
        commandContext.getOperationLogManager().logJobOperation("SetJobRetries", null, null, null, null, null, propertyChanges);
    }

    protected abstract BatchElementConfiguration collectJobIds(CommandContext var1);

    public BatchConfiguration getConfiguration(BatchElementConfiguration elementConfiguration) {
        return new SetRetriesBatchConfiguration(elementConfiguration.getIds(), elementConfiguration.getMappings(), this.retries);
    }
}

