/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cfg;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.naming.InitialContext;
import javax.script.ScriptEngineManager;
import javax.sql.DataSource;
import org.apache.ibatis.builder.xml.XMLConfigBuilder;
import org.apache.ibatis.datasource.pooled.PooledDataSource;
import org.apache.ibatis.mapping.Environment;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.ExecutorType;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.ibatis.session.defaults.DefaultSqlSessionFactory;
import org.apache.ibatis.transaction.TransactionFactory;
import org.apache.ibatis.transaction.jdbc.JdbcTransactionFactory;
import org.apache.ibatis.transaction.managed.ManagedTransactionFactory;
import org.camunda.bpm.dmn.engine.DmnEngine;
import org.camunda.bpm.dmn.engine.DmnEngineConfiguration;
import org.camunda.bpm.dmn.engine.impl.DefaultDmnEngineConfiguration;
import org.camunda.bpm.dmn.feel.impl.scala.function.FeelCustomFunctionProvider;
import org.camunda.bpm.engine.ArtifactFactory;
import org.camunda.bpm.engine.AuthorizationService;
import org.camunda.bpm.engine.CaseService;
import org.camunda.bpm.engine.DecisionService;
import org.camunda.bpm.engine.ExternalTaskService;
import org.camunda.bpm.engine.FilterService;
import org.camunda.bpm.engine.FormService;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.IdentityService;
import org.camunda.bpm.engine.ManagementService;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.ProcessEngineConfiguration;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.TaskService;
import org.camunda.bpm.engine.authorization.Permission;
import org.camunda.bpm.engine.authorization.Permissions;
import org.camunda.bpm.engine.impl.AbstractDefinitionDeployer;
import org.camunda.bpm.engine.impl.AuthorizationServiceImpl;
import org.camunda.bpm.engine.impl.DecisionServiceImpl;
import org.camunda.bpm.engine.impl.DefaultArtifactFactory;
import org.camunda.bpm.engine.impl.ExternalTaskServiceImpl;
import org.camunda.bpm.engine.impl.FilterServiceImpl;
import org.camunda.bpm.engine.impl.FormServiceImpl;
import org.camunda.bpm.engine.impl.HistoryServiceImpl;
import org.camunda.bpm.engine.impl.IdentityServiceImpl;
import org.camunda.bpm.engine.impl.ManagementServiceImpl;
import org.camunda.bpm.engine.impl.ModificationBatchJobHandler;
import org.camunda.bpm.engine.impl.OptimizeService;
import org.camunda.bpm.engine.impl.PriorityProvider;
import org.camunda.bpm.engine.impl.ProcessEngineImpl;
import org.camunda.bpm.engine.impl.ProcessEngineLogger;
import org.camunda.bpm.engine.impl.RepositoryServiceImpl;
import org.camunda.bpm.engine.impl.RestartProcessInstancesJobHandler;
import org.camunda.bpm.engine.impl.RuntimeServiceImpl;
import org.camunda.bpm.engine.impl.ServiceImpl;
import org.camunda.bpm.engine.impl.TaskServiceImpl;
import org.camunda.bpm.engine.impl.application.ProcessApplicationManager;
import org.camunda.bpm.engine.impl.batch.BatchJobConfiguration;
import org.camunda.bpm.engine.impl.batch.BatchJobHandler;
import org.camunda.bpm.engine.impl.batch.BatchMonitorJobHandler;
import org.camunda.bpm.engine.impl.batch.BatchSeedJobHandler;
import org.camunda.bpm.engine.impl.batch.deletion.DeleteHistoricProcessInstancesJobHandler;
import org.camunda.bpm.engine.impl.batch.deletion.DeleteProcessInstancesJobHandler;
import org.camunda.bpm.engine.impl.batch.externaltask.SetExternalTaskRetriesJobHandler;
import org.camunda.bpm.engine.impl.batch.job.SetJobRetriesJobHandler;
import org.camunda.bpm.engine.impl.batch.message.MessageCorrelationBatchJobHandler;
import org.camunda.bpm.engine.impl.batch.removaltime.BatchSetRemovalTimeJobHandler;
import org.camunda.bpm.engine.impl.batch.removaltime.DecisionSetRemovalTimeJobHandler;
import org.camunda.bpm.engine.impl.batch.removaltime.ProcessSetRemovalTimeJobHandler;
import org.camunda.bpm.engine.impl.batch.update.UpdateProcessInstancesSuspendStateJobHandler;
import org.camunda.bpm.engine.impl.batch.variables.BatchSetVariablesHandler;
import org.camunda.bpm.engine.impl.bpmn.behavior.ExternalTaskActivityBehavior;
import org.camunda.bpm.engine.impl.bpmn.deployer.BpmnDeployer;
import org.camunda.bpm.engine.impl.bpmn.parser.BpmnParseListener;
import org.camunda.bpm.engine.impl.bpmn.parser.BpmnParser;
import org.camunda.bpm.engine.impl.bpmn.parser.DefaultFailedJobParseListener;
import org.camunda.bpm.engine.impl.calendar.BusinessCalendarManager;
import org.camunda.bpm.engine.impl.calendar.CycleBusinessCalendar;
import org.camunda.bpm.engine.impl.calendar.DueDateBusinessCalendar;
import org.camunda.bpm.engine.impl.calendar.DurationBusinessCalendar;
import org.camunda.bpm.engine.impl.calendar.MapBusinessCalendarManager;
import org.camunda.bpm.engine.impl.cfg.BatchWindowConfiguration;
import org.camunda.bpm.engine.impl.cfg.BpmnParseFactory;
import org.camunda.bpm.engine.impl.cfg.CommandChecker;
import org.camunda.bpm.engine.impl.cfg.ConfigurationLogger;
import org.camunda.bpm.engine.impl.cfg.DefaultBpmnParseFactory;
import org.camunda.bpm.engine.impl.cfg.IdGenerator;
import org.camunda.bpm.engine.impl.cfg.JpaHelper;
import org.camunda.bpm.engine.impl.cfg.ProcessEnginePlugin;
import org.camunda.bpm.engine.impl.cfg.StandaloneProcessEngineConfiguration;
import org.camunda.bpm.engine.impl.cfg.TransactionContextFactory;
import org.camunda.bpm.engine.impl.cfg.auth.AuthorizationCommandChecker;
import org.camunda.bpm.engine.impl.cfg.auth.DefaultAuthorizationProvider;
import org.camunda.bpm.engine.impl.cfg.auth.DefaultPermissionProvider;
import org.camunda.bpm.engine.impl.cfg.auth.PermissionProvider;
import org.camunda.bpm.engine.impl.cfg.auth.ResourceAuthorizationProvider;
import org.camunda.bpm.engine.impl.cfg.multitenancy.TenantCommandChecker;
import org.camunda.bpm.engine.impl.cfg.multitenancy.TenantIdProvider;
import org.camunda.bpm.engine.impl.cfg.standalone.StandaloneTransactionContextFactory;
import org.camunda.bpm.engine.impl.cmmn.CaseServiceImpl;
import org.camunda.bpm.engine.impl.cmmn.deployer.CmmnDeployer;
import org.camunda.bpm.engine.impl.cmmn.entity.repository.CaseDefinitionManager;
import org.camunda.bpm.engine.impl.cmmn.entity.runtime.CaseExecutionManager;
import org.camunda.bpm.engine.impl.cmmn.entity.runtime.CaseSentryPartManager;
import org.camunda.bpm.engine.impl.cmmn.handler.DefaultCmmnElementHandlerRegistry;
import org.camunda.bpm.engine.impl.cmmn.transformer.CmmnTransformFactory;
import org.camunda.bpm.engine.impl.cmmn.transformer.CmmnTransformListener;
import org.camunda.bpm.engine.impl.cmmn.transformer.CmmnTransformer;
import org.camunda.bpm.engine.impl.cmmn.transformer.DefaultCmmnTransformFactory;
import org.camunda.bpm.engine.impl.db.DbIdGenerator;
import org.camunda.bpm.engine.impl.db.entitymanager.DbEntityManagerFactory;
import org.camunda.bpm.engine.impl.db.entitymanager.cache.DbEntityCacheKeyMapping;
import org.camunda.bpm.engine.impl.db.sql.DbSqlPersistenceProviderFactory;
import org.camunda.bpm.engine.impl.db.sql.DbSqlSessionFactory;
import org.camunda.bpm.engine.impl.delegate.DefaultDelegateInterceptor;
import org.camunda.bpm.engine.impl.digest.Default16ByteSaltGenerator;
import org.camunda.bpm.engine.impl.digest.PasswordEncryptor;
import org.camunda.bpm.engine.impl.digest.PasswordManager;
import org.camunda.bpm.engine.impl.digest.SaltGenerator;
import org.camunda.bpm.engine.impl.digest.Sha512HashDigest;
import org.camunda.bpm.engine.impl.dmn.batch.DeleteHistoricDecisionInstancesJobHandler;
import org.camunda.bpm.engine.impl.dmn.configuration.DmnEngineConfigurationBuilder;
import org.camunda.bpm.engine.impl.dmn.deployer.DecisionDefinitionDeployer;
import org.camunda.bpm.engine.impl.dmn.deployer.DecisionRequirementsDefinitionDeployer;
import org.camunda.bpm.engine.impl.dmn.entity.repository.DecisionDefinitionManager;
import org.camunda.bpm.engine.impl.dmn.entity.repository.DecisionRequirementsDefinitionManager;
import org.camunda.bpm.engine.impl.el.CommandContextFunctionMapper;
import org.camunda.bpm.engine.impl.el.DateTimeFunctionMapper;
import org.camunda.bpm.engine.impl.el.ExpressionManager;
import org.camunda.bpm.engine.impl.event.CompensationEventHandler;
import org.camunda.bpm.engine.impl.event.ConditionalEventHandler;
import org.camunda.bpm.engine.impl.event.EventHandler;
import org.camunda.bpm.engine.impl.event.EventHandlerImpl;
import org.camunda.bpm.engine.impl.event.EventType;
import org.camunda.bpm.engine.impl.event.SignalEventHandler;
import org.camunda.bpm.engine.impl.externaltask.DefaultExternalTaskPriorityProvider;
import org.camunda.bpm.engine.impl.form.deployer.CamundaFormDefinitionDeployer;
import org.camunda.bpm.engine.impl.form.engine.FormEngine;
import org.camunda.bpm.engine.impl.form.engine.HtmlFormEngine;
import org.camunda.bpm.engine.impl.form.engine.JuelFormEngine;
import org.camunda.bpm.engine.impl.form.entity.CamundaFormDefinitionManager;
import org.camunda.bpm.engine.impl.form.type.AbstractFormFieldType;
import org.camunda.bpm.engine.impl.form.type.BooleanFormType;
import org.camunda.bpm.engine.impl.form.type.DateFormType;
import org.camunda.bpm.engine.impl.form.type.FormTypes;
import org.camunda.bpm.engine.impl.form.type.LongFormType;
import org.camunda.bpm.engine.impl.form.type.StringFormType;
import org.camunda.bpm.engine.impl.form.validator.FormFieldValidator;
import org.camunda.bpm.engine.impl.form.validator.FormValidators;
import org.camunda.bpm.engine.impl.form.validator.MaxLengthValidator;
import org.camunda.bpm.engine.impl.form.validator.MaxValidator;
import org.camunda.bpm.engine.impl.form.validator.MinLengthValidator;
import org.camunda.bpm.engine.impl.form.validator.MinValidator;
import org.camunda.bpm.engine.impl.form.validator.ReadOnlyValidator;
import org.camunda.bpm.engine.impl.form.validator.RequiredValidator;
import org.camunda.bpm.engine.impl.history.DefaultHistoryRemovalTimeProvider;
import org.camunda.bpm.engine.impl.history.HistoryLevel;
import org.camunda.bpm.engine.impl.history.HistoryRemovalTimeProvider;
import org.camunda.bpm.engine.impl.history.event.HistoricDecisionInstanceManager;
import org.camunda.bpm.engine.impl.history.event.HostnameProvider;
import org.camunda.bpm.engine.impl.history.event.SimpleIpBasedProvider;
import org.camunda.bpm.engine.impl.history.handler.CompositeDbHistoryEventHandler;
import org.camunda.bpm.engine.impl.history.handler.CompositeHistoryEventHandler;
import org.camunda.bpm.engine.impl.history.handler.HistoryEventHandler;
import org.camunda.bpm.engine.impl.history.parser.HistoryParseListener;
import org.camunda.bpm.engine.impl.history.producer.CacheAwareCmmnHistoryEventProducer;
import org.camunda.bpm.engine.impl.history.producer.CacheAwareHistoryEventProducer;
import org.camunda.bpm.engine.impl.history.producer.CmmnHistoryEventProducer;
import org.camunda.bpm.engine.impl.history.producer.DefaultDmnHistoryEventProducer;
import org.camunda.bpm.engine.impl.history.producer.DmnHistoryEventProducer;
import org.camunda.bpm.engine.impl.history.producer.HistoryEventProducer;
import org.camunda.bpm.engine.impl.history.transformer.CmmnHistoryTransformListener;
import org.camunda.bpm.engine.impl.identity.DefaultPasswordPolicyImpl;
import org.camunda.bpm.engine.impl.identity.ReadOnlyIdentityProvider;
import org.camunda.bpm.engine.impl.identity.WritableIdentityProvider;
import org.camunda.bpm.engine.impl.identity.db.DbIdentityServiceProvider;
import org.camunda.bpm.engine.impl.incident.CompositeIncidentHandler;
import org.camunda.bpm.engine.impl.incident.DefaultIncidentHandler;
import org.camunda.bpm.engine.impl.incident.IncidentHandler;
import org.camunda.bpm.engine.impl.interceptor.CommandContextFactory;
import org.camunda.bpm.engine.impl.interceptor.CommandExecutor;
import org.camunda.bpm.engine.impl.interceptor.CommandExecutorImpl;
import org.camunda.bpm.engine.impl.interceptor.CommandInterceptor;
import org.camunda.bpm.engine.impl.interceptor.CrdbTransactionRetryInterceptor;
import org.camunda.bpm.engine.impl.interceptor.DelegateInterceptor;
import org.camunda.bpm.engine.impl.interceptor.SessionFactory;
import org.camunda.bpm.engine.impl.jobexecutor.AsyncContinuationJobHandler;
import org.camunda.bpm.engine.impl.jobexecutor.DefaultFailedJobCommandFactory;
import org.camunda.bpm.engine.impl.jobexecutor.DefaultJobExecutor;
import org.camunda.bpm.engine.impl.jobexecutor.DefaultJobPriorityProvider;
import org.camunda.bpm.engine.impl.jobexecutor.FailedJobCommandFactory;
import org.camunda.bpm.engine.impl.jobexecutor.JobDeclaration;
import org.camunda.bpm.engine.impl.jobexecutor.JobExecutor;
import org.camunda.bpm.engine.impl.jobexecutor.JobHandler;
import org.camunda.bpm.engine.impl.jobexecutor.NotifyAcquisitionRejectedJobsHandler;
import org.camunda.bpm.engine.impl.jobexecutor.ProcessEventJobHandler;
import org.camunda.bpm.engine.impl.jobexecutor.RejectedJobsHandler;
import org.camunda.bpm.engine.impl.jobexecutor.TimerActivateJobDefinitionHandler;
import org.camunda.bpm.engine.impl.jobexecutor.TimerActivateProcessDefinitionHandler;
import org.camunda.bpm.engine.impl.jobexecutor.TimerCatchIntermediateEventJobHandler;
import org.camunda.bpm.engine.impl.jobexecutor.TimerExecuteNestedActivityJobHandler;
import org.camunda.bpm.engine.impl.jobexecutor.TimerStartEventJobHandler;
import org.camunda.bpm.engine.impl.jobexecutor.TimerStartEventSubprocessJobHandler;
import org.camunda.bpm.engine.impl.jobexecutor.TimerSuspendJobDefinitionHandler;
import org.camunda.bpm.engine.impl.jobexecutor.TimerSuspendProcessDefinitionHandler;
import org.camunda.bpm.engine.impl.jobexecutor.TimerTaskListenerJobHandler;
import org.camunda.bpm.engine.impl.jobexecutor.historycleanup.BatchWindowManager;
import org.camunda.bpm.engine.impl.jobexecutor.historycleanup.DefaultBatchWindowManager;
import org.camunda.bpm.engine.impl.jobexecutor.historycleanup.HistoryCleanupHelper;
import org.camunda.bpm.engine.impl.jobexecutor.historycleanup.HistoryCleanupJobHandler;
import org.camunda.bpm.engine.impl.metrics.MetricsRegistry;
import org.camunda.bpm.engine.impl.metrics.MetricsReporterIdProvider;
import org.camunda.bpm.engine.impl.metrics.parser.MetricsBpmnParseListener;
import org.camunda.bpm.engine.impl.metrics.parser.MetricsCmmnTransformListener;
import org.camunda.bpm.engine.impl.metrics.reporter.DbMetricsReporter;
import org.camunda.bpm.engine.impl.migration.DefaultMigrationActivityMatcher;
import org.camunda.bpm.engine.impl.migration.DefaultMigrationInstructionGenerator;
import org.camunda.bpm.engine.impl.migration.MigrationActivityMatcher;
import org.camunda.bpm.engine.impl.migration.MigrationInstructionGenerator;
import org.camunda.bpm.engine.impl.migration.batch.MigrationBatchJobHandler;
import org.camunda.bpm.engine.impl.migration.validation.activity.MigrationActivityValidator;
import org.camunda.bpm.engine.impl.migration.validation.activity.NoCompensationHandlerActivityValidator;
import org.camunda.bpm.engine.impl.migration.validation.activity.SupportedActivityValidator;
import org.camunda.bpm.engine.impl.migration.validation.activity.SupportedPassiveEventTriggerActivityValidator;
import org.camunda.bpm.engine.impl.migration.validation.instance.AsyncAfterMigrationValidator;
import org.camunda.bpm.engine.impl.migration.validation.instance.AsyncMigrationValidator;
import org.camunda.bpm.engine.impl.migration.validation.instance.AsyncProcessStartMigrationValidator;
import org.camunda.bpm.engine.impl.migration.validation.instance.MigratingActivityInstanceValidator;
import org.camunda.bpm.engine.impl.migration.validation.instance.MigratingCompensationInstanceValidator;
import org.camunda.bpm.engine.impl.migration.validation.instance.MigratingTransitionInstanceValidator;
import org.camunda.bpm.engine.impl.migration.validation.instance.NoUnmappedCompensationStartEventValidator;
import org.camunda.bpm.engine.impl.migration.validation.instance.NoUnmappedLeafInstanceValidator;
import org.camunda.bpm.engine.impl.migration.validation.instance.SupportedActivityInstanceValidator;
import org.camunda.bpm.engine.impl.migration.validation.instance.VariableConflictActivityInstanceValidator;
import org.camunda.bpm.engine.impl.migration.validation.instruction.AdditionalFlowScopeInstructionValidator;
import org.camunda.bpm.engine.impl.migration.validation.instruction.CannotAddMultiInstanceBodyValidator;
import org.camunda.bpm.engine.impl.migration.validation.instruction.CannotAddMultiInstanceInnerActivityValidator;
import org.camunda.bpm.engine.impl.migration.validation.instruction.CannotRemoveMultiInstanceInnerActivityValidator;
import org.camunda.bpm.engine.impl.migration.validation.instruction.ConditionalEventUpdateEventTriggerValidator;
import org.camunda.bpm.engine.impl.migration.validation.instruction.GatewayMappingValidator;
import org.camunda.bpm.engine.impl.migration.validation.instruction.MigrationInstructionValidator;
import org.camunda.bpm.engine.impl.migration.validation.instruction.OnlyOnceMappedActivityInstructionValidator;
import org.camunda.bpm.engine.impl.migration.validation.instruction.SameBehaviorInstructionValidator;
import org.camunda.bpm.engine.impl.migration.validation.instruction.SameEventScopeInstructionValidator;
import org.camunda.bpm.engine.impl.migration.validation.instruction.SameEventTypeValidator;
import org.camunda.bpm.engine.impl.migration.validation.instruction.UpdateEventTriggersValidator;
import org.camunda.bpm.engine.impl.optimize.OptimizeManager;
import org.camunda.bpm.engine.impl.persistence.GenericManagerFactory;
import org.camunda.bpm.engine.impl.persistence.deploy.Deployer;
import org.camunda.bpm.engine.impl.persistence.deploy.cache.CacheFactory;
import org.camunda.bpm.engine.impl.persistence.deploy.cache.DefaultCacheFactory;
import org.camunda.bpm.engine.impl.persistence.deploy.cache.DeploymentCache;
import org.camunda.bpm.engine.impl.persistence.entity.AttachmentManager;
import org.camunda.bpm.engine.impl.persistence.entity.AuthorizationManager;
import org.camunda.bpm.engine.impl.persistence.entity.BatchManager;
import org.camunda.bpm.engine.impl.persistence.entity.ByteArrayManager;
import org.camunda.bpm.engine.impl.persistence.entity.CommentManager;
import org.camunda.bpm.engine.impl.persistence.entity.DeploymentManager;
import org.camunda.bpm.engine.impl.persistence.entity.EventSubscriptionManager;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionManager;
import org.camunda.bpm.engine.impl.persistence.entity.ExternalTaskManager;
import org.camunda.bpm.engine.impl.persistence.entity.FilterManager;
import org.camunda.bpm.engine.impl.persistence.entity.HistoricActivityInstanceManager;
import org.camunda.bpm.engine.impl.persistence.entity.HistoricBatchManager;
import org.camunda.bpm.engine.impl.persistence.entity.HistoricCaseActivityInstanceManager;
import org.camunda.bpm.engine.impl.persistence.entity.HistoricCaseInstanceManager;
import org.camunda.bpm.engine.impl.persistence.entity.HistoricDetailManager;
import org.camunda.bpm.engine.impl.persistence.entity.HistoricExternalTaskLogManager;
import org.camunda.bpm.engine.impl.persistence.entity.HistoricIdentityLinkLogManager;
import org.camunda.bpm.engine.impl.persistence.entity.HistoricIncidentManager;
import org.camunda.bpm.engine.impl.persistence.entity.HistoricJobLogManager;
import org.camunda.bpm.engine.impl.persistence.entity.HistoricProcessInstanceManager;
import org.camunda.bpm.engine.impl.persistence.entity.HistoricStatisticsManager;
import org.camunda.bpm.engine.impl.persistence.entity.HistoricTaskInstanceManager;
import org.camunda.bpm.engine.impl.persistence.entity.HistoricVariableInstanceManager;
import org.camunda.bpm.engine.impl.persistence.entity.IdentityInfoManager;
import org.camunda.bpm.engine.impl.persistence.entity.IdentityLinkManager;
import org.camunda.bpm.engine.impl.persistence.entity.IncidentManager;
import org.camunda.bpm.engine.impl.persistence.entity.JobDefinitionManager;
import org.camunda.bpm.engine.impl.persistence.entity.JobManager;
import org.camunda.bpm.engine.impl.persistence.entity.MeterLogManager;
import org.camunda.bpm.engine.impl.persistence.entity.ProcessDefinitionManager;
import org.camunda.bpm.engine.impl.persistence.entity.PropertyManager;
import org.camunda.bpm.engine.impl.persistence.entity.ReportManager;
import org.camunda.bpm.engine.impl.persistence.entity.ResourceManager;
import org.camunda.bpm.engine.impl.persistence.entity.SchemaLogManager;
import org.camunda.bpm.engine.impl.persistence.entity.StatisticsManager;
import org.camunda.bpm.engine.impl.persistence.entity.TableDataManager;
import org.camunda.bpm.engine.impl.persistence.entity.TaskManager;
import org.camunda.bpm.engine.impl.persistence.entity.TaskReportManager;
import org.camunda.bpm.engine.impl.persistence.entity.TenantManager;
import org.camunda.bpm.engine.impl.persistence.entity.UserOperationLogManager;
import org.camunda.bpm.engine.impl.persistence.entity.VariableInstanceManager;
import org.camunda.bpm.engine.impl.repository.DefaultDeploymentHandlerFactory;
import org.camunda.bpm.engine.impl.runtime.ConditionHandler;
import org.camunda.bpm.engine.impl.runtime.CorrelationHandler;
import org.camunda.bpm.engine.impl.runtime.DefaultConditionHandler;
import org.camunda.bpm.engine.impl.runtime.DefaultCorrelationHandler;
import org.camunda.bpm.engine.impl.runtime.DefaultDeserializationTypeValidator;
import org.camunda.bpm.engine.impl.scripting.ScriptFactory;
import org.camunda.bpm.engine.impl.scripting.engine.BeansResolverFactory;
import org.camunda.bpm.engine.impl.scripting.engine.DefaultScriptEngineResolver;
import org.camunda.bpm.engine.impl.scripting.engine.ResolverFactory;
import org.camunda.bpm.engine.impl.scripting.engine.ScriptBindingsFactory;
import org.camunda.bpm.engine.impl.scripting.engine.ScriptEngineResolver;
import org.camunda.bpm.engine.impl.scripting.engine.ScriptingEngines;
import org.camunda.bpm.engine.impl.scripting.engine.VariableScopeResolverFactory;
import org.camunda.bpm.engine.impl.scripting.env.ScriptEnvResolver;
import org.camunda.bpm.engine.impl.scripting.env.ScriptingEnvironment;
import org.camunda.bpm.engine.impl.telemetry.TelemetryRegistry;
import org.camunda.bpm.engine.impl.telemetry.dto.DatabaseImpl;
import org.camunda.bpm.engine.impl.telemetry.dto.InternalsImpl;
import org.camunda.bpm.engine.impl.telemetry.dto.JdkImpl;
import org.camunda.bpm.engine.impl.telemetry.dto.ProductImpl;
import org.camunda.bpm.engine.impl.telemetry.dto.TelemetryDataImpl;
import org.camunda.bpm.engine.impl.telemetry.reporter.TelemetryReporter;
import org.camunda.bpm.engine.impl.util.EnsureUtil;
import org.camunda.bpm.engine.impl.util.IoUtil;
import org.camunda.bpm.engine.impl.util.ParseUtil;
import org.camunda.bpm.engine.impl.util.ProcessEngineDetails;
import org.camunda.bpm.engine.impl.util.ReflectUtil;
import org.camunda.bpm.engine.impl.variable.ValueTypeResolverImpl;
import org.camunda.bpm.engine.impl.variable.serializer.BooleanValueSerializer;
import org.camunda.bpm.engine.impl.variable.serializer.ByteArrayValueSerializer;
import org.camunda.bpm.engine.impl.variable.serializer.DateValueSerializer;
import org.camunda.bpm.engine.impl.variable.serializer.DefaultVariableSerializers;
import org.camunda.bpm.engine.impl.variable.serializer.DoubleValueSerializer;
import org.camunda.bpm.engine.impl.variable.serializer.FileValueSerializer;
import org.camunda.bpm.engine.impl.variable.serializer.IntegerValueSerializer;
import org.camunda.bpm.engine.impl.variable.serializer.JavaObjectSerializer;
import org.camunda.bpm.engine.impl.variable.serializer.LongValueSerlializer;
import org.camunda.bpm.engine.impl.variable.serializer.NullValueSerializer;
import org.camunda.bpm.engine.impl.variable.serializer.ShortValueSerializer;
import org.camunda.bpm.engine.impl.variable.serializer.StringValueSerializer;
import org.camunda.bpm.engine.impl.variable.serializer.TypedValueSerializer;
import org.camunda.bpm.engine.impl.variable.serializer.VariableSerializerFactory;
import org.camunda.bpm.engine.impl.variable.serializer.VariableSerializers;
import org.camunda.bpm.engine.impl.variable.serializer.jpa.EntityManagerSession;
import org.camunda.bpm.engine.impl.variable.serializer.jpa.EntityManagerSessionFactory;
import org.camunda.bpm.engine.impl.variable.serializer.jpa.JPAVariableSerializer;
import org.camunda.bpm.engine.repository.DeploymentHandlerFactory;
import org.camunda.bpm.engine.runtime.WhitelistingDeserializationTypeValidator;
import org.camunda.bpm.engine.test.mock.MocksResolverFactory;
import org.camunda.bpm.engine.variable.Variables;
import org.camunda.bpm.engine.variable.type.ValueType;
import org.camunda.connect.Connectors;
import org.camunda.connect.spi.Connector;
import org.camunda.connect.spi.ConnectorRequest;

public abstract class ProcessEngineConfigurationImpl
extends ProcessEngineConfiguration {
    protected static final ConfigurationLogger LOG = ConfigurationLogger.CONFIG_LOGGER;
    public static final String DB_SCHEMA_UPDATE_CREATE = "create";
    public static final String DB_SCHEMA_UPDATE_DROP_CREATE = "drop-create";
    public static final int HISTORYLEVEL_NONE = HistoryLevel.HISTORY_LEVEL_NONE.getId();
    public static final int HISTORYLEVEL_ACTIVITY = HistoryLevel.HISTORY_LEVEL_ACTIVITY.getId();
    public static final int HISTORYLEVEL_AUDIT = HistoryLevel.HISTORY_LEVEL_AUDIT.getId();
    public static final int HISTORYLEVEL_FULL = HistoryLevel.HISTORY_LEVEL_FULL.getId();
    public static final String DEFAULT_WS_SYNC_FACTORY = "org.camunda.bpm.engine.impl.webservice.CxfWebServiceClientFactory";
    public static final String DEFAULT_MYBATIS_MAPPING_FILE = "org/camunda/bpm/engine/impl/mapping/mappings.xml";
    public static final int DEFAULT_FAILED_JOB_LISTENER_MAX_RETRIES = 3;
    public static final int DEFAULT_INVOCATIONS_PER_BATCH_JOB = 1;
    protected static final Map<Object, Object> DEFAULT_BEANS_MAP = new HashMap<Object, Object>();
    protected static final String PRODUCT_NAME = "Camunda BPM Runtime";
    public static SqlSessionFactory cachedSqlSessionFactory;
    protected RepositoryService repositoryService = new RepositoryServiceImpl();
    protected RuntimeService runtimeService = new RuntimeServiceImpl();
    protected HistoryService historyService = new HistoryServiceImpl();
    protected IdentityService identityService = new IdentityServiceImpl();
    protected TaskService taskService = new TaskServiceImpl();
    protected FormService formService = new FormServiceImpl();
    protected ManagementService managementService = new ManagementServiceImpl(this);
    protected AuthorizationService authorizationService = new AuthorizationServiceImpl();
    protected CaseService caseService = new CaseServiceImpl();
    protected FilterService filterService = new FilterServiceImpl();
    protected ExternalTaskService externalTaskService = new ExternalTaskServiceImpl();
    protected DecisionService decisionService = new DecisionServiceImpl();
    protected OptimizeService optimizeService = new OptimizeService();
    protected List<CommandInterceptor> customPreCommandInterceptorsTxRequired;
    protected List<CommandInterceptor> customPostCommandInterceptorsTxRequired;
    protected List<CommandInterceptor> commandInterceptorsTxRequired;
    protected CommandExecutor commandExecutorTxRequired;
    protected List<CommandInterceptor> customPreCommandInterceptorsTxRequiresNew;
    protected List<CommandInterceptor> customPostCommandInterceptorsTxRequiresNew;
    protected List<CommandInterceptor> commandInterceptorsTxRequiresNew;
    protected CommandExecutor commandExecutorTxRequiresNew;
    protected CommandExecutor commandExecutorSchemaOperations;
    protected int commandRetries = 0;
    protected List<SessionFactory> customSessionFactories;
    protected DbSqlSessionFactory dbSqlSessionFactory;
    protected Map<Class<?>, SessionFactory> sessionFactories;
    protected List<Deployer> customPreDeployers;
    protected List<Deployer> customPostDeployers;
    protected List<Deployer> deployers;
    protected DeploymentCache deploymentCache;
    protected CacheFactory cacheFactory;
    protected int cacheCapacity = 1000;
    protected boolean enableFetchProcessDefinitionDescription = true;
    protected List<JobHandler> customJobHandlers;
    protected Map<String, JobHandler> jobHandlers;
    protected JobExecutor jobExecutor;
    protected PriorityProvider<JobDeclaration<?, ?>> jobPriorityProvider;
    protected Long jobExecutorPriorityRangeMin = null;
    protected Long jobExecutorPriorityRangeMax = null;
    protected PriorityProvider<ExternalTaskActivityBehavior> externalTaskPriorityProvider;
    protected SqlSessionFactory sqlSessionFactory;
    protected TransactionFactory transactionFactory;
    protected IdGenerator idGenerator;
    protected DataSource idGeneratorDataSource;
    protected String idGeneratorDataSourceJndiName;
    protected Map<String, IncidentHandler> incidentHandlers;
    protected List<IncidentHandler> customIncidentHandlers;
    protected Map<String, BatchJobHandler<?>> batchHandlers;
    protected List<BatchJobHandler<?>> customBatchJobHandlers;
    protected int batchJobsPerSeed = 100;
    protected int invocationsPerBatchJob = 1;
    protected Map<String, Integer> invocationsPerBatchJobByBatchType;
    protected int batchPollTime = 30;
    protected long batchJobPriority = DefaultJobPriorityProvider.DEFAULT_PRIORITY;
    protected List<FormEngine> customFormEngines;
    protected Map<String, FormEngine> formEngines;
    protected List<AbstractFormFieldType> customFormTypes;
    protected FormTypes formTypes;
    protected FormValidators formValidators;
    protected Map<String, Class<? extends FormFieldValidator>> customFormFieldValidators;
    protected boolean disableStrictCamundaFormParsing = false;
    protected List<TypedValueSerializer> customPreVariableSerializers;
    protected List<TypedValueSerializer> customPostVariableSerializers;
    protected VariableSerializers variableSerializers;
    protected VariableSerializerFactory fallbackSerializerFactory;
    protected String defaultSerializationFormat = Variables.SerializationDataFormats.JAVA.getName();
    protected boolean javaSerializationFormatEnabled = false;
    protected String defaultCharsetName = null;
    protected Charset defaultCharset = null;
    protected ExpressionManager expressionManager;
    protected ScriptingEngines scriptingEngines;
    protected List<ResolverFactory> resolverFactories;
    protected ScriptingEnvironment scriptingEnvironment;
    protected List<ScriptEnvResolver> scriptEnvResolvers;
    protected ScriptFactory scriptFactory;
    protected ScriptEngineResolver scriptEngineResolver;
    protected String scriptEngineNameJavaScript;
    protected boolean autoStoreScriptVariables = false;
    protected boolean enableScriptCompilation = true;
    protected boolean enableScriptEngineCaching = true;
    protected boolean enableFetchScriptEngineFromProcessApplication = true;
    protected boolean enableScriptEngineLoadExternalResources = false;
    protected boolean enableScriptEngineNashornCompatibility = false;
    protected boolean configureScriptEngineHostAccess = true;
    protected boolean cmmnEnabled = true;
    protected boolean dmnEnabled = true;
    protected boolean standaloneTasksEnabled = true;
    protected boolean enableGracefulDegradationOnContextSwitchFailure = true;
    protected BusinessCalendarManager businessCalendarManager;
    protected String wsSyncFactoryClassName = "org.camunda.bpm.engine.impl.webservice.CxfWebServiceClientFactory";
    protected CommandContextFactory commandContextFactory;
    protected TransactionContextFactory transactionContextFactory;
    protected BpmnParseFactory bpmnParseFactory;
    protected CmmnTransformFactory cmmnTransformFactory;
    protected DefaultCmmnElementHandlerRegistry cmmnElementHandlerRegistry;
    protected DefaultDmnEngineConfiguration dmnEngineConfiguration;
    protected DmnEngine dmnEngine;
    protected List<FeelCustomFunctionProvider> dmnFeelCustomFunctionProviders;
    protected boolean dmnFeelEnableLegacyBehavior = false;
    protected HistoryLevel historyLevel;
    protected List<HistoryLevel> historyLevels;
    protected List<HistoryLevel> customHistoryLevels;
    protected List<BpmnParseListener> preParseListeners;
    protected List<BpmnParseListener> postParseListeners;
    protected List<CmmnTransformListener> customPreCmmnTransformListeners;
    protected List<CmmnTransformListener> customPostCmmnTransformListeners;
    protected Map<Object, Object> beans;
    protected boolean isDbIdentityUsed = true;
    protected boolean isDbHistoryUsed = true;
    protected DelegateInterceptor delegateInterceptor;
    protected CommandInterceptor actualCommandExecutor;
    protected RejectedJobsHandler customRejectedJobsHandler;
    protected Map<String, EventHandler> eventHandlers;
    protected List<EventHandler> customEventHandlers;
    protected FailedJobCommandFactory failedJobCommandFactory;
    protected String databaseTablePrefix = "";
    protected String databaseSchema = null;
    protected boolean isCreateDiagramOnDeploy = false;
    protected ProcessApplicationManager processApplicationManager;
    protected CorrelationHandler correlationHandler;
    protected ConditionHandler conditionHandler;
    protected SessionFactory identityProviderSessionFactory;
    protected PasswordEncryptor passwordEncryptor;
    protected List<PasswordEncryptor> customPasswordChecker;
    protected PasswordManager passwordManager;
    protected SaltGenerator saltGenerator;
    protected Set<String> registeredDeployments;
    protected DeploymentHandlerFactory deploymentHandlerFactory;
    protected ResourceAuthorizationProvider resourceAuthorizationProvider;
    protected List<ProcessEnginePlugin> processEnginePlugins = new ArrayList<ProcessEnginePlugin>();
    protected HistoryEventProducer historyEventProducer;
    protected CmmnHistoryEventProducer cmmnHistoryEventProducer;
    protected DmnHistoryEventProducer dmnHistoryEventProducer;
    protected HistoryEventHandler historyEventHandler;
    protected List<HistoryEventHandler> customHistoryEventHandlers = new ArrayList<HistoryEventHandler>();
    protected boolean enableDefaultDbHistoryEventHandler = true;
    protected PermissionProvider permissionProvider;
    protected boolean isExecutionTreePrefetchEnabled = true;
    protected boolean isCompositeIncidentHandlersEnabled = false;
    protected boolean isDeploymentLockUsed = true;
    protected boolean isDeploymentSynchronized = true;
    protected boolean isDbEntityCacheReuseEnabled = false;
    protected boolean isInvokeCustomVariableListeners = true;
    protected ProcessEngineImpl processEngine;
    protected ArtifactFactory artifactFactory;
    protected DbEntityCacheKeyMapping dbEntityCacheKeyMapping = DbEntityCacheKeyMapping.defaultEntityCacheKeyMapping();
    protected MetricsRegistry metricsRegistry;
    protected DbMetricsReporter dbMetricsReporter;
    protected boolean isMetricsEnabled = true;
    protected boolean isDbMetricsReporterActivate = true;
    protected MetricsReporterIdProvider metricsReporterIdProvider;
    protected boolean isTaskMetricsEnabled = true;
    protected String hostname;
    protected HostnameProvider hostnameProvider;
    protected boolean enableExpressionsInAdhocQueries = false;
    protected boolean enableExpressionsInStoredQueries = true;
    protected boolean enableXxeProcessing = false;
    protected boolean restrictUserOperationLogToAuthenticatedUsers = true;
    protected boolean disableStrictCallActivityValidation = false;
    protected boolean isBpmnStacktraceVerbose = false;
    protected boolean forceCloseMybatisConnectionPool = true;
    protected TenantIdProvider tenantIdProvider = null;
    protected List<CommandChecker> commandCheckers = null;
    protected List<String> adminGroups;
    protected List<String> adminUsers;
    protected MigrationActivityMatcher migrationActivityMatcher;
    protected List<MigrationActivityValidator> customPreMigrationActivityValidators;
    protected List<MigrationActivityValidator> customPostMigrationActivityValidators;
    protected MigrationInstructionGenerator migrationInstructionGenerator;
    protected List<MigrationInstructionValidator> customPreMigrationInstructionValidators;
    protected List<MigrationInstructionValidator> customPostMigrationInstructionValidators;
    protected List<MigrationInstructionValidator> migrationInstructionValidators;
    protected List<MigratingActivityInstanceValidator> customPreMigratingActivityInstanceValidators;
    protected List<MigratingActivityInstanceValidator> customPostMigratingActivityInstanceValidators;
    protected List<MigratingActivityInstanceValidator> migratingActivityInstanceValidators;
    protected List<MigratingTransitionInstanceValidator> migratingTransitionInstanceValidators;
    protected List<MigratingCompensationInstanceValidator> migratingCompensationInstanceValidators;
    protected Permission defaultUserPermissionForTask;
    protected boolean enableHistoricInstancePermissions = false;
    protected boolean isUseSharedSqlSessionFactory = false;
    protected String historyCleanupBatchWindowStartTime;
    protected String historyCleanupBatchWindowEndTime = "00:00";
    protected Date historyCleanupBatchWindowStartTimeAsDate;
    protected Date historyCleanupBatchWindowEndTimeAsDate;
    protected Map<Integer, BatchWindowConfiguration> historyCleanupBatchWindows = new HashMap<Integer, BatchWindowConfiguration>();
    protected String mondayHistoryCleanupBatchWindowStartTime;
    protected String mondayHistoryCleanupBatchWindowEndTime;
    protected String tuesdayHistoryCleanupBatchWindowStartTime;
    protected String tuesdayHistoryCleanupBatchWindowEndTime;
    protected String wednesdayHistoryCleanupBatchWindowStartTime;
    protected String wednesdayHistoryCleanupBatchWindowEndTime;
    protected String thursdayHistoryCleanupBatchWindowStartTime;
    protected String thursdayHistoryCleanupBatchWindowEndTime;
    protected String fridayHistoryCleanupBatchWindowStartTime;
    protected String fridayHistoryCleanupBatchWindowEndTime;
    protected String saturdayHistoryCleanupBatchWindowStartTime;
    protected String saturdayHistoryCleanupBatchWindowEndTime;
    protected String sundayHistoryCleanupBatchWindowStartTime;
    protected String sundayHistoryCleanupBatchWindowEndTime;
    protected int historyCleanupDegreeOfParallelism = 1;
    protected String historyTimeToLive;
    protected String batchOperationHistoryTimeToLive;
    protected Map<String, String> batchOperationsForHistoryCleanup;
    protected Map<String, Integer> parsedBatchOperationsForHistoryCleanup;
    protected long historyCleanupJobPriority = DefaultJobPriorityProvider.DEFAULT_PRIORITY;
    protected String historyCleanupJobLogTimeToLive;
    protected String taskMetricsTimeToLive;
    protected Integer parsedTaskMetricsTimeToLive;
    protected BatchWindowManager batchWindowManager = new DefaultBatchWindowManager();
    protected HistoryRemovalTimeProvider historyRemovalTimeProvider;
    protected String historyRemovalTimeStrategy;
    protected String historyCleanupStrategy;
    private int historyCleanupBatchSize = 500;
    private int historyCleanupBatchThreshold = 10;
    private boolean historyCleanupMetricsEnabled = true;
    protected boolean historyCleanupEnabled = true;
    private int failedJobListenerMaxRetries = 3;
    protected String failedJobRetryTimeCycle;
    protected int loginMaxAttempts = 10;
    protected int loginDelayFactor = 2;
    protected int loginDelayMaxTime = 60;
    protected int loginDelayBase = 3;
    protected int queryMaxResultsLimit = Integer.MAX_VALUE;
    protected String loggingContextActivityId = "activityId";
    protected String loggingContextApplicationName = "applicationName";
    protected String loggingContextBusinessKey;
    protected String loggingContextProcessDefinitionId = "processDefinitionId";
    protected String loggingContextProcessInstanceId = "processInstanceId";
    protected String loggingContextTenantId = "tenantId";
    protected Boolean initializeTelemetry = null;
    protected String telemetryEndpoint = "https://api.telemetry.camunda.cloud/pings";
    protected int telemetryRequestRetries = 2;
    protected TelemetryReporter telemetryReporter;
    protected boolean isTelemetryReporterActivate = true;
    protected Connector<? extends ConnectorRequest<?>> telemetryHttpConnector;
    protected long telemetryReportingPeriod = 86400L;
    protected TelemetryDataImpl telemetryData;
    protected int telemetryRequestTimeout = 15000;
    protected static Properties databaseTypeMappings;
    protected static final String MY_SQL_PRODUCT_NAME = "MySQL";
    protected static final String MARIA_DB_PRODUCT_NAME = "MariaDB";
    protected static final String POSTGRES_DB_PRODUCT_NAME = "PostgreSQL";
    protected static final String CRDB_DB_PRODUCT_NAME = "CockroachDB";

    @Override
    public ProcessEngine buildProcessEngine() {
        this.init();
        this.processEngine = new ProcessEngineImpl(this);
        this.invokePostProcessEngineBuild(this.processEngine);
        return this.processEngine;
    }

    protected void init() {
        this.invokePreInit();
        this.initDefaultCharset();
        this.initHistoryLevel();
        this.initHistoryEventProducer();
        this.initCmmnHistoryEventProducer();
        this.initDmnHistoryEventProducer();
        this.initHistoryEventHandler();
        this.initExpressionManager();
        this.initBeans();
        this.initArtifactFactory();
        this.initFormEngines();
        this.initFormTypes();
        this.initFormFieldValidators();
        this.initScripting();
        this.initDmnEngine();
        this.initBusinessCalendarManager();
        this.initCommandContextFactory();
        this.initTransactionContextFactory();
        this.initDataSource();
        this.initCommandExecutors();
        this.initServices();
        this.initIdGenerator();
        this.initFailedJobCommandFactory();
        this.initDeployers();
        this.initJobProvider();
        this.initExternalTaskPriorityProvider();
        this.initBatchHandlers();
        this.initJobExecutor();
        this.initTransactionFactory();
        this.initSqlSessionFactory();
        this.initIdentityProviderSessionFactory();
        this.initSessionFactories();
        this.initValueTypeResolver();
        this.initTypeValidator();
        this.initSerialization();
        this.initJpa();
        this.initDelegateInterceptor();
        this.initEventHandlers();
        this.initProcessApplicationManager();
        this.initCorrelationHandler();
        this.initConditionHandler();
        this.initIncidentHandlers();
        this.initPasswordDigest();
        this.initDeploymentRegistration();
        this.initDeploymentHandlerFactory();
        this.initResourceAuthorizationProvider();
        this.initPermissionProvider();
        this.initHostName();
        this.initMetrics();
        this.initTelemetry();
        this.initMigration();
        this.initCommandCheckers();
        this.initDefaultUserPermissionForTask();
        this.initHistoryRemovalTime();
        this.initHistoryCleanup();
        this.initInvocationsPerBatchJobByBatchType();
        this.initAdminUser();
        this.initAdminGroups();
        this.initPasswordPolicy();
        this.invokePostInit();
    }

    protected void initTypeValidator() {
        if (this.deserializationTypeValidator == null) {
            this.deserializationTypeValidator = new DefaultDeserializationTypeValidator();
        }
        if (this.deserializationTypeValidator instanceof WhitelistingDeserializationTypeValidator) {
            WhitelistingDeserializationTypeValidator validator = (WhitelistingDeserializationTypeValidator)this.deserializationTypeValidator;
            validator.setAllowedClasses(this.deserializationAllowedClasses);
            validator.setAllowedPackages(this.deserializationAllowedPackages);
        }
    }

    public void initHistoryRemovalTime() {
        this.initHistoryRemovalTimeProvider();
        this.initHistoryRemovalTimeStrategy();
    }

    public void initHistoryRemovalTimeStrategy() {
        if (this.historyRemovalTimeStrategy == null) {
            this.historyRemovalTimeStrategy = "end";
        }
        if (!("start".equals(this.historyRemovalTimeStrategy) || "end".equals(this.historyRemovalTimeStrategy) || "none".equals(this.historyRemovalTimeStrategy))) {
            throw LOG.invalidPropertyValue("historyRemovalTimeStrategy", String.valueOf(this.historyRemovalTimeStrategy), String.format("history removal time strategy must be set to '%s', '%s' or '%s'", "start", "end", "none"));
        }
    }

    public void initHistoryRemovalTimeProvider() {
        if (this.historyRemovalTimeProvider == null) {
            this.historyRemovalTimeProvider = new DefaultHistoryRemovalTimeProvider();
        }
    }

    public void initHistoryCleanup() {
        this.initHistoryCleanupStrategy();
        if (this.historyCleanupDegreeOfParallelism < 1 || this.historyCleanupDegreeOfParallelism > 8) {
            throw LOG.invalidPropertyValue("historyCleanupDegreeOfParallelism", String.valueOf(this.historyCleanupDegreeOfParallelism), String.format("value for number of threads for history cleanup should be between 1 and %s", 8));
        }
        if (this.historyCleanupBatchWindowStartTime != null) {
            this.initHistoryCleanupBatchWindowStartTime();
        }
        if (this.historyCleanupBatchWindowEndTime != null) {
            this.initHistoryCleanupBatchWindowEndTime();
        }
        this.initHistoryCleanupBatchWindowsMap();
        if (this.historyCleanupBatchSize > 500 || this.historyCleanupBatchSize <= 0) {
            throw LOG.invalidPropertyValue("historyCleanupBatchSize", String.valueOf(this.historyCleanupBatchSize), String.format("value for batch size should be between 1 and %s", 500));
        }
        if (this.historyCleanupBatchThreshold < 0) {
            throw LOG.invalidPropertyValue("historyCleanupBatchThreshold", String.valueOf(this.historyCleanupBatchThreshold), "History cleanup batch threshold cannot be negative.");
        }
        this.initHistoryTimeToLive();
        this.initBatchOperationsHistoryTimeToLive();
        this.initHistoryCleanupJobLogTimeToLive();
        this.initTaskMetricsTimeToLive();
    }

    protected void initHistoryCleanupStrategy() {
        if (this.historyCleanupStrategy == null) {
            this.historyCleanupStrategy = "removalTimeBased";
        }
        if (!"removalTimeBased".equals(this.historyCleanupStrategy) && !"endTimeBased".equals(this.historyCleanupStrategy)) {
            throw LOG.invalidPropertyValue("historyCleanupStrategy", String.valueOf(this.historyCleanupStrategy), String.format("history cleanup strategy must be either set to '%s' or '%s'", "removalTimeBased", "endTimeBased"));
        }
        if ("removalTimeBased".equals(this.historyCleanupStrategy) && "none".equals(this.historyRemovalTimeStrategy)) {
            throw LOG.invalidPropertyValue("historyRemovalTimeStrategy", String.valueOf(this.historyRemovalTimeStrategy), String.format("history removal time strategy cannot be set to '%s' in conjunction with '%s' history cleanup strategy", "none", "removalTimeBased"));
        }
    }

    private void initHistoryCleanupBatchWindowsMap() {
        if (this.mondayHistoryCleanupBatchWindowStartTime != null || this.mondayHistoryCleanupBatchWindowEndTime != null) {
            this.historyCleanupBatchWindows.put(2, new BatchWindowConfiguration(this.mondayHistoryCleanupBatchWindowStartTime, this.mondayHistoryCleanupBatchWindowEndTime));
        }
        if (this.tuesdayHistoryCleanupBatchWindowStartTime != null || this.tuesdayHistoryCleanupBatchWindowEndTime != null) {
            this.historyCleanupBatchWindows.put(3, new BatchWindowConfiguration(this.tuesdayHistoryCleanupBatchWindowStartTime, this.tuesdayHistoryCleanupBatchWindowEndTime));
        }
        if (this.wednesdayHistoryCleanupBatchWindowStartTime != null || this.wednesdayHistoryCleanupBatchWindowEndTime != null) {
            this.historyCleanupBatchWindows.put(4, new BatchWindowConfiguration(this.wednesdayHistoryCleanupBatchWindowStartTime, this.wednesdayHistoryCleanupBatchWindowEndTime));
        }
        if (this.thursdayHistoryCleanupBatchWindowStartTime != null || this.thursdayHistoryCleanupBatchWindowEndTime != null) {
            this.historyCleanupBatchWindows.put(5, new BatchWindowConfiguration(this.thursdayHistoryCleanupBatchWindowStartTime, this.thursdayHistoryCleanupBatchWindowEndTime));
        }
        if (this.fridayHistoryCleanupBatchWindowStartTime != null || this.fridayHistoryCleanupBatchWindowEndTime != null) {
            this.historyCleanupBatchWindows.put(6, new BatchWindowConfiguration(this.fridayHistoryCleanupBatchWindowStartTime, this.fridayHistoryCleanupBatchWindowEndTime));
        }
        if (this.saturdayHistoryCleanupBatchWindowStartTime != null || this.saturdayHistoryCleanupBatchWindowEndTime != null) {
            this.historyCleanupBatchWindows.put(7, new BatchWindowConfiguration(this.saturdayHistoryCleanupBatchWindowStartTime, this.saturdayHistoryCleanupBatchWindowEndTime));
        }
        if (this.sundayHistoryCleanupBatchWindowStartTime != null || this.sundayHistoryCleanupBatchWindowEndTime != null) {
            this.historyCleanupBatchWindows.put(1, new BatchWindowConfiguration(this.sundayHistoryCleanupBatchWindowStartTime, this.sundayHistoryCleanupBatchWindowEndTime));
        }
    }

    protected void initInvocationsPerBatchJobByBatchType() {
        if (this.invocationsPerBatchJobByBatchType == null) {
            this.invocationsPerBatchJobByBatchType = new HashMap<String, Integer>();
        } else {
            Set<String> batchTypes = this.invocationsPerBatchJobByBatchType.keySet();
            batchTypes.stream().filter(batchType -> !this.batchHandlers.containsKey(batchType)).forEach(LOG::invalidBatchTypeForInvocationsPerBatchJob);
        }
    }

    protected void initHistoryTimeToLive() {
        try {
            ParseUtil.parseHistoryTimeToLive(this.historyTimeToLive);
        }
        catch (Exception e) {
            throw LOG.invalidPropertyValue("historyTimeToLive", this.historyTimeToLive, e);
        }
    }

    protected void initBatchOperationsHistoryTimeToLive() {
        try {
            ParseUtil.parseHistoryTimeToLive(this.batchOperationHistoryTimeToLive);
        }
        catch (Exception e) {
            throw LOG.invalidPropertyValue("batchOperationHistoryTimeToLive", this.batchOperationHistoryTimeToLive, e);
        }
        if (this.batchOperationsForHistoryCleanup == null) {
            this.batchOperationsForHistoryCleanup = new HashMap<String, String>();
        } else {
            for (String batchOperation : this.batchOperationsForHistoryCleanup.keySet()) {
                String timeToLive = this.batchOperationsForHistoryCleanup.get(batchOperation);
                if (!this.batchHandlers.keySet().contains(batchOperation)) {
                    LOG.invalidBatchOperation(batchOperation, timeToLive);
                }
                try {
                    ParseUtil.parseHistoryTimeToLive(timeToLive);
                }
                catch (Exception e) {
                    throw LOG.invalidPropertyValue("history time to live for " + batchOperation + " batch operations", timeToLive, e);
                }
            }
        }
        if (this.batchHandlers != null && this.batchOperationHistoryTimeToLive != null) {
            for (String batchOperation : this.batchHandlers.keySet()) {
                if (this.batchOperationsForHistoryCleanup.containsKey(batchOperation)) continue;
                this.batchOperationsForHistoryCleanup.put(batchOperation, this.batchOperationHistoryTimeToLive);
            }
        }
        this.parsedBatchOperationsForHistoryCleanup = new HashMap<String, Integer>();
        if (this.batchOperationsForHistoryCleanup != null) {
            for (String operation : this.batchOperationsForHistoryCleanup.keySet()) {
                Integer historyTimeToLive = ParseUtil.parseHistoryTimeToLive(this.batchOperationsForHistoryCleanup.get(operation));
                this.parsedBatchOperationsForHistoryCleanup.put(operation, historyTimeToLive);
            }
        }
    }

    private void initHistoryCleanupBatchWindowEndTime() {
        try {
            this.historyCleanupBatchWindowEndTimeAsDate = HistoryCleanupHelper.parseTimeConfiguration(this.historyCleanupBatchWindowEndTime);
        }
        catch (ParseException e) {
            throw LOG.invalidPropertyValue("historyCleanupBatchWindowEndTime", this.historyCleanupBatchWindowEndTime);
        }
    }

    private void initHistoryCleanupBatchWindowStartTime() {
        try {
            this.historyCleanupBatchWindowStartTimeAsDate = HistoryCleanupHelper.parseTimeConfiguration(this.historyCleanupBatchWindowStartTime);
        }
        catch (ParseException e) {
            throw LOG.invalidPropertyValue("historyCleanupBatchWindowStartTime", this.historyCleanupBatchWindowStartTime);
        }
    }

    protected void initHistoryCleanupJobLogTimeToLive() {
        try {
            ParseUtil.parseHistoryTimeToLive(this.historyCleanupJobLogTimeToLive);
        }
        catch (Exception e) {
            throw LOG.invalidPropertyValue("historyCleanupJobLogTimeToLive", this.historyCleanupJobLogTimeToLive, e);
        }
    }

    protected void initTaskMetricsTimeToLive() {
        try {
            this.parsedTaskMetricsTimeToLive = ParseUtil.parseHistoryTimeToLive(this.taskMetricsTimeToLive);
        }
        catch (Exception e) {
            throw LOG.invalidPropertyValue("taskMetricsTimeToLive", this.taskMetricsTimeToLive, e);
        }
    }

    protected void invokePreInit() {
        for (ProcessEnginePlugin plugin : this.processEnginePlugins) {
            LOG.pluginActivated(plugin.toString(), this.getProcessEngineName());
            plugin.preInit(this);
        }
    }

    protected void invokePostInit() {
        for (ProcessEnginePlugin plugin : this.processEnginePlugins) {
            plugin.postInit(this);
        }
    }

    protected void invokePostProcessEngineBuild(ProcessEngine engine) {
        for (ProcessEnginePlugin plugin : this.processEnginePlugins) {
            plugin.postProcessEngineBuild(engine);
        }
    }

    protected void initFailedJobCommandFactory() {
        if (this.failedJobCommandFactory == null) {
            this.failedJobCommandFactory = new DefaultFailedJobCommandFactory();
        }
        if (this.postParseListeners == null) {
            this.postParseListeners = new ArrayList<BpmnParseListener>();
        }
        this.postParseListeners.add(new DefaultFailedJobParseListener());
    }

    protected void initIncidentHandlers() {
        if (this.incidentHandlers == null) {
            this.incidentHandlers = new HashMap<String, IncidentHandler>();
            DefaultIncidentHandler failedJobIncidentHandler = new DefaultIncidentHandler("failedJob");
            DefaultIncidentHandler failedExternalTaskIncidentHandler = new DefaultIncidentHandler("failedExternalTask");
            if (this.isCompositeIncidentHandlersEnabled) {
                this.addIncidentHandler(new CompositeIncidentHandler((IncidentHandler)failedJobIncidentHandler, new IncidentHandler[0]));
                this.addIncidentHandler(new CompositeIncidentHandler((IncidentHandler)failedExternalTaskIncidentHandler, new IncidentHandler[0]));
            } else {
                this.addIncidentHandler(failedJobIncidentHandler);
                this.addIncidentHandler(failedExternalTaskIncidentHandler);
            }
        }
        if (this.customIncidentHandlers != null) {
            for (IncidentHandler incidentHandler : this.customIncidentHandlers) {
                this.addIncidentHandler(incidentHandler);
            }
        }
    }

    protected void initBatchHandlers() {
        if (this.batchHandlers == null) {
            this.batchHandlers = new HashMap();
            MigrationBatchJobHandler migrationHandler = new MigrationBatchJobHandler();
            this.batchHandlers.put(migrationHandler.getType(), migrationHandler);
            ModificationBatchJobHandler modificationHandler = new ModificationBatchJobHandler();
            this.batchHandlers.put(modificationHandler.getType(), modificationHandler);
            DeleteProcessInstancesJobHandler deleteProcessJobHandler = new DeleteProcessInstancesJobHandler();
            this.batchHandlers.put(deleteProcessJobHandler.getType(), deleteProcessJobHandler);
            DeleteHistoricProcessInstancesJobHandler deleteHistoricProcessInstancesJobHandler = new DeleteHistoricProcessInstancesJobHandler();
            this.batchHandlers.put(deleteHistoricProcessInstancesJobHandler.getType(), deleteHistoricProcessInstancesJobHandler);
            SetJobRetriesJobHandler setJobRetriesJobHandler = new SetJobRetriesJobHandler();
            this.batchHandlers.put(setJobRetriesJobHandler.getType(), setJobRetriesJobHandler);
            SetExternalTaskRetriesJobHandler setExternalTaskRetriesJobHandler = new SetExternalTaskRetriesJobHandler();
            this.batchHandlers.put(setExternalTaskRetriesJobHandler.getType(), setExternalTaskRetriesJobHandler);
            RestartProcessInstancesJobHandler restartProcessInstancesJobHandler = new RestartProcessInstancesJobHandler();
            this.batchHandlers.put(restartProcessInstancesJobHandler.getType(), restartProcessInstancesJobHandler);
            UpdateProcessInstancesSuspendStateJobHandler suspendProcessInstancesJobHandler = new UpdateProcessInstancesSuspendStateJobHandler();
            this.batchHandlers.put(suspendProcessInstancesJobHandler.getType(), suspendProcessInstancesJobHandler);
            DeleteHistoricDecisionInstancesJobHandler deleteHistoricDecisionInstancesJobHandler = new DeleteHistoricDecisionInstancesJobHandler();
            this.batchHandlers.put(deleteHistoricDecisionInstancesJobHandler.getType(), deleteHistoricDecisionInstancesJobHandler);
            ProcessSetRemovalTimeJobHandler processSetRemovalTimeJobHandler = new ProcessSetRemovalTimeJobHandler();
            this.batchHandlers.put(processSetRemovalTimeJobHandler.getType(), processSetRemovalTimeJobHandler);
            DecisionSetRemovalTimeJobHandler decisionSetRemovalTimeJobHandler = new DecisionSetRemovalTimeJobHandler();
            this.batchHandlers.put(decisionSetRemovalTimeJobHandler.getType(), decisionSetRemovalTimeJobHandler);
            BatchSetRemovalTimeJobHandler batchSetRemovalTimeJobHandler = new BatchSetRemovalTimeJobHandler();
            this.batchHandlers.put(batchSetRemovalTimeJobHandler.getType(), batchSetRemovalTimeJobHandler);
            BatchSetVariablesHandler batchSetVariablesHandler = new BatchSetVariablesHandler();
            this.batchHandlers.put(batchSetVariablesHandler.getType(), batchSetVariablesHandler);
            MessageCorrelationBatchJobHandler messageCorrelationJobHandler = new MessageCorrelationBatchJobHandler();
            this.batchHandlers.put(messageCorrelationJobHandler.getType(), messageCorrelationJobHandler);
        }
        if (this.customBatchJobHandlers != null) {
            for (BatchJobHandler<?> customBatchJobHandler : this.customBatchJobHandlers) {
                this.batchHandlers.put(customBatchJobHandler.getType(), customBatchJobHandler);
            }
        }
    }

    protected abstract Collection<? extends CommandInterceptor> getDefaultCommandInterceptorsTxRequired();

    protected abstract Collection<? extends CommandInterceptor> getDefaultCommandInterceptorsTxRequiresNew();

    protected void initCommandExecutors() {
        this.initActualCommandExecutor();
        this.initCommandInterceptorsTxRequired();
        this.initCommandExecutorTxRequired();
        this.initCommandInterceptorsTxRequiresNew();
        this.initCommandExecutorTxRequiresNew();
        this.initCommandExecutorDbSchemaOperations();
    }

    protected void initActualCommandExecutor() {
        this.actualCommandExecutor = new CommandExecutorImpl();
    }

    protected void initCommandInterceptorsTxRequired() {
        if (this.commandInterceptorsTxRequired == null) {
            this.commandInterceptorsTxRequired = this.customPreCommandInterceptorsTxRequired != null ? new ArrayList<CommandInterceptor>(this.customPreCommandInterceptorsTxRequired) : new ArrayList<CommandInterceptor>();
            this.commandInterceptorsTxRequired.addAll(this.getDefaultCommandInterceptorsTxRequired());
            if (this.customPostCommandInterceptorsTxRequired != null) {
                this.commandInterceptorsTxRequired.addAll(this.customPostCommandInterceptorsTxRequired);
            }
            this.commandInterceptorsTxRequired.add(this.actualCommandExecutor);
        }
    }

    protected void initCommandInterceptorsTxRequiresNew() {
        if (this.commandInterceptorsTxRequiresNew == null) {
            this.commandInterceptorsTxRequiresNew = this.customPreCommandInterceptorsTxRequiresNew != null ? new ArrayList<CommandInterceptor>(this.customPreCommandInterceptorsTxRequiresNew) : new ArrayList<CommandInterceptor>();
            this.commandInterceptorsTxRequiresNew.addAll(this.getDefaultCommandInterceptorsTxRequiresNew());
            if (this.customPostCommandInterceptorsTxRequiresNew != null) {
                this.commandInterceptorsTxRequiresNew.addAll(this.customPostCommandInterceptorsTxRequiresNew);
            }
            this.commandInterceptorsTxRequiresNew.add(this.actualCommandExecutor);
        }
    }

    protected void initCommandExecutorTxRequired() {
        if (this.commandExecutorTxRequired == null) {
            this.commandExecutorTxRequired = this.initInterceptorChain(this.commandInterceptorsTxRequired);
        }
    }

    protected void initCommandExecutorTxRequiresNew() {
        if (this.commandExecutorTxRequiresNew == null) {
            this.commandExecutorTxRequiresNew = this.initInterceptorChain(this.commandInterceptorsTxRequiresNew);
        }
    }

    protected void initCommandExecutorDbSchemaOperations() {
        if (this.commandExecutorSchemaOperations == null) {
            this.commandExecutorSchemaOperations = this.commandExecutorTxRequired;
        }
    }

    protected CommandInterceptor initInterceptorChain(List<CommandInterceptor> chain) {
        if (chain == null || chain.isEmpty()) {
            throw new ProcessEngineException("invalid command interceptor chain configuration: " + chain);
        }
        for (int i = 0; i < chain.size() - 1; ++i) {
            chain.get(i).setNext(chain.get(i + 1));
        }
        return chain.get(0);
    }

    protected void initServices() {
        this.initService(this.repositoryService);
        this.initService(this.runtimeService);
        this.initService(this.historyService);
        this.initService(this.identityService);
        this.initService(this.taskService);
        this.initService(this.formService);
        this.initService(this.managementService);
        this.initService(this.authorizationService);
        this.initService(this.caseService);
        this.initService(this.filterService);
        this.initService(this.externalTaskService);
        this.initService(this.decisionService);
        this.initService(this.optimizeService);
    }

    protected void initService(Object service) {
        if (service instanceof ServiceImpl) {
            ((ServiceImpl)service).setCommandExecutor(this.commandExecutorTxRequired);
        }
        if (service instanceof RepositoryServiceImpl) {
            ((RepositoryServiceImpl)service).setDeploymentCharset(this.getDefaultCharset());
        }
    }

    protected void initDataSource() {
        if (this.dataSource == null) {
            if (this.dataSourceJndiName != null) {
                try {
                    this.dataSource = (DataSource)new InitialContext().lookup(this.dataSourceJndiName);
                }
                catch (Exception e) {
                    throw new ProcessEngineException("couldn't lookup datasource from " + this.dataSourceJndiName + ": " + e.getMessage(), e);
                }
            } else if (this.jdbcUrl != null) {
                if (this.jdbcDriver == null || this.jdbcUrl == null || this.jdbcUsername == null) {
                    throw new ProcessEngineException("DataSource or JDBC properties have to be specified in a process engine configuration");
                }
                PooledDataSource pooledDataSource = new PooledDataSource(ReflectUtil.getClassLoader(), this.jdbcDriver, this.jdbcUrl, this.jdbcUsername, this.jdbcPassword);
                if (this.jdbcMaxActiveConnections > 0) {
                    pooledDataSource.setPoolMaximumActiveConnections(this.jdbcMaxActiveConnections);
                }
                if (this.jdbcMaxIdleConnections > 0) {
                    pooledDataSource.setPoolMaximumIdleConnections(this.jdbcMaxIdleConnections);
                }
                if (this.jdbcMaxCheckoutTime > 0) {
                    pooledDataSource.setPoolMaximumCheckoutTime(this.jdbcMaxCheckoutTime);
                }
                if (this.jdbcMaxWaitTime > 0) {
                    pooledDataSource.setPoolTimeToWait(this.jdbcMaxWaitTime);
                }
                if (this.jdbcPingEnabled) {
                    pooledDataSource.setPoolPingEnabled(true);
                    if (this.jdbcPingQuery != null) {
                        pooledDataSource.setPoolPingQuery(this.jdbcPingQuery);
                    }
                    pooledDataSource.setPoolPingConnectionsNotUsedFor(this.jdbcPingConnectionNotUsedFor);
                }
                this.dataSource = pooledDataSource;
            }
            if (this.dataSource instanceof PooledDataSource) {
                ((PooledDataSource)this.dataSource).forceCloseAll();
            }
        }
        if (this.databaseType == null) {
            this.initDatabaseType();
        }
    }

    protected static Properties getDefaultDatabaseTypeMappings() {
        Properties databaseTypeMappings = new Properties();
        databaseTypeMappings.setProperty("H2", "h2");
        databaseTypeMappings.setProperty(MY_SQL_PRODUCT_NAME, "mysql");
        databaseTypeMappings.setProperty(MARIA_DB_PRODUCT_NAME, "mariadb");
        databaseTypeMappings.setProperty("Oracle", "oracle");
        databaseTypeMappings.setProperty(POSTGRES_DB_PRODUCT_NAME, "postgres");
        databaseTypeMappings.setProperty(CRDB_DB_PRODUCT_NAME, "cockroachdb");
        databaseTypeMappings.setProperty("Microsoft SQL Server", "mssql");
        databaseTypeMappings.setProperty("DB2", "db2");
        databaseTypeMappings.setProperty("DB2", "db2");
        databaseTypeMappings.setProperty("DB2/NT", "db2");
        databaseTypeMappings.setProperty("DB2/NT64", "db2");
        databaseTypeMappings.setProperty("DB2 UDP", "db2");
        databaseTypeMappings.setProperty("DB2/LINUX", "db2");
        databaseTypeMappings.setProperty("DB2/LINUX390", "db2");
        databaseTypeMappings.setProperty("DB2/LINUXX8664", "db2");
        databaseTypeMappings.setProperty("DB2/LINUXZ64", "db2");
        databaseTypeMappings.setProperty("DB2/400 SQL", "db2");
        databaseTypeMappings.setProperty("DB2/6000", "db2");
        databaseTypeMappings.setProperty("DB2 UDB iSeries", "db2");
        databaseTypeMappings.setProperty("DB2/AIX64", "db2");
        databaseTypeMappings.setProperty("DB2/HPUX", "db2");
        databaseTypeMappings.setProperty("DB2/HP64", "db2");
        databaseTypeMappings.setProperty("DB2/SUN", "db2");
        databaseTypeMappings.setProperty("DB2/SUN64", "db2");
        databaseTypeMappings.setProperty("DB2/PTX", "db2");
        databaseTypeMappings.setProperty("DB2/2", "db2");
        return databaseTypeMappings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initDatabaseType() {
        Connection connection = null;
        try {
            connection = this.dataSource.getConnection();
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            String databaseProductName = databaseMetaData.getDatabaseProductName();
            if (MY_SQL_PRODUCT_NAME.equals(databaseProductName)) {
                databaseProductName = this.checkForMariaDb(databaseMetaData, databaseProductName);
            }
            if (POSTGRES_DB_PRODUCT_NAME.equals(databaseProductName)) {
                databaseProductName = this.checkForCrdb(connection);
            }
            LOG.debugDatabaseproductName(databaseProductName);
            this.databaseType = databaseTypeMappings.getProperty(databaseProductName);
            EnsureUtil.ensureNotNull("couldn't deduct database type from database product name '" + databaseProductName + "'", "databaseType", (Object)this.databaseType);
            LOG.debugDatabaseType(this.databaseType);
            this.initDatabaseVendorAndVersion(databaseMetaData);
        }
        catch (SQLException e) {
            LOG.databaseConnectionAccessException(e);
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException e) {
                LOG.databaseConnectionCloseException(e);
            }
        }
    }

    protected String checkForMariaDb(DatabaseMetaData databaseMetaData, String databaseName) {
        try {
            String databaseProductVersion = databaseMetaData.getDatabaseProductVersion();
            if (databaseProductVersion != null && databaseProductVersion.toLowerCase().contains("mariadb")) {
                return MARIA_DB_PRODUCT_NAME;
            }
        }
        catch (SQLException databaseProductVersion) {
            // empty catch block
        }
        try {
            String driverName = databaseMetaData.getDriverName();
            if (driverName != null && driverName.toLowerCase().contains("mariadb")) {
                return MARIA_DB_PRODUCT_NAME;
            }
        }
        catch (SQLException driverName) {
            // empty catch block
        }
        String metaDataClassName = databaseMetaData.getClass().getName();
        if (metaDataClassName != null && metaDataClassName.toLowerCase().contains("mariadb")) {
            return MARIA_DB_PRODUCT_NAME;
        }
        return databaseName;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String checkForCrdb(Connection connection) {
        try (PreparedStatement preparedStatement = connection.prepareStatement("select version() as version;");){
            ResultSet result = preparedStatement.executeQuery();
            if (!result.next()) return POSTGRES_DB_PRODUCT_NAME;
            String versionData = result.getString(1);
            if (versionData == null) return POSTGRES_DB_PRODUCT_NAME;
            if (!versionData.toLowerCase().contains("cockroachdb")) return POSTGRES_DB_PRODUCT_NAME;
            String string = CRDB_DB_PRODUCT_NAME;
            return string;
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return POSTGRES_DB_PRODUCT_NAME;
    }

    protected void initDatabaseVendorAndVersion(DatabaseMetaData databaseMetaData) throws SQLException {
        this.databaseVendor = databaseMetaData.getDatabaseProductName();
        this.databaseVersion = databaseMetaData.getDatabaseProductVersion();
    }

    protected void initTransactionFactory() {
        if (this.transactionFactory == null) {
            this.transactionFactory = this.transactionsExternallyManaged ? new ManagedTransactionFactory() : new JdbcTransactionFactory();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initSqlSessionFactory() {
        Class<ProcessEngineConfigurationImpl> clazz = ProcessEngineConfigurationImpl.class;
        synchronized (ProcessEngineConfigurationImpl.class) {
            if (this.isUseSharedSqlSessionFactory) {
                this.sqlSessionFactory = cachedSqlSessionFactory;
            }
            if (this.sqlSessionFactory == null) {
                InputStream inputStream = null;
                try {
                    inputStream = this.getMyBatisXmlConfigurationSteam();
                    Environment environment = new Environment("default", this.transactionFactory, this.dataSource);
                    InputStreamReader reader = new InputStreamReader(inputStream);
                    Properties properties = new Properties();
                    if (this.isUseSharedSqlSessionFactory) {
                        properties.put("prefix", "${@org.camunda.bpm.engine.impl.context.Context@getProcessEngineConfiguration().databaseTablePrefix}");
                    } else {
                        properties.put("prefix", this.databaseTablePrefix);
                    }
                    ProcessEngineConfigurationImpl.initSqlSessionFactoryProperties(properties, this.databaseTablePrefix, this.databaseType);
                    XMLConfigBuilder parser = new XMLConfigBuilder((Reader)reader, "", properties);
                    Configuration configuration = parser.getConfiguration();
                    configuration.setEnvironment(environment);
                    configuration = parser.parse();
                    configuration.setDefaultStatementTimeout(this.jdbcStatementTimeout);
                    if (this.isJdbcBatchProcessing()) {
                        configuration.setDefaultExecutorType(ExecutorType.BATCH);
                    }
                    this.sqlSessionFactory = new DefaultSqlSessionFactory(configuration);
                    if (this.isUseSharedSqlSessionFactory) {
                        cachedSqlSessionFactory = this.sqlSessionFactory;
                    }
                }
                catch (Exception e) {
                    throw new ProcessEngineException("Error while building ibatis SqlSessionFactory: " + e.getMessage(), e);
                }
                finally {
                    IoUtil.closeSilently(inputStream);
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static void initSqlSessionFactoryProperties(Properties properties, String databaseTablePrefix, String databaseType) {
        if (databaseType != null) {
            properties.put("limitBefore", DbSqlSessionFactory.databaseSpecificLimitBeforeStatements.get(databaseType));
            properties.put("limitAfter", DbSqlSessionFactory.databaseSpecificLimitAfterStatements.get(databaseType));
            properties.put("limitBeforeWithoutOffset", DbSqlSessionFactory.databaseSpecificLimitBeforeWithoutOffsetStatements.get(databaseType));
            properties.put("limitAfterWithoutOffset", DbSqlSessionFactory.databaseSpecificLimitAfterWithoutOffsetStatements.get(databaseType));
            properties.put("optimizeLimitBeforeWithoutOffset", DbSqlSessionFactory.optimizeDatabaseSpecificLimitBeforeWithoutOffsetStatements.get(databaseType));
            properties.put("optimizeLimitAfterWithoutOffset", DbSqlSessionFactory.optimizeDatabaseSpecificLimitAfterWithoutOffsetStatements.get(databaseType));
            properties.put("innerLimitAfter", DbSqlSessionFactory.databaseSpecificInnerLimitAfterStatements.get(databaseType));
            properties.put("limitBetween", DbSqlSessionFactory.databaseSpecificLimitBetweenStatements.get(databaseType));
            properties.put("limitBetweenFilter", DbSqlSessionFactory.databaseSpecificLimitBetweenFilterStatements.get(databaseType));
            properties.put("limitBetweenAcquisition", DbSqlSessionFactory.databaseSpecificLimitBetweenAcquisitionStatements.get(databaseType));
            properties.put("orderBy", DbSqlSessionFactory.databaseSpecificOrderByStatements.get(databaseType));
            properties.put("limitBeforeNativeQuery", DbSqlSessionFactory.databaseSpecificLimitBeforeNativeQueryStatements.get(databaseType));
            properties.put("distinct", DbSqlSessionFactory.databaseSpecificDistinct.get(databaseType));
            properties.put("numericCast", DbSqlSessionFactory.databaseSpecificNumericCast.get(databaseType));
            properties.put("countDistinctBeforeStart", DbSqlSessionFactory.databaseSpecificCountDistinctBeforeStart.get(databaseType));
            properties.put("countDistinctBeforeEnd", DbSqlSessionFactory.databaseSpecificCountDistinctBeforeEnd.get(databaseType));
            properties.put("countDistinctAfterEnd", DbSqlSessionFactory.databaseSpecificCountDistinctAfterEnd.get(databaseType));
            properties.put("escapeChar", DbSqlSessionFactory.databaseSpecificEscapeChar.get(databaseType));
            properties.put("bitand1", DbSqlSessionFactory.databaseSpecificBitAnd1.get(databaseType));
            properties.put("bitand2", DbSqlSessionFactory.databaseSpecificBitAnd2.get(databaseType));
            properties.put("bitand3", DbSqlSessionFactory.databaseSpecificBitAnd3.get(databaseType));
            properties.put("datepart1", DbSqlSessionFactory.databaseSpecificDatepart1.get(databaseType));
            properties.put("datepart2", DbSqlSessionFactory.databaseSpecificDatepart2.get(databaseType));
            properties.put("datepart3", DbSqlSessionFactory.databaseSpecificDatepart3.get(databaseType));
            properties.put("trueConstant", DbSqlSessionFactory.databaseSpecificTrueConstant.get(databaseType));
            properties.put("falseConstant", DbSqlSessionFactory.databaseSpecificFalseConstant.get(databaseType));
            properties.put("dbSpecificDummyTable", DbSqlSessionFactory.databaseSpecificDummyTable.get(databaseType));
            properties.put("dbSpecificIfNullFunction", DbSqlSessionFactory.databaseSpecificIfNull.get(databaseType));
            properties.put("dayComparator", DbSqlSessionFactory.databaseSpecificDaysComparator.get(databaseType));
            properties.put("collationForCaseSensitivity", DbSqlSessionFactory.databaseSpecificCollationForCaseSensitivity.get(databaseType));
            properties.put("authJoinStart", DbSqlSessionFactory.databaseSpecificAuthJoinStart.get(databaseType));
            properties.put("authJoinEnd", DbSqlSessionFactory.databaseSpecificAuthJoinEnd.get(databaseType));
            properties.put("authJoinSeparator", DbSqlSessionFactory.databaseSpecificAuthJoinSeparator.get(databaseType));
            properties.put("authJoin1Start", DbSqlSessionFactory.databaseSpecificAuth1JoinStart.get(databaseType));
            properties.put("authJoin1End", DbSqlSessionFactory.databaseSpecificAuth1JoinEnd.get(databaseType));
            properties.put("authJoin1Separator", DbSqlSessionFactory.databaseSpecificAuth1JoinSeparator.get(databaseType));
            Map<String, String> constants = DbSqlSessionFactory.dbSpecificConstants.get(databaseType);
            for (Map.Entry<String, String> entry : constants.entrySet()) {
                properties.put(entry.getKey(), entry.getValue());
            }
        }
    }

    protected InputStream getMyBatisXmlConfigurationSteam() {
        return ReflectUtil.getResourceAsStream(DEFAULT_MYBATIS_MAPPING_FILE);
    }

    protected void initIdentityProviderSessionFactory() {
        if (this.identityProviderSessionFactory == null) {
            this.identityProviderSessionFactory = new GenericManagerFactory(DbIdentityServiceProvider.class);
        }
    }

    protected void initSessionFactories() {
        if (this.sessionFactories == null) {
            this.sessionFactories = new HashMap();
            this.initPersistenceProviders();
            this.addSessionFactory(new DbEntityManagerFactory(this.idGenerator));
            this.addSessionFactory(new GenericManagerFactory(AttachmentManager.class));
            this.addSessionFactory(new GenericManagerFactory(CommentManager.class));
            this.addSessionFactory(new GenericManagerFactory(DeploymentManager.class));
            this.addSessionFactory(new GenericManagerFactory(ExecutionManager.class));
            this.addSessionFactory(new GenericManagerFactory(HistoricActivityInstanceManager.class));
            this.addSessionFactory(new GenericManagerFactory(HistoricCaseActivityInstanceManager.class));
            this.addSessionFactory(new GenericManagerFactory(HistoricStatisticsManager.class));
            this.addSessionFactory(new GenericManagerFactory(HistoricDetailManager.class));
            this.addSessionFactory(new GenericManagerFactory(HistoricProcessInstanceManager.class));
            this.addSessionFactory(new GenericManagerFactory(HistoricCaseInstanceManager.class));
            this.addSessionFactory(new GenericManagerFactory(UserOperationLogManager.class));
            this.addSessionFactory(new GenericManagerFactory(HistoricTaskInstanceManager.class));
            this.addSessionFactory(new GenericManagerFactory(HistoricVariableInstanceManager.class));
            this.addSessionFactory(new GenericManagerFactory(HistoricIncidentManager.class));
            this.addSessionFactory(new GenericManagerFactory(HistoricIdentityLinkLogManager.class));
            this.addSessionFactory(new GenericManagerFactory(HistoricJobLogManager.class));
            this.addSessionFactory(new GenericManagerFactory(HistoricExternalTaskLogManager.class));
            this.addSessionFactory(new GenericManagerFactory(IdentityInfoManager.class));
            this.addSessionFactory(new GenericManagerFactory(IdentityLinkManager.class));
            this.addSessionFactory(new GenericManagerFactory(JobManager.class));
            this.addSessionFactory(new GenericManagerFactory(JobDefinitionManager.class));
            this.addSessionFactory(new GenericManagerFactory(ProcessDefinitionManager.class));
            this.addSessionFactory(new GenericManagerFactory(PropertyManager.class));
            this.addSessionFactory(new GenericManagerFactory(ResourceManager.class));
            this.addSessionFactory(new GenericManagerFactory(ByteArrayManager.class));
            this.addSessionFactory(new GenericManagerFactory(TableDataManager.class));
            this.addSessionFactory(new GenericManagerFactory(TaskManager.class));
            this.addSessionFactory(new GenericManagerFactory(TaskReportManager.class));
            this.addSessionFactory(new GenericManagerFactory(VariableInstanceManager.class));
            this.addSessionFactory(new GenericManagerFactory(EventSubscriptionManager.class));
            this.addSessionFactory(new GenericManagerFactory(StatisticsManager.class));
            this.addSessionFactory(new GenericManagerFactory(IncidentManager.class));
            this.addSessionFactory(new GenericManagerFactory(AuthorizationManager.class));
            this.addSessionFactory(new GenericManagerFactory(FilterManager.class));
            this.addSessionFactory(new GenericManagerFactory(MeterLogManager.class));
            this.addSessionFactory(new GenericManagerFactory(ExternalTaskManager.class));
            this.addSessionFactory(new GenericManagerFactory(ReportManager.class));
            this.addSessionFactory(new GenericManagerFactory(BatchManager.class));
            this.addSessionFactory(new GenericManagerFactory(HistoricBatchManager.class));
            this.addSessionFactory(new GenericManagerFactory(TenantManager.class));
            this.addSessionFactory(new GenericManagerFactory(SchemaLogManager.class));
            this.addSessionFactory(new GenericManagerFactory(CaseDefinitionManager.class));
            this.addSessionFactory(new GenericManagerFactory(CaseExecutionManager.class));
            this.addSessionFactory(new GenericManagerFactory(CaseSentryPartManager.class));
            this.addSessionFactory(new GenericManagerFactory(DecisionDefinitionManager.class));
            this.addSessionFactory(new GenericManagerFactory(DecisionRequirementsDefinitionManager.class));
            this.addSessionFactory(new GenericManagerFactory(HistoricDecisionInstanceManager.class));
            this.addSessionFactory(new GenericManagerFactory(CamundaFormDefinitionManager.class));
            this.addSessionFactory(new GenericManagerFactory(OptimizeManager.class));
            this.sessionFactories.put(ReadOnlyIdentityProvider.class, this.identityProviderSessionFactory);
            Class<?> identityProviderType = this.identityProviderSessionFactory.getSessionType();
            if (WritableIdentityProvider.class.isAssignableFrom(identityProviderType)) {
                this.sessionFactories.put(WritableIdentityProvider.class, this.identityProviderSessionFactory);
            }
        }
        if (this.customSessionFactories != null) {
            for (SessionFactory sessionFactory : this.customSessionFactories) {
                this.addSessionFactory(sessionFactory);
            }
        }
    }

    protected void initPersistenceProviders() {
        this.ensurePrefixAndSchemaFitToegether(this.databaseTablePrefix, this.databaseSchema);
        this.dbSqlSessionFactory = new DbSqlSessionFactory(this.jdbcBatchProcessing);
        this.dbSqlSessionFactory.setDatabaseType(this.databaseType);
        this.dbSqlSessionFactory.setIdGenerator(this.idGenerator);
        this.dbSqlSessionFactory.setSqlSessionFactory(this.sqlSessionFactory);
        this.dbSqlSessionFactory.setDbIdentityUsed(this.isDbIdentityUsed);
        this.dbSqlSessionFactory.setDbHistoryUsed(this.isDbHistoryUsed);
        this.dbSqlSessionFactory.setCmmnEnabled(this.cmmnEnabled);
        this.dbSqlSessionFactory.setDmnEnabled(this.dmnEnabled);
        this.dbSqlSessionFactory.setDatabaseTablePrefix(this.databaseTablePrefix);
        if (this.databaseTablePrefix != null && this.databaseSchema == null && this.databaseTablePrefix.contains(".")) {
            this.databaseSchema = this.databaseTablePrefix.split("\\.")[0];
        }
        this.dbSqlSessionFactory.setDatabaseSchema(this.databaseSchema);
        this.addSessionFactory(this.dbSqlSessionFactory);
        this.addSessionFactory(new DbSqlPersistenceProviderFactory());
    }

    protected void initMigration() {
        this.initMigrationInstructionValidators();
        this.initMigrationActivityMatcher();
        this.initMigrationInstructionGenerator();
        this.initMigratingActivityInstanceValidators();
        this.initMigratingTransitionInstanceValidators();
        this.initMigratingCompensationInstanceValidators();
    }

    protected void initMigrationActivityMatcher() {
        if (this.migrationActivityMatcher == null) {
            this.migrationActivityMatcher = new DefaultMigrationActivityMatcher();
        }
    }

    protected void initMigrationInstructionGenerator() {
        if (this.migrationInstructionGenerator == null) {
            this.migrationInstructionGenerator = new DefaultMigrationInstructionGenerator(this.migrationActivityMatcher);
        }
        ArrayList<MigrationActivityValidator> migrationActivityValidators = new ArrayList<MigrationActivityValidator>();
        if (this.customPreMigrationActivityValidators != null) {
            migrationActivityValidators.addAll(this.customPreMigrationActivityValidators);
        }
        migrationActivityValidators.addAll(this.getDefaultMigrationActivityValidators());
        if (this.customPostMigrationActivityValidators != null) {
            migrationActivityValidators.addAll(this.customPostMigrationActivityValidators);
        }
        this.migrationInstructionGenerator = this.migrationInstructionGenerator.migrationActivityValidators(migrationActivityValidators).migrationInstructionValidators(this.migrationInstructionValidators);
    }

    protected void initMigrationInstructionValidators() {
        if (this.migrationInstructionValidators == null) {
            this.migrationInstructionValidators = new ArrayList<MigrationInstructionValidator>();
            if (this.customPreMigrationInstructionValidators != null) {
                this.migrationInstructionValidators.addAll(this.customPreMigrationInstructionValidators);
            }
            this.migrationInstructionValidators.addAll(this.getDefaultMigrationInstructionValidators());
            if (this.customPostMigrationInstructionValidators != null) {
                this.migrationInstructionValidators.addAll(this.customPostMigrationInstructionValidators);
            }
        }
    }

    protected void initMigratingActivityInstanceValidators() {
        if (this.migratingActivityInstanceValidators == null) {
            this.migratingActivityInstanceValidators = new ArrayList<MigratingActivityInstanceValidator>();
            if (this.customPreMigratingActivityInstanceValidators != null) {
                this.migratingActivityInstanceValidators.addAll(this.customPreMigratingActivityInstanceValidators);
            }
            this.migratingActivityInstanceValidators.addAll(this.getDefaultMigratingActivityInstanceValidators());
            if (this.customPostMigratingActivityInstanceValidators != null) {
                this.migratingActivityInstanceValidators.addAll(this.customPostMigratingActivityInstanceValidators);
            }
        }
    }

    protected void initMigratingTransitionInstanceValidators() {
        if (this.migratingTransitionInstanceValidators == null) {
            this.migratingTransitionInstanceValidators = new ArrayList<MigratingTransitionInstanceValidator>();
            this.migratingTransitionInstanceValidators.addAll(this.getDefaultMigratingTransitionInstanceValidators());
        }
    }

    protected void initMigratingCompensationInstanceValidators() {
        if (this.migratingCompensationInstanceValidators == null) {
            this.migratingCompensationInstanceValidators = new ArrayList<MigratingCompensationInstanceValidator>();
            this.migratingCompensationInstanceValidators.add(new NoUnmappedLeafInstanceValidator());
            this.migratingCompensationInstanceValidators.add(new NoUnmappedCompensationStartEventValidator());
        }
    }

    protected void ensurePrefixAndSchemaFitToegether(String prefix, String schema) {
        if (schema == null) {
            return;
        }
        if (prefix == null || prefix != null && !prefix.startsWith(schema + ".")) {
            throw new ProcessEngineException("When setting a schema the prefix has to be schema + '.'. Received schema: " + schema + " prefix: " + prefix);
        }
    }

    protected void addSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactories.put(sessionFactory.getSessionType(), sessionFactory);
    }

    protected void initDeployers() {
        if (this.deployers == null) {
            this.deployers = new ArrayList<Deployer>();
            if (this.customPreDeployers != null) {
                this.deployers.addAll(this.customPreDeployers);
            }
            this.deployers.addAll(this.getDefaultDeployers());
            if (this.customPostDeployers != null) {
                this.deployers.addAll(this.customPostDeployers);
            }
        }
        if (this.deploymentCache == null) {
            ArrayList<Deployer> deployers = new ArrayList<Deployer>();
            if (this.customPreDeployers != null) {
                deployers.addAll(this.customPreDeployers);
            }
            deployers.addAll(this.getDefaultDeployers());
            if (this.customPostDeployers != null) {
                deployers.addAll(this.customPostDeployers);
            }
            this.initCacheFactory();
            this.deploymentCache = new DeploymentCache(this.cacheFactory, this.cacheCapacity);
            this.deploymentCache.setDeployers(deployers);
        }
    }

    protected Collection<? extends Deployer> getDefaultDeployers() {
        ArrayList<AbstractDefinitionDeployer> defaultDeployers = new ArrayList<AbstractDefinitionDeployer>();
        BpmnDeployer bpmnDeployer = this.getBpmnDeployer();
        defaultDeployers.add(bpmnDeployer);
        defaultDeployers.add(this.getCamundaFormDeployer());
        if (this.isCmmnEnabled()) {
            CmmnDeployer cmmnDeployer = this.getCmmnDeployer();
            defaultDeployers.add(cmmnDeployer);
        }
        if (this.isDmnEnabled()) {
            DecisionRequirementsDefinitionDeployer decisionRequirementsDefinitionDeployer = this.getDecisionRequirementsDefinitionDeployer();
            DecisionDefinitionDeployer decisionDefinitionDeployer = this.getDecisionDefinitionDeployer();
            defaultDeployers.add(decisionRequirementsDefinitionDeployer);
            defaultDeployers.add(decisionDefinitionDeployer);
        }
        return defaultDeployers;
    }

    protected BpmnDeployer getBpmnDeployer() {
        BpmnDeployer bpmnDeployer = new BpmnDeployer();
        bpmnDeployer.setExpressionManager(this.expressionManager);
        bpmnDeployer.setIdGenerator(this.idGenerator);
        if (this.bpmnParseFactory == null) {
            this.bpmnParseFactory = new DefaultBpmnParseFactory();
        }
        BpmnParser bpmnParser = new BpmnParser(this.expressionManager, this.bpmnParseFactory);
        if (this.preParseListeners != null) {
            bpmnParser.getParseListeners().addAll(this.preParseListeners);
        }
        bpmnParser.getParseListeners().addAll(this.getDefaultBPMNParseListeners());
        if (this.postParseListeners != null) {
            bpmnParser.getParseListeners().addAll(this.postParseListeners);
        }
        bpmnDeployer.setBpmnParser(bpmnParser);
        return bpmnDeployer;
    }

    protected List<BpmnParseListener> getDefaultBPMNParseListeners() {
        ArrayList<BpmnParseListener> defaultListeners = new ArrayList<BpmnParseListener>();
        if (!HistoryLevel.HISTORY_LEVEL_NONE.equals(this.historyLevel)) {
            defaultListeners.add(new HistoryParseListener(this.historyEventProducer));
        }
        if (this.isMetricsEnabled) {
            defaultListeners.add(new MetricsBpmnParseListener());
        }
        return defaultListeners;
    }

    protected CamundaFormDefinitionDeployer getCamundaFormDeployer() {
        CamundaFormDefinitionDeployer deployer = new CamundaFormDefinitionDeployer();
        deployer.setIdGenerator(this.idGenerator);
        return deployer;
    }

    protected CmmnDeployer getCmmnDeployer() {
        CmmnDeployer cmmnDeployer = new CmmnDeployer();
        cmmnDeployer.setIdGenerator(this.idGenerator);
        if (this.cmmnTransformFactory == null) {
            this.cmmnTransformFactory = new DefaultCmmnTransformFactory();
        }
        if (this.cmmnElementHandlerRegistry == null) {
            this.cmmnElementHandlerRegistry = new DefaultCmmnElementHandlerRegistry();
        }
        CmmnTransformer cmmnTransformer = new CmmnTransformer(this.expressionManager, this.cmmnElementHandlerRegistry, this.cmmnTransformFactory);
        if (this.customPreCmmnTransformListeners != null) {
            cmmnTransformer.getTransformListeners().addAll(this.customPreCmmnTransformListeners);
        }
        cmmnTransformer.getTransformListeners().addAll(this.getDefaultCmmnTransformListeners());
        if (this.customPostCmmnTransformListeners != null) {
            cmmnTransformer.getTransformListeners().addAll(this.customPostCmmnTransformListeners);
        }
        cmmnDeployer.setTransformer(cmmnTransformer);
        return cmmnDeployer;
    }

    protected List<CmmnTransformListener> getDefaultCmmnTransformListeners() {
        ArrayList<CmmnTransformListener> defaultListener = new ArrayList<CmmnTransformListener>();
        if (!HistoryLevel.HISTORY_LEVEL_NONE.equals(this.historyLevel)) {
            defaultListener.add(new CmmnHistoryTransformListener(this.cmmnHistoryEventProducer));
        }
        if (this.isMetricsEnabled) {
            defaultListener.add(new MetricsCmmnTransformListener());
        }
        return defaultListener;
    }

    protected DecisionDefinitionDeployer getDecisionDefinitionDeployer() {
        DecisionDefinitionDeployer decisionDefinitionDeployer = new DecisionDefinitionDeployer();
        decisionDefinitionDeployer.setIdGenerator(this.idGenerator);
        decisionDefinitionDeployer.setTransformer(this.dmnEngineConfiguration.getTransformer());
        return decisionDefinitionDeployer;
    }

    protected DecisionRequirementsDefinitionDeployer getDecisionRequirementsDefinitionDeployer() {
        DecisionRequirementsDefinitionDeployer drdDeployer = new DecisionRequirementsDefinitionDeployer();
        drdDeployer.setIdGenerator(this.idGenerator);
        drdDeployer.setTransformer(this.dmnEngineConfiguration.getTransformer());
        return drdDeployer;
    }

    public DmnEngine getDmnEngine() {
        return this.dmnEngine;
    }

    public void setDmnEngine(DmnEngine dmnEngine) {
        this.dmnEngine = dmnEngine;
    }

    public DefaultDmnEngineConfiguration getDmnEngineConfiguration() {
        return this.dmnEngineConfiguration;
    }

    public void setDmnEngineConfiguration(DefaultDmnEngineConfiguration dmnEngineConfiguration) {
        this.dmnEngineConfiguration = dmnEngineConfiguration;
    }

    protected void initJobExecutor() {
        long effectiveJobExecutorPriorityRangeMax;
        if (this.jobExecutor == null) {
            this.jobExecutor = new DefaultJobExecutor();
        }
        this.jobHandlers = new HashMap<String, JobHandler>();
        TimerExecuteNestedActivityJobHandler timerExecuteNestedActivityJobHandler = new TimerExecuteNestedActivityJobHandler();
        this.jobHandlers.put(timerExecuteNestedActivityJobHandler.getType(), timerExecuteNestedActivityJobHandler);
        TimerCatchIntermediateEventJobHandler timerCatchIntermediateEvent = new TimerCatchIntermediateEventJobHandler();
        this.jobHandlers.put(timerCatchIntermediateEvent.getType(), timerCatchIntermediateEvent);
        TimerStartEventJobHandler timerStartEvent = new TimerStartEventJobHandler();
        this.jobHandlers.put(timerStartEvent.getType(), timerStartEvent);
        TimerStartEventSubprocessJobHandler timerStartEventSubprocess = new TimerStartEventSubprocessJobHandler();
        this.jobHandlers.put(timerStartEventSubprocess.getType(), timerStartEventSubprocess);
        AsyncContinuationJobHandler asyncContinuationJobHandler = new AsyncContinuationJobHandler();
        this.jobHandlers.put(asyncContinuationJobHandler.getType(), asyncContinuationJobHandler);
        ProcessEventJobHandler processEventJobHandler = new ProcessEventJobHandler();
        this.jobHandlers.put(processEventJobHandler.getType(), processEventJobHandler);
        TimerSuspendProcessDefinitionHandler suspendProcessDefinitionHandler = new TimerSuspendProcessDefinitionHandler();
        this.jobHandlers.put(suspendProcessDefinitionHandler.getType(), suspendProcessDefinitionHandler);
        TimerActivateProcessDefinitionHandler activateProcessDefinitionHandler = new TimerActivateProcessDefinitionHandler();
        this.jobHandlers.put(activateProcessDefinitionHandler.getType(), activateProcessDefinitionHandler);
        TimerSuspendJobDefinitionHandler suspendJobDefinitionHandler = new TimerSuspendJobDefinitionHandler();
        this.jobHandlers.put(suspendJobDefinitionHandler.getType(), suspendJobDefinitionHandler);
        TimerActivateJobDefinitionHandler activateJobDefinitionHandler = new TimerActivateJobDefinitionHandler();
        this.jobHandlers.put(activateJobDefinitionHandler.getType(), activateJobDefinitionHandler);
        TimerTaskListenerJobHandler taskListenerJobHandler = new TimerTaskListenerJobHandler();
        this.jobHandlers.put(taskListenerJobHandler.getType(), taskListenerJobHandler);
        BatchSeedJobHandler batchSeedJobHandler = new BatchSeedJobHandler();
        this.jobHandlers.put(batchSeedJobHandler.getType(), batchSeedJobHandler);
        BatchMonitorJobHandler batchMonitorJobHandler = new BatchMonitorJobHandler();
        this.jobHandlers.put(batchMonitorJobHandler.getType(), batchMonitorJobHandler);
        HistoryCleanupJobHandler historyCleanupJobHandler = new HistoryCleanupJobHandler();
        this.jobHandlers.put(historyCleanupJobHandler.getType(), historyCleanupJobHandler);
        for (JobHandler jobHandler : this.batchHandlers.values()) {
            this.jobHandlers.put(jobHandler.getType(), jobHandler);
        }
        if (this.getCustomJobHandlers() != null) {
            for (JobHandler<BatchJobConfiguration> jobHandler : this.getCustomJobHandlers()) {
                this.jobHandlers.put(jobHandler.getType(), jobHandler);
            }
        }
        this.jobExecutor.setAutoActivate(this.jobExecutorActivate);
        if (this.jobExecutor.getRejectedJobsHandler() == null) {
            if (this.customRejectedJobsHandler != null) {
                this.jobExecutor.setRejectedJobsHandler(this.customRejectedJobsHandler);
            } else {
                this.jobExecutor.setRejectedJobsHandler(new NotifyAcquisitionRejectedJobsHandler());
            }
        }
        long effectiveJobExecutorPriorityRangeMin = this.jobExecutorPriorityRangeMin == null ? 0L : this.jobExecutorPriorityRangeMin;
        long l = effectiveJobExecutorPriorityRangeMax = this.jobExecutorPriorityRangeMax == null ? Long.MAX_VALUE : this.jobExecutorPriorityRangeMax;
        if (effectiveJobExecutorPriorityRangeMin > effectiveJobExecutorPriorityRangeMax) {
            throw ProcessEngineLogger.JOB_EXECUTOR_LOGGER.jobExecutorPriorityRangeException("jobExecutorPriorityRangeMin can not be greater than jobExecutorPriorityRangeMax");
        }
        if (effectiveJobExecutorPriorityRangeMin < 0L) {
            throw ProcessEngineLogger.JOB_EXECUTOR_LOGGER.jobExecutorPriorityRangeException("job executor priority range can not be negative");
        }
        if (effectiveJobExecutorPriorityRangeMin > this.historyCleanupJobPriority || effectiveJobExecutorPriorityRangeMax < this.historyCleanupJobPriority) {
            ProcessEngineLogger.JOB_EXECUTOR_LOGGER.infoJobExecutorDoesNotHandleHistoryCleanupJobs(this);
        }
        if (effectiveJobExecutorPriorityRangeMin > this.batchJobPriority || effectiveJobExecutorPriorityRangeMax < this.batchJobPriority) {
            ProcessEngineLogger.JOB_EXECUTOR_LOGGER.infoJobExecutorDoesNotHandleBatchJobs(this);
        }
    }

    protected void initJobProvider() {
        if (this.producePrioritizedJobs && this.jobPriorityProvider == null) {
            this.jobPriorityProvider = new DefaultJobPriorityProvider();
        }
    }

    protected void initExternalTaskPriorityProvider() {
        if (this.producePrioritizedExternalTasks && this.externalTaskPriorityProvider == null) {
            this.externalTaskPriorityProvider = new DefaultExternalTaskPriorityProvider();
        }
    }

    public void initHistoryLevel() {
        if (this.historyLevel != null) {
            this.setHistory(this.historyLevel.getName());
        }
        if (this.historyLevels == null) {
            this.historyLevels = new ArrayList<HistoryLevel>();
            this.historyLevels.add(HistoryLevel.HISTORY_LEVEL_NONE);
            this.historyLevels.add(HistoryLevel.HISTORY_LEVEL_ACTIVITY);
            this.historyLevels.add(HistoryLevel.HISTORY_LEVEL_AUDIT);
            this.historyLevels.add(HistoryLevel.HISTORY_LEVEL_FULL);
        }
        if (this.customHistoryLevels != null) {
            this.historyLevels.addAll(this.customHistoryLevels);
        }
        if ("variable".equalsIgnoreCase(this.history)) {
            this.historyLevel = HistoryLevel.HISTORY_LEVEL_ACTIVITY;
            LOG.usingDeprecatedHistoryLevelVariable();
        } else {
            for (HistoryLevel historyLevel : this.historyLevels) {
                if (!historyLevel.getName().equalsIgnoreCase(this.history)) continue;
                this.historyLevel = historyLevel;
            }
        }
        if (this.historyLevel == null && !"auto".equalsIgnoreCase(this.history)) {
            throw new ProcessEngineException("invalid history level: " + this.history);
        }
    }

    protected void initIdGenerator() {
        if (this.idGenerator == null) {
            StandaloneProcessEngineConfiguration processEngineConfiguration;
            CommandExecutor idGeneratorCommandExecutor = null;
            if (this.idGeneratorDataSource != null) {
                processEngineConfiguration = new StandaloneProcessEngineConfiguration();
                processEngineConfiguration.setDataSource(this.idGeneratorDataSource);
                processEngineConfiguration.setDatabaseSchemaUpdate("false");
                processEngineConfiguration.init();
                idGeneratorCommandExecutor = processEngineConfiguration.getCommandExecutorTxRequiresNew();
            } else if (this.idGeneratorDataSourceJndiName != null) {
                processEngineConfiguration = new StandaloneProcessEngineConfiguration();
                processEngineConfiguration.setDataSourceJndiName(this.idGeneratorDataSourceJndiName);
                processEngineConfiguration.setDatabaseSchemaUpdate("false");
                processEngineConfiguration.init();
                idGeneratorCommandExecutor = processEngineConfiguration.getCommandExecutorTxRequiresNew();
            } else {
                idGeneratorCommandExecutor = this.commandExecutorTxRequiresNew;
            }
            DbIdGenerator dbIdGenerator = new DbIdGenerator();
            dbIdGenerator.setIdBlockSize(this.idBlockSize);
            dbIdGenerator.setCommandExecutor(idGeneratorCommandExecutor);
            this.idGenerator = dbIdGenerator;
        }
    }

    protected void initCommandContextFactory() {
        if (this.commandContextFactory == null) {
            this.commandContextFactory = new CommandContextFactory();
            this.commandContextFactory.setProcessEngineConfiguration(this);
        }
    }

    protected void initTransactionContextFactory() {
        if (this.transactionContextFactory == null) {
            this.transactionContextFactory = new StandaloneTransactionContextFactory();
        }
    }

    protected void initValueTypeResolver() {
        if (this.valueTypeResolver == null) {
            this.valueTypeResolver = new ValueTypeResolverImpl();
        }
    }

    protected void initDefaultCharset() {
        if (this.defaultCharset == null) {
            if (this.defaultCharsetName == null) {
                this.defaultCharsetName = "UTF-8";
            }
            this.defaultCharset = Charset.forName(this.defaultCharsetName);
        }
    }

    protected void initMetrics() {
        if (this.isMetricsEnabled) {
            if (this.metricsRegistry == null) {
                this.metricsRegistry = new MetricsRegistry();
            }
            this.initDefaultMetrics(this.metricsRegistry);
            if (this.dbMetricsReporter == null) {
                this.dbMetricsReporter = new DbMetricsReporter(this.metricsRegistry, this.commandExecutorTxRequired);
            }
        }
    }

    protected void initHostName() {
        if (this.hostname == null) {
            if (this.hostnameProvider == null) {
                this.hostnameProvider = new SimpleIpBasedProvider();
            }
            this.hostname = this.hostnameProvider.getHostname(this);
        }
    }

    protected void initDefaultMetrics(MetricsRegistry metricsRegistry) {
        metricsRegistry.createMeter("activity-instance-start");
        metricsRegistry.createDbMeter("activity-instance-end");
        metricsRegistry.createDbMeter("job-acquisition-attempt");
        metricsRegistry.createDbMeter("job-acquired-success");
        metricsRegistry.createDbMeter("job-acquired-failure");
        metricsRegistry.createDbMeter("job-successful");
        metricsRegistry.createDbMeter("job-failed");
        metricsRegistry.createDbMeter("job-locked-exclusive");
        metricsRegistry.createDbMeter("job-execution-rejected");
        metricsRegistry.createMeter("root-process-instance-start");
        metricsRegistry.createMeter("executed-decision-instances");
        metricsRegistry.createMeter("executed-decision-elements");
    }

    protected void initSerialization() {
        if (this.variableSerializers == null) {
            this.variableSerializers = new DefaultVariableSerializers();
            if (this.customPreVariableSerializers != null) {
                for (TypedValueSerializer customVariableType : this.customPreVariableSerializers) {
                    this.variableSerializers.addSerializer(customVariableType);
                }
            }
            this.variableSerializers.addSerializer(new NullValueSerializer());
            this.variableSerializers.addSerializer(new StringValueSerializer());
            this.variableSerializers.addSerializer(new BooleanValueSerializer());
            this.variableSerializers.addSerializer(new ShortValueSerializer());
            this.variableSerializers.addSerializer(new IntegerValueSerializer());
            this.variableSerializers.addSerializer(new LongValueSerlializer());
            this.variableSerializers.addSerializer(new DateValueSerializer());
            this.variableSerializers.addSerializer(new DoubleValueSerializer());
            this.variableSerializers.addSerializer(new ByteArrayValueSerializer());
            this.variableSerializers.addSerializer(new JavaObjectSerializer());
            this.variableSerializers.addSerializer(new FileValueSerializer());
            if (this.customPostVariableSerializers != null) {
                for (TypedValueSerializer customVariableType : this.customPostVariableSerializers) {
                    this.variableSerializers.addSerializer(customVariableType);
                }
            }
        }
    }

    protected void initFormEngines() {
        if (this.formEngines == null) {
            this.formEngines = new HashMap<String, FormEngine>();
            HtmlFormEngine defaultFormEngine = new HtmlFormEngine();
            this.formEngines.put(null, defaultFormEngine);
            this.formEngines.put(defaultFormEngine.getName(), defaultFormEngine);
            JuelFormEngine juelFormEngine = new JuelFormEngine();
            this.formEngines.put(juelFormEngine.getName(), juelFormEngine);
        }
        if (this.customFormEngines != null) {
            for (FormEngine formEngine : this.customFormEngines) {
                this.formEngines.put(formEngine.getName(), formEngine);
            }
        }
    }

    protected void initFormTypes() {
        if (this.formTypes == null) {
            this.formTypes = new FormTypes();
            this.formTypes.addFormType(new StringFormType());
            this.formTypes.addFormType(new LongFormType());
            this.formTypes.addFormType(new DateFormType("dd/MM/yyyy"));
            this.formTypes.addFormType(new BooleanFormType());
        }
        if (this.customFormTypes != null) {
            for (AbstractFormFieldType customFormType : this.customFormTypes) {
                this.formTypes.addFormType(customFormType);
            }
        }
    }

    protected void initFormFieldValidators() {
        if (this.formValidators == null) {
            this.formValidators = new FormValidators();
            this.formValidators.addValidator("min", MinValidator.class);
            this.formValidators.addValidator("max", MaxValidator.class);
            this.formValidators.addValidator("minlength", MinLengthValidator.class);
            this.formValidators.addValidator("maxlength", MaxLengthValidator.class);
            this.formValidators.addValidator("required", RequiredValidator.class);
            this.formValidators.addValidator("readonly", ReadOnlyValidator.class);
        }
        if (this.customFormFieldValidators != null) {
            for (Map.Entry<String, Class<? extends FormFieldValidator>> validator : this.customFormFieldValidators.entrySet()) {
                this.formValidators.addValidator(validator.getKey(), validator.getValue());
            }
        }
    }

    protected void initScripting() {
        if (this.resolverFactories == null) {
            this.resolverFactories = new ArrayList<ResolverFactory>();
            this.resolverFactories.add(new MocksResolverFactory());
            this.resolverFactories.add(new VariableScopeResolverFactory());
            this.resolverFactories.add(new BeansResolverFactory());
        }
        if (this.scriptEngineResolver == null) {
            this.scriptEngineResolver = new DefaultScriptEngineResolver(new ScriptEngineManager());
        }
        if (this.scriptingEngines == null) {
            this.scriptingEngines = new ScriptingEngines(new ScriptBindingsFactory(this.resolverFactories), this.scriptEngineResolver);
            this.scriptingEngines.setEnableScriptEngineCaching(this.enableScriptEngineCaching);
        }
        if (this.scriptFactory == null) {
            this.scriptFactory = new ScriptFactory();
        }
        if (this.scriptEnvResolvers == null) {
            this.scriptEnvResolvers = new ArrayList<ScriptEnvResolver>();
        }
        if (this.scriptingEnvironment == null) {
            this.scriptingEnvironment = new ScriptingEnvironment(this.scriptFactory, this.scriptEnvResolvers, this.scriptingEngines);
        }
    }

    protected void initDmnEngine() {
        if (this.dmnEngine == null) {
            if (this.dmnEngineConfiguration == null) {
                this.dmnEngineConfiguration = (DefaultDmnEngineConfiguration)DmnEngineConfiguration.createDefaultDmnEngineConfiguration();
            }
            this.dmnEngineConfiguration = new DmnEngineConfigurationBuilder(this.dmnEngineConfiguration).dmnHistoryEventProducer(this.dmnHistoryEventProducer).scriptEngineResolver(this.scriptingEngines).expressionManager(this.expressionManager).feelCustomFunctionProviders(this.dmnFeelCustomFunctionProviders).enableFeelLegacyBehavior(this.dmnFeelEnableLegacyBehavior).build();
            this.dmnEngine = this.dmnEngineConfiguration.buildEngine();
        } else if (this.dmnEngineConfiguration == null) {
            this.dmnEngineConfiguration = (DefaultDmnEngineConfiguration)this.dmnEngine.getConfiguration();
        }
    }

    protected void initExpressionManager() {
        if (this.expressionManager == null) {
            this.expressionManager = new ExpressionManager(this.beans);
        }
        this.expressionManager.addFunctionMapper(new CommandContextFunctionMapper());
        this.expressionManager.addFunctionMapper(new DateTimeFunctionMapper());
    }

    protected void initBusinessCalendarManager() {
        if (this.businessCalendarManager == null) {
            MapBusinessCalendarManager mapBusinessCalendarManager = new MapBusinessCalendarManager();
            mapBusinessCalendarManager.addBusinessCalendar(DurationBusinessCalendar.NAME, new DurationBusinessCalendar());
            mapBusinessCalendarManager.addBusinessCalendar("dueDate", new DueDateBusinessCalendar());
            mapBusinessCalendarManager.addBusinessCalendar(CycleBusinessCalendar.NAME, new CycleBusinessCalendar());
            this.businessCalendarManager = mapBusinessCalendarManager;
        }
    }

    protected void initDelegateInterceptor() {
        if (this.delegateInterceptor == null) {
            this.delegateInterceptor = new DefaultDelegateInterceptor();
        }
    }

    protected void initEventHandlers() {
        if (this.eventHandlers == null) {
            this.eventHandlers = new HashMap<String, EventHandler>();
            SignalEventHandler signalEventHander = new SignalEventHandler();
            this.eventHandlers.put(signalEventHander.getEventHandlerType(), signalEventHander);
            CompensationEventHandler compensationEventHandler = new CompensationEventHandler();
            this.eventHandlers.put(compensationEventHandler.getEventHandlerType(), compensationEventHandler);
            EventHandlerImpl messageEventHandler = new EventHandlerImpl(EventType.MESSAGE);
            this.eventHandlers.put(messageEventHandler.getEventHandlerType(), messageEventHandler);
            ConditionalEventHandler conditionalEventHandler = new ConditionalEventHandler();
            this.eventHandlers.put(conditionalEventHandler.getEventHandlerType(), conditionalEventHandler);
        }
        if (this.customEventHandlers != null) {
            for (EventHandler eventHandler : this.customEventHandlers) {
                this.eventHandlers.put(eventHandler.getEventHandlerType(), eventHandler);
            }
        }
    }

    protected void initCommandCheckers() {
        if (this.commandCheckers == null) {
            this.commandCheckers = new ArrayList<CommandChecker>();
            this.commandCheckers.add(new TenantCommandChecker());
            this.commandCheckers.add(new AuthorizationCommandChecker());
        }
    }

    protected void initJpa() {
        if (this.jpaPersistenceUnitName != null) {
            this.jpaEntityManagerFactory = JpaHelper.createEntityManagerFactory(this.jpaPersistenceUnitName);
        }
        if (this.jpaEntityManagerFactory != null) {
            this.sessionFactories.put(EntityManagerSession.class, new EntityManagerSessionFactory(this.jpaEntityManagerFactory, this.jpaHandleTransaction, this.jpaCloseEntityManager));
            JPAVariableSerializer jpaType = (JPAVariableSerializer)this.variableSerializers.getSerializerByName("jpa");
            if (jpaType == null) {
                int serializableIndex = this.variableSerializers.getSerializerIndexByName(ValueType.BYTES.getName());
                if (serializableIndex > -1) {
                    this.variableSerializers.addSerializer(new JPAVariableSerializer(), serializableIndex);
                } else {
                    this.variableSerializers.addSerializer(new JPAVariableSerializer());
                }
            }
        }
    }

    protected void initBeans() {
        if (this.beans == null) {
            this.beans = DEFAULT_BEANS_MAP;
        }
    }

    protected void initArtifactFactory() {
        if (this.artifactFactory == null) {
            this.artifactFactory = new DefaultArtifactFactory();
        }
    }

    protected void initProcessApplicationManager() {
        if (this.processApplicationManager == null) {
            this.processApplicationManager = new ProcessApplicationManager();
        }
    }

    protected void initCorrelationHandler() {
        if (this.correlationHandler == null) {
            this.correlationHandler = new DefaultCorrelationHandler();
        }
    }

    protected void initConditionHandler() {
        if (this.conditionHandler == null) {
            this.conditionHandler = new DefaultConditionHandler();
        }
    }

    protected void initDeploymentHandlerFactory() {
        if (this.deploymentHandlerFactory == null) {
            this.deploymentHandlerFactory = new DefaultDeploymentHandlerFactory();
        }
    }

    protected void initHistoryEventProducer() {
        if (this.historyEventProducer == null) {
            this.historyEventProducer = new CacheAwareHistoryEventProducer();
        }
    }

    protected void initCmmnHistoryEventProducer() {
        if (this.cmmnHistoryEventProducer == null) {
            this.cmmnHistoryEventProducer = new CacheAwareCmmnHistoryEventProducer();
        }
    }

    protected void initDmnHistoryEventProducer() {
        if (this.dmnHistoryEventProducer == null) {
            this.dmnHistoryEventProducer = new DefaultDmnHistoryEventProducer();
        }
    }

    protected void initHistoryEventHandler() {
        if (this.historyEventHandler == null) {
            this.historyEventHandler = this.enableDefaultDbHistoryEventHandler ? new CompositeDbHistoryEventHandler(this.customHistoryEventHandlers) : new CompositeHistoryEventHandler(this.customHistoryEventHandlers);
        }
    }

    protected void initPasswordDigest() {
        if (this.saltGenerator == null) {
            this.saltGenerator = new Default16ByteSaltGenerator();
        }
        if (this.passwordEncryptor == null) {
            this.passwordEncryptor = new Sha512HashDigest();
        }
        if (this.customPasswordChecker == null) {
            this.customPasswordChecker = Collections.emptyList();
        }
        if (this.passwordManager == null) {
            this.passwordManager = new PasswordManager(this.passwordEncryptor, this.customPasswordChecker);
        }
    }

    public void initPasswordPolicy() {
        if (this.passwordPolicy == null && this.enablePasswordPolicy) {
            this.passwordPolicy = new DefaultPasswordPolicyImpl();
        }
    }

    protected void initDeploymentRegistration() {
        if (this.registeredDeployments == null) {
            this.registeredDeployments = new CopyOnWriteArraySet<String>();
        }
    }

    protected void initCacheFactory() {
        if (this.cacheFactory == null) {
            this.cacheFactory = new DefaultCacheFactory();
        }
    }

    protected void initResourceAuthorizationProvider() {
        if (this.resourceAuthorizationProvider == null) {
            this.resourceAuthorizationProvider = new DefaultAuthorizationProvider();
        }
    }

    protected void initPermissionProvider() {
        if (this.permissionProvider == null) {
            this.permissionProvider = new DefaultPermissionProvider();
        }
    }

    protected void initDefaultUserPermissionForTask() {
        if (this.defaultUserPermissionForTask == null) {
            if (Permissions.UPDATE.getName().equals(this.defaultUserPermissionNameForTask)) {
                this.defaultUserPermissionForTask = Permissions.UPDATE;
            } else if (Permissions.TASK_WORK.getName().equals(this.defaultUserPermissionNameForTask)) {
                this.defaultUserPermissionForTask = Permissions.TASK_WORK;
            } else {
                throw LOG.invalidConfigDefaultUserPermissionNameForTask(this.defaultUserPermissionNameForTask, new String[]{Permissions.UPDATE.getName(), Permissions.TASK_WORK.getName()});
            }
        }
    }

    protected void initAdminUser() {
        if (this.adminUsers == null) {
            this.adminUsers = new ArrayList<String>();
        }
    }

    protected void initAdminGroups() {
        if (this.adminGroups == null) {
            this.adminGroups = new ArrayList<String>();
        }
        if (this.adminGroups.isEmpty() || !this.adminGroups.contains("camunda-admin")) {
            this.adminGroups.add("camunda-admin");
        }
    }

    protected void initTelemetry() {
        if (this.telemetryRegistry == null) {
            this.telemetryRegistry = new TelemetryRegistry();
        }
        if (this.telemetryData == null) {
            this.initTelemetryData();
        }
        try {
            if (this.telemetryHttpConnector == null) {
                this.telemetryHttpConnector = Connectors.getConnector((String)Connectors.HTTP_CONNECTOR_ID);
            }
        }
        catch (Exception e) {
            ProcessEngineLogger.TELEMETRY_LOGGER.unexpectedExceptionDuringHttpConnectorConfiguration(e);
        }
        if (this.telemetryHttpConnector == null) {
            ProcessEngineLogger.TELEMETRY_LOGGER.unableToConfigureHttpConnectorWarning();
        } else if (this.telemetryReporter == null) {
            this.telemetryReporter = new TelemetryReporter(this.commandExecutorTxRequired, this.telemetryEndpoint, this.telemetryRequestRetries, this.telemetryReportingPeriod, this.telemetryData, this.telemetryHttpConnector, this.telemetryRegistry, this.metricsRegistry, this.telemetryRequestTimeout);
        }
    }

    protected void initTelemetryData() {
        DatabaseImpl database = new DatabaseImpl(this.databaseVendor, this.databaseVersion);
        JdkImpl jdk = ParseUtil.parseJdkDetails();
        InternalsImpl internals = new InternalsImpl(database, this.telemetryRegistry.getApplicationServer(), this.telemetryRegistry.getLicenseKey(), jdk);
        String camundaIntegration = this.telemetryRegistry.getCamundaIntegration();
        if (camundaIntegration != null && !camundaIntegration.isEmpty()) {
            internals.getCamundaIntegration().add(camundaIntegration);
        }
        ProcessEngineDetails engineInfo = ParseUtil.parseProcessEngineVersion(true);
        ProductImpl product = new ProductImpl(PRODUCT_NAME, engineInfo.getVersion(), engineInfo.getEdition(), internals);
        this.telemetryData = new TelemetryDataImpl(null, product);
    }

    @Override
    public String getProcessEngineName() {
        return this.processEngineName;
    }

    public HistoryLevel getHistoryLevel() {
        return this.historyLevel;
    }

    public void setHistoryLevel(HistoryLevel historyLevel) {
        this.historyLevel = historyLevel;
    }

    public HistoryLevel getDefaultHistoryLevel() {
        if (this.historyLevels != null) {
            for (HistoryLevel historyLevel : this.historyLevels) {
                if ("audit" == null || !"audit".equalsIgnoreCase(historyLevel.getName())) continue;
                return historyLevel;
            }
        }
        return null;
    }

    @Override
    public ProcessEngineConfigurationImpl setProcessEngineName(String processEngineName) {
        this.processEngineName = processEngineName;
        return this;
    }

    public List<CommandInterceptor> getCustomPreCommandInterceptorsTxRequired() {
        return this.customPreCommandInterceptorsTxRequired;
    }

    public ProcessEngineConfigurationImpl setCustomPreCommandInterceptorsTxRequired(List<CommandInterceptor> customPreCommandInterceptorsTxRequired) {
        this.customPreCommandInterceptorsTxRequired = customPreCommandInterceptorsTxRequired;
        return this;
    }

    public List<CommandInterceptor> getCustomPostCommandInterceptorsTxRequired() {
        return this.customPostCommandInterceptorsTxRequired;
    }

    public ProcessEngineConfigurationImpl setCustomPostCommandInterceptorsTxRequired(List<CommandInterceptor> customPostCommandInterceptorsTxRequired) {
        this.customPostCommandInterceptorsTxRequired = customPostCommandInterceptorsTxRequired;
        return this;
    }

    public List<CommandInterceptor> getCommandInterceptorsTxRequired() {
        return this.commandInterceptorsTxRequired;
    }

    public ProcessEngineConfigurationImpl setCommandInterceptorsTxRequired(List<CommandInterceptor> commandInterceptorsTxRequired) {
        this.commandInterceptorsTxRequired = commandInterceptorsTxRequired;
        return this;
    }

    public CommandExecutor getCommandExecutorTxRequired() {
        return this.commandExecutorTxRequired;
    }

    public ProcessEngineConfigurationImpl setCommandExecutorTxRequired(CommandExecutor commandExecutorTxRequired) {
        this.commandExecutorTxRequired = commandExecutorTxRequired;
        return this;
    }

    public List<CommandInterceptor> getCustomPreCommandInterceptorsTxRequiresNew() {
        return this.customPreCommandInterceptorsTxRequiresNew;
    }

    public ProcessEngineConfigurationImpl setCustomPreCommandInterceptorsTxRequiresNew(List<CommandInterceptor> customPreCommandInterceptorsTxRequiresNew) {
        this.customPreCommandInterceptorsTxRequiresNew = customPreCommandInterceptorsTxRequiresNew;
        return this;
    }

    public List<CommandInterceptor> getCustomPostCommandInterceptorsTxRequiresNew() {
        return this.customPostCommandInterceptorsTxRequiresNew;
    }

    public ProcessEngineConfigurationImpl setCustomPostCommandInterceptorsTxRequiresNew(List<CommandInterceptor> customPostCommandInterceptorsTxRequiresNew) {
        this.customPostCommandInterceptorsTxRequiresNew = customPostCommandInterceptorsTxRequiresNew;
        return this;
    }

    public List<CommandInterceptor> getCommandInterceptorsTxRequiresNew() {
        return this.commandInterceptorsTxRequiresNew;
    }

    public ProcessEngineConfigurationImpl setCommandInterceptorsTxRequiresNew(List<CommandInterceptor> commandInterceptorsTxRequiresNew) {
        this.commandInterceptorsTxRequiresNew = commandInterceptorsTxRequiresNew;
        return this;
    }

    public CommandExecutor getCommandExecutorTxRequiresNew() {
        return this.commandExecutorTxRequiresNew;
    }

    public ProcessEngineConfigurationImpl setCommandExecutorTxRequiresNew(CommandExecutor commandExecutorTxRequiresNew) {
        this.commandExecutorTxRequiresNew = commandExecutorTxRequiresNew;
        return this;
    }

    public RepositoryService getRepositoryService() {
        return this.repositoryService;
    }

    public ProcessEngineConfigurationImpl setRepositoryService(RepositoryService repositoryService) {
        this.repositoryService = repositoryService;
        return this;
    }

    public RuntimeService getRuntimeService() {
        return this.runtimeService;
    }

    public ProcessEngineConfigurationImpl setRuntimeService(RuntimeService runtimeService) {
        this.runtimeService = runtimeService;
        return this;
    }

    public HistoryService getHistoryService() {
        return this.historyService;
    }

    public ProcessEngineConfigurationImpl setHistoryService(HistoryService historyService) {
        this.historyService = historyService;
        return this;
    }

    public IdentityService getIdentityService() {
        return this.identityService;
    }

    public ProcessEngineConfigurationImpl setIdentityService(IdentityService identityService) {
        this.identityService = identityService;
        return this;
    }

    public TaskService getTaskService() {
        return this.taskService;
    }

    public ProcessEngineConfigurationImpl setTaskService(TaskService taskService) {
        this.taskService = taskService;
        return this;
    }

    public FormService getFormService() {
        return this.formService;
    }

    public ProcessEngineConfigurationImpl setFormService(FormService formService) {
        this.formService = formService;
        return this;
    }

    public ManagementService getManagementService() {
        return this.managementService;
    }

    public AuthorizationService getAuthorizationService() {
        return this.authorizationService;
    }

    public void setAuthorizationService(AuthorizationService authorizationService) {
        this.authorizationService = authorizationService;
    }

    public ProcessEngineConfigurationImpl setManagementService(ManagementService managementService) {
        this.managementService = managementService;
        return this;
    }

    public CaseService getCaseService() {
        return this.caseService;
    }

    public void setCaseService(CaseService caseService) {
        this.caseService = caseService;
    }

    public FilterService getFilterService() {
        return this.filterService;
    }

    public void setFilterService(FilterService filterService) {
        this.filterService = filterService;
    }

    public ExternalTaskService getExternalTaskService() {
        return this.externalTaskService;
    }

    public void setExternalTaskService(ExternalTaskService externalTaskService) {
        this.externalTaskService = externalTaskService;
    }

    public DecisionService getDecisionService() {
        return this.decisionService;
    }

    public void setDecisionService(DecisionService decisionService) {
        this.decisionService = decisionService;
    }

    public OptimizeService getOptimizeService() {
        return this.optimizeService;
    }

    public Map<Class<?>, SessionFactory> getSessionFactories() {
        return this.sessionFactories;
    }

    public ProcessEngineConfigurationImpl setSessionFactories(Map<Class<?>, SessionFactory> sessionFactories) {
        this.sessionFactories = sessionFactories;
        return this;
    }

    public List<Deployer> getDeployers() {
        return this.deployers;
    }

    public ProcessEngineConfigurationImpl setDeployers(List<Deployer> deployers) {
        this.deployers = deployers;
        return this;
    }

    public JobExecutor getJobExecutor() {
        return this.jobExecutor;
    }

    public ProcessEngineConfigurationImpl setJobExecutor(JobExecutor jobExecutor) {
        this.jobExecutor = jobExecutor;
        return this;
    }

    public PriorityProvider<JobDeclaration<?, ?>> getJobPriorityProvider() {
        return this.jobPriorityProvider;
    }

    public void setJobPriorityProvider(PriorityProvider<JobDeclaration<?, ?>> jobPriorityProvider) {
        this.jobPriorityProvider = jobPriorityProvider;
    }

    public Long getJobExecutorPriorityRangeMin() {
        return this.jobExecutorPriorityRangeMin;
    }

    public ProcessEngineConfigurationImpl setJobExecutorPriorityRangeMin(Long jobExecutorPriorityRangeMin) {
        this.jobExecutorPriorityRangeMin = jobExecutorPriorityRangeMin;
        return this;
    }

    public Long getJobExecutorPriorityRangeMax() {
        return this.jobExecutorPriorityRangeMax;
    }

    public ProcessEngineConfigurationImpl setJobExecutorPriorityRangeMax(Long jobExecutorPriorityRangeMax) {
        this.jobExecutorPriorityRangeMax = jobExecutorPriorityRangeMax;
        return this;
    }

    public PriorityProvider<ExternalTaskActivityBehavior> getExternalTaskPriorityProvider() {
        return this.externalTaskPriorityProvider;
    }

    public void setExternalTaskPriorityProvider(PriorityProvider<ExternalTaskActivityBehavior> externalTaskPriorityProvider) {
        this.externalTaskPriorityProvider = externalTaskPriorityProvider;
    }

    public IdGenerator getIdGenerator() {
        return this.idGenerator;
    }

    public ProcessEngineConfigurationImpl setIdGenerator(IdGenerator idGenerator) {
        this.idGenerator = idGenerator;
        return this;
    }

    public String getWsSyncFactoryClassName() {
        return this.wsSyncFactoryClassName;
    }

    public ProcessEngineConfigurationImpl setWsSyncFactoryClassName(String wsSyncFactoryClassName) {
        this.wsSyncFactoryClassName = wsSyncFactoryClassName;
        return this;
    }

    public Map<String, FormEngine> getFormEngines() {
        return this.formEngines;
    }

    public ProcessEngineConfigurationImpl setFormEngines(Map<String, FormEngine> formEngines) {
        this.formEngines = formEngines;
        return this;
    }

    public FormTypes getFormTypes() {
        return this.formTypes;
    }

    public ProcessEngineConfigurationImpl setFormTypes(FormTypes formTypes) {
        this.formTypes = formTypes;
        return this;
    }

    public ScriptingEngines getScriptingEngines() {
        return this.scriptingEngines;
    }

    public ProcessEngineConfigurationImpl setScriptingEngines(ScriptingEngines scriptingEngines) {
        this.scriptingEngines = scriptingEngines;
        return this;
    }

    public VariableSerializers getVariableSerializers() {
        return this.variableSerializers;
    }

    public VariableSerializerFactory getFallbackSerializerFactory() {
        return this.fallbackSerializerFactory;
    }

    public void setFallbackSerializerFactory(VariableSerializerFactory fallbackSerializerFactory) {
        this.fallbackSerializerFactory = fallbackSerializerFactory;
    }

    public ProcessEngineConfigurationImpl setVariableTypes(VariableSerializers variableSerializers) {
        this.variableSerializers = variableSerializers;
        return this;
    }

    public ExpressionManager getExpressionManager() {
        return this.expressionManager;
    }

    public ProcessEngineConfigurationImpl setExpressionManager(ExpressionManager expressionManager) {
        this.expressionManager = expressionManager;
        return this;
    }

    public BusinessCalendarManager getBusinessCalendarManager() {
        return this.businessCalendarManager;
    }

    public ProcessEngineConfigurationImpl setBusinessCalendarManager(BusinessCalendarManager businessCalendarManager) {
        this.businessCalendarManager = businessCalendarManager;
        return this;
    }

    public CommandContextFactory getCommandContextFactory() {
        return this.commandContextFactory;
    }

    public ProcessEngineConfigurationImpl setCommandContextFactory(CommandContextFactory commandContextFactory) {
        this.commandContextFactory = commandContextFactory;
        return this;
    }

    public TransactionContextFactory getTransactionContextFactory() {
        return this.transactionContextFactory;
    }

    public ProcessEngineConfigurationImpl setTransactionContextFactory(TransactionContextFactory transactionContextFactory) {
        this.transactionContextFactory = transactionContextFactory;
        return this;
    }

    public BpmnParseFactory getBpmnParseFactory() {
        return this.bpmnParseFactory;
    }

    public ProcessEngineConfigurationImpl setBpmnParseFactory(BpmnParseFactory bpmnParseFactory) {
        this.bpmnParseFactory = bpmnParseFactory;
        return this;
    }

    public List<Deployer> getCustomPreDeployers() {
        return this.customPreDeployers;
    }

    public ProcessEngineConfigurationImpl setCustomPreDeployers(List<Deployer> customPreDeployers) {
        this.customPreDeployers = customPreDeployers;
        return this;
    }

    public List<Deployer> getCustomPostDeployers() {
        return this.customPostDeployers;
    }

    public ProcessEngineConfigurationImpl setCustomPostDeployers(List<Deployer> customPostDeployers) {
        this.customPostDeployers = customPostDeployers;
        return this;
    }

    public void setCacheFactory(CacheFactory cacheFactory) {
        this.cacheFactory = cacheFactory;
    }

    public void setCacheCapacity(int cacheCapacity) {
        this.cacheCapacity = cacheCapacity;
    }

    public void setEnableFetchProcessDefinitionDescription(boolean enableFetchProcessDefinitionDescription) {
        this.enableFetchProcessDefinitionDescription = enableFetchProcessDefinitionDescription;
    }

    public boolean getEnableFetchProcessDefinitionDescription() {
        return this.enableFetchProcessDefinitionDescription;
    }

    public Permission getDefaultUserPermissionForTask() {
        return this.defaultUserPermissionForTask;
    }

    public ProcessEngineConfigurationImpl setDefaultUserPermissionForTask(Permission defaultUserPermissionForTask) {
        this.defaultUserPermissionForTask = defaultUserPermissionForTask;
        return this;
    }

    public ProcessEngineConfigurationImpl setEnableHistoricInstancePermissions(boolean enable) {
        this.enableHistoricInstancePermissions = enable;
        return this;
    }

    public boolean isEnableHistoricInstancePermissions() {
        return this.enableHistoricInstancePermissions;
    }

    public Map<String, JobHandler> getJobHandlers() {
        return this.jobHandlers;
    }

    public ProcessEngineConfigurationImpl setJobHandlers(Map<String, JobHandler> jobHandlers) {
        this.jobHandlers = jobHandlers;
        return this;
    }

    public SqlSessionFactory getSqlSessionFactory() {
        return this.sqlSessionFactory;
    }

    public ProcessEngineConfigurationImpl setSqlSessionFactory(SqlSessionFactory sqlSessionFactory) {
        this.sqlSessionFactory = sqlSessionFactory;
        return this;
    }

    public DbSqlSessionFactory getDbSqlSessionFactory() {
        return this.dbSqlSessionFactory;
    }

    public ProcessEngineConfigurationImpl setDbSqlSessionFactory(DbSqlSessionFactory dbSqlSessionFactory) {
        this.dbSqlSessionFactory = dbSqlSessionFactory;
        return this;
    }

    public TransactionFactory getTransactionFactory() {
        return this.transactionFactory;
    }

    public ProcessEngineConfigurationImpl setTransactionFactory(TransactionFactory transactionFactory) {
        this.transactionFactory = transactionFactory;
        return this;
    }

    public List<SessionFactory> getCustomSessionFactories() {
        return this.customSessionFactories;
    }

    public ProcessEngineConfigurationImpl setCustomSessionFactories(List<SessionFactory> customSessionFactories) {
        this.customSessionFactories = customSessionFactories;
        return this;
    }

    public List<JobHandler> getCustomJobHandlers() {
        return this.customJobHandlers;
    }

    public ProcessEngineConfigurationImpl setCustomJobHandlers(List<JobHandler> customJobHandlers) {
        this.customJobHandlers = customJobHandlers;
        return this;
    }

    public List<FormEngine> getCustomFormEngines() {
        return this.customFormEngines;
    }

    public ProcessEngineConfigurationImpl setCustomFormEngines(List<FormEngine> customFormEngines) {
        this.customFormEngines = customFormEngines;
        return this;
    }

    public List<AbstractFormFieldType> getCustomFormTypes() {
        return this.customFormTypes;
    }

    public ProcessEngineConfigurationImpl setCustomFormTypes(List<AbstractFormFieldType> customFormTypes) {
        this.customFormTypes = customFormTypes;
        return this;
    }

    public List<TypedValueSerializer> getCustomPreVariableSerializers() {
        return this.customPreVariableSerializers;
    }

    public ProcessEngineConfigurationImpl setCustomPreVariableSerializers(List<TypedValueSerializer> customPreVariableTypes) {
        this.customPreVariableSerializers = customPreVariableTypes;
        return this;
    }

    public List<TypedValueSerializer> getCustomPostVariableSerializers() {
        return this.customPostVariableSerializers;
    }

    public ProcessEngineConfigurationImpl setCustomPostVariableSerializers(List<TypedValueSerializer> customPostVariableTypes) {
        this.customPostVariableSerializers = customPostVariableTypes;
        return this;
    }

    public List<BpmnParseListener> getCustomPreBPMNParseListeners() {
        return this.preParseListeners;
    }

    public void setCustomPreBPMNParseListeners(List<BpmnParseListener> preParseListeners) {
        this.preParseListeners = preParseListeners;
    }

    public List<BpmnParseListener> getCustomPostBPMNParseListeners() {
        return this.postParseListeners;
    }

    public void setCustomPostBPMNParseListeners(List<BpmnParseListener> postParseListeners) {
        this.postParseListeners = postParseListeners;
    }

    @Deprecated
    public List<BpmnParseListener> getPreParseListeners() {
        return this.preParseListeners;
    }

    @Deprecated
    public void setPreParseListeners(List<BpmnParseListener> preParseListeners) {
        this.preParseListeners = preParseListeners;
    }

    @Deprecated
    public List<BpmnParseListener> getPostParseListeners() {
        return this.postParseListeners;
    }

    @Deprecated
    public void setPostParseListeners(List<BpmnParseListener> postParseListeners) {
        this.postParseListeners = postParseListeners;
    }

    public List<CmmnTransformListener> getCustomPreCmmnTransformListeners() {
        return this.customPreCmmnTransformListeners;
    }

    public void setCustomPreCmmnTransformListeners(List<CmmnTransformListener> customPreCmmnTransformListeners) {
        this.customPreCmmnTransformListeners = customPreCmmnTransformListeners;
    }

    public List<CmmnTransformListener> getCustomPostCmmnTransformListeners() {
        return this.customPostCmmnTransformListeners;
    }

    public void setCustomPostCmmnTransformListeners(List<CmmnTransformListener> customPostCmmnTransformListeners) {
        this.customPostCmmnTransformListeners = customPostCmmnTransformListeners;
    }

    public Map<Object, Object> getBeans() {
        return this.beans;
    }

    public void setBeans(Map<Object, Object> beans) {
        this.beans = beans;
    }

    @Override
    public ProcessEngineConfigurationImpl setClassLoader(ClassLoader classLoader) {
        super.setClassLoader(classLoader);
        return this;
    }

    @Override
    public ProcessEngineConfigurationImpl setDatabaseType(String databaseType) {
        super.setDatabaseType(databaseType);
        return this;
    }

    @Override
    public ProcessEngineConfigurationImpl setDataSource(DataSource dataSource) {
        super.setDataSource(dataSource);
        return this;
    }

    @Override
    public ProcessEngineConfigurationImpl setDatabaseSchemaUpdate(String databaseSchemaUpdate) {
        super.setDatabaseSchemaUpdate(databaseSchemaUpdate);
        return this;
    }

    @Override
    public ProcessEngineConfigurationImpl setHistory(String history) {
        super.setHistory(history);
        return this;
    }

    @Override
    public ProcessEngineConfigurationImpl setIdBlockSize(int idBlockSize) {
        super.setIdBlockSize(idBlockSize);
        return this;
    }

    @Override
    public ProcessEngineConfigurationImpl setJdbcDriver(String jdbcDriver) {
        super.setJdbcDriver(jdbcDriver);
        return this;
    }

    @Override
    public ProcessEngineConfigurationImpl setJdbcPassword(String jdbcPassword) {
        super.setJdbcPassword(jdbcPassword);
        return this;
    }

    @Override
    public ProcessEngineConfigurationImpl setJdbcUrl(String jdbcUrl) {
        super.setJdbcUrl(jdbcUrl);
        return this;
    }

    @Override
    public ProcessEngineConfigurationImpl setJdbcUsername(String jdbcUsername) {
        super.setJdbcUsername(jdbcUsername);
        return this;
    }

    @Override
    public ProcessEngineConfigurationImpl setJobExecutorActivate(boolean jobExecutorActivate) {
        super.setJobExecutorActivate(jobExecutorActivate);
        return this;
    }

    @Override
    public ProcessEngineConfigurationImpl setMailServerDefaultFrom(String mailServerDefaultFrom) {
        super.setMailServerDefaultFrom(mailServerDefaultFrom);
        return this;
    }

    @Override
    public ProcessEngineConfigurationImpl setMailServerHost(String mailServerHost) {
        super.setMailServerHost(mailServerHost);
        return this;
    }

    @Override
    public ProcessEngineConfigurationImpl setMailServerPassword(String mailServerPassword) {
        super.setMailServerPassword(mailServerPassword);
        return this;
    }

    @Override
    public ProcessEngineConfigurationImpl setMailServerPort(int mailServerPort) {
        super.setMailServerPort(mailServerPort);
        return this;
    }

    @Override
    public ProcessEngineConfigurationImpl setMailServerUseTLS(boolean useTLS) {
        super.setMailServerUseTLS(useTLS);
        return this;
    }

    @Override
    public ProcessEngineConfigurationImpl setMailServerUsername(String mailServerUsername) {
        super.setMailServerUsername(mailServerUsername);
        return this;
    }

    @Override
    public ProcessEngineConfigurationImpl setJdbcMaxActiveConnections(int jdbcMaxActiveConnections) {
        super.setJdbcMaxActiveConnections(jdbcMaxActiveConnections);
        return this;
    }

    @Override
    public ProcessEngineConfigurationImpl setJdbcMaxCheckoutTime(int jdbcMaxCheckoutTime) {
        super.setJdbcMaxCheckoutTime(jdbcMaxCheckoutTime);
        return this;
    }

    @Override
    public ProcessEngineConfigurationImpl setJdbcMaxIdleConnections(int jdbcMaxIdleConnections) {
        super.setJdbcMaxIdleConnections(jdbcMaxIdleConnections);
        return this;
    }

    @Override
    public ProcessEngineConfigurationImpl setJdbcMaxWaitTime(int jdbcMaxWaitTime) {
        super.setJdbcMaxWaitTime(jdbcMaxWaitTime);
        return this;
    }

    @Override
    public ProcessEngineConfigurationImpl setTransactionsExternallyManaged(boolean transactionsExternallyManaged) {
        super.setTransactionsExternallyManaged(transactionsExternallyManaged);
        return this;
    }

    @Override
    public ProcessEngineConfigurationImpl setJpaEntityManagerFactory(Object jpaEntityManagerFactory) {
        this.jpaEntityManagerFactory = jpaEntityManagerFactory;
        return this;
    }

    @Override
    public ProcessEngineConfigurationImpl setJpaHandleTransaction(boolean jpaHandleTransaction) {
        this.jpaHandleTransaction = jpaHandleTransaction;
        return this;
    }

    @Override
    public ProcessEngineConfigurationImpl setJpaCloseEntityManager(boolean jpaCloseEntityManager) {
        this.jpaCloseEntityManager = jpaCloseEntityManager;
        return this;
    }

    @Override
    public ProcessEngineConfigurationImpl setJdbcPingEnabled(boolean jdbcPingEnabled) {
        this.jdbcPingEnabled = jdbcPingEnabled;
        return this;
    }

    @Override
    public ProcessEngineConfigurationImpl setJdbcPingQuery(String jdbcPingQuery) {
        this.jdbcPingQuery = jdbcPingQuery;
        return this;
    }

    @Override
    public ProcessEngineConfigurationImpl setJdbcPingConnectionNotUsedFor(int jdbcPingNotUsedFor) {
        this.jdbcPingConnectionNotUsedFor = jdbcPingNotUsedFor;
        return this;
    }

    public boolean isDbIdentityUsed() {
        return this.isDbIdentityUsed;
    }

    public void setDbIdentityUsed(boolean isDbIdentityUsed) {
        this.isDbIdentityUsed = isDbIdentityUsed;
    }

    public boolean isDbHistoryUsed() {
        return this.isDbHistoryUsed;
    }

    public void setDbHistoryUsed(boolean isDbHistoryUsed) {
        this.isDbHistoryUsed = isDbHistoryUsed;
    }

    public List<ResolverFactory> getResolverFactories() {
        return this.resolverFactories;
    }

    public void setResolverFactories(List<ResolverFactory> resolverFactories) {
        this.resolverFactories = resolverFactories;
    }

    public DeploymentCache getDeploymentCache() {
        return this.deploymentCache;
    }

    public void setDeploymentCache(DeploymentCache deploymentCache) {
        this.deploymentCache = deploymentCache;
    }

    public DeploymentHandlerFactory getDeploymentHandlerFactory() {
        return this.deploymentHandlerFactory;
    }

    public ProcessEngineConfigurationImpl setDeploymentHandlerFactory(DeploymentHandlerFactory deploymentHandlerFactory) {
        this.deploymentHandlerFactory = deploymentHandlerFactory;
        return this;
    }

    public ProcessEngineConfigurationImpl setDelegateInterceptor(DelegateInterceptor delegateInterceptor) {
        this.delegateInterceptor = delegateInterceptor;
        return this;
    }

    public DelegateInterceptor getDelegateInterceptor() {
        return this.delegateInterceptor;
    }

    public RejectedJobsHandler getCustomRejectedJobsHandler() {
        return this.customRejectedJobsHandler;
    }

    public ProcessEngineConfigurationImpl setCustomRejectedJobsHandler(RejectedJobsHandler customRejectedJobsHandler) {
        this.customRejectedJobsHandler = customRejectedJobsHandler;
        return this;
    }

    public EventHandler getEventHandler(String eventType) {
        return this.eventHandlers.get(eventType);
    }

    public void setEventHandlers(Map<String, EventHandler> eventHandlers) {
        this.eventHandlers = eventHandlers;
    }

    public Map<String, EventHandler> getEventHandlers() {
        return this.eventHandlers;
    }

    public List<EventHandler> getCustomEventHandlers() {
        return this.customEventHandlers;
    }

    public void setCustomEventHandlers(List<EventHandler> customEventHandlers) {
        this.customEventHandlers = customEventHandlers;
    }

    public FailedJobCommandFactory getFailedJobCommandFactory() {
        return this.failedJobCommandFactory;
    }

    public ProcessEngineConfigurationImpl setFailedJobCommandFactory(FailedJobCommandFactory failedJobCommandFactory) {
        this.failedJobCommandFactory = failedJobCommandFactory;
        return this;
    }

    public ProcessEngineConfiguration setDatabaseTablePrefix(String databaseTablePrefix) {
        this.databaseTablePrefix = databaseTablePrefix;
        return this;
    }

    public String getDatabaseTablePrefix() {
        return this.databaseTablePrefix;
    }

    public boolean isCreateDiagramOnDeploy() {
        return this.isCreateDiagramOnDeploy;
    }

    public ProcessEngineConfiguration setCreateDiagramOnDeploy(boolean createDiagramOnDeploy) {
        this.isCreateDiagramOnDeploy = createDiagramOnDeploy;
        return this;
    }

    public String getDatabaseSchema() {
        return this.databaseSchema;
    }

    public void setDatabaseSchema(String databaseSchema) {
        this.databaseSchema = databaseSchema;
    }

    public DataSource getIdGeneratorDataSource() {
        return this.idGeneratorDataSource;
    }

    public void setIdGeneratorDataSource(DataSource idGeneratorDataSource) {
        this.idGeneratorDataSource = idGeneratorDataSource;
    }

    public String getIdGeneratorDataSourceJndiName() {
        return this.idGeneratorDataSourceJndiName;
    }

    public void setIdGeneratorDataSourceJndiName(String idGeneratorDataSourceJndiName) {
        this.idGeneratorDataSourceJndiName = idGeneratorDataSourceJndiName;
    }

    public ProcessApplicationManager getProcessApplicationManager() {
        return this.processApplicationManager;
    }

    public void setProcessApplicationManager(ProcessApplicationManager processApplicationManager) {
        this.processApplicationManager = processApplicationManager;
    }

    public CommandExecutor getCommandExecutorSchemaOperations() {
        return this.commandExecutorSchemaOperations;
    }

    public void setCommandExecutorSchemaOperations(CommandExecutor commandExecutorSchemaOperations) {
        this.commandExecutorSchemaOperations = commandExecutorSchemaOperations;
    }

    public CorrelationHandler getCorrelationHandler() {
        return this.correlationHandler;
    }

    public void setCorrelationHandler(CorrelationHandler correlationHandler) {
        this.correlationHandler = correlationHandler;
    }

    public ConditionHandler getConditionHandler() {
        return this.conditionHandler;
    }

    public void setConditionHandler(ConditionHandler conditionHandler) {
        this.conditionHandler = conditionHandler;
    }

    public ProcessEngineConfigurationImpl setHistoryEventHandler(HistoryEventHandler historyEventHandler) {
        this.historyEventHandler = historyEventHandler;
        return this;
    }

    public HistoryEventHandler getHistoryEventHandler() {
        return this.historyEventHandler;
    }

    public boolean isEnableDefaultDbHistoryEventHandler() {
        return this.enableDefaultDbHistoryEventHandler;
    }

    public void setEnableDefaultDbHistoryEventHandler(boolean enableDefaultDbHistoryEventHandler) {
        this.enableDefaultDbHistoryEventHandler = enableDefaultDbHistoryEventHandler;
    }

    public List<HistoryEventHandler> getCustomHistoryEventHandlers() {
        return this.customHistoryEventHandlers;
    }

    public void setCustomHistoryEventHandlers(List<HistoryEventHandler> customHistoryEventHandlers) {
        this.customHistoryEventHandlers = customHistoryEventHandlers;
    }

    public IncidentHandler getIncidentHandler(String incidentType) {
        return this.incidentHandlers.get(incidentType);
    }

    public void addIncidentHandler(IncidentHandler incidentHandler) {
        IncidentHandler existsHandler = this.incidentHandlers.get(incidentHandler.getIncidentHandlerType());
        if (existsHandler instanceof CompositeIncidentHandler) {
            ((CompositeIncidentHandler)existsHandler).add(incidentHandler);
        } else {
            this.incidentHandlers.put(incidentHandler.getIncidentHandlerType(), incidentHandler);
        }
    }

    public Map<String, IncidentHandler> getIncidentHandlers() {
        return this.incidentHandlers;
    }

    public void setIncidentHandlers(Map<String, IncidentHandler> incidentHandlers) {
        this.incidentHandlers = incidentHandlers;
    }

    public List<IncidentHandler> getCustomIncidentHandlers() {
        return this.customIncidentHandlers;
    }

    public void setCustomIncidentHandlers(List<IncidentHandler> customIncidentHandlers) {
        this.customIncidentHandlers = customIncidentHandlers;
    }

    public Map<String, BatchJobHandler<?>> getBatchHandlers() {
        return this.batchHandlers;
    }

    public void setBatchHandlers(Map<String, BatchJobHandler<?>> batchHandlers) {
        this.batchHandlers = batchHandlers;
    }

    public List<BatchJobHandler<?>> getCustomBatchJobHandlers() {
        return this.customBatchJobHandlers;
    }

    public void setCustomBatchJobHandlers(List<BatchJobHandler<?>> customBatchJobHandlers) {
        this.customBatchJobHandlers = customBatchJobHandlers;
    }

    public int getBatchJobsPerSeed() {
        return this.batchJobsPerSeed;
    }

    public void setBatchJobsPerSeed(int batchJobsPerSeed) {
        this.batchJobsPerSeed = batchJobsPerSeed;
    }

    public Map<String, Integer> getInvocationsPerBatchJobByBatchType() {
        return this.invocationsPerBatchJobByBatchType;
    }

    public ProcessEngineConfigurationImpl setInvocationsPerBatchJobByBatchType(Map<String, Integer> invocationsPerBatchJobByBatchType) {
        this.invocationsPerBatchJobByBatchType = invocationsPerBatchJobByBatchType;
        return this;
    }

    public int getInvocationsPerBatchJob() {
        return this.invocationsPerBatchJob;
    }

    public void setInvocationsPerBatchJob(int invocationsPerBatchJob) {
        this.invocationsPerBatchJob = invocationsPerBatchJob;
    }

    public int getBatchPollTime() {
        return this.batchPollTime;
    }

    public void setBatchPollTime(int batchPollTime) {
        this.batchPollTime = batchPollTime;
    }

    public long getBatchJobPriority() {
        return this.batchJobPriority;
    }

    public void setBatchJobPriority(long batchJobPriority) {
        this.batchJobPriority = batchJobPriority;
    }

    public long getHistoryCleanupJobPriority() {
        return this.historyCleanupJobPriority;
    }

    public ProcessEngineConfigurationImpl setHistoryCleanupJobPriority(long historyCleanupJobPriority) {
        this.historyCleanupJobPriority = historyCleanupJobPriority;
        return this;
    }

    public SessionFactory getIdentityProviderSessionFactory() {
        return this.identityProviderSessionFactory;
    }

    public void setIdentityProviderSessionFactory(SessionFactory identityProviderSessionFactory) {
        this.identityProviderSessionFactory = identityProviderSessionFactory;
    }

    public SaltGenerator getSaltGenerator() {
        return this.saltGenerator;
    }

    public void setSaltGenerator(SaltGenerator saltGenerator) {
        this.saltGenerator = saltGenerator;
    }

    public void setPasswordEncryptor(PasswordEncryptor passwordEncryptor) {
        this.passwordEncryptor = passwordEncryptor;
    }

    public PasswordEncryptor getPasswordEncryptor() {
        return this.passwordEncryptor;
    }

    public List<PasswordEncryptor> getCustomPasswordChecker() {
        return this.customPasswordChecker;
    }

    public void setCustomPasswordChecker(List<PasswordEncryptor> customPasswordChecker) {
        this.customPasswordChecker = customPasswordChecker;
    }

    public PasswordManager getPasswordManager() {
        return this.passwordManager;
    }

    public void setPasswordManager(PasswordManager passwordManager) {
        this.passwordManager = passwordManager;
    }

    public Set<String> getRegisteredDeployments() {
        return this.registeredDeployments;
    }

    public void setRegisteredDeployments(Set<String> registeredDeployments) {
        this.registeredDeployments = registeredDeployments;
    }

    public ResourceAuthorizationProvider getResourceAuthorizationProvider() {
        return this.resourceAuthorizationProvider;
    }

    public void setResourceAuthorizationProvider(ResourceAuthorizationProvider resourceAuthorizationProvider) {
        this.resourceAuthorizationProvider = resourceAuthorizationProvider;
    }

    public PermissionProvider getPermissionProvider() {
        return this.permissionProvider;
    }

    public void setPermissionProvider(PermissionProvider permissionProvider) {
        this.permissionProvider = permissionProvider;
    }

    public List<ProcessEnginePlugin> getProcessEnginePlugins() {
        return this.processEnginePlugins;
    }

    public void setProcessEnginePlugins(List<ProcessEnginePlugin> processEnginePlugins) {
        this.processEnginePlugins = processEnginePlugins;
    }

    public ProcessEngineConfigurationImpl setHistoryEventProducer(HistoryEventProducer historyEventProducer) {
        this.historyEventProducer = historyEventProducer;
        return this;
    }

    public HistoryEventProducer getHistoryEventProducer() {
        return this.historyEventProducer;
    }

    public ProcessEngineConfigurationImpl setCmmnHistoryEventProducer(CmmnHistoryEventProducer cmmnHistoryEventProducer) {
        this.cmmnHistoryEventProducer = cmmnHistoryEventProducer;
        return this;
    }

    public CmmnHistoryEventProducer getCmmnHistoryEventProducer() {
        return this.cmmnHistoryEventProducer;
    }

    public ProcessEngineConfigurationImpl setDmnHistoryEventProducer(DmnHistoryEventProducer dmnHistoryEventProducer) {
        this.dmnHistoryEventProducer = dmnHistoryEventProducer;
        return this;
    }

    public DmnHistoryEventProducer getDmnHistoryEventProducer() {
        return this.dmnHistoryEventProducer;
    }

    public Map<String, Class<? extends FormFieldValidator>> getCustomFormFieldValidators() {
        return this.customFormFieldValidators;
    }

    public void setCustomFormFieldValidators(Map<String, Class<? extends FormFieldValidator>> customFormFieldValidators) {
        this.customFormFieldValidators = customFormFieldValidators;
    }

    public void setFormValidators(FormValidators formValidators) {
        this.formValidators = formValidators;
    }

    public FormValidators getFormValidators() {
        return this.formValidators;
    }

    public ProcessEngineConfigurationImpl setDisableStrictCamundaFormParsing(boolean disableStrictCamundaFormParsing) {
        this.disableStrictCamundaFormParsing = disableStrictCamundaFormParsing;
        return this;
    }

    public boolean isDisableStrictCamundaFormParsing() {
        return this.disableStrictCamundaFormParsing;
    }

    public boolean isExecutionTreePrefetchEnabled() {
        return this.isExecutionTreePrefetchEnabled;
    }

    public void setExecutionTreePrefetchEnabled(boolean isExecutionTreePrefetchingEnabled) {
        this.isExecutionTreePrefetchEnabled = isExecutionTreePrefetchingEnabled;
    }

    public ProcessEngineImpl getProcessEngine() {
        return this.processEngine;
    }

    public void setAutoStoreScriptVariables(boolean autoStoreScriptVariables) {
        this.autoStoreScriptVariables = autoStoreScriptVariables;
    }

    public boolean isAutoStoreScriptVariables() {
        return this.autoStoreScriptVariables;
    }

    public void setEnableScriptCompilation(boolean enableScriptCompilation) {
        this.enableScriptCompilation = enableScriptCompilation;
    }

    public boolean isEnableScriptCompilation() {
        return this.enableScriptCompilation;
    }

    public boolean isEnableGracefulDegradationOnContextSwitchFailure() {
        return this.enableGracefulDegradationOnContextSwitchFailure;
    }

    public void setEnableGracefulDegradationOnContextSwitchFailure(boolean enableGracefulDegradationOnContextSwitchFailure) {
        this.enableGracefulDegradationOnContextSwitchFailure = enableGracefulDegradationOnContextSwitchFailure;
    }

    public boolean isDeploymentLockUsed() {
        return this.isDeploymentLockUsed;
    }

    public void setDeploymentLockUsed(boolean isDeploymentLockUsed) {
        this.isDeploymentLockUsed = isDeploymentLockUsed;
    }

    public boolean isDeploymentSynchronized() {
        return this.isDeploymentSynchronized;
    }

    public void setDeploymentSynchronized(boolean deploymentSynchronized) {
        this.isDeploymentSynchronized = deploymentSynchronized;
    }

    public boolean isCmmnEnabled() {
        return this.cmmnEnabled;
    }

    public void setCmmnEnabled(boolean cmmnEnabled) {
        this.cmmnEnabled = cmmnEnabled;
    }

    public boolean isDmnEnabled() {
        return this.dmnEnabled;
    }

    public void setDmnEnabled(boolean dmnEnabled) {
        this.dmnEnabled = dmnEnabled;
    }

    public boolean isStandaloneTasksEnabled() {
        return this.standaloneTasksEnabled;
    }

    public ProcessEngineConfigurationImpl setStandaloneTasksEnabled(boolean standaloneTasksEnabled) {
        this.standaloneTasksEnabled = standaloneTasksEnabled;
        return this;
    }

    public boolean isCompositeIncidentHandlersEnabled() {
        return this.isCompositeIncidentHandlersEnabled;
    }

    public ProcessEngineConfigurationImpl setCompositeIncidentHandlersEnabled(boolean compositeIncidentHandlersEnabled) {
        this.isCompositeIncidentHandlersEnabled = compositeIncidentHandlersEnabled;
        return this;
    }

    public ScriptFactory getScriptFactory() {
        return this.scriptFactory;
    }

    public ScriptingEnvironment getScriptingEnvironment() {
        return this.scriptingEnvironment;
    }

    public void setScriptFactory(ScriptFactory scriptFactory) {
        this.scriptFactory = scriptFactory;
    }

    public ScriptEngineResolver getScriptEngineResolver() {
        return this.scriptEngineResolver;
    }

    public ProcessEngineConfigurationImpl setScriptEngineResolver(ScriptEngineResolver scriptEngineResolver) {
        this.scriptEngineResolver = scriptEngineResolver;
        if (this.scriptingEngines != null) {
            this.scriptingEngines.setScriptEngineResolver(scriptEngineResolver);
        }
        return this;
    }

    public void setScriptingEnvironment(ScriptingEnvironment scriptingEnvironment) {
        this.scriptingEnvironment = scriptingEnvironment;
    }

    public List<ScriptEnvResolver> getEnvScriptResolvers() {
        return this.scriptEnvResolvers;
    }

    public void setEnvScriptResolvers(List<ScriptEnvResolver> scriptEnvResolvers) {
        this.scriptEnvResolvers = scriptEnvResolvers;
    }

    public String getScriptEngineNameJavaScript() {
        return this.scriptEngineNameJavaScript;
    }

    public ProcessEngineConfigurationImpl setScriptEngineNameJavaScript(String scriptEngineNameJavaScript) {
        this.scriptEngineNameJavaScript = scriptEngineNameJavaScript;
        return this;
    }

    public ProcessEngineConfiguration setArtifactFactory(ArtifactFactory artifactFactory) {
        this.artifactFactory = artifactFactory;
        return this;
    }

    public ArtifactFactory getArtifactFactory() {
        return this.artifactFactory;
    }

    public String getDefaultSerializationFormat() {
        return this.defaultSerializationFormat;
    }

    public ProcessEngineConfigurationImpl setDefaultSerializationFormat(String defaultSerializationFormat) {
        this.defaultSerializationFormat = defaultSerializationFormat;
        return this;
    }

    public boolean isJavaSerializationFormatEnabled() {
        return this.javaSerializationFormatEnabled;
    }

    public void setJavaSerializationFormatEnabled(boolean javaSerializationFormatEnabled) {
        this.javaSerializationFormatEnabled = javaSerializationFormatEnabled;
    }

    public ProcessEngineConfigurationImpl setDefaultCharsetName(String defaultCharsetName) {
        this.defaultCharsetName = defaultCharsetName;
        return this;
    }

    public ProcessEngineConfigurationImpl setDefaultCharset(Charset defautlCharset) {
        this.defaultCharset = defautlCharset;
        return this;
    }

    public Charset getDefaultCharset() {
        return this.defaultCharset;
    }

    public boolean isDbEntityCacheReuseEnabled() {
        return this.isDbEntityCacheReuseEnabled;
    }

    public ProcessEngineConfigurationImpl setDbEntityCacheReuseEnabled(boolean isDbEntityCacheReuseEnabled) {
        this.isDbEntityCacheReuseEnabled = isDbEntityCacheReuseEnabled;
        return this;
    }

    public DbEntityCacheKeyMapping getDbEntityCacheKeyMapping() {
        return this.dbEntityCacheKeyMapping;
    }

    public ProcessEngineConfigurationImpl setDbEntityCacheKeyMapping(DbEntityCacheKeyMapping dbEntityCacheKeyMapping) {
        this.dbEntityCacheKeyMapping = dbEntityCacheKeyMapping;
        return this;
    }

    public ProcessEngineConfigurationImpl setCustomHistoryLevels(List<HistoryLevel> customHistoryLevels) {
        this.customHistoryLevels = customHistoryLevels;
        return this;
    }

    public List<HistoryLevel> getHistoryLevels() {
        return this.historyLevels;
    }

    public List<HistoryLevel> getCustomHistoryLevels() {
        return this.customHistoryLevels;
    }

    public boolean isInvokeCustomVariableListeners() {
        return this.isInvokeCustomVariableListeners;
    }

    public ProcessEngineConfigurationImpl setInvokeCustomVariableListeners(boolean isInvokeCustomVariableListeners) {
        this.isInvokeCustomVariableListeners = isInvokeCustomVariableListeners;
        return this;
    }

    public void close() {
        if (this.forceCloseMybatisConnectionPool && this.dataSource instanceof PooledDataSource) {
            ((PooledDataSource)this.dataSource).forceCloseAll();
        }
    }

    public MetricsRegistry getMetricsRegistry() {
        return this.metricsRegistry;
    }

    public ProcessEngineConfigurationImpl setMetricsRegistry(MetricsRegistry metricsRegistry) {
        this.metricsRegistry = metricsRegistry;
        return this;
    }

    public ProcessEngineConfigurationImpl setMetricsEnabled(boolean isMetricsEnabled) {
        this.isMetricsEnabled = isMetricsEnabled;
        return this;
    }

    public boolean isMetricsEnabled() {
        return this.isMetricsEnabled;
    }

    public DbMetricsReporter getDbMetricsReporter() {
        return this.dbMetricsReporter;
    }

    public ProcessEngineConfigurationImpl setDbMetricsReporter(DbMetricsReporter dbMetricsReporter) {
        this.dbMetricsReporter = dbMetricsReporter;
        return this;
    }

    public boolean isDbMetricsReporterActivate() {
        return this.isDbMetricsReporterActivate;
    }

    public ProcessEngineConfigurationImpl setDbMetricsReporterActivate(boolean isDbMetricsReporterEnabled) {
        this.isDbMetricsReporterActivate = isDbMetricsReporterEnabled;
        return this;
    }

    @Deprecated
    public MetricsReporterIdProvider getMetricsReporterIdProvider() {
        return this.metricsReporterIdProvider;
    }

    @Deprecated
    public ProcessEngineConfigurationImpl setMetricsReporterIdProvider(MetricsReporterIdProvider metricsReporterIdProvider) {
        this.metricsReporterIdProvider = metricsReporterIdProvider;
        return this;
    }

    public String getHostname() {
        return this.hostname;
    }

    public ProcessEngineConfigurationImpl setHostname(String hostname) {
        this.hostname = hostname;
        return this;
    }

    public HostnameProvider getHostnameProvider() {
        return this.hostnameProvider;
    }

    public ProcessEngineConfigurationImpl setHostnameProvider(HostnameProvider hostnameProvider) {
        this.hostnameProvider = hostnameProvider;
        return this;
    }

    public boolean isTaskMetricsEnabled() {
        return this.isTaskMetricsEnabled;
    }

    public ProcessEngineConfigurationImpl setTaskMetricsEnabled(boolean isTaskMetricsEnabled) {
        this.isTaskMetricsEnabled = isTaskMetricsEnabled;
        return this;
    }

    public boolean isEnableScriptEngineCaching() {
        return this.enableScriptEngineCaching;
    }

    public ProcessEngineConfigurationImpl setEnableScriptEngineCaching(boolean enableScriptEngineCaching) {
        this.enableScriptEngineCaching = enableScriptEngineCaching;
        return this;
    }

    public boolean isEnableFetchScriptEngineFromProcessApplication() {
        return this.enableFetchScriptEngineFromProcessApplication;
    }

    public ProcessEngineConfigurationImpl setEnableFetchScriptEngineFromProcessApplication(boolean enable) {
        this.enableFetchScriptEngineFromProcessApplication = enable;
        return this;
    }

    public boolean isEnableScriptEngineLoadExternalResources() {
        return this.enableScriptEngineLoadExternalResources;
    }

    public ProcessEngineConfigurationImpl setEnableScriptEngineLoadExternalResources(boolean enableScriptEngineLoadExternalResources) {
        this.enableScriptEngineLoadExternalResources = enableScriptEngineLoadExternalResources;
        return this;
    }

    public boolean isEnableScriptEngineNashornCompatibility() {
        return this.enableScriptEngineNashornCompatibility;
    }

    public ProcessEngineConfigurationImpl setEnableScriptEngineNashornCompatibility(boolean enableScriptEngineNashornCompatibility) {
        this.enableScriptEngineNashornCompatibility = enableScriptEngineNashornCompatibility;
        return this;
    }

    public boolean isConfigureScriptEngineHostAccess() {
        return this.configureScriptEngineHostAccess;
    }

    public ProcessEngineConfigurationImpl setConfigureScriptEngineHostAccess(boolean configureScriptEngineHostAccess) {
        this.configureScriptEngineHostAccess = configureScriptEngineHostAccess;
        return this;
    }

    public boolean isEnableExpressionsInAdhocQueries() {
        return this.enableExpressionsInAdhocQueries;
    }

    public void setEnableExpressionsInAdhocQueries(boolean enableExpressionsInAdhocQueries) {
        this.enableExpressionsInAdhocQueries = enableExpressionsInAdhocQueries;
    }

    public boolean isEnableExpressionsInStoredQueries() {
        return this.enableExpressionsInStoredQueries;
    }

    public void setEnableExpressionsInStoredQueries(boolean enableExpressionsInStoredQueries) {
        this.enableExpressionsInStoredQueries = enableExpressionsInStoredQueries;
    }

    public boolean isEnableXxeProcessing() {
        return this.enableXxeProcessing;
    }

    public void setEnableXxeProcessing(boolean enableXxeProcessing) {
        this.enableXxeProcessing = enableXxeProcessing;
    }

    public ProcessEngineConfigurationImpl setBpmnStacktraceVerbose(boolean isBpmnStacktraceVerbose) {
        this.isBpmnStacktraceVerbose = isBpmnStacktraceVerbose;
        return this;
    }

    public boolean isBpmnStacktraceVerbose() {
        return this.isBpmnStacktraceVerbose;
    }

    public boolean isForceCloseMybatisConnectionPool() {
        return this.forceCloseMybatisConnectionPool;
    }

    public ProcessEngineConfigurationImpl setForceCloseMybatisConnectionPool(boolean forceCloseMybatisConnectionPool) {
        this.forceCloseMybatisConnectionPool = forceCloseMybatisConnectionPool;
        return this;
    }

    public boolean isRestrictUserOperationLogToAuthenticatedUsers() {
        return this.restrictUserOperationLogToAuthenticatedUsers;
    }

    public ProcessEngineConfigurationImpl setRestrictUserOperationLogToAuthenticatedUsers(boolean restrictUserOperationLogToAuthenticatedUsers) {
        this.restrictUserOperationLogToAuthenticatedUsers = restrictUserOperationLogToAuthenticatedUsers;
        return this;
    }

    public ProcessEngineConfigurationImpl setTenantIdProvider(TenantIdProvider tenantIdProvider) {
        this.tenantIdProvider = tenantIdProvider;
        return this;
    }

    public TenantIdProvider getTenantIdProvider() {
        return this.tenantIdProvider;
    }

    public void setMigrationActivityMatcher(MigrationActivityMatcher migrationActivityMatcher) {
        this.migrationActivityMatcher = migrationActivityMatcher;
    }

    public MigrationActivityMatcher getMigrationActivityMatcher() {
        return this.migrationActivityMatcher;
    }

    public void setCustomPreMigrationActivityValidators(List<MigrationActivityValidator> customPreMigrationActivityValidators) {
        this.customPreMigrationActivityValidators = customPreMigrationActivityValidators;
    }

    public List<MigrationActivityValidator> getCustomPreMigrationActivityValidators() {
        return this.customPreMigrationActivityValidators;
    }

    public void setCustomPostMigrationActivityValidators(List<MigrationActivityValidator> customPostMigrationActivityValidators) {
        this.customPostMigrationActivityValidators = customPostMigrationActivityValidators;
    }

    public List<MigrationActivityValidator> getCustomPostMigrationActivityValidators() {
        return this.customPostMigrationActivityValidators;
    }

    public List<MigrationActivityValidator> getDefaultMigrationActivityValidators() {
        ArrayList<MigrationActivityValidator> migrationActivityValidators = new ArrayList<MigrationActivityValidator>();
        migrationActivityValidators.add(SupportedActivityValidator.INSTANCE);
        migrationActivityValidators.add(SupportedPassiveEventTriggerActivityValidator.INSTANCE);
        migrationActivityValidators.add(NoCompensationHandlerActivityValidator.INSTANCE);
        return migrationActivityValidators;
    }

    public void setMigrationInstructionGenerator(MigrationInstructionGenerator migrationInstructionGenerator) {
        this.migrationInstructionGenerator = migrationInstructionGenerator;
    }

    public MigrationInstructionGenerator getMigrationInstructionGenerator() {
        return this.migrationInstructionGenerator;
    }

    public void setMigrationInstructionValidators(List<MigrationInstructionValidator> migrationInstructionValidators) {
        this.migrationInstructionValidators = migrationInstructionValidators;
    }

    public List<MigrationInstructionValidator> getMigrationInstructionValidators() {
        return this.migrationInstructionValidators;
    }

    public void setCustomPostMigrationInstructionValidators(List<MigrationInstructionValidator> customPostMigrationInstructionValidators) {
        this.customPostMigrationInstructionValidators = customPostMigrationInstructionValidators;
    }

    public List<MigrationInstructionValidator> getCustomPostMigrationInstructionValidators() {
        return this.customPostMigrationInstructionValidators;
    }

    public void setCustomPreMigrationInstructionValidators(List<MigrationInstructionValidator> customPreMigrationInstructionValidators) {
        this.customPreMigrationInstructionValidators = customPreMigrationInstructionValidators;
    }

    public List<MigrationInstructionValidator> getCustomPreMigrationInstructionValidators() {
        return this.customPreMigrationInstructionValidators;
    }

    public List<MigrationInstructionValidator> getDefaultMigrationInstructionValidators() {
        ArrayList<MigrationInstructionValidator> migrationInstructionValidators = new ArrayList<MigrationInstructionValidator>();
        migrationInstructionValidators.add(new SameBehaviorInstructionValidator());
        migrationInstructionValidators.add(new SameEventTypeValidator());
        migrationInstructionValidators.add(new OnlyOnceMappedActivityInstructionValidator());
        migrationInstructionValidators.add(new CannotAddMultiInstanceBodyValidator());
        migrationInstructionValidators.add(new CannotAddMultiInstanceInnerActivityValidator());
        migrationInstructionValidators.add(new CannotRemoveMultiInstanceInnerActivityValidator());
        migrationInstructionValidators.add(new GatewayMappingValidator());
        migrationInstructionValidators.add(new SameEventScopeInstructionValidator());
        migrationInstructionValidators.add(new UpdateEventTriggersValidator());
        migrationInstructionValidators.add(new AdditionalFlowScopeInstructionValidator());
        migrationInstructionValidators.add(new ConditionalEventUpdateEventTriggerValidator());
        return migrationInstructionValidators;
    }

    public void setMigratingActivityInstanceValidators(List<MigratingActivityInstanceValidator> migratingActivityInstanceValidators) {
        this.migratingActivityInstanceValidators = migratingActivityInstanceValidators;
    }

    public List<MigratingActivityInstanceValidator> getMigratingActivityInstanceValidators() {
        return this.migratingActivityInstanceValidators;
    }

    public void setCustomPostMigratingActivityInstanceValidators(List<MigratingActivityInstanceValidator> customPostMigratingActivityInstanceValidators) {
        this.customPostMigratingActivityInstanceValidators = customPostMigratingActivityInstanceValidators;
    }

    public List<MigratingActivityInstanceValidator> getCustomPostMigratingActivityInstanceValidators() {
        return this.customPostMigratingActivityInstanceValidators;
    }

    public void setCustomPreMigratingActivityInstanceValidators(List<MigratingActivityInstanceValidator> customPreMigratingActivityInstanceValidators) {
        this.customPreMigratingActivityInstanceValidators = customPreMigratingActivityInstanceValidators;
    }

    public List<MigratingActivityInstanceValidator> getCustomPreMigratingActivityInstanceValidators() {
        return this.customPreMigratingActivityInstanceValidators;
    }

    public List<MigratingTransitionInstanceValidator> getMigratingTransitionInstanceValidators() {
        return this.migratingTransitionInstanceValidators;
    }

    public List<MigratingCompensationInstanceValidator> getMigratingCompensationInstanceValidators() {
        return this.migratingCompensationInstanceValidators;
    }

    public List<MigratingActivityInstanceValidator> getDefaultMigratingActivityInstanceValidators() {
        ArrayList<MigratingActivityInstanceValidator> migratingActivityInstanceValidators = new ArrayList<MigratingActivityInstanceValidator>();
        migratingActivityInstanceValidators.add(new NoUnmappedLeafInstanceValidator());
        migratingActivityInstanceValidators.add(new VariableConflictActivityInstanceValidator());
        migratingActivityInstanceValidators.add(new SupportedActivityInstanceValidator());
        return migratingActivityInstanceValidators;
    }

    public List<MigratingTransitionInstanceValidator> getDefaultMigratingTransitionInstanceValidators() {
        ArrayList<MigratingTransitionInstanceValidator> migratingTransitionInstanceValidators = new ArrayList<MigratingTransitionInstanceValidator>();
        migratingTransitionInstanceValidators.add(new NoUnmappedLeafInstanceValidator());
        migratingTransitionInstanceValidators.add(new AsyncAfterMigrationValidator());
        migratingTransitionInstanceValidators.add(new AsyncProcessStartMigrationValidator());
        migratingTransitionInstanceValidators.add(new AsyncMigrationValidator());
        return migratingTransitionInstanceValidators;
    }

    public List<CommandChecker> getCommandCheckers() {
        return this.commandCheckers;
    }

    public void setCommandCheckers(List<CommandChecker> commandCheckers) {
        this.commandCheckers = commandCheckers;
    }

    public ProcessEngineConfigurationImpl setUseSharedSqlSessionFactory(boolean isUseSharedSqlSessionFactory) {
        this.isUseSharedSqlSessionFactory = isUseSharedSqlSessionFactory;
        return this;
    }

    public boolean isUseSharedSqlSessionFactory() {
        return this.isUseSharedSqlSessionFactory;
    }

    public boolean getDisableStrictCallActivityValidation() {
        return this.disableStrictCallActivityValidation;
    }

    public void setDisableStrictCallActivityValidation(boolean disableStrictCallActivityValidation) {
        this.disableStrictCallActivityValidation = disableStrictCallActivityValidation;
    }

    public String getHistoryCleanupBatchWindowStartTime() {
        return this.historyCleanupBatchWindowStartTime;
    }

    public void setHistoryCleanupBatchWindowStartTime(String historyCleanupBatchWindowStartTime) {
        this.historyCleanupBatchWindowStartTime = historyCleanupBatchWindowStartTime;
    }

    public String getHistoryCleanupBatchWindowEndTime() {
        return this.historyCleanupBatchWindowEndTime;
    }

    public void setHistoryCleanupBatchWindowEndTime(String historyCleanupBatchWindowEndTime) {
        this.historyCleanupBatchWindowEndTime = historyCleanupBatchWindowEndTime;
    }

    public String getMondayHistoryCleanupBatchWindowStartTime() {
        return this.mondayHistoryCleanupBatchWindowStartTime;
    }

    public void setMondayHistoryCleanupBatchWindowStartTime(String mondayHistoryCleanupBatchWindowStartTime) {
        this.mondayHistoryCleanupBatchWindowStartTime = mondayHistoryCleanupBatchWindowStartTime;
    }

    public String getMondayHistoryCleanupBatchWindowEndTime() {
        return this.mondayHistoryCleanupBatchWindowEndTime;
    }

    public void setMondayHistoryCleanupBatchWindowEndTime(String mondayHistoryCleanupBatchWindowEndTime) {
        this.mondayHistoryCleanupBatchWindowEndTime = mondayHistoryCleanupBatchWindowEndTime;
    }

    public String getTuesdayHistoryCleanupBatchWindowStartTime() {
        return this.tuesdayHistoryCleanupBatchWindowStartTime;
    }

    public void setTuesdayHistoryCleanupBatchWindowStartTime(String tuesdayHistoryCleanupBatchWindowStartTime) {
        this.tuesdayHistoryCleanupBatchWindowStartTime = tuesdayHistoryCleanupBatchWindowStartTime;
    }

    public String getTuesdayHistoryCleanupBatchWindowEndTime() {
        return this.tuesdayHistoryCleanupBatchWindowEndTime;
    }

    public void setTuesdayHistoryCleanupBatchWindowEndTime(String tuesdayHistoryCleanupBatchWindowEndTime) {
        this.tuesdayHistoryCleanupBatchWindowEndTime = tuesdayHistoryCleanupBatchWindowEndTime;
    }

    public String getWednesdayHistoryCleanupBatchWindowStartTime() {
        return this.wednesdayHistoryCleanupBatchWindowStartTime;
    }

    public void setWednesdayHistoryCleanupBatchWindowStartTime(String wednesdayHistoryCleanupBatchWindowStartTime) {
        this.wednesdayHistoryCleanupBatchWindowStartTime = wednesdayHistoryCleanupBatchWindowStartTime;
    }

    public String getWednesdayHistoryCleanupBatchWindowEndTime() {
        return this.wednesdayHistoryCleanupBatchWindowEndTime;
    }

    public void setWednesdayHistoryCleanupBatchWindowEndTime(String wednesdayHistoryCleanupBatchWindowEndTime) {
        this.wednesdayHistoryCleanupBatchWindowEndTime = wednesdayHistoryCleanupBatchWindowEndTime;
    }

    public String getThursdayHistoryCleanupBatchWindowStartTime() {
        return this.thursdayHistoryCleanupBatchWindowStartTime;
    }

    public void setThursdayHistoryCleanupBatchWindowStartTime(String thursdayHistoryCleanupBatchWindowStartTime) {
        this.thursdayHistoryCleanupBatchWindowStartTime = thursdayHistoryCleanupBatchWindowStartTime;
    }

    public String getThursdayHistoryCleanupBatchWindowEndTime() {
        return this.thursdayHistoryCleanupBatchWindowEndTime;
    }

    public void setThursdayHistoryCleanupBatchWindowEndTime(String thursdayHistoryCleanupBatchWindowEndTime) {
        this.thursdayHistoryCleanupBatchWindowEndTime = thursdayHistoryCleanupBatchWindowEndTime;
    }

    public String getFridayHistoryCleanupBatchWindowStartTime() {
        return this.fridayHistoryCleanupBatchWindowStartTime;
    }

    public void setFridayHistoryCleanupBatchWindowStartTime(String fridayHistoryCleanupBatchWindowStartTime) {
        this.fridayHistoryCleanupBatchWindowStartTime = fridayHistoryCleanupBatchWindowStartTime;
    }

    public String getFridayHistoryCleanupBatchWindowEndTime() {
        return this.fridayHistoryCleanupBatchWindowEndTime;
    }

    public void setFridayHistoryCleanupBatchWindowEndTime(String fridayHistoryCleanupBatchWindowEndTime) {
        this.fridayHistoryCleanupBatchWindowEndTime = fridayHistoryCleanupBatchWindowEndTime;
    }

    public String getSaturdayHistoryCleanupBatchWindowStartTime() {
        return this.saturdayHistoryCleanupBatchWindowStartTime;
    }

    public void setSaturdayHistoryCleanupBatchWindowStartTime(String saturdayHistoryCleanupBatchWindowStartTime) {
        this.saturdayHistoryCleanupBatchWindowStartTime = saturdayHistoryCleanupBatchWindowStartTime;
    }

    public String getSaturdayHistoryCleanupBatchWindowEndTime() {
        return this.saturdayHistoryCleanupBatchWindowEndTime;
    }

    public void setSaturdayHistoryCleanupBatchWindowEndTime(String saturdayHistoryCleanupBatchWindowEndTime) {
        this.saturdayHistoryCleanupBatchWindowEndTime = saturdayHistoryCleanupBatchWindowEndTime;
    }

    public String getSundayHistoryCleanupBatchWindowStartTime() {
        return this.sundayHistoryCleanupBatchWindowStartTime;
    }

    public void setSundayHistoryCleanupBatchWindowStartTime(String sundayHistoryCleanupBatchWindowStartTime) {
        this.sundayHistoryCleanupBatchWindowStartTime = sundayHistoryCleanupBatchWindowStartTime;
    }

    public String getSundayHistoryCleanupBatchWindowEndTime() {
        return this.sundayHistoryCleanupBatchWindowEndTime;
    }

    public void setSundayHistoryCleanupBatchWindowEndTime(String sundayHistoryCleanupBatchWindowEndTime) {
        this.sundayHistoryCleanupBatchWindowEndTime = sundayHistoryCleanupBatchWindowEndTime;
    }

    public Date getHistoryCleanupBatchWindowStartTimeAsDate() {
        return this.historyCleanupBatchWindowStartTimeAsDate;
    }

    public void setHistoryCleanupBatchWindowStartTimeAsDate(Date historyCleanupBatchWindowStartTimeAsDate) {
        this.historyCleanupBatchWindowStartTimeAsDate = historyCleanupBatchWindowStartTimeAsDate;
    }

    public void setHistoryCleanupBatchWindowEndTimeAsDate(Date historyCleanupBatchWindowEndTimeAsDate) {
        this.historyCleanupBatchWindowEndTimeAsDate = historyCleanupBatchWindowEndTimeAsDate;
    }

    public Date getHistoryCleanupBatchWindowEndTimeAsDate() {
        return this.historyCleanupBatchWindowEndTimeAsDate;
    }

    public Map<Integer, BatchWindowConfiguration> getHistoryCleanupBatchWindows() {
        return this.historyCleanupBatchWindows;
    }

    public void setHistoryCleanupBatchWindows(Map<Integer, BatchWindowConfiguration> historyCleanupBatchWindows) {
        this.historyCleanupBatchWindows = historyCleanupBatchWindows;
    }

    public int getHistoryCleanupBatchSize() {
        return this.historyCleanupBatchSize;
    }

    public void setHistoryCleanupBatchSize(int historyCleanupBatchSize) {
        this.historyCleanupBatchSize = historyCleanupBatchSize;
    }

    public int getHistoryCleanupBatchThreshold() {
        return this.historyCleanupBatchThreshold;
    }

    public void setHistoryCleanupBatchThreshold(int historyCleanupBatchThreshold) {
        this.historyCleanupBatchThreshold = historyCleanupBatchThreshold;
    }

    public boolean isHistoryCleanupMetricsEnabled() {
        return this.historyCleanupMetricsEnabled;
    }

    public void setHistoryCleanupMetricsEnabled(boolean historyCleanupMetricsEnabled) {
        this.historyCleanupMetricsEnabled = historyCleanupMetricsEnabled;
    }

    public boolean isHistoryCleanupEnabled() {
        return this.historyCleanupEnabled;
    }

    public ProcessEngineConfigurationImpl setHistoryCleanupEnabled(boolean historyCleanupEnabled) {
        this.historyCleanupEnabled = historyCleanupEnabled;
        return this;
    }

    public String getHistoryTimeToLive() {
        return this.historyTimeToLive;
    }

    public void setHistoryTimeToLive(String historyTimeToLive) {
        this.historyTimeToLive = historyTimeToLive;
    }

    public String getBatchOperationHistoryTimeToLive() {
        return this.batchOperationHistoryTimeToLive;
    }

    public int getHistoryCleanupDegreeOfParallelism() {
        return this.historyCleanupDegreeOfParallelism;
    }

    public void setHistoryCleanupDegreeOfParallelism(int historyCleanupDegreeOfParallelism) {
        this.historyCleanupDegreeOfParallelism = historyCleanupDegreeOfParallelism;
    }

    public void setBatchOperationHistoryTimeToLive(String batchOperationHistoryTimeToLive) {
        this.batchOperationHistoryTimeToLive = batchOperationHistoryTimeToLive;
    }

    public Map<String, String> getBatchOperationsForHistoryCleanup() {
        return this.batchOperationsForHistoryCleanup;
    }

    public void setBatchOperationsForHistoryCleanup(Map<String, String> batchOperationsForHistoryCleanup) {
        this.batchOperationsForHistoryCleanup = batchOperationsForHistoryCleanup;
    }

    public Map<String, Integer> getParsedBatchOperationsForHistoryCleanup() {
        return this.parsedBatchOperationsForHistoryCleanup;
    }

    public void setParsedBatchOperationsForHistoryCleanup(Map<String, Integer> parsedBatchOperationsForHistoryCleanup) {
        this.parsedBatchOperationsForHistoryCleanup = parsedBatchOperationsForHistoryCleanup;
    }

    public String getHistoryCleanupJobLogTimeToLive() {
        return this.historyCleanupJobLogTimeToLive;
    }

    public ProcessEngineConfigurationImpl setHistoryCleanupJobLogTimeToLive(String historyCleanupJobLogTimeToLive) {
        this.historyCleanupJobLogTimeToLive = historyCleanupJobLogTimeToLive;
        return this;
    }

    public String getTaskMetricsTimeToLive() {
        return this.taskMetricsTimeToLive;
    }

    public ProcessEngineConfigurationImpl setTaskMetricsTimeToLive(String taskMetricsTimeToLive) {
        this.taskMetricsTimeToLive = taskMetricsTimeToLive;
        return this;
    }

    public Integer getParsedTaskMetricsTimeToLive() {
        return this.parsedTaskMetricsTimeToLive;
    }

    public ProcessEngineConfigurationImpl setParsedTaskMetricsTimeToLive(Integer parsedTaskMetricsTimeToLive) {
        this.parsedTaskMetricsTimeToLive = parsedTaskMetricsTimeToLive;
        return this;
    }

    public BatchWindowManager getBatchWindowManager() {
        return this.batchWindowManager;
    }

    public void setBatchWindowManager(BatchWindowManager batchWindowManager) {
        this.batchWindowManager = batchWindowManager;
    }

    public HistoryRemovalTimeProvider getHistoryRemovalTimeProvider() {
        return this.historyRemovalTimeProvider;
    }

    public ProcessEngineConfigurationImpl setHistoryRemovalTimeProvider(HistoryRemovalTimeProvider removalTimeProvider) {
        this.historyRemovalTimeProvider = removalTimeProvider;
        return this;
    }

    public String getHistoryRemovalTimeStrategy() {
        return this.historyRemovalTimeStrategy;
    }

    public ProcessEngineConfigurationImpl setHistoryRemovalTimeStrategy(String removalTimeStrategy) {
        this.historyRemovalTimeStrategy = removalTimeStrategy;
        return this;
    }

    public String getHistoryCleanupStrategy() {
        return this.historyCleanupStrategy;
    }

    public ProcessEngineConfigurationImpl setHistoryCleanupStrategy(String historyCleanupStrategy) {
        this.historyCleanupStrategy = historyCleanupStrategy;
        return this;
    }

    public int getFailedJobListenerMaxRetries() {
        return this.failedJobListenerMaxRetries;
    }

    public void setFailedJobListenerMaxRetries(int failedJobListenerMaxRetries) {
        this.failedJobListenerMaxRetries = failedJobListenerMaxRetries;
    }

    public String getFailedJobRetryTimeCycle() {
        return this.failedJobRetryTimeCycle;
    }

    public void setFailedJobRetryTimeCycle(String failedJobRetryTimeCycle) {
        this.failedJobRetryTimeCycle = failedJobRetryTimeCycle;
    }

    public int getLoginMaxAttempts() {
        return this.loginMaxAttempts;
    }

    public void setLoginMaxAttempts(int loginMaxAttempts) {
        this.loginMaxAttempts = loginMaxAttempts;
    }

    public int getLoginDelayFactor() {
        return this.loginDelayFactor;
    }

    public void setLoginDelayFactor(int loginDelayFactor) {
        this.loginDelayFactor = loginDelayFactor;
    }

    public int getLoginDelayMaxTime() {
        return this.loginDelayMaxTime;
    }

    public void setLoginDelayMaxTime(int loginDelayMaxTime) {
        this.loginDelayMaxTime = loginDelayMaxTime;
    }

    public int getLoginDelayBase() {
        return this.loginDelayBase;
    }

    public void setLoginDelayBase(int loginInitialDelay) {
        this.loginDelayBase = loginInitialDelay;
    }

    public List<String> getAdminGroups() {
        return this.adminGroups;
    }

    public void setAdminGroups(List<String> adminGroups) {
        this.adminGroups = adminGroups;
    }

    public List<String> getAdminUsers() {
        return this.adminUsers;
    }

    public void setAdminUsers(List<String> adminUsers) {
        this.adminUsers = adminUsers;
    }

    public int getQueryMaxResultsLimit() {
        return this.queryMaxResultsLimit;
    }

    public ProcessEngineConfigurationImpl setQueryMaxResultsLimit(int queryMaxResultsLimit) {
        this.queryMaxResultsLimit = queryMaxResultsLimit;
        return this;
    }

    public String getLoggingContextActivityId() {
        return this.loggingContextActivityId;
    }

    public ProcessEngineConfigurationImpl setLoggingContextActivityId(String loggingContextActivityId) {
        this.loggingContextActivityId = loggingContextActivityId;
        return this;
    }

    public String getLoggingContextApplicationName() {
        return this.loggingContextApplicationName;
    }

    public ProcessEngineConfigurationImpl setLoggingContextApplicationName(String loggingContextApplicationName) {
        this.loggingContextApplicationName = loggingContextApplicationName;
        return this;
    }

    public String getLoggingContextBusinessKey() {
        return this.loggingContextBusinessKey;
    }

    public ProcessEngineConfigurationImpl setLoggingContextBusinessKey(String loggingContextBusinessKey) {
        this.loggingContextBusinessKey = loggingContextBusinessKey;
        return this;
    }

    public String getLoggingContextProcessDefinitionId() {
        return this.loggingContextProcessDefinitionId;
    }

    public ProcessEngineConfigurationImpl setLoggingContextProcessDefinitionId(String loggingContextProcessDefinitionId) {
        this.loggingContextProcessDefinitionId = loggingContextProcessDefinitionId;
        return this;
    }

    public String getLoggingContextProcessInstanceId() {
        return this.loggingContextProcessInstanceId;
    }

    public ProcessEngineConfigurationImpl setLoggingContextProcessInstanceId(String loggingContextProcessInstanceId) {
        this.loggingContextProcessInstanceId = loggingContextProcessInstanceId;
        return this;
    }

    public String getLoggingContextTenantId() {
        return this.loggingContextTenantId;
    }

    public ProcessEngineConfigurationImpl setLoggingContextTenantId(String loggingContextTenantId) {
        this.loggingContextTenantId = loggingContextTenantId;
        return this;
    }

    public List<FeelCustomFunctionProvider> getDmnFeelCustomFunctionProviders() {
        return this.dmnFeelCustomFunctionProviders;
    }

    public ProcessEngineConfigurationImpl setDmnFeelCustomFunctionProviders(List<FeelCustomFunctionProvider> dmnFeelCustomFunctionProviders) {
        this.dmnFeelCustomFunctionProviders = dmnFeelCustomFunctionProviders;
        return this;
    }

    public boolean isDmnFeelEnableLegacyBehavior() {
        return this.dmnFeelEnableLegacyBehavior;
    }

    public ProcessEngineConfigurationImpl setDmnFeelEnableLegacyBehavior(boolean dmnFeelEnableLegacyBehavior) {
        this.dmnFeelEnableLegacyBehavior = dmnFeelEnableLegacyBehavior;
        return this;
    }

    public Boolean isInitializeTelemetry() {
        return this.initializeTelemetry;
    }

    public ProcessEngineConfigurationImpl setInitializeTelemetry(boolean telemetryInitialized) {
        this.initializeTelemetry = telemetryInitialized;
        return this;
    }

    public String getTelemetryEndpoint() {
        return this.telemetryEndpoint;
    }

    public ProcessEngineConfigurationImpl setTelemetryEndpoint(String telemetryEndpoint) {
        this.telemetryEndpoint = telemetryEndpoint;
        return this;
    }

    public int getTelemetryRequestRetries() {
        return this.telemetryRequestRetries;
    }

    public ProcessEngineConfigurationImpl setTelemetryRequestRetries(int telemetryRequestRetries) {
        this.telemetryRequestRetries = telemetryRequestRetries;
        return this;
    }

    public long getTelemetryReportingPeriod() {
        return this.telemetryReportingPeriod;
    }

    public ProcessEngineConfigurationImpl setTelemetryReportingPeriod(long telemetryReportingPeriod) {
        this.telemetryReportingPeriod = telemetryReportingPeriod;
        return this;
    }

    public TelemetryReporter getTelemetryReporter() {
        return this.telemetryReporter;
    }

    public ProcessEngineConfigurationImpl setTelemetryReporter(TelemetryReporter telemetryReporter) {
        this.telemetryReporter = telemetryReporter;
        return this;
    }

    public boolean isTelemetryReporterActivate() {
        return this.isTelemetryReporterActivate;
    }

    public ProcessEngineConfigurationImpl setTelemetryReporterActivate(boolean isTelemetryReporterActivate) {
        this.isTelemetryReporterActivate = isTelemetryReporterActivate;
        return this;
    }

    public Connector<? extends ConnectorRequest<?>> getTelemetryHttpConnector() {
        return this.telemetryHttpConnector;
    }

    public ProcessEngineConfigurationImpl setTelemetryHttpConnector(Connector<? extends ConnectorRequest<?>> telemetryHttp) {
        this.telemetryHttpConnector = telemetryHttp;
        return this;
    }

    public TelemetryDataImpl getTelemetryData() {
        return this.telemetryData;
    }

    public ProcessEngineConfigurationImpl setTelemetryData(TelemetryDataImpl telemetryData) {
        this.telemetryData = telemetryData;
        return this;
    }

    public int getTelemetryRequestTimeout() {
        return this.telemetryRequestTimeout;
    }

    public ProcessEngineConfigurationImpl setTelemetryRequestTimeout(int telemetryRequestTimeout) {
        this.telemetryRequestTimeout = telemetryRequestTimeout;
        return this;
    }

    public ProcessEngineConfigurationImpl setCommandRetries(int commandRetries) {
        this.commandRetries = commandRetries;
        return this;
    }

    public int getCommandRetries() {
        return this.commandRetries;
    }

    protected CrdbTransactionRetryInterceptor getCrdbRetryInterceptor() {
        return new CrdbTransactionRetryInterceptor(this.commandRetries);
    }

    static {
        databaseTypeMappings = ProcessEngineConfigurationImpl.getDefaultDatabaseTypeMappings();
    }
}

