/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.interceptor;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.application.ProcessApplicationReference;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.commons.logging.MdcAccess;

public class ProcessDataContext {
    public static final String PROPERTY_ACTIVITY_ID = "activityId";
    protected static final String NULL_VALUE = "~NULL_VALUE~";
    protected String mdcPropertyActivityId;
    protected String mdcPropertyApplicationName;
    protected String mdcPropertyBusinessKey;
    protected String mdcPropertyDefinitionId;
    protected String mdcPropertyInstanceId;
    protected String mdcPropertyTenantId;
    protected List<String> mdcPropertyNames = new ArrayList<String>();
    protected Map<String, String> basicToMdcPropertyNames = new HashMap<String, String>();
    protected boolean handleMdc = false;
    protected Map<String, Deque<String>> propertyValues = new HashMap<String, Deque<String>>();
    protected boolean startNewSection = false;
    protected Deque<List<String>> sections = new ArrayDeque<List<String>>();

    public ProcessDataContext(ProcessEngineConfigurationImpl configuration) {
        this.mdcPropertyActivityId = configuration.getLoggingContextActivityId();
        if (ProcessDataContext.isNotBlank(this.mdcPropertyActivityId)) {
            this.mdcPropertyNames.add(this.mdcPropertyActivityId);
            this.basicToMdcPropertyNames.put(PROPERTY_ACTIVITY_ID, this.mdcPropertyActivityId);
        }
        this.mdcPropertyApplicationName = configuration.getLoggingContextApplicationName();
        if (ProcessDataContext.isNotBlank(this.mdcPropertyApplicationName)) {
            this.mdcPropertyNames.add(this.mdcPropertyApplicationName);
        }
        this.mdcPropertyBusinessKey = configuration.getLoggingContextBusinessKey();
        if (ProcessDataContext.isNotBlank(this.mdcPropertyBusinessKey)) {
            this.mdcPropertyNames.add(this.mdcPropertyBusinessKey);
        }
        this.mdcPropertyDefinitionId = configuration.getLoggingContextProcessDefinitionId();
        if (ProcessDataContext.isNotBlank(this.mdcPropertyDefinitionId)) {
            this.mdcPropertyNames.add(this.mdcPropertyDefinitionId);
        }
        this.mdcPropertyInstanceId = configuration.getLoggingContextProcessInstanceId();
        if (ProcessDataContext.isNotBlank(this.mdcPropertyInstanceId)) {
            this.mdcPropertyNames.add(this.mdcPropertyInstanceId);
        }
        this.mdcPropertyTenantId = configuration.getLoggingContextTenantId();
        if (ProcessDataContext.isNotBlank(this.mdcPropertyTenantId)) {
            this.mdcPropertyNames.add(this.mdcPropertyTenantId);
        }
        this.handleMdc = !this.mdcPropertyNames.isEmpty();
    }

    public boolean pushSection(ExecutionEntity execution) {
        ProcessApplicationReference currentPa;
        if (this.handleMdc && this.propertyValues.isEmpty()) {
            this.clearMdc();
        }
        this.startNewSection = true;
        this.addToStack(execution.getActivityId(), PROPERTY_ACTIVITY_ID, this.mdcPropertyActivityId != null);
        this.addToStack(execution.getProcessDefinitionId(), this.mdcPropertyDefinitionId);
        this.addToStack(execution.getProcessInstanceId(), this.mdcPropertyInstanceId);
        this.addToStack(execution.getTenantId(), this.mdcPropertyTenantId);
        if (ProcessDataContext.isNotBlank(this.mdcPropertyApplicationName) && (currentPa = Context.getCurrentProcessApplication()) != null) {
            this.addToStack(currentPa.getName(), this.mdcPropertyApplicationName);
        }
        if (ProcessDataContext.isNotBlank(this.mdcPropertyBusinessKey)) {
            this.addToStack(execution.getBusinessKey(), this.mdcPropertyBusinessKey);
        }
        return !this.startNewSection;
    }

    public void popSection() {
        List<String> section = this.sections.pollFirst();
        if (section != null) {
            for (String property : section) {
                this.removeFromStack(property);
            }
        }
    }

    public void clearMdc() {
        if (this.handleMdc) {
            for (String property : this.mdcPropertyNames) {
                MdcAccess.remove((String)this.getMdcProperty(property));
            }
        }
    }

    public void updateMdc() {
        if (this.handleMdc && !this.propertyValues.isEmpty()) {
            for (String property : this.mdcPropertyNames) {
                this.updateMdc(this.getMdcProperty(property));
            }
        }
    }

    public void fetchCurrentContext() {
        if (this.handleMdc) {
            this.startNewSection = true;
            for (String property : this.mdcPropertyNames) {
                String mdcProperty = this.getMdcProperty(property);
                this.addToStack(MdcAccess.get((String)mdcProperty), mdcProperty, false);
            }
            this.startNewSection = false;
        }
    }

    public String getLatestPropertyValue(String property) {
        Deque<String> deque;
        if (!this.propertyValues.isEmpty() && (deque = this.propertyValues.get(property)) != null) {
            return deque.peekFirst();
        }
        return null;
    }

    protected void addToStack(String value, String property) {
        this.addToStack(value, property, true);
    }

    protected void addToStack(String value, String property, boolean updateMdc) {
        if (!ProcessDataContext.isNotBlank(property)) {
            return;
        }
        Deque<String> deque = this.getDeque(property);
        String current = deque.peekFirst();
        if (ProcessDataContext.valuesEqual(current, value)) {
            return;
        }
        this.addToCurrentSection(property);
        if (value == null) {
            deque.addFirst(NULL_VALUE);
            if (this.handleMdc && updateMdc) {
                MdcAccess.remove((String)this.getMdcProperty(property));
            }
        } else {
            deque.addFirst(value);
            if (this.handleMdc && updateMdc) {
                MdcAccess.put((String)this.getMdcProperty(property), (String)value);
            }
        }
    }

    protected void removeFromStack(String property) {
        if (property == null) {
            return;
        }
        this.getDeque(property).removeFirst();
        if (this.handleMdc) {
            this.updateMdc(this.getMdcProperty(property));
        }
    }

    protected Deque<String> getDeque(String property) {
        Deque<String> deque = this.propertyValues.get(property);
        if (deque == null) {
            deque = new ArrayDeque<String>();
            this.propertyValues.put(property, deque);
        }
        return deque;
    }

    protected void addToCurrentSection(String property) {
        List<String> section = this.sections.peekFirst();
        if (this.startNewSection) {
            section = new ArrayList<String>();
            this.sections.addFirst(section);
            this.startNewSection = false;
        }
        section.add(property);
    }

    protected void updateMdc(String property) {
        if (this.handleMdc) {
            String previousValue = this.propertyValues.containsKey(property) ? this.propertyValues.get(property).peekFirst() : null;
            String mdcProperty = this.getMdcProperty(property);
            if (ProcessDataContext.isNull(previousValue)) {
                MdcAccess.remove((String)mdcProperty);
            } else {
                MdcAccess.put((String)mdcProperty, (String)previousValue);
            }
        }
    }

    protected String getMdcProperty(String property) {
        return this.basicToMdcPropertyNames.containsKey(property) ? this.basicToMdcPropertyNames.get(property) : property;
    }

    protected static boolean isNotBlank(String property) {
        return property != null && !property.trim().isEmpty();
    }

    protected static boolean valuesEqual(String val1, String val2) {
        if (ProcessDataContext.isNull(val1)) {
            return val2 == null;
        }
        return val1.equals(val2);
    }

    protected static boolean isNull(String value) {
        return value == null || NULL_VALUE.equals(value);
    }
}

