/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.batch.deletion;

import camundajar.impl.com.google.gson.JsonObject;
import java.util.List;
import org.camunda.bpm.engine.impl.batch.BatchConfiguration;
import org.camunda.bpm.engine.impl.batch.DeploymentMappingJsonConverter;
import org.camunda.bpm.engine.impl.batch.DeploymentMappings;
import org.camunda.bpm.engine.impl.json.JsonObjectConverter;
import org.camunda.bpm.engine.impl.util.JsonUtil;

public class DeleteHistoricProcessInstanceBatchConfigurationJsonConverter
extends JsonObjectConverter<BatchConfiguration> {
    public static final DeleteHistoricProcessInstanceBatchConfigurationJsonConverter INSTANCE = new DeleteHistoricProcessInstanceBatchConfigurationJsonConverter();
    public static final String HISTORIC_PROCESS_INSTANCE_IDS = "historicProcessInstanceIds";
    public static final String HISTORIC_PROCESS_INSTANCE_ID_MAPPINGS = "historicProcessInstanceIdMappings";
    public static final String FAIL_IF_NOT_EXISTS = "failIfNotExists";

    @Override
    public JsonObject toJsonObject(BatchConfiguration configuration) {
        JsonObject json = JsonUtil.createObject();
        JsonUtil.addListField(json, HISTORIC_PROCESS_INSTANCE_ID_MAPPINGS, DeploymentMappingJsonConverter.INSTANCE, configuration.getIdMappings());
        JsonUtil.addListField(json, HISTORIC_PROCESS_INSTANCE_IDS, configuration.getIds());
        JsonUtil.addField(json, FAIL_IF_NOT_EXISTS, configuration.isFailIfNotExists());
        return json;
    }

    @Override
    public BatchConfiguration toObject(JsonObject json) {
        BatchConfiguration configuration = new BatchConfiguration(this.readProcessInstanceIds(json), this.readIdMappings(json), JsonUtil.getBoolean(json, FAIL_IF_NOT_EXISTS));
        return configuration;
    }

    protected List<String> readProcessInstanceIds(JsonObject jsonObject) {
        return JsonUtil.asStringList(JsonUtil.getArray(jsonObject, HISTORIC_PROCESS_INSTANCE_IDS));
    }

    protected DeploymentMappings readIdMappings(JsonObject json) {
        return JsonUtil.asList(JsonUtil.getArray(json, HISTORIC_PROCESS_INSTANCE_ID_MAPPINGS), DeploymentMappingJsonConverter.INSTANCE, DeploymentMappings::new);
    }
}

