/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.opencv.presets;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.List;
import org.bytedeco.javacpp.ClassProperties;
import org.bytedeco.javacpp.FunctionPointer;
import org.bytedeco.javacpp.LoadEnabled;
import org.bytedeco.javacpp.Loader;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.annotation.Adapter;
import org.bytedeco.javacpp.annotation.ByRef;
import org.bytedeco.javacpp.annotation.Cast;
import org.bytedeco.javacpp.annotation.Platform;
import org.bytedeco.javacpp.annotation.Properties;
import org.bytedeco.javacpp.tools.Info;
import org.bytedeco.javacpp.tools.InfoMap;
import org.bytedeco.javacpp.tools.InfoMapper;
import org.bytedeco.openblas.presets.openblas;

@Properties(inherit={openblas.class}, value={@Platform(include={"<opencv2/core/hal/interface.h>", "<opencv2/core/cvdef.h>", "<opencv2/core/hal/hal.hpp>", "<opencv2/core/fast_math.hpp>", "<algorithm>", "<map>", "<opencv2/core/saturate.hpp>", "<opencv2/core/version.hpp>", "<opencv2/core/base.hpp>", "<opencv2/core/cvstd.hpp>", "<opencv2/core/utility.hpp>", "<opencv2/core/utils/instrumentation.hpp>", "<opencv2/core/utils/tls.hpp>", "<opencv2/core/types_c.h>", "<opencv2/core/core_c.h>", "<opencv2/core/types.hpp>", "<opencv2/core.hpp>", "<opencv2/core/cuda.hpp>", "<opencv2/core/ocl.hpp>", "<opencv2/core/operations.hpp>", "<opencv2/core/bufferpool.hpp>", "<opencv2/core/mat.hpp>", "<opencv2/core/persistence.hpp>", "<opencv2/core/optim.hpp>", "<opencv2/core/async.hpp>", "opencv_adapters.h"}, link={"opencv_core@.409", "opencv_imgproc@.409"}, exclude={"openblas_config.h", "cblas.h", "lapacke_config.h", "lapacke_mangling.h", "lapack.h", "lapacke.h", "lapacke_utils.h"}, resource={"include", "lib", "sdk", "share", "x86", "x64", "OpenCVConfig.cmake", "OpenCVConfig-version.cmake", "python"}, linkresource={"lib"}, preload={"opencv_cudev@.409"}, compiler={"cpp11"}, define={"SHARED_PTR_NAMESPACE std"}), @Platform(value={"android"}, preload={""}), @Platform(value={"ios"}, preload={"liblibjpeg", "liblibpng", "liblibprotobuf", "liblibwebp", "libzlib", "libopencv_core"}), @Platform(value={"linux"}, preloadpath={"/usr/lib/", "/usr/lib32/", "/usr/lib64/"}), @Platform(value={"linux-armhf"}, preloadpath={"/usr/arm-linux-gnueabihf/lib/", "/usr/lib/arm-linux-gnueabihf/"}), @Platform(value={"linux-arm64"}, preloadpath={"/usr/aarch64-linux-gnu/lib/", "/usr/lib/aarch64-linux-gnu/"}), @Platform(value={"linux-x86"}, preloadpath={"/usr/lib32/", "/usr/lib/"}), @Platform(value={"linux-x86_64"}, preloadpath={"/usr/lib64/", "/usr/lib/"}), @Platform(value={"linux-ppc64"}, preloadpath={"/usr/lib/powerpc64-linux-gnu/", "/usr/lib/powerpc64le-linux-gnu/"}), @Platform(value={"windows"}, define={"SHARED_PTR_NAMESPACE std", "_WIN32_WINNT 0x0502"}, link={"opencv_core490", "opencv_imgproc490"}, preload={"opencv_cudev490"}), @Platform(value={"linux-arm64", "linux-ppc64le", "linux-x86_64", "macosx-x86_64", "windows-x86_64"}, extension={"-gpu"})}, target="org.bytedeco.opencv.opencv_core", global="org.bytedeco.opencv.global.opencv_core", helper="org.bytedeco.opencv.helper.opencv_core")
public class opencv_core
implements LoadEnabled,
InfoMapper {
    public void init(ClassProperties properties) {
        String[] libs;
        String platform = properties.getProperty("platform");
        String extension = properties.getProperty("platform.extension");
        List preloads = properties.get("platform.preload");
        List resources = properties.get("platform.preloadresource");
        List preloadpaths = properties.get("platform.preloadpath");
        if (!Loader.isLoadLibraries() || extension == null || !extension.equals("-gpu")) {
            return;
        }
        int i = 0;
        if (platform.startsWith("windows")) {
            preloads.add(i++, "zlibwapi");
        }
        for (String lib : libs = new String[]{"cudart", "cublasLt", "cublas", "cufft", "cudnn", "nppc", "nppial", "nppicc", "nppicom", "nppidei", "nppif", "nppig", "nppim", "nppist", "nppisu", "nppitc", "npps", "cudnn_ops_infer", "cudnn_ops_train", "cudnn_adv_infer", "cudnn_adv_train", "cudnn_cnn_infer", "cudnn_cnn_train"}) {
            if (platform.startsWith("linux")) {
                lib = lib + (lib.startsWith("cudnn") ? "@.8" : (lib.equals("cufft") ? "@.11" : (lib.equals("cudart") ? "@.12" : "@.12")));
            } else {
                if (!platform.startsWith("windows")) continue;
                lib = lib + (lib.startsWith("cudnn") ? "64_8" : (lib.equals("cufft") ? "64_11" : (lib.equals("cudart") ? "64_12" : "64_12")));
            }
            if (preloads.contains(lib)) continue;
            preloads.add(i++, lib);
        }
        if (i > 0) {
            resources.add("/org/bytedeco/cuda/");
        }
    }

    public void map(InfoMap infoMap) {
        infoMap.putFirst(new Info(new String[]{"openblas_config.h", "cblas.h", "lapacke_config.h", "lapacke_mangling.h", "lapack.h", "lapacke.h", "lapacke_utils.h"}).skip()).put(new Info(new String[]{"algorithm", "map", "opencv_adapters.h"}).skip()).put(new Info(new String[]{"__cplusplus", "CV_StaticAssert", "CV__LEGACY_PERSISTENCE"}).define()).put(new Info(new String[]{"__OPENCV_BUILD", "defined __ICL", "defined __ICC", "defined __ECL", "defined __ECC", "defined __INTEL_COMPILER", "defined WIN32 || defined _WIN32", "defined(__clang__)", "defined(__GNUC__)", "defined(_MSC_VER)", "defined __GNUC__ || defined __clang__", "OPENCV_NOSTL_TRANSITIONAL", "CV_COLLECT_IMPL_DATA", "__cplusplus >= 201103L || (defined(_MSC_VER) && _MSC_VER >= 1800)", "CV_CXX11", "CV_FP16_TYPE", "__EMSCRIPTEN__", "defined(CV__ENABLE_C_API_CTORS) && defined(__cplusplus)", "defined(CV__ENABLE_C_API_CTORS) && defined(__cplusplus) && !defined(__CUDACC__)"}).define(false)).put(new Info(new String[]{"CV_ENABLE_UNROLLED", "CV_CDECL", "CV_STDCALL", "CV_IMPL", "CV_EXTERN_C", "CV_Func", "CV__ErrorNoReturn", "CV__ErrorNoReturn_", "CV_ErrorNoReturn", "CV_ErrorNoReturn_", "CV_USRTYPE1", "CV_Assert_1"}).cppTypes(new String[0]).cppText("")).put(new Info(new String[]{"CV_DEFAULT", "CV_INLINE", "CV_ALWAYS_INLINE", "CV_EXPORTS", "CV_NEON", "CPU_HAS_NEON_FEATURE", "CV__DEBUG_NS_BEGIN", "CV__DEBUG_NS_END", "CV_NORETURN", "CV_SUPPRESS_DEPRECATED_START", "CV_SUPPRESS_DEPRECATED_END", "CV_CATCH_ALL", "CV_NODISCARD", "CV_NODISCARD_STD"}).annotations(new String[0]).cppTypes(new String[0])).put(new Info(new String[]{"CVAPI"}).cppText("#define CVAPI(rettype) rettype")).put(new Info(new String[]{"CV_DEPRECATED"}).cppText("#define CV_DEPRECATED deprecated").cppTypes(new String[0])).put(new Info(new String[]{"CV_DEPRECATED_EXTERNAL"}).cppText("#define CV_DEPRECATED_EXTERNAL deprecated").cppTypes(new String[0])).put(new Info(new String[]{"deprecated"}).annotations(new String[]{"@Deprecated"})).put(new Info(new String[]{"CV_OVERRIDE"}).cppText("#define CV_OVERRIDE override").cppTypes(new String[0])).put(new Info(new String[]{"override"}).annotations(new String[]{"@Override"})).put(new Info(new String[]{"CV_FINAL"}).cppText("#define CV_FINAL final").cppTypes(new String[0])).put(new Info(new String[]{"final"}).annotations(new String[]{"final"})).put(new Info(new String[]{"CV_NOEXCEPT"}).cppText("#define CV_NOEXCEPT noexcept").cppTypes(new String[0])).put(new Info(new String[]{"noexcept"}).annotations(new String[]{"@NoException"})).put(new Info(new String[]{"CV_CONSTEXPR"}).cppText("#define CV_CONSTEXPR constexpr").cppTypes(new String[0])).put(new Info(new String[]{"constexpr"}).annotations(new String[]{"@Const"})).put(new Info(new String[]{"CV_EXPORTS_AS", "CV_WRAP_AS"}).annotations(new String[]{"@Name"}).cppTypes(new String[0]).cppText("")).put(new Info(new String[]{"CV_EXPORTS_W", "CV_EXPORTS_W_SIMPLE", "CV_EXPORTS_W_MAP", "CV_EXPORTS_W_PARAMS", "CV_IN_OUT", "CV_OUT", "CV_PROP", "CV_PROP_RW", "CV_WRAP"}).annotations(new String[0]).cppTypes(new String[0]).cppText("")).put(new Info(new String[]{"CvRNG"}).cast().valueTypes(new String[]{"long"}).pointerTypes(new String[]{"LongPointer", "LongBuffer", "long[]"})).put(new Info(new String[]{"CV_MAT_DEPTH", "CV_8UC", "CV_8SC", "CV_16UC", "CV_16SC", "CV_32SC", "CV_32FC", "CV_64FC"}).cppTypes(new String[]{"int", "int"})).put(new Info(new String[]{"CV_MAKETYPE", "CV_MAKE_TYPE"}).cppTypes(new String[]{"int", "int", "int"})).put(new Info(new String[]{"CV_8UC1", "CV_8UC2", "CV_8UC3", "CV_8UC4", "CV_8SC1", "CV_8SC2", "CV_8SC3", "CV_8SC4", "CV_16UC1", "CV_16UC2", "CV_16UC3", "CV_16UC4", "CV_16SC1", "CV_16SC2", "CV_16SC3", "CV_16SC4", "CV_32SC1", "CV_32SC2", "CV_32SC3", "CV_32SC4", "CV_32FC1", "CV_32FC2", "CV_32FC3", "CV_32FC4", "CV_64FC1", "CV_64FC2", "CV_64FC3", "CV_64FC4"}).cppTypes(new String[]{"int"}).translate()).put(new Info(new String[]{"CV_MAT_CN", "CV_MAT_TYPE", "CV_IS_CONT_MAT", "CV_IS_MAT_CONT"}).cppTypes(new String[]{"int", "int"})).put(new Info(new String[]{"CV_VERSION"}).pointerTypes(new String[]{"String"}).translate(false)).put(new Info(new String[]{"CV_WHOLE_ARR", "CV_WHOLE_SEQ"}).cppTypes(new String[]{"CvSlice"}).translate()).put(new Info(new String[]{"std::uint32_t"}).cast().valueTypes(new String[]{"int"}).pointerTypes(new String[]{"IntPointer", "IntBuffer", "int[]"})).put(new Info(new String[]{"cv::ocl::initializeContextFromHandle"}).skip()).put(new Info(new String[]{"cv::ocl::Platform"}).pointerTypes(new String[]{"OclPlatform"})).put(new Info(new String[]{"cv::ocl::Queue::Impl", "cv::ocl::Program::Impl", "cv::ocl::ProgramSource::Impl"}).cast().pointerTypes(new String[]{"Pointer"})).put(new Info(new String[]{"cv::ocl::Kernel(const char*, const cv::ocl::ProgramSource&, const cv::String&, cv::String*)"}).javaText("public Kernel(String kname, @Const @ByRef ProgramSource prog,\n            @Str String buildopts, @Str BytePointer errmsg) { allocate(kname, prog, buildopts, errmsg); }\nprivate native void allocate(String kname, @Const @ByRef ProgramSource prog,\n            @Str String buildopts, @Cast({\"\", \"cv::String*\"}) @Str BytePointer errmsg/*=NULL*/);")).put(new Info(new String[]{"cv::ocl::Kernel::create(const char*, const cv::ocl::ProgramSource&, const cv::String&, cv::String*)"}).javaText("public native @Cast(\"bool\") boolean create(String kname, @Const @ByRef ProgramSource prog,\n            @Str String buildopts, @Cast({\"\", \"cv::String*\"}) @Str BytePointer errmsg/*=NULL*/);")).put(new Info(new String[]{"CvArr"}).skip().pointerTypes(new String[]{"CvArr"})).put(new Info(new String[]{"_IplROI"}).pointerTypes(new String[]{"IplROI"})).put(new Info(new String[]{"_IplImage"}).pointerTypes(new String[]{"IplImage"})).put(new Info(new String[]{"_IplTileInfo"}).pointerTypes(new String[]{"IplTileInfo"})).put(new Info(new String[]{"IplImage"}).base("AbstractIplImage")).put(new Info(new String[]{"IplConvKernel"}).base("org.bytedeco.opencv.opencv_imgproc.AbstractIplConvKernel")).put(new Info(new String[]{"CvMat"}).base("AbstractCvMat")).put(new Info(new String[]{"CvMatND"}).base("AbstractCvMatND")).put(new Info(new String[]{"CvSparseMat"}).base("AbstractCvSparseMat")).put(new Info(new String[]{"CvHistogram"}).base("org.bytedeco.opencv.opencv_imgproc.AbstractCvHistogram")).put(new Info(new String[]{"CvRect"}).base("AbstractCvRect")).put(new Info(new String[]{"CvPoint"}).cast().pointerTypes(new String[]{"CvPoint", "IntBuffer", "int[]"}).base("AbstractCvPoint")).put(new Info(new String[]{"CvPoint2D32f"}).cast().pointerTypes(new String[]{"CvPoint2D32f", "FloatBuffer", "float[]"}).base("AbstractCvPoint2D32f")).put(new Info(new String[]{"CvPoint3D32f"}).cast().pointerTypes(new String[]{"CvPoint3D32f", "FloatBuffer", "float[]"}).base("AbstractCvPoint3D32f")).put(new Info(new String[]{"CvPoint2D64f"}).cast().pointerTypes(new String[]{"CvPoint2D64f", "DoubleBuffer", "double[]"}).base("AbstractCvPoint2D64f")).put(new Info(new String[]{"CvPoint3D64f"}).cast().pointerTypes(new String[]{"CvPoint3D64f", "DoubleBuffer", "double[]"}).base("AbstractCvPoint3D64f")).put(new Info(new String[]{"CvSize"}).base("AbstractCvSize")).put(new Info(new String[]{"CvSize2D32f"}).base("AbstractCvSize2D32f")).put(new Info(new String[]{"CvBox2D"}).base("AbstractCvBox2D")).put(new Info(new String[]{"CvScalar"}).base("AbstractCvScalar")).put(new Info(new String[]{"CvMemStorage"}).base("AbstractCvMemStorage")).put(new Info(new String[]{"CvSeq"}).base("AbstractCvSeq")).put(new Info(new String[]{"CvSet"}).base("AbstractCvSet")).put(new Info(new String[]{"CvChain", "CvContour", "CvContourTree"}).base("CvSeq")).put(new Info(new String[]{"CvGraph"}).base("AbstractCvGraph")).put(new Info(new String[]{"CvGraphVtx2D"}).base("CvGraphVtx")).put(new Info(new String[]{"CvChainPtReader"}).base("CvSeqReader")).put(new Info(new String[]{"CvFileStorage"}).base("AbstractCvFileStorage")).put(new Info(new String[]{"CvGraphScanner"}).base("AbstractCvGraphScanner")).put(new Info(new String[]{"CvFont"}).base("AbstractCvFont")).put(new Info(new String[]{"cvGetSubArr"}).cppTypes(new String[]{"CvMat*", "CvArr*", "CvMat*", "CvRect"})).put(new Info(new String[]{"cvZero"}).cppTypes(new String[]{"void", "CvArr*"})).put(new Info(new String[]{"cvCvtScale", "cvScale", "cvCvtScaleAbs"}).cppTypes(new String[]{"void", "CvArr*", "CvArr*", "double", "double"})).put(new Info(new String[]{"cvConvert", "cvT"}).cppTypes(new String[]{"void", "CvArr*", "CvArr*"})).put(new Info(new String[]{"cvCheckArray"}).cppTypes(new String[]{"int", "CvArr*", "int", "double", "double"})).put(new Info(new String[]{"cvMatMulAdd"}).cppTypes(new String[]{"void", "CvArr*", "CvArr*", "CvArr*", "CvArr*"})).put(new Info(new String[]{"cvMatMul"}).cppTypes(new String[]{"void", "CvArr*", "CvArr*", "CvArr*"})).put(new Info(new String[]{"cvMatMulAddEx"}).cppTypes(new String[]{"void", "CvArr*", "CvArr*", "double", "CvArr*", "double", "CvArr*", "int"})).put(new Info(new String[]{"cvMatMulAddS"}).cppTypes(new String[]{"void", "CvArr*", "CvArr*", "CvMat*", "CvMat*"})).put(new Info(new String[]{"cvMirror", "cvInv"}).cppTypes(new String[]{"void", "CvArr*", "CvArr*", "int"})).put(new Info(new String[]{"cvMahalonobis"}).cppTypes(new String[]{"double", "CvArr*", "CvArr*", "CvArr*"})).put(new Info(new String[]{"cvFFT"}).cppTypes(new String[]{"void", "CvArr*", "CvArr*", "int", "int"})).put(new Info(new String[]{"cvGraphFindEdge"}).cppTypes(new String[]{"CvGraphEdge*", "CvGraph*", "int", "int"})).put(new Info(new String[]{"cvGraphFindEdgeByPtr"}).cppTypes(new String[]{"CvGraphEdge*", "CvGraph*", "CvGraphVtx*", "CvGraphVtx*"})).put(new Info(new String[]{"cvDrawRect", "cvDrawLine"}).cppTypes(new String[]{"void", "CvArr*", "CvPoint", "CvPoint", "CvScalar", "int", "int", "int"})).put(new Info(new String[]{"cvDrawCircle"}).cppTypes(new String[]{"void", "CvArr*", "CvPoint", "int", "CvScalar", "int", "int", "int"})).put(new Info(new String[]{"cvDrawEllipse"}).cppTypes(new String[]{"void", "CvArr*", "CvPoint", "CvSize", "double", "double", "double", "CvScalar", "int", "int", "int"})).put(new Info(new String[]{"cvDrawPolyLine"}).cppTypes(new String[]{"void", "CvArr*", "CvPoint**", "int*", "int", "int", "CvScalar", "int", "int", "int"})).put(new Info(new String[]{"__CV_BEGIN__", "__CV_END__", "__CV_EXIT__"}).cppTypes(new String[0])).put(new Info(new String[]{"uchar"}).cast().valueTypes(new String[]{"byte"}).pointerTypes(new String[]{"BytePointer", "ByteBuffer", "byte[]"})).put(new Info(new String[]{"std::vector<std::vector<char> >", "std::vector<std::vector<uchar> >", "std::vector<std::vector<cv::uint8_t> >"}).cast().pointerTypes(new String[]{"ByteVectorVector"}).define()).put(new Info(new String[]{"std::vector<std::vector<int> >"}).pointerTypes(new String[]{"IntVectorVector"}).define()).put(new Info(new String[]{"std::vector<std::vector<float> >"}).pointerTypes(new String[]{"FloatVectorVector"}).define()).put(new Info(new String[]{"std::vector<cv::String>", "std::vector<std::string>"}).pointerTypes(new String[]{"StringVector"}).define()).put(new Info(new String[]{"std::vector<cv::Point>"}).pointerTypes(new String[]{"PointVector"}).define()).put(new Info(new String[]{"std::vector<cv::Point2f>"}).pointerTypes(new String[]{"Point2fVector"}).define()).put(new Info(new String[]{"std::vector<cv::Point2d>"}).pointerTypes(new String[]{"Point2dVector"}).define()).put(new Info(new String[]{"std::vector<cv::Point3i>", "std::vector<cv::Vec3i>"}).cast().pointerTypes(new String[]{"Point3iVector"}).define()).put(new Info(new String[]{"std::vector<cv::Point3f>"}).cast().pointerTypes(new String[]{"Point3fVector"}).define()).put(new Info(new String[]{"std::vector<cv::Size>"}).pointerTypes(new String[]{"SizeVector"}).define()).put(new Info(new String[]{"std::vector<cv::Rect>"}).pointerTypes(new String[]{"RectVector"}).define()).put(new Info(new String[]{"std::vector<cv::Rect2d>"}).pointerTypes(new String[]{"Rect2dVector"}).define()).put(new Info(new String[]{"std::vector<cv::Scalar>"}).pointerTypes(new String[]{"ScalarVector"}).define()).put(new Info(new String[]{"std::vector<cv::KeyPoint>"}).pointerTypes(new String[]{"KeyPointVector"}).define()).put(new Info(new String[]{"std::vector<cv::DMatch>"}).pointerTypes(new String[]{"DMatchVector"}).define()).put(new Info(new String[]{"std::vector<cv::Range>"}).pointerTypes(new String[]{"RangeVector"}).define()).put(new Info(new String[]{"std::vector<std::vector<cv::Point> >"}).pointerTypes(new String[]{"PointVectorVector"}).define()).put(new Info(new String[]{"std::vector<std::vector<cv::Point2f> >"}).pointerTypes(new String[]{"Point2fVectorVector"}).define()).put(new Info(new String[]{"std::vector<std::vector<cv::Point2d> >"}).pointerTypes(new String[]{"Point2dVectorVector"}).define()).put(new Info(new String[]{"std::vector<std::vector<cv::Point3f> >"}).pointerTypes(new String[]{"Point3fVectorVector"}).define()).put(new Info(new String[]{"std::vector<std::vector<cv::Rect> >"}).pointerTypes(new String[]{"RectVectorVector"}).define()).put(new Info(new String[]{"std::vector<std::vector<cv::KeyPoint> >"}).pointerTypes(new String[]{"KeyPointVectorVector"}).define()).put(new Info(new String[]{"std::vector<std::vector<cv::DMatch> >"}).pointerTypes(new String[]{"DMatchVectorVector"}).define()).put(new Info(new String[]{"std::vector<cv::Mat>"}).pointerTypes(new String[]{"MatVector"}).define()).put(new Info(new String[]{"std::vector<cv::UMat>"}).pointerTypes(new String[]{"UMatVector"}).define()).put(new Info(new String[]{"std::vector<cv::cuda::GpuMat>"}).pointerTypes(new String[]{"GpuMatVector"}).define()).put(new Info(new String[]{"std::vector<std::vector<cv::Mat> >"}).pointerTypes(new String[]{"MatVectorVector"}).define()).put(new Info(new String[]{"std::pair<int,int>"}).pointerTypes(new String[]{"IntIntPair"}).define()).put(new Info(new String[]{"std::map<int,double>"}).pointerTypes(new String[]{"IntDoubleMap"}).define()).put(new Info(new String[]{"std::vector<std::pair<int,double> >"}).pointerTypes(new String[]{"IntDoublePairVector"}).define()).put(new Info(new String[]{"std::vector<std::pair<int,int> >"}).pointerTypes(new String[]{"IntIntPairVector"}).define()).put(new Info(new String[]{"std::vector<std::pair<cv::Mat,uchar> >"}).pointerTypes(new String[]{"MatBytePairVector"}).define()).put(new Info(new String[]{"std::vector<std::pair<cv::UMat,uchar> >"}).pointerTypes(new String[]{"UMatBytePairVector"}).define()).put(new Info(new String[]{"std::vector<cv::instr::NodeDataTls*>"}).pointerTypes(new String[]{"NodeDataTlsVector"}).define()).put(new Info(new String[]{"cv::TLSData<cv::instr::NodeDataTls>"}).pointerTypes(new String[]{"NodeDataTlsData"}).define()).put(new Info(new String[]{"cv::Node<cv::instr::NodeData>"}).pointerTypes(new String[]{"InstrNode"}).define()).put(new Info(new String[]{"cv::instr::NodeData::m_tls"}).javaText("@MemberGetter public native @ByRef NodeDataTlsData m_tls();")).put(new Info(new String[]{"cv::SparseMat::Node"}).pointerTypes(new String[]{"SparseMat.Node"})).put(new Info(new String[]{"cv::ml::DTrees::Node"}).pointerTypes(new String[]{"DTrees.Node"})).put(new Info(new String[]{"cv::randu<int>"}).javaNames(new String[]{"intRand"})).put(new Info(new String[]{"cv::randu<float>"}).javaNames(new String[]{"floatRand"})).put(new Info(new String[]{"cv::randu<double>"}).javaNames(new String[]{"doubleRand"})).put(new Info(new String[]{"CvModule::first", "CvModule::last", "CvType::first", "CvType::last", "cv::fromUtf16", "cv::toUtf16", "cv::Exception", "cv::Allocator", "cv::DataDepth", "cv::DataType", "cv::ParamType", "cv::_InputArray", "cv::_OutputArray", "cv::Mat_", "cv::SparseMat_", "cv::Matx_AddOp", "cv::Matx_SubOp", "cv::Matx_ScaleOp", "cv::Matx_MulOp", "cv::Matx_MatMulOp", "cv::Matx_TOp", "cv::Matx", "cv::Vec", "cv::MatIterator_", "cv::MatConstIterator_", "cv::Mat::MSize", "cv::Mat::MStep", "cv::MatCommaInitializer_", "cv::MatxCommaInitializer", "cv::VecCommaInitializer", "cv::MatConstIterator(cv::Mat*, int*)", "cv::SparseMatIterator(cv::SparseMat*, int*)", "cv::SparseMatIterator_", "cv::SparseMatConstIterator_", "cv::SparseMatConstIterator::operator --", "cv::AlgorithmInfoData", "cv::AlgorithmInfo::addParam", "cv::CommandLineParser", "cv::cvStartWriteRawData_Base64", "cv::cvWriteRawData_Base64", "cv::cvEndWriteRawData_Base64", "cv::cvWriteMat_Base64", "cv::cvWriteMatND_Base64", "cv::FileStorage::Impl"}).skip()).put(new Info(new String[]{"cv::AutoBuffer<double>", "std::shared_ptr<void>", "std::type_index"}).cast().pointerTypes(new String[]{"Pointer"})).put(new Info(new String[]{"cv::Mat"}).base("AbstractMat")).put(new Info(new String[]{"cv::noArray()"}).javaText("public static Mat noArray() { return null; }")).put(new Info(new String[]{"cv::Mat(int, int, int, void*, size_t)"}).javaText("public Mat(int rows, int cols, int type, Pointer data, @Cast(\"size_t\") long step/*=AUTO_STEP*/) { super((Pointer)null); allocate(rows, cols, type, data, step); this.pointer = data; }\nprivate native void allocate(int rows, int cols, int type, Pointer data, @Cast(\"size_t\") long step/*=AUTO_STEP*/);\nprivate Pointer pointer; // a reference to prevent deallocation\n/** Calls {@link #Mat(int, int, int, Pointer, long) Mat(rows, cols, type, data, AUTO_STEP)} as with {@link #Mat(int, int, int, Pointer, boolean) Mat(rows, cols, type, data, false)}. */\npublic Mat(int rows, int cols, int type, Pointer data) { this(rows, cols, type, data, AUTO_STEP); }\npublic Mat(CvArr arr) { super(cvarrToMat(arr)); this.pointer = arr; }\n/** Warning: If {@code copyData} is false, the data of the OpenCV Mat returned by this constructor is externally allocated from OpenCV point of view,\n *  and will not benefit from OpenCV reference counting feature. One must ensure that the data does not get implicitly or explicitly deallocated when\n *  another Mat has been created pointing to the same data with, e.g., reshape(), rowRange(), etc... */\npublic Mat(int rows, int cols, int type, Pointer data, boolean copyData) { super((Pointer)null);\n    if (copyData) { allocate(rows, cols, type); data().put(data); } else { allocate(rows, cols, type, data, AUTO_STEP); this.pointer = data; }\n}\n/** Calls {@link #Mat(int, int, int, Pointer, boolean) Mat((int)Math.min(data.limit() - data.position(), Integer.MAX_VALUE), 1, type, data, copyData)}. */\npublic Mat(int type, Pointer data, boolean copyData) { this((int)Math.min(data.limit() - data.position(), Integer.MAX_VALUE), 1, type, data, copyData); }\n/** Calls {@link #Mat(int, Pointer, boolean) Mat(CV_32SC2, points, copyData)}. */ public Mat(Point points, boolean copyData) { this(CV_32SC2, points, copyData); }\n/** Calls {@link #Mat(int, Pointer, boolean) Mat(CV_32FC2, points, copyData)}. */ public Mat(Point2f points, boolean copyData) { this(CV_32FC2, points, copyData); }\n/** Calls {@link #Mat(int, Pointer, boolean) Mat(CV_64FC2, points, copyData)}. */ public Mat(Point2d points, boolean copyData) { this(CV_64FC2, points, copyData); }\n/** Calls {@link #Mat(int, Pointer, boolean) Mat(CV_32SC3, points, copyData)}. */ public Mat(Point3i points, boolean copyData) { this(CV_32SC3, points, copyData); }\n/** Calls {@link #Mat(int, Pointer, boolean) Mat(CV_32FC3, points, copyData)}. */ public Mat(Point3f points, boolean copyData) { this(CV_32FC3, points, copyData); }\n/** Calls {@link #Mat(int, Pointer, boolean) Mat(CV_64FC3, points, copyData)}. */ public Mat(Point3d points, boolean copyData) { this(CV_64FC3, points, copyData); }\n/** Calls {@link #Mat(int, Pointer, boolean) Mat(CV_64FC4, scalar, copyData)}. */ public Mat(Scalar scalar, boolean copyData) { this(CV_64FC4, scalar, copyData); }\n/** Calls {@link #Mat(int, Pointer, boolean) Mat(CV_32SC4, scalar, copyData)}. */ public Mat(Scalar4i scalar, boolean copyData) { this(CV_32SC4, scalar, copyData); }\n/** Calls {@link #Mat(Point, boolean) Mat(points, false)}. */    public Mat(Point points)    { this(points, false); }\n/** Calls {@link #Mat(Point2f, boolean) Mat(points, false)}. */  public Mat(Point2f points)  { this(points, false); }\n/** Calls {@link #Mat(Point2d, boolean) Mat(points, false)}. */  public Mat(Point2d points)  { this(points, false); }\n/** Calls {@link #Mat(Point3i, boolean) Mat(points, false)}. */  public Mat(Point3i points)  { this(points, false); }\n/** Calls {@link #Mat(Point3f, boolean) Mat(points, false)}. */  public Mat(Point3f points)  { this(points, false); }\n/** Calls {@link #Mat(Point3d, boolean) Mat(points, false)}. */  public Mat(Point3d points)  { this(points, false); }\n/** Calls {@link #Mat(Scalar, boolean) Mat(scalar, false)}. */   public Mat(Scalar scalar)   { this(scalar, false); }\n/** Calls {@link #Mat(Scalar4i, boolean) Mat(scalar, false)}. */ public Mat(Scalar4i scalar) { this(scalar, false); }\npublic Mat(byte ... b) { this(b, false); }\npublic Mat(short ... s) { this(s, false); }\npublic Mat(byte[] b, boolean signed) { this(b.length, 1, signed ? CV_8SC1 : CV_8UC1); data().put(b); }\npublic Mat(short[] s, boolean signed) { this(s.length, 1, signed ? CV_16SC1 : CV_16UC1); new ShortPointer(data()).put(s); }\npublic Mat(int ... n) { this(n.length, 1, CV_32SC1); new IntPointer(data()).put(n); }\npublic Mat(double ... d) { this(d.length, 1, CV_64FC1); new DoublePointer(data()).put(d); }\npublic Mat(float ... f) { this(f.length, 1, CV_32FC1); new FloatPointer(data()).put(f); }\n/** Calls {@link #Mat(BytePointer, boolean) Mat(p, false)}. */   public Mat(BytePointer p) { this(p, false); }\n/** Calls {@link #Mat(ShortPointer, boolean) Mat(p, false)}. */  public Mat(ShortPointer p) { this(p, false); }\n/** Calls {@link #Mat(BytePointer, boolean, boolean) Mat(p, signed, false)}. */  public Mat(BytePointer p, boolean signed) { this(p, signed, false); }\n/** Calls {@link #Mat(ShortPointer, boolean, boolean) Mat(p, signed, false)}. */ public Mat(ShortPointer p, boolean signed) { this(p, signed, false); }\n/** Calls {@link #Mat(IntPointer, boolean) Mat(p, false)}. */    public Mat(IntPointer p) { this(p, false); }\n/** Calls {@link #Mat(FloatPointer, boolean) Mat(p, false)}. */  public Mat(FloatPointer p) { this(p, false); }\n/** Calls {@link #Mat(DoublePointer, boolean) Mat(p, false)}. */ public Mat(DoublePointer p) { this(p, false); }\n/** Calls {@link #Mat(int, Pointer, boolean) Mat(signed ? CV_8SC1 : CV_8UC1, p, copyData)}. */   public Mat(BytePointer p, boolean signed, boolean copyData) { this(signed ? CV_8SC1 : CV_8UC1, p, copyData); }\n/** Calls {@link #Mat(int, Pointer, boolean) Mat(signed ? CV_16SC1 : CV_16UC1, p, copyData)}. */ public Mat(ShortPointer p, boolean signed, boolean copyData) { this(signed ? CV_16SC1 : CV_16UC1, p, copyData); }\n/** Calls {@link #Mat(int, Pointer, boolean) Mat(CV_32SC1, p, copyData)}. */ public Mat(IntPointer p, boolean copyData) { this(CV_32SC1, p, copyData); }\n/** Calls {@link #Mat(int, Pointer, boolean) Mat(CV_32FC1, p, copyData)}. */ public Mat(FloatPointer p, boolean copyData) { this(CV_32FC1, p, copyData); }\n/** Calls {@link #Mat(int, Pointer, boolean) Mat(CV_64FC1, p, copyData)}. */ public Mat(DoublePointer p, boolean copyData) { this(CV_64FC1, p, copyData); }\n")).put(new Info(new String[]{"cv::Mat::zeros(int, int*, int)", "cv::Mat::ones(int, int*, int)"}).skip()).put(new Info(new String[]{"cv::Mat::size"}).javaText("public native @ByVal Size size();\n@MemberGetter public native int size(int i);")).put(new Info(new String[]{"cv::Mat::step"}).javaText("@MemberGetter public native long step();\n@MemberGetter public native long step(int i);")).put(new Info(new String[]{"cv::UMat::zeros(int, int*, int)", "cv::UMat::ones(int, int*, int)"}).skip()).put(new Info(new String[]{"cv::UMat::size"}).javaText("public native @ByVal Size size();\n@MemberGetter public native int size(int i);")).put(new Info(new String[]{"cv::UMat::step"}).javaText("@MemberGetter public native long step();\n@MemberGetter public native long step(int i);")).put(new Info(new String[]{"cv::DefaultDeleter<CvMat>"}).pointerTypes(new String[]{"CvMatDefaultDeleter"})).put(new Info(new String[]{"std::initializer_list", "std::lock_guard", "std::recursive_mutex", "_InputArray::KindFlag"}).skip()).put(new Info(new String[]{"cv::InputArray", "cv::OutputArray", "cv::InputOutputArray", "cv::_InputOutputArray"}).skip().pointerTypes(new String[]{"Mat", "Mat", "Mat", "UMat", "UMat", "UMat", "GpuMat", "GpuMat", "GpuMat"})).put(new Info(new String[]{"cv::InputArrayOfArrays", "cv::OutputArrayOfArrays", "cv::InputOutputArrayOfArrays"}).skip().pointerTypes(new String[]{"MatVector", "UMatVector", "GpuMatVector"})).put(new Info(new String[]{"cv::cuda::GpuMatND::SizeArray", "cv::cuda::GpuMatND::IndexArray"}).annotations(new String[]{"@StdVector"}).valueTypes(new String[]{"IntPointer", "IntBuffer", "int[]"})).put(new Info(new String[]{"cv::cuda::GpuMatND::StepArray"}).annotations(new String[]{"@StdVector"}).valueTypes(new String[]{"SizeTPointer"})).put(new Info(new String[]{"cv::traits::Depth", "cv::traits::Type"}).skip()).put(new Info(new String[]{"cv::Complex<float>"}).pointerTypes(new String[]{"Complexf"}).base("FloatPointer")).put(new Info(new String[]{"cv::Complex<double>"}).pointerTypes(new String[]{"Complexd"}).base("DoublePointer")).put(new Info(new String[]{"cv::Point_<int>"}).pointerTypes(new String[]{"Point"}).base("IntPointer")).put(new Info(new String[]{"cv::Point_<float>"}).pointerTypes(new String[]{"Point2f"}).base("FloatPointer")).put(new Info(new String[]{"cv::Point_<double>"}).pointerTypes(new String[]{"Point2d"}).base("DoublePointer")).put(new Info(new String[]{"cv::Point3_<int>"}).pointerTypes(new String[]{"Point3i"}).base("IntPointer")).put(new Info(new String[]{"cv::Point3_<float>"}).pointerTypes(new String[]{"Point3f"}).base("FloatPointer")).put(new Info(new String[]{"cv::Point3_<double>"}).pointerTypes(new String[]{"Point3d"}).base("DoublePointer")).put(new Info(new String[]{"cv::Size_<int>"}).pointerTypes(new String[]{"Size"}).base("IntPointer")).put(new Info(new String[]{"cv::Size_<float>"}).pointerTypes(new String[]{"Size2f"}).base("FloatPointer")).put(new Info(new String[]{"cv::Size_<double>"}).pointerTypes(new String[]{"Size2d"}).base("DoublePointer")).put(new Info(new String[]{"cv::Rect_<int>"}).pointerTypes(new String[]{"Rect"}).base("IntPointer")).put(new Info(new String[]{"cv::Rect_<float>"}).pointerTypes(new String[]{"Rect2f"}).base("FloatPointer")).put(new Info(new String[]{"cv::Rect_<double>"}).pointerTypes(new String[]{"Rect2d"}).base("DoublePointer")).put(new Info(new String[]{"cv::RotatedRect"}).pointerTypes(new String[]{"RotatedRect"}).base("FloatPointer")).put(new Info(new String[]{"cv::Scalar_<double>"}).pointerTypes(new String[]{"Scalar"}).base("AbstractScalar")).put(new Info(new String[]{"cv::Scalar_<int>"}).pointerTypes(new String[]{"Scalar4i"}).base("IntPointer")).put(new Info(new String[]{"cv::Scalar_<float>"}).pointerTypes(new String[]{"Scalar4f"}).base("FloatPointer")).put(new Info(new String[]{"cv::Vec2i"}).cast().pointerTypes(new String[]{"Point"})).put(new Info(new String[]{"cv::Vec2f"}).cast().pointerTypes(new String[]{"Point2f"})).put(new Info(new String[]{"cv::Vec2d"}).cast().pointerTypes(new String[]{"Point2d"})).put(new Info(new String[]{"cv::Vec3i"}).cast().pointerTypes(new String[]{"Point3i"})).put(new Info(new String[]{"cv::Vec3f"}).cast().pointerTypes(new String[]{"Point3f"})).put(new Info(new String[]{"cv::Vec3d"}).cast().pointerTypes(new String[]{"Point3d"})).put(new Info(new String[]{"cv::Vec4i"}).cast().pointerTypes(new String[]{"Scalar4i"})).put(new Info(new String[]{"cv::Vec4f"}).cast().pointerTypes(new String[]{"Scalar4f"})).put(new Info(new String[]{"cv::Vec4d"}).cast().pointerTypes(new String[]{"Scalar"})).put(new Info(new String[]{"defined __INTEL_COMPILER && !(defined WIN32 || defined _WIN32)", "defined __GNUC__", "defined WIN32 || defined _WIN32 || defined WINCE"}).define(false)).put(new Info(new String[]{"cv::saturate_cast<uchar>"}).javaNames(new String[]{"ucharSaturateCast"})).put(new Info(new String[]{"cv::saturate_cast<schar>"}).javaNames(new String[]{"scharSaturateCast"})).put(new Info(new String[]{"cv::saturate_cast<ushort>"}).javaNames(new String[]{"ushortSaturateCast"})).put(new Info(new String[]{"cv::saturate_cast<short>"}).javaNames(new String[]{"shortSaturateCast"})).put(new Info(new String[]{"cv::saturate_cast<int>"}).javaNames(new String[]{"intSaturate"})).put(new Info(new String[]{"cv::saturate_cast<unsigned>"}).javaNames(new String[]{"unsignedSaturateCast"})).put(new Info(new String[]{"cv::saturate_cast<uint64>"}).javaNames(new String[]{"uint64SaturateCast"})).put(new Info(new String[]{"cv::saturate_cast<int64>"}).javaNames(new String[]{"int64SaturateCast"})).put(new Info(new String[]{"cv::saturate_cast<cv::float16_t>", "saturate_cast<float16_t>"}).javaNames(new String[]{"float16SaturateCast"})).put(new Info(new String[]{"cv::normL2Sqr", "cv::normL1", "cv::seqPopMulti"}).skip()).put(new Info(new String[]{"cv::Formatted(cv::Mat&, cv::Formatter*, int*)"}).javaText("public Formatted(@Const @ByRef Mat m, @Const Formatter fmt,\n              @StdVector IntPointer params) { allocate(m, fmt, params); }\nprivate native void allocate(@Const @ByRef Mat m, @Const Formatter fmt,\n              @Cast({\"\", \"std::vector<int>&\"}) @StdVector IntPointer params);")).put(new Info(new String[]{"cv::MinProblemSolver", "cv::DownhillSolver", "cv::ConjGradSolver"}).purify()).put(new Info(new String[]{"cv::MinProblemSolver::Function"}).virtualize()).put(new Info(new String[]{"HAVE_OPENCV_CUDAOPTFLOW", "HAVE_OPENCV_CUDAWARPING", "HAVE_OPENCV_CUDALEGACY", "HAVE_OPENCV_XFEATURES2D", "defined(HAVE_OPENCV_CUDAWARPING)", "defined(HAVE_OPENCV_CUDAIMGPROC) && defined(HAVE_OPENCV_CUDAOPTFLOW)", "defined(HAVE_OPENCV_CUDA) && defined(HAVE_OPENCV_CUDAWARPING)"}).define(false)).put(new Info(new String[]{"operator cv::cuda::Stream::bool_type", "cv::cuda::convertFp16"}).skip()).put(new Info(new String[]{"cv::min(cv::InputArray, cv::InputArray, cv::OutputArray)", "cv::max(cv::InputArray, cv::InputArray, cv::OutputArray)"}).skip()).put(new Info(new String[]{"std::function<void(const cv::Range&)>"}).pointerTypes(new String[]{"Functor"})).put(new Info(new String[]{"cv::Ptr"}).skip().annotations(new String[]{"@Ptr"})).put(new Info(new String[]{"cv::String"}).skip().annotations(new String[]{"@Str"}).valueTypes(new String[]{"BytePointer", "String"})).put(new Info(new String[]{"cv::Algorithm"}).upcast()).put(new Info(new String[]{"cv::read<int>", "cv::read<float>", "cv::read<double>"}).define()).put(new Info(new String[]{"cv::read<int>(const cv::FileNode&, cv::Complex<int>&, const cv::Complex<int>&)"}).skip()).put(new Info(new String[]{"cv::read<_Tp,std>(const cv::FileNode&, _Tp&, const _Tp&)"}).skip()).put(new Info(new String[]{"cv::Algorithm::read"}));
        for (String c : new String[]{"int", "float", "double", "cv::String"}) {
            infoMap.put(new Info(new String[]{"cv::write<" + c + ">(cv::FileStorage&, const _Tp&)", "cv::write<" + c + ">(cv::FileStorage&, const " + c + "&)"}).define());
        }
        for (String c : new String[]{"cv::Point_", "cv::Point3_", "cv::Size_", "cv::Complex", "cv::Rect_", "cv::Scalar_"}) {
            for (String t : new String[]{"int", "float", "double"}) {
                if (c.equals("cv::Complex") && t.equals("int")) continue;
                infoMap.put(new Info(new String[]{"cv::write<" + c + "<" + t + "> >(cv::FileStorage&, const cv::String&, const _Tp&)", "cv::write<" + c + "<" + t + "> >(cv::FileStorage&, const cv::String&, const " + c + "<" + t + ">&)", "cv::write<" + c + "<" + t + "> >(cv::FileStorage&, const _Tp&)", "cv::write<" + c + "<" + t + "> >(cv::FileStorage&, const " + c + "<" + t + ">&)"}).define());
            }
        }
        for (String c : infoMap.keySet().toArray(new String[0])) {
            if (!c.startsWith("std::vector<")) continue;
            c = c.substring(12, c.length() - 1);
            infoMap.put(new Info(new String[]{"cv::write<" + c + (c.endsWith(">") ? " " : "") + ">(cv::FileStorage&, const std::vector<_Tp>&)", "cv::write<" + c + (c.endsWith(">") ? " " : "") + ">(cv::FileStorage&, const " + c + "&)", "cv::write<" + c + (c.endsWith(">") ? " " : "") + ">(cv::FileStorage&, const cv::String&, const std::vector<_Tp>&)", "cv::write<" + c + (c.endsWith(">") ? " " : "") + ">(cv::FileStorage&, const cv::String&, const " + c + "&)", "cv::read<" + c + (c.endsWith(">") ? " " : "") + ">(const cv::FileNode&, std::vector<_Tp>&, const std::vector<_Tp>&)", "cv::read<" + c + (c.endsWith(">") ? " " : "") + ">(const cv::FileNode&, " + c + "&, const " + c + "&)"}).define());
        }
    }

    static {
        Loader.checkVersion((String)"org.bytedeco", (String)"opencv");
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD, ElementType.PARAMETER})
    @Cast(value={"cv::String&"})
    @Adapter(value="StrAdapter")
    public static @interface Str {
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD, ElementType.PARAMETER})
    @Cast(value={"cv::Ptr", "&"})
    @Adapter(value="PtrAdapter")
    public static @interface Ptr {
        public String value() default "";
    }

    public static class Functor
    extends FunctionPointer {
        public Functor(Pointer p) {
            super(p);
        }

        protected Functor() {
            this.allocate();
        }

        private native void allocate();

        public native void call(@ByRef @Cast(value={"const cv::Range*"}) Pointer var1);

        static {
            Loader.load();
        }
    }
}

