// Targeted by JavaCPP version 1.5.10: DO NOT EDIT THIS FILE

package org.bytedeco.opencv.global;

import org.bytedeco.opencv.opencv_aruco.*;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import static org.bytedeco.openblas.global.openblas_nolapack.*;
import static org.bytedeco.openblas.global.openblas.*;
import org.bytedeco.opencv.opencv_core.*;
import static org.bytedeco.opencv.global.opencv_core.*;
import org.bytedeco.opencv.opencv_imgproc.*;
import static org.bytedeco.opencv.global.opencv_imgproc.*;
import static org.bytedeco.opencv.global.opencv_imgcodecs.*;
import org.bytedeco.opencv.opencv_videoio.*;
import static org.bytedeco.opencv.global.opencv_videoio.*;
import org.bytedeco.opencv.opencv_highgui.*;
import static org.bytedeco.opencv.global.opencv_highgui.*;
import org.bytedeco.opencv.opencv_flann.*;
import static org.bytedeco.opencv.global.opencv_flann.*;
import org.bytedeco.opencv.opencv_features2d.*;
import static org.bytedeco.opencv.global.opencv_features2d.*;
import org.bytedeco.opencv.opencv_calib3d.*;
import static org.bytedeco.opencv.global.opencv_calib3d.*;
import org.bytedeco.opencv.opencv_dnn.*;
import static org.bytedeco.opencv.global.opencv_dnn.*;
import org.bytedeco.opencv.opencv_objdetect.*;
import static org.bytedeco.opencv.global.opencv_objdetect.*;

public class opencv_aruco extends org.bytedeco.opencv.presets.opencv_aruco {
    static { Loader.load(); }

// Parsed from <opencv2/aruco.hpp>

// This file is part of OpenCV project.
// It is subject to the license terms in the LICENSE file found in the top-level directory
// of this distribution and at http://opencv.org/license.html
// #ifndef OPENCV_ARUCO_HPP
// #define OPENCV_ARUCO_HPP

// #include "opencv2/objdetect/aruco_detector.hpp"
// #include "opencv2/aruco/aruco_calib.hpp"

/**
 * \defgroup aruco Aruco markers, module functionality was moved to objdetect module
 * \{
 * ArUco Marker Detection, module functionality was moved to objdetect module
 * @see ArucoDetector, CharucoDetector, Board, GridBoard, CharucoBoard
 * \}
 */

/** \addtogroup aruco
/** \{
<p>
/** \brief detect markers
@deprecated Use class ArucoDetector::detectMarkers
*/
@Namespace("cv::aruco") public static native void detectMarkers(@ByVal Mat image, @Ptr Dictionary dictionary, @ByVal MatVector corners,
                                @ByVal Mat ids, @Ptr DetectorParameters parameters/*=makePtr<cv::aruco::DetectorParameters>()*/,
                                @ByVal(nullValue = "cv::OutputArrayOfArrays(cv::noArray())") MatVector rejectedImgPoints);
@Namespace("cv::aruco") public static native void detectMarkers(@ByVal Mat image, @Ptr Dictionary dictionary, @ByVal MatVector corners,
                                @ByVal Mat ids);
@Namespace("cv::aruco") public static native void detectMarkers(@ByVal Mat image, @Ptr Dictionary dictionary, @ByVal UMatVector corners,
                                @ByVal Mat ids, @Ptr DetectorParameters parameters/*=makePtr<cv::aruco::DetectorParameters>()*/,
                                @ByVal(nullValue = "cv::OutputArrayOfArrays(cv::noArray())") UMatVector rejectedImgPoints);
@Namespace("cv::aruco") public static native void detectMarkers(@ByVal Mat image, @Ptr Dictionary dictionary, @ByVal UMatVector corners,
                                @ByVal Mat ids);
@Namespace("cv::aruco") public static native void detectMarkers(@ByVal Mat image, @Ptr Dictionary dictionary, @ByVal GpuMatVector corners,
                                @ByVal Mat ids, @Ptr DetectorParameters parameters/*=makePtr<cv::aruco::DetectorParameters>()*/,
                                @ByVal(nullValue = "cv::OutputArrayOfArrays(cv::noArray())") GpuMatVector rejectedImgPoints);
@Namespace("cv::aruco") public static native void detectMarkers(@ByVal Mat image, @Ptr Dictionary dictionary, @ByVal GpuMatVector corners,
                                @ByVal Mat ids);
@Namespace("cv::aruco") public static native void detectMarkers(@ByVal UMat image, @Ptr Dictionary dictionary, @ByVal MatVector corners,
                                @ByVal UMat ids, @Ptr DetectorParameters parameters/*=makePtr<cv::aruco::DetectorParameters>()*/,
                                @ByVal(nullValue = "cv::OutputArrayOfArrays(cv::noArray())") MatVector rejectedImgPoints);
@Namespace("cv::aruco") public static native void detectMarkers(@ByVal UMat image, @Ptr Dictionary dictionary, @ByVal MatVector corners,
                                @ByVal UMat ids);
@Namespace("cv::aruco") public static native void detectMarkers(@ByVal UMat image, @Ptr Dictionary dictionary, @ByVal UMatVector corners,
                                @ByVal UMat ids, @Ptr DetectorParameters parameters/*=makePtr<cv::aruco::DetectorParameters>()*/,
                                @ByVal(nullValue = "cv::OutputArrayOfArrays(cv::noArray())") UMatVector rejectedImgPoints);
@Namespace("cv::aruco") public static native void detectMarkers(@ByVal UMat image, @Ptr Dictionary dictionary, @ByVal UMatVector corners,
                                @ByVal UMat ids);
@Namespace("cv::aruco") public static native void detectMarkers(@ByVal UMat image, @Ptr Dictionary dictionary, @ByVal GpuMatVector corners,
                                @ByVal UMat ids, @Ptr DetectorParameters parameters/*=makePtr<cv::aruco::DetectorParameters>()*/,
                                @ByVal(nullValue = "cv::OutputArrayOfArrays(cv::noArray())") GpuMatVector rejectedImgPoints);
@Namespace("cv::aruco") public static native void detectMarkers(@ByVal UMat image, @Ptr Dictionary dictionary, @ByVal GpuMatVector corners,
                                @ByVal UMat ids);
@Namespace("cv::aruco") public static native void detectMarkers(@ByVal GpuMat image, @Ptr Dictionary dictionary, @ByVal MatVector corners,
                                @ByVal GpuMat ids, @Ptr DetectorParameters parameters/*=makePtr<cv::aruco::DetectorParameters>()*/,
                                @ByVal(nullValue = "cv::OutputArrayOfArrays(cv::noArray())") MatVector rejectedImgPoints);
@Namespace("cv::aruco") public static native void detectMarkers(@ByVal GpuMat image, @Ptr Dictionary dictionary, @ByVal MatVector corners,
                                @ByVal GpuMat ids);
@Namespace("cv::aruco") public static native void detectMarkers(@ByVal GpuMat image, @Ptr Dictionary dictionary, @ByVal UMatVector corners,
                                @ByVal GpuMat ids, @Ptr DetectorParameters parameters/*=makePtr<cv::aruco::DetectorParameters>()*/,
                                @ByVal(nullValue = "cv::OutputArrayOfArrays(cv::noArray())") UMatVector rejectedImgPoints);
@Namespace("cv::aruco") public static native void detectMarkers(@ByVal GpuMat image, @Ptr Dictionary dictionary, @ByVal UMatVector corners,
                                @ByVal GpuMat ids);
@Namespace("cv::aruco") public static native void detectMarkers(@ByVal GpuMat image, @Ptr Dictionary dictionary, @ByVal GpuMatVector corners,
                                @ByVal GpuMat ids, @Ptr DetectorParameters parameters/*=makePtr<cv::aruco::DetectorParameters>()*/,
                                @ByVal(nullValue = "cv::OutputArrayOfArrays(cv::noArray())") GpuMatVector rejectedImgPoints);
@Namespace("cv::aruco") public static native void detectMarkers(@ByVal GpuMat image, @Ptr Dictionary dictionary, @ByVal GpuMatVector corners,
                                @ByVal GpuMat ids);

/** \brief refine detected markers
@deprecated Use class ArucoDetector::refineDetectedMarkers
*/
@Namespace("cv::aruco") public static native void refineDetectedMarkers(@ByVal Mat image,@Ptr Board board,
                                        @ByVal MatVector detectedCorners,
                                        @ByVal Mat detectedIds, @ByVal MatVector rejectedCorners,
                                        @ByVal(nullValue = "cv::InputArray(cv::noArray())") Mat cameraMatrix, @ByVal(nullValue = "cv::InputArray(cv::noArray())") Mat distCoeffs,
                                        float minRepDistance/*=10.f*/, float errorCorrectionRate/*=3.f*/,
                                        @Cast("bool") boolean checkAllOrders/*=true*/, @ByVal(nullValue = "cv::OutputArray(cv::noArray())") Mat recoveredIdxs,
                                        @Ptr DetectorParameters parameters/*=makePtr<cv::aruco::DetectorParameters>()*/);
@Namespace("cv::aruco") public static native void refineDetectedMarkers(@ByVal Mat image,@Ptr Board board,
                                        @ByVal MatVector detectedCorners,
                                        @ByVal Mat detectedIds, @ByVal MatVector rejectedCorners);
@Namespace("cv::aruco") public static native void refineDetectedMarkers(@ByVal Mat image,@Ptr Board board,
                                        @ByVal UMatVector detectedCorners,
                                        @ByVal Mat detectedIds, @ByVal UMatVector rejectedCorners,
                                        @ByVal(nullValue = "cv::InputArray(cv::noArray())") Mat cameraMatrix, @ByVal(nullValue = "cv::InputArray(cv::noArray())") Mat distCoeffs,
                                        float minRepDistance/*=10.f*/, float errorCorrectionRate/*=3.f*/,
                                        @Cast("bool") boolean checkAllOrders/*=true*/, @ByVal(nullValue = "cv::OutputArray(cv::noArray())") Mat recoveredIdxs,
                                        @Ptr DetectorParameters parameters/*=makePtr<cv::aruco::DetectorParameters>()*/);
@Namespace("cv::aruco") public static native void refineDetectedMarkers(@ByVal Mat image,@Ptr Board board,
                                        @ByVal UMatVector detectedCorners,
                                        @ByVal Mat detectedIds, @ByVal UMatVector rejectedCorners);
@Namespace("cv::aruco") public static native void refineDetectedMarkers(@ByVal Mat image,@Ptr Board board,
                                        @ByVal GpuMatVector detectedCorners,
                                        @ByVal Mat detectedIds, @ByVal GpuMatVector rejectedCorners,
                                        @ByVal(nullValue = "cv::InputArray(cv::noArray())") Mat cameraMatrix, @ByVal(nullValue = "cv::InputArray(cv::noArray())") Mat distCoeffs,
                                        float minRepDistance/*=10.f*/, float errorCorrectionRate/*=3.f*/,
                                        @Cast("bool") boolean checkAllOrders/*=true*/, @ByVal(nullValue = "cv::OutputArray(cv::noArray())") Mat recoveredIdxs,
                                        @Ptr DetectorParameters parameters/*=makePtr<cv::aruco::DetectorParameters>()*/);
@Namespace("cv::aruco") public static native void refineDetectedMarkers(@ByVal Mat image,@Ptr Board board,
                                        @ByVal GpuMatVector detectedCorners,
                                        @ByVal Mat detectedIds, @ByVal GpuMatVector rejectedCorners);
@Namespace("cv::aruco") public static native void refineDetectedMarkers(@ByVal UMat image,@Ptr Board board,
                                        @ByVal MatVector detectedCorners,
                                        @ByVal UMat detectedIds, @ByVal MatVector rejectedCorners,
                                        @ByVal(nullValue = "cv::InputArray(cv::noArray())") UMat cameraMatrix, @ByVal(nullValue = "cv::InputArray(cv::noArray())") UMat distCoeffs,
                                        float minRepDistance/*=10.f*/, float errorCorrectionRate/*=3.f*/,
                                        @Cast("bool") boolean checkAllOrders/*=true*/, @ByVal(nullValue = "cv::OutputArray(cv::noArray())") UMat recoveredIdxs,
                                        @Ptr DetectorParameters parameters/*=makePtr<cv::aruco::DetectorParameters>()*/);
@Namespace("cv::aruco") public static native void refineDetectedMarkers(@ByVal UMat image,@Ptr Board board,
                                        @ByVal MatVector detectedCorners,
                                        @ByVal UMat detectedIds, @ByVal MatVector rejectedCorners);
@Namespace("cv::aruco") public static native void refineDetectedMarkers(@ByVal UMat image,@Ptr Board board,
                                        @ByVal UMatVector detectedCorners,
                                        @ByVal UMat detectedIds, @ByVal UMatVector rejectedCorners,
                                        @ByVal(nullValue = "cv::InputArray(cv::noArray())") UMat cameraMatrix, @ByVal(nullValue = "cv::InputArray(cv::noArray())") UMat distCoeffs,
                                        float minRepDistance/*=10.f*/, float errorCorrectionRate/*=3.f*/,
                                        @Cast("bool") boolean checkAllOrders/*=true*/, @ByVal(nullValue = "cv::OutputArray(cv::noArray())") UMat recoveredIdxs,
                                        @Ptr DetectorParameters parameters/*=makePtr<cv::aruco::DetectorParameters>()*/);
@Namespace("cv::aruco") public static native void refineDetectedMarkers(@ByVal UMat image,@Ptr Board board,
                                        @ByVal UMatVector detectedCorners,
                                        @ByVal UMat detectedIds, @ByVal UMatVector rejectedCorners);
@Namespace("cv::aruco") public static native void refineDetectedMarkers(@ByVal UMat image,@Ptr Board board,
                                        @ByVal GpuMatVector detectedCorners,
                                        @ByVal UMat detectedIds, @ByVal GpuMatVector rejectedCorners,
                                        @ByVal(nullValue = "cv::InputArray(cv::noArray())") UMat cameraMatrix, @ByVal(nullValue = "cv::InputArray(cv::noArray())") UMat distCoeffs,
                                        float minRepDistance/*=10.f*/, float errorCorrectionRate/*=3.f*/,
                                        @Cast("bool") boolean checkAllOrders/*=true*/, @ByVal(nullValue = "cv::OutputArray(cv::noArray())") UMat recoveredIdxs,
                                        @Ptr DetectorParameters parameters/*=makePtr<cv::aruco::DetectorParameters>()*/);
@Namespace("cv::aruco") public static native void refineDetectedMarkers(@ByVal UMat image,@Ptr Board board,
                                        @ByVal GpuMatVector detectedCorners,
                                        @ByVal UMat detectedIds, @ByVal GpuMatVector rejectedCorners);
@Namespace("cv::aruco") public static native void refineDetectedMarkers(@ByVal GpuMat image,@Ptr Board board,
                                        @ByVal MatVector detectedCorners,
                                        @ByVal GpuMat detectedIds, @ByVal MatVector rejectedCorners,
                                        @ByVal(nullValue = "cv::InputArray(cv::noArray())") GpuMat cameraMatrix, @ByVal(nullValue = "cv::InputArray(cv::noArray())") GpuMat distCoeffs,
                                        float minRepDistance/*=10.f*/, float errorCorrectionRate/*=3.f*/,
                                        @Cast("bool") boolean checkAllOrders/*=true*/, @ByVal(nullValue = "cv::OutputArray(cv::noArray())") GpuMat recoveredIdxs,
                                        @Ptr DetectorParameters parameters/*=makePtr<cv::aruco::DetectorParameters>()*/);
@Namespace("cv::aruco") public static native void refineDetectedMarkers(@ByVal GpuMat image,@Ptr Board board,
                                        @ByVal MatVector detectedCorners,
                                        @ByVal GpuMat detectedIds, @ByVal MatVector rejectedCorners);
@Namespace("cv::aruco") public static native void refineDetectedMarkers(@ByVal GpuMat image,@Ptr Board board,
                                        @ByVal UMatVector detectedCorners,
                                        @ByVal GpuMat detectedIds, @ByVal UMatVector rejectedCorners,
                                        @ByVal(nullValue = "cv::InputArray(cv::noArray())") GpuMat cameraMatrix, @ByVal(nullValue = "cv::InputArray(cv::noArray())") GpuMat distCoeffs,
                                        float minRepDistance/*=10.f*/, float errorCorrectionRate/*=3.f*/,
                                        @Cast("bool") boolean checkAllOrders/*=true*/, @ByVal(nullValue = "cv::OutputArray(cv::noArray())") GpuMat recoveredIdxs,
                                        @Ptr DetectorParameters parameters/*=makePtr<cv::aruco::DetectorParameters>()*/);
@Namespace("cv::aruco") public static native void refineDetectedMarkers(@ByVal GpuMat image,@Ptr Board board,
                                        @ByVal UMatVector detectedCorners,
                                        @ByVal GpuMat detectedIds, @ByVal UMatVector rejectedCorners);
@Namespace("cv::aruco") public static native void refineDetectedMarkers(@ByVal GpuMat image,@Ptr Board board,
                                        @ByVal GpuMatVector detectedCorners,
                                        @ByVal GpuMat detectedIds, @ByVal GpuMatVector rejectedCorners,
                                        @ByVal(nullValue = "cv::InputArray(cv::noArray())") GpuMat cameraMatrix, @ByVal(nullValue = "cv::InputArray(cv::noArray())") GpuMat distCoeffs,
                                        float minRepDistance/*=10.f*/, float errorCorrectionRate/*=3.f*/,
                                        @Cast("bool") boolean checkAllOrders/*=true*/, @ByVal(nullValue = "cv::OutputArray(cv::noArray())") GpuMat recoveredIdxs,
                                        @Ptr DetectorParameters parameters/*=makePtr<cv::aruco::DetectorParameters>()*/);
@Namespace("cv::aruco") public static native void refineDetectedMarkers(@ByVal GpuMat image,@Ptr Board board,
                                        @ByVal GpuMatVector detectedCorners,
                                        @ByVal GpuMat detectedIds, @ByVal GpuMatVector rejectedCorners);

/** \brief draw planar board
@deprecated Use Board::generateImage
*/
@Namespace("cv::aruco") public static native void drawPlanarBoard(@Ptr Board board, @ByVal Size outSize, @ByVal Mat img, int marginSize,
                                  int borderBits);
@Namespace("cv::aruco") public static native void drawPlanarBoard(@Ptr Board board, @ByVal Size outSize, @ByVal UMat img, int marginSize,
                                  int borderBits);
@Namespace("cv::aruco") public static native void drawPlanarBoard(@Ptr Board board, @ByVal Size outSize, @ByVal GpuMat img, int marginSize,
                                  int borderBits);

/** \brief get board object and image points
@deprecated Use Board::matchImagePoints
*/
@Namespace("cv::aruco") public static native void getBoardObjectAndImagePoints(@Ptr Board board, @ByVal MatVector detectedCorners,
                                               @ByVal Mat detectedIds, @ByVal Mat objPoints, @ByVal Mat imgPoints);
@Namespace("cv::aruco") public static native void getBoardObjectAndImagePoints(@Ptr Board board, @ByVal UMatVector detectedCorners,
                                               @ByVal Mat detectedIds, @ByVal Mat objPoints, @ByVal Mat imgPoints);
@Namespace("cv::aruco") public static native void getBoardObjectAndImagePoints(@Ptr Board board, @ByVal GpuMatVector detectedCorners,
                                               @ByVal Mat detectedIds, @ByVal Mat objPoints, @ByVal Mat imgPoints);
@Namespace("cv::aruco") public static native void getBoardObjectAndImagePoints(@Ptr Board board, @ByVal MatVector detectedCorners,
                                               @ByVal UMat detectedIds, @ByVal UMat objPoints, @ByVal UMat imgPoints);
@Namespace("cv::aruco") public static native void getBoardObjectAndImagePoints(@Ptr Board board, @ByVal UMatVector detectedCorners,
                                               @ByVal UMat detectedIds, @ByVal UMat objPoints, @ByVal UMat imgPoints);
@Namespace("cv::aruco") public static native void getBoardObjectAndImagePoints(@Ptr Board board, @ByVal GpuMatVector detectedCorners,
                                               @ByVal UMat detectedIds, @ByVal UMat objPoints, @ByVal UMat imgPoints);
@Namespace("cv::aruco") public static native void getBoardObjectAndImagePoints(@Ptr Board board, @ByVal MatVector detectedCorners,
                                               @ByVal GpuMat detectedIds, @ByVal GpuMat objPoints, @ByVal GpuMat imgPoints);
@Namespace("cv::aruco") public static native void getBoardObjectAndImagePoints(@Ptr Board board, @ByVal UMatVector detectedCorners,
                                               @ByVal GpuMat detectedIds, @ByVal GpuMat objPoints, @ByVal GpuMat imgPoints);
@Namespace("cv::aruco") public static native void getBoardObjectAndImagePoints(@Ptr Board board, @ByVal GpuMatVector detectedCorners,
                                               @ByVal GpuMat detectedIds, @ByVal GpuMat objPoints, @ByVal GpuMat imgPoints);


/** @deprecated Use cv::solvePnP
 */
@Namespace("cv::aruco") public static native int estimatePoseBoard(@ByVal MatVector corners, @ByVal Mat ids, @Ptr Board board,
                                   @ByVal Mat cameraMatrix, @ByVal Mat distCoeffs, @ByVal Mat rvec,
                                   @ByVal Mat tvec, @Cast("bool") boolean useExtrinsicGuess/*=false*/);
@Namespace("cv::aruco") public static native int estimatePoseBoard(@ByVal MatVector corners, @ByVal Mat ids, @Ptr Board board,
                                   @ByVal Mat cameraMatrix, @ByVal Mat distCoeffs, @ByVal Mat rvec,
                                   @ByVal Mat tvec);
@Namespace("cv::aruco") public static native int estimatePoseBoard(@ByVal UMatVector corners, @ByVal Mat ids, @Ptr Board board,
                                   @ByVal Mat cameraMatrix, @ByVal Mat distCoeffs, @ByVal Mat rvec,
                                   @ByVal Mat tvec, @Cast("bool") boolean useExtrinsicGuess/*=false*/);
@Namespace("cv::aruco") public static native int estimatePoseBoard(@ByVal UMatVector corners, @ByVal Mat ids, @Ptr Board board,
                                   @ByVal Mat cameraMatrix, @ByVal Mat distCoeffs, @ByVal Mat rvec,
                                   @ByVal Mat tvec);
@Namespace("cv::aruco") public static native int estimatePoseBoard(@ByVal GpuMatVector corners, @ByVal Mat ids, @Ptr Board board,
                                   @ByVal Mat cameraMatrix, @ByVal Mat distCoeffs, @ByVal Mat rvec,
                                   @ByVal Mat tvec, @Cast("bool") boolean useExtrinsicGuess/*=false*/);
@Namespace("cv::aruco") public static native int estimatePoseBoard(@ByVal GpuMatVector corners, @ByVal Mat ids, @Ptr Board board,
                                   @ByVal Mat cameraMatrix, @ByVal Mat distCoeffs, @ByVal Mat rvec,
                                   @ByVal Mat tvec);
@Namespace("cv::aruco") public static native int estimatePoseBoard(@ByVal MatVector corners, @ByVal UMat ids, @Ptr Board board,
                                   @ByVal UMat cameraMatrix, @ByVal UMat distCoeffs, @ByVal UMat rvec,
                                   @ByVal UMat tvec, @Cast("bool") boolean useExtrinsicGuess/*=false*/);
@Namespace("cv::aruco") public static native int estimatePoseBoard(@ByVal MatVector corners, @ByVal UMat ids, @Ptr Board board,
                                   @ByVal UMat cameraMatrix, @ByVal UMat distCoeffs, @ByVal UMat rvec,
                                   @ByVal UMat tvec);
@Namespace("cv::aruco") public static native int estimatePoseBoard(@ByVal UMatVector corners, @ByVal UMat ids, @Ptr Board board,
                                   @ByVal UMat cameraMatrix, @ByVal UMat distCoeffs, @ByVal UMat rvec,
                                   @ByVal UMat tvec, @Cast("bool") boolean useExtrinsicGuess/*=false*/);
@Namespace("cv::aruco") public static native int estimatePoseBoard(@ByVal UMatVector corners, @ByVal UMat ids, @Ptr Board board,
                                   @ByVal UMat cameraMatrix, @ByVal UMat distCoeffs, @ByVal UMat rvec,
                                   @ByVal UMat tvec);
@Namespace("cv::aruco") public static native int estimatePoseBoard(@ByVal GpuMatVector corners, @ByVal UMat ids, @Ptr Board board,
                                   @ByVal UMat cameraMatrix, @ByVal UMat distCoeffs, @ByVal UMat rvec,
                                   @ByVal UMat tvec, @Cast("bool") boolean useExtrinsicGuess/*=false*/);
@Namespace("cv::aruco") public static native int estimatePoseBoard(@ByVal GpuMatVector corners, @ByVal UMat ids, @Ptr Board board,
                                   @ByVal UMat cameraMatrix, @ByVal UMat distCoeffs, @ByVal UMat rvec,
                                   @ByVal UMat tvec);
@Namespace("cv::aruco") public static native int estimatePoseBoard(@ByVal MatVector corners, @ByVal GpuMat ids, @Ptr Board board,
                                   @ByVal GpuMat cameraMatrix, @ByVal GpuMat distCoeffs, @ByVal GpuMat rvec,
                                   @ByVal GpuMat tvec, @Cast("bool") boolean useExtrinsicGuess/*=false*/);
@Namespace("cv::aruco") public static native int estimatePoseBoard(@ByVal MatVector corners, @ByVal GpuMat ids, @Ptr Board board,
                                   @ByVal GpuMat cameraMatrix, @ByVal GpuMat distCoeffs, @ByVal GpuMat rvec,
                                   @ByVal GpuMat tvec);
@Namespace("cv::aruco") public static native int estimatePoseBoard(@ByVal UMatVector corners, @ByVal GpuMat ids, @Ptr Board board,
                                   @ByVal GpuMat cameraMatrix, @ByVal GpuMat distCoeffs, @ByVal GpuMat rvec,
                                   @ByVal GpuMat tvec, @Cast("bool") boolean useExtrinsicGuess/*=false*/);
@Namespace("cv::aruco") public static native int estimatePoseBoard(@ByVal UMatVector corners, @ByVal GpuMat ids, @Ptr Board board,
                                   @ByVal GpuMat cameraMatrix, @ByVal GpuMat distCoeffs, @ByVal GpuMat rvec,
                                   @ByVal GpuMat tvec);
@Namespace("cv::aruco") public static native int estimatePoseBoard(@ByVal GpuMatVector corners, @ByVal GpuMat ids, @Ptr Board board,
                                   @ByVal GpuMat cameraMatrix, @ByVal GpuMat distCoeffs, @ByVal GpuMat rvec,
                                   @ByVal GpuMat tvec, @Cast("bool") boolean useExtrinsicGuess/*=false*/);
@Namespace("cv::aruco") public static native int estimatePoseBoard(@ByVal GpuMatVector corners, @ByVal GpuMat ids, @Ptr Board board,
                                   @ByVal GpuMat cameraMatrix, @ByVal GpuMat distCoeffs, @ByVal GpuMat rvec,
                                   @ByVal GpuMat tvec);

/**
 * \brief Pose estimation for a ChArUco board given some of their corners
 * @param charucoCorners vector of detected charuco corners
 * @param charucoIds list of identifiers for each corner in charucoCorners
 * @param board layout of ChArUco board.
 * @param cameraMatrix input 3x3 floating-point camera matrix
 * {@code A = \vecthreethree{f_x}{0}{c_x}{0}{f_y}{c_y}{0}{0}{1}}
 * @param distCoeffs vector of distortion coefficients
 * {@code (k_1, k_2, p_1, p_2[, k_3[, k_4, k_5, k_6],[s_1, s_2, s_3, s_4]])} of 4, 5, 8 or 12 elements
 * @param rvec Output vector (e.g. cv::Mat) corresponding to the rotation vector of the board
 * (see cv::Rodrigues).
 * @param tvec Output vector (e.g. cv::Mat) corresponding to the translation vector of the board.
 * @param useExtrinsicGuess defines whether initial guess for \b rvec and \b tvec will be used or not.
 *
 * This function estimates a Charuco board pose from some detected corners.
 * The function checks if the input corners are enough and valid to perform pose estimation.
 * If pose estimation is valid, returns true, else returns false.
 * @see use cv::drawFrameAxes to get world coordinate system axis for object points
 */
@Namespace("cv::aruco") public static native @Cast("bool") boolean estimatePoseCharucoBoard(@ByVal Mat charucoCorners, @ByVal Mat charucoIds,
                                           @Ptr CharucoBoard board, @ByVal Mat cameraMatrix,
                                           @ByVal Mat distCoeffs, @ByVal Mat rvec,
                                           @ByVal Mat tvec, @Cast("bool") boolean useExtrinsicGuess/*=false*/);
@Namespace("cv::aruco") public static native @Cast("bool") boolean estimatePoseCharucoBoard(@ByVal Mat charucoCorners, @ByVal Mat charucoIds,
                                           @Ptr CharucoBoard board, @ByVal Mat cameraMatrix,
                                           @ByVal Mat distCoeffs, @ByVal Mat rvec,
                                           @ByVal Mat tvec);
@Namespace("cv::aruco") public static native @Cast("bool") boolean estimatePoseCharucoBoard(@ByVal UMat charucoCorners, @ByVal UMat charucoIds,
                                           @Ptr CharucoBoard board, @ByVal UMat cameraMatrix,
                                           @ByVal UMat distCoeffs, @ByVal UMat rvec,
                                           @ByVal UMat tvec, @Cast("bool") boolean useExtrinsicGuess/*=false*/);
@Namespace("cv::aruco") public static native @Cast("bool") boolean estimatePoseCharucoBoard(@ByVal UMat charucoCorners, @ByVal UMat charucoIds,
                                           @Ptr CharucoBoard board, @ByVal UMat cameraMatrix,
                                           @ByVal UMat distCoeffs, @ByVal UMat rvec,
                                           @ByVal UMat tvec);
@Namespace("cv::aruco") public static native @Cast("bool") boolean estimatePoseCharucoBoard(@ByVal GpuMat charucoCorners, @ByVal GpuMat charucoIds,
                                           @Ptr CharucoBoard board, @ByVal GpuMat cameraMatrix,
                                           @ByVal GpuMat distCoeffs, @ByVal GpuMat rvec,
                                           @ByVal GpuMat tvec, @Cast("bool") boolean useExtrinsicGuess/*=false*/);
@Namespace("cv::aruco") public static native @Cast("bool") boolean estimatePoseCharucoBoard(@ByVal GpuMat charucoCorners, @ByVal GpuMat charucoIds,
                                           @Ptr CharucoBoard board, @ByVal GpuMat cameraMatrix,
                                           @ByVal GpuMat distCoeffs, @ByVal GpuMat rvec,
                                           @ByVal GpuMat tvec);

/** @deprecated Use cv::solvePnP
 */
@Namespace("cv::aruco") public static native void estimatePoseSingleMarkers(@ByVal MatVector corners, float markerLength,
                                            @ByVal Mat cameraMatrix, @ByVal Mat distCoeffs,
                                            @ByVal Mat rvecs, @ByVal Mat tvecs, @ByVal(nullValue = "cv::OutputArray(cv::noArray())") Mat objPoints,
                                            @Ptr EstimateParameters estimateParameters/*=makePtr<EstimateParameters>()*/);
@Namespace("cv::aruco") public static native void estimatePoseSingleMarkers(@ByVal MatVector corners, float markerLength,
                                            @ByVal Mat cameraMatrix, @ByVal Mat distCoeffs,
                                            @ByVal Mat rvecs, @ByVal Mat tvecs);
@Namespace("cv::aruco") public static native void estimatePoseSingleMarkers(@ByVal UMatVector corners, float markerLength,
                                            @ByVal Mat cameraMatrix, @ByVal Mat distCoeffs,
                                            @ByVal Mat rvecs, @ByVal Mat tvecs, @ByVal(nullValue = "cv::OutputArray(cv::noArray())") Mat objPoints,
                                            @Ptr EstimateParameters estimateParameters/*=makePtr<EstimateParameters>()*/);
@Namespace("cv::aruco") public static native void estimatePoseSingleMarkers(@ByVal UMatVector corners, float markerLength,
                                            @ByVal Mat cameraMatrix, @ByVal Mat distCoeffs,
                                            @ByVal Mat rvecs, @ByVal Mat tvecs);
@Namespace("cv::aruco") public static native void estimatePoseSingleMarkers(@ByVal GpuMatVector corners, float markerLength,
                                            @ByVal Mat cameraMatrix, @ByVal Mat distCoeffs,
                                            @ByVal Mat rvecs, @ByVal Mat tvecs, @ByVal(nullValue = "cv::OutputArray(cv::noArray())") Mat objPoints,
                                            @Ptr EstimateParameters estimateParameters/*=makePtr<EstimateParameters>()*/);
@Namespace("cv::aruco") public static native void estimatePoseSingleMarkers(@ByVal GpuMatVector corners, float markerLength,
                                            @ByVal Mat cameraMatrix, @ByVal Mat distCoeffs,
                                            @ByVal Mat rvecs, @ByVal Mat tvecs);
@Namespace("cv::aruco") public static native void estimatePoseSingleMarkers(@ByVal MatVector corners, float markerLength,
                                            @ByVal UMat cameraMatrix, @ByVal UMat distCoeffs,
                                            @ByVal UMat rvecs, @ByVal UMat tvecs, @ByVal(nullValue = "cv::OutputArray(cv::noArray())") UMat objPoints,
                                            @Ptr EstimateParameters estimateParameters/*=makePtr<EstimateParameters>()*/);
@Namespace("cv::aruco") public static native void estimatePoseSingleMarkers(@ByVal MatVector corners, float markerLength,
                                            @ByVal UMat cameraMatrix, @ByVal UMat distCoeffs,
                                            @ByVal UMat rvecs, @ByVal UMat tvecs);
@Namespace("cv::aruco") public static native void estimatePoseSingleMarkers(@ByVal UMatVector corners, float markerLength,
                                            @ByVal UMat cameraMatrix, @ByVal UMat distCoeffs,
                                            @ByVal UMat rvecs, @ByVal UMat tvecs, @ByVal(nullValue = "cv::OutputArray(cv::noArray())") UMat objPoints,
                                            @Ptr EstimateParameters estimateParameters/*=makePtr<EstimateParameters>()*/);
@Namespace("cv::aruco") public static native void estimatePoseSingleMarkers(@ByVal UMatVector corners, float markerLength,
                                            @ByVal UMat cameraMatrix, @ByVal UMat distCoeffs,
                                            @ByVal UMat rvecs, @ByVal UMat tvecs);
@Namespace("cv::aruco") public static native void estimatePoseSingleMarkers(@ByVal GpuMatVector corners, float markerLength,
                                            @ByVal UMat cameraMatrix, @ByVal UMat distCoeffs,
                                            @ByVal UMat rvecs, @ByVal UMat tvecs, @ByVal(nullValue = "cv::OutputArray(cv::noArray())") UMat objPoints,
                                            @Ptr EstimateParameters estimateParameters/*=makePtr<EstimateParameters>()*/);
@Namespace("cv::aruco") public static native void estimatePoseSingleMarkers(@ByVal GpuMatVector corners, float markerLength,
                                            @ByVal UMat cameraMatrix, @ByVal UMat distCoeffs,
                                            @ByVal UMat rvecs, @ByVal UMat tvecs);
@Namespace("cv::aruco") public static native void estimatePoseSingleMarkers(@ByVal MatVector corners, float markerLength,
                                            @ByVal GpuMat cameraMatrix, @ByVal GpuMat distCoeffs,
                                            @ByVal GpuMat rvecs, @ByVal GpuMat tvecs, @ByVal(nullValue = "cv::OutputArray(cv::noArray())") GpuMat objPoints,
                                            @Ptr EstimateParameters estimateParameters/*=makePtr<EstimateParameters>()*/);
@Namespace("cv::aruco") public static native void estimatePoseSingleMarkers(@ByVal MatVector corners, float markerLength,
                                            @ByVal GpuMat cameraMatrix, @ByVal GpuMat distCoeffs,
                                            @ByVal GpuMat rvecs, @ByVal GpuMat tvecs);
@Namespace("cv::aruco") public static native void estimatePoseSingleMarkers(@ByVal UMatVector corners, float markerLength,
                                            @ByVal GpuMat cameraMatrix, @ByVal GpuMat distCoeffs,
                                            @ByVal GpuMat rvecs, @ByVal GpuMat tvecs, @ByVal(nullValue = "cv::OutputArray(cv::noArray())") GpuMat objPoints,
                                            @Ptr EstimateParameters estimateParameters/*=makePtr<EstimateParameters>()*/);
@Namespace("cv::aruco") public static native void estimatePoseSingleMarkers(@ByVal UMatVector corners, float markerLength,
                                            @ByVal GpuMat cameraMatrix, @ByVal GpuMat distCoeffs,
                                            @ByVal GpuMat rvecs, @ByVal GpuMat tvecs);
@Namespace("cv::aruco") public static native void estimatePoseSingleMarkers(@ByVal GpuMatVector corners, float markerLength,
                                            @ByVal GpuMat cameraMatrix, @ByVal GpuMat distCoeffs,
                                            @ByVal GpuMat rvecs, @ByVal GpuMat tvecs, @ByVal(nullValue = "cv::OutputArray(cv::noArray())") GpuMat objPoints,
                                            @Ptr EstimateParameters estimateParameters/*=makePtr<EstimateParameters>()*/);
@Namespace("cv::aruco") public static native void estimatePoseSingleMarkers(@ByVal GpuMatVector corners, float markerLength,
                                            @ByVal GpuMat cameraMatrix, @ByVal GpuMat distCoeffs,
                                            @ByVal GpuMat rvecs, @ByVal GpuMat tvecs);


/** @deprecated Use CharucoBoard::checkCharucoCornersCollinear
 */
@Namespace("cv::aruco") public static native @Cast("bool") boolean testCharucoCornersCollinear(@Ptr CharucoBoard board, @ByVal Mat charucoIds);
@Namespace("cv::aruco") public static native @Cast("bool") boolean testCharucoCornersCollinear(@Ptr CharucoBoard board, @ByVal UMat charucoIds);
@Namespace("cv::aruco") public static native @Cast("bool") boolean testCharucoCornersCollinear(@Ptr CharucoBoard board, @ByVal GpuMat charucoIds);

/** \} */




// #endif


// Parsed from <opencv2/aruco/aruco_calib.hpp>

// This file is part of OpenCV project.
// It is subject to the license terms in the LICENSE file found in the top-level directory
// of this distribution and at http://opencv.org/license.html
// #ifndef OPENCV_ARUCO_CALIB_POSE_HPP
// #define OPENCV_ARUCO_CALIB_POSE_HPP
// #include <opencv2/objdetect/aruco_board.hpp>

/** \addtogroup aruco
 *  \{
<p>
/** \brief rvec/tvec define the right handed coordinate system of the marker.
 *
 * PatternPositionType defines center this system and axes direction.
 * Axis X (red color) - first coordinate, axis Y (green color) - second coordinate,
 * axis Z (blue color) - third coordinate.
 * @see estimatePoseSingleMarkers(), check tutorial_aruco_detection in aruco contrib
 */
/** enum cv::aruco::PatternPositionType */
public static final int
    /** \brief The marker coordinate system is centered on the middle of the marker.
     *
     * The coordinates of the four corners (CCW order) of the marker in its own coordinate system are:
     * (-markerLength/2, markerLength/2, 0), (markerLength/2, markerLength/2, 0),
     * (markerLength/2, -markerLength/2, 0), (-markerLength/2, -markerLength/2, 0).
     *
     * These pattern points define this coordinate system:
     * ![Image with axes drawn](tutorials/images/singlemarkersaxes2.jpg)
     */
    ARUCO_CCW_CENTER = 0,
    /** \brief The marker coordinate system is centered on the top-left corner of the marker.
     *
     * The coordinates of the four corners (CW order) of the marker in its own coordinate system are:
     * (0, 0, 0), (markerLength, 0, 0),
     * (markerLength, markerLength, 0), (0, markerLength, 0).
     *
     * These pattern points define this coordinate system:
     * ![Image with axes drawn](tutorials/images/singlemarkersaxes.jpg)
     *
     * These pattern dots are convenient to use with a chessboard/ChArUco board.
     */
    ARUCO_CW_TOP_LEFT_CORNER = 1;
// Targeting ..\opencv_aruco\EstimateParameters.java



/**
 * \brief Calibrate a camera using aruco markers
 *
 * @param corners vector of detected marker corners in all frames.
 * The corners should have the same format returned by detectMarkers (see #detectMarkers).
 * @param ids list of identifiers for each marker in corners
 * @param counter number of markers in each frame so that corners and ids can be split
 * @param board Marker Board layout
 * @param imageSize Size of the image used only to initialize the intrinsic camera matrix.
 * @param cameraMatrix Output 3x3 floating-point camera matrix
 * {@code A = \vecthreethree{f_x}{0}{c_x}{0}{f_y}{c_y}{0}{0}{1}} . If CV\_CALIB\_USE\_INTRINSIC\_GUESS
 * and/or CV_CALIB_FIX_ASPECT_RATIO are specified, some or all of fx, fy, cx, cy must be
 * initialized before calling the function.
 * @param distCoeffs Output vector of distortion coefficients
 * {@code (k_1, k_2, p_1, p_2[, k_3[, k_4, k_5, k_6],[s_1, s_2, s_3, s_4]])} of 4, 5, 8 or 12 elements
 * @param rvecs Output vector of rotation vectors (see Rodrigues ) estimated for each board view
 * (e.g. std::vector<cv::Mat>>). That is, each k-th rotation vector together with the corresponding
 * k-th translation vector (see the next output parameter description) brings the board pattern
 * from the model coordinate space (in which object points are specified) to the world coordinate
 * space, that is, a real position of the board pattern in the k-th pattern view (k=0.. *M* -1).
 * @param tvecs Output vector of translation vectors estimated for each pattern view.
 * @param stdDeviationsIntrinsics Output vector of standard deviations estimated for intrinsic parameters.
 * Order of deviations values:
 * {@code (f_x, f_y, c_x, c_y, k_1, k_2, p_1, p_2, k_3, k_4, k_5, k_6 , s_1, s_2, s_3,
 * s_4, \tau_x, \tau_y)} If one of parameters is not estimated, it's deviation is equals to zero.
 * @param stdDeviationsExtrinsics Output vector of standard deviations estimated for extrinsic parameters.
 * Order of deviations values: {@code (R_1, T_1, \dotsc , R_M, T_M)} where M is number of pattern views,
 * {@code R_i, T_i} are concatenated 1x3 vectors.
 * @param perViewErrors Output vector of average re-projection errors estimated for each pattern view.
 * @param flags flags Different flags  for the calibration process (see #calibrateCamera for details).
 * @param criteria Termination criteria for the iterative optimization algorithm.
 *
 * This function calibrates a camera using an Aruco Board. The function receives a list of
 * detected markers from several views of the Board. The process is similar to the chessboard
 * calibration in calibrateCamera(). The function returns the final re-projection error.
 */
@Namespace("cv::aruco") public static native @Name("calibrateCameraAruco") double calibrateCameraArucoExtended(@ByVal MatVector corners, @ByVal Mat ids, @ByVal Mat counter, @Ptr Board board,
                            @ByVal Size imageSize, @ByVal Mat cameraMatrix, @ByVal Mat distCoeffs,
                            @ByVal MatVector rvecs, @ByVal MatVector tvecs, @ByVal Mat stdDeviationsIntrinsics,
                            @ByVal Mat stdDeviationsExtrinsics, @ByVal Mat perViewErrors, int flags/*=0*/,
                            @Const @ByRef(nullValue = "cv::TermCriteria(cv::TermCriteria::COUNT + cv::TermCriteria::EPS, 30, DBL_EPSILON)") TermCriteria criteria);
@Namespace("cv::aruco") public static native @Name("calibrateCameraAruco") double calibrateCameraArucoExtended(@ByVal MatVector corners, @ByVal Mat ids, @ByVal Mat counter, @Ptr Board board,
                            @ByVal Size imageSize, @ByVal Mat cameraMatrix, @ByVal Mat distCoeffs,
                            @ByVal MatVector rvecs, @ByVal MatVector tvecs, @ByVal Mat stdDeviationsIntrinsics,
                            @ByVal Mat stdDeviationsExtrinsics, @ByVal Mat perViewErrors);
@Namespace("cv::aruco") public static native @Name("calibrateCameraAruco") double calibrateCameraArucoExtended(@ByVal UMatVector corners, @ByVal Mat ids, @ByVal Mat counter, @Ptr Board board,
                            @ByVal Size imageSize, @ByVal Mat cameraMatrix, @ByVal Mat distCoeffs,
                            @ByVal UMatVector rvecs, @ByVal UMatVector tvecs, @ByVal Mat stdDeviationsIntrinsics,
                            @ByVal Mat stdDeviationsExtrinsics, @ByVal Mat perViewErrors, int flags/*=0*/,
                            @Const @ByRef(nullValue = "cv::TermCriteria(cv::TermCriteria::COUNT + cv::TermCriteria::EPS, 30, DBL_EPSILON)") TermCriteria criteria);
@Namespace("cv::aruco") public static native @Name("calibrateCameraAruco") double calibrateCameraArucoExtended(@ByVal UMatVector corners, @ByVal Mat ids, @ByVal Mat counter, @Ptr Board board,
                            @ByVal Size imageSize, @ByVal Mat cameraMatrix, @ByVal Mat distCoeffs,
                            @ByVal UMatVector rvecs, @ByVal UMatVector tvecs, @ByVal Mat stdDeviationsIntrinsics,
                            @ByVal Mat stdDeviationsExtrinsics, @ByVal Mat perViewErrors);
@Namespace("cv::aruco") public static native @Name("calibrateCameraAruco") double calibrateCameraArucoExtended(@ByVal GpuMatVector corners, @ByVal Mat ids, @ByVal Mat counter, @Ptr Board board,
                            @ByVal Size imageSize, @ByVal Mat cameraMatrix, @ByVal Mat distCoeffs,
                            @ByVal GpuMatVector rvecs, @ByVal GpuMatVector tvecs, @ByVal Mat stdDeviationsIntrinsics,
                            @ByVal Mat stdDeviationsExtrinsics, @ByVal Mat perViewErrors, int flags/*=0*/,
                            @Const @ByRef(nullValue = "cv::TermCriteria(cv::TermCriteria::COUNT + cv::TermCriteria::EPS, 30, DBL_EPSILON)") TermCriteria criteria);
@Namespace("cv::aruco") public static native @Name("calibrateCameraAruco") double calibrateCameraArucoExtended(@ByVal GpuMatVector corners, @ByVal Mat ids, @ByVal Mat counter, @Ptr Board board,
                            @ByVal Size imageSize, @ByVal Mat cameraMatrix, @ByVal Mat distCoeffs,
                            @ByVal GpuMatVector rvecs, @ByVal GpuMatVector tvecs, @ByVal Mat stdDeviationsIntrinsics,
                            @ByVal Mat stdDeviationsExtrinsics, @ByVal Mat perViewErrors);
@Namespace("cv::aruco") public static native @Name("calibrateCameraAruco") double calibrateCameraArucoExtended(@ByVal MatVector corners, @ByVal UMat ids, @ByVal UMat counter, @Ptr Board board,
                            @ByVal Size imageSize, @ByVal UMat cameraMatrix, @ByVal UMat distCoeffs,
                            @ByVal MatVector rvecs, @ByVal MatVector tvecs, @ByVal UMat stdDeviationsIntrinsics,
                            @ByVal UMat stdDeviationsExtrinsics, @ByVal UMat perViewErrors, int flags/*=0*/,
                            @Const @ByRef(nullValue = "cv::TermCriteria(cv::TermCriteria::COUNT + cv::TermCriteria::EPS, 30, DBL_EPSILON)") TermCriteria criteria);
@Namespace("cv::aruco") public static native @Name("calibrateCameraAruco") double calibrateCameraArucoExtended(@ByVal MatVector corners, @ByVal UMat ids, @ByVal UMat counter, @Ptr Board board,
                            @ByVal Size imageSize, @ByVal UMat cameraMatrix, @ByVal UMat distCoeffs,
                            @ByVal MatVector rvecs, @ByVal MatVector tvecs, @ByVal UMat stdDeviationsIntrinsics,
                            @ByVal UMat stdDeviationsExtrinsics, @ByVal UMat perViewErrors);
@Namespace("cv::aruco") public static native @Name("calibrateCameraAruco") double calibrateCameraArucoExtended(@ByVal UMatVector corners, @ByVal UMat ids, @ByVal UMat counter, @Ptr Board board,
                            @ByVal Size imageSize, @ByVal UMat cameraMatrix, @ByVal UMat distCoeffs,
                            @ByVal UMatVector rvecs, @ByVal UMatVector tvecs, @ByVal UMat stdDeviationsIntrinsics,
                            @ByVal UMat stdDeviationsExtrinsics, @ByVal UMat perViewErrors, int flags/*=0*/,
                            @Const @ByRef(nullValue = "cv::TermCriteria(cv::TermCriteria::COUNT + cv::TermCriteria::EPS, 30, DBL_EPSILON)") TermCriteria criteria);
@Namespace("cv::aruco") public static native @Name("calibrateCameraAruco") double calibrateCameraArucoExtended(@ByVal UMatVector corners, @ByVal UMat ids, @ByVal UMat counter, @Ptr Board board,
                            @ByVal Size imageSize, @ByVal UMat cameraMatrix, @ByVal UMat distCoeffs,
                            @ByVal UMatVector rvecs, @ByVal UMatVector tvecs, @ByVal UMat stdDeviationsIntrinsics,
                            @ByVal UMat stdDeviationsExtrinsics, @ByVal UMat perViewErrors);
@Namespace("cv::aruco") public static native @Name("calibrateCameraAruco") double calibrateCameraArucoExtended(@ByVal GpuMatVector corners, @ByVal UMat ids, @ByVal UMat counter, @Ptr Board board,
                            @ByVal Size imageSize, @ByVal UMat cameraMatrix, @ByVal UMat distCoeffs,
                            @ByVal GpuMatVector rvecs, @ByVal GpuMatVector tvecs, @ByVal UMat stdDeviationsIntrinsics,
                            @ByVal UMat stdDeviationsExtrinsics, @ByVal UMat perViewErrors, int flags/*=0*/,
                            @Const @ByRef(nullValue = "cv::TermCriteria(cv::TermCriteria::COUNT + cv::TermCriteria::EPS, 30, DBL_EPSILON)") TermCriteria criteria);
@Namespace("cv::aruco") public static native @Name("calibrateCameraAruco") double calibrateCameraArucoExtended(@ByVal GpuMatVector corners, @ByVal UMat ids, @ByVal UMat counter, @Ptr Board board,
                            @ByVal Size imageSize, @ByVal UMat cameraMatrix, @ByVal UMat distCoeffs,
                            @ByVal GpuMatVector rvecs, @ByVal GpuMatVector tvecs, @ByVal UMat stdDeviationsIntrinsics,
                            @ByVal UMat stdDeviationsExtrinsics, @ByVal UMat perViewErrors);
@Namespace("cv::aruco") public static native @Name("calibrateCameraAruco") double calibrateCameraArucoExtended(@ByVal MatVector corners, @ByVal GpuMat ids, @ByVal GpuMat counter, @Ptr Board board,
                            @ByVal Size imageSize, @ByVal GpuMat cameraMatrix, @ByVal GpuMat distCoeffs,
                            @ByVal MatVector rvecs, @ByVal MatVector tvecs, @ByVal GpuMat stdDeviationsIntrinsics,
                            @ByVal GpuMat stdDeviationsExtrinsics, @ByVal GpuMat perViewErrors, int flags/*=0*/,
                            @Const @ByRef(nullValue = "cv::TermCriteria(cv::TermCriteria::COUNT + cv::TermCriteria::EPS, 30, DBL_EPSILON)") TermCriteria criteria);
@Namespace("cv::aruco") public static native @Name("calibrateCameraAruco") double calibrateCameraArucoExtended(@ByVal MatVector corners, @ByVal GpuMat ids, @ByVal GpuMat counter, @Ptr Board board,
                            @ByVal Size imageSize, @ByVal GpuMat cameraMatrix, @ByVal GpuMat distCoeffs,
                            @ByVal MatVector rvecs, @ByVal MatVector tvecs, @ByVal GpuMat stdDeviationsIntrinsics,
                            @ByVal GpuMat stdDeviationsExtrinsics, @ByVal GpuMat perViewErrors);
@Namespace("cv::aruco") public static native @Name("calibrateCameraAruco") double calibrateCameraArucoExtended(@ByVal UMatVector corners, @ByVal GpuMat ids, @ByVal GpuMat counter, @Ptr Board board,
                            @ByVal Size imageSize, @ByVal GpuMat cameraMatrix, @ByVal GpuMat distCoeffs,
                            @ByVal UMatVector rvecs, @ByVal UMatVector tvecs, @ByVal GpuMat stdDeviationsIntrinsics,
                            @ByVal GpuMat stdDeviationsExtrinsics, @ByVal GpuMat perViewErrors, int flags/*=0*/,
                            @Const @ByRef(nullValue = "cv::TermCriteria(cv::TermCriteria::COUNT + cv::TermCriteria::EPS, 30, DBL_EPSILON)") TermCriteria criteria);
@Namespace("cv::aruco") public static native @Name("calibrateCameraAruco") double calibrateCameraArucoExtended(@ByVal UMatVector corners, @ByVal GpuMat ids, @ByVal GpuMat counter, @Ptr Board board,
                            @ByVal Size imageSize, @ByVal GpuMat cameraMatrix, @ByVal GpuMat distCoeffs,
                            @ByVal UMatVector rvecs, @ByVal UMatVector tvecs, @ByVal GpuMat stdDeviationsIntrinsics,
                            @ByVal GpuMat stdDeviationsExtrinsics, @ByVal GpuMat perViewErrors);
@Namespace("cv::aruco") public static native @Name("calibrateCameraAruco") double calibrateCameraArucoExtended(@ByVal GpuMatVector corners, @ByVal GpuMat ids, @ByVal GpuMat counter, @Ptr Board board,
                            @ByVal Size imageSize, @ByVal GpuMat cameraMatrix, @ByVal GpuMat distCoeffs,
                            @ByVal GpuMatVector rvecs, @ByVal GpuMatVector tvecs, @ByVal GpuMat stdDeviationsIntrinsics,
                            @ByVal GpuMat stdDeviationsExtrinsics, @ByVal GpuMat perViewErrors, int flags/*=0*/,
                            @Const @ByRef(nullValue = "cv::TermCriteria(cv::TermCriteria::COUNT + cv::TermCriteria::EPS, 30, DBL_EPSILON)") TermCriteria criteria);
@Namespace("cv::aruco") public static native @Name("calibrateCameraAruco") double calibrateCameraArucoExtended(@ByVal GpuMatVector corners, @ByVal GpuMat ids, @ByVal GpuMat counter, @Ptr Board board,
                            @ByVal Size imageSize, @ByVal GpuMat cameraMatrix, @ByVal GpuMat distCoeffs,
                            @ByVal GpuMatVector rvecs, @ByVal GpuMatVector tvecs, @ByVal GpuMat stdDeviationsIntrinsics,
                            @ByVal GpuMat stdDeviationsExtrinsics, @ByVal GpuMat perViewErrors);

/** \overload
 * \brief It's the same function as #calibrateCameraAruco but without calibration error estimation.
 */
@Namespace("cv::aruco") public static native double calibrateCameraAruco(@ByVal MatVector corners, @ByVal Mat ids, @ByVal Mat counter,
                                         @Ptr Board board, @ByVal Size imageSize, @ByVal Mat cameraMatrix,
                                         @ByVal Mat distCoeffs, @ByVal(nullValue = "cv::OutputArrayOfArrays(cv::noArray())") MatVector rvecs,
                                         @ByVal(nullValue = "cv::OutputArrayOfArrays(cv::noArray())") MatVector tvecs, int flags/*=0*/,
                                         @Const @ByRef(nullValue = "cv::TermCriteria(cv::TermCriteria::COUNT + cv::TermCriteria::EPS,"
                                                                                      + "30, DBL_EPSILON)") TermCriteria criteria);
@Namespace("cv::aruco") public static native double calibrateCameraAruco(@ByVal MatVector corners, @ByVal Mat ids, @ByVal Mat counter,
                                         @Ptr Board board, @ByVal Size imageSize, @ByVal Mat cameraMatrix,
                                         @ByVal Mat distCoeffs);
@Namespace("cv::aruco") public static native double calibrateCameraAruco(@ByVal UMatVector corners, @ByVal Mat ids, @ByVal Mat counter,
                                         @Ptr Board board, @ByVal Size imageSize, @ByVal Mat cameraMatrix,
                                         @ByVal Mat distCoeffs, @ByVal(nullValue = "cv::OutputArrayOfArrays(cv::noArray())") UMatVector rvecs,
                                         @ByVal(nullValue = "cv::OutputArrayOfArrays(cv::noArray())") UMatVector tvecs, int flags/*=0*/,
                                         @Const @ByRef(nullValue = "cv::TermCriteria(cv::TermCriteria::COUNT + cv::TermCriteria::EPS,"
                                                                                      + "30, DBL_EPSILON)") TermCriteria criteria);
@Namespace("cv::aruco") public static native double calibrateCameraAruco(@ByVal UMatVector corners, @ByVal Mat ids, @ByVal Mat counter,
                                         @Ptr Board board, @ByVal Size imageSize, @ByVal Mat cameraMatrix,
                                         @ByVal Mat distCoeffs);
@Namespace("cv::aruco") public static native double calibrateCameraAruco(@ByVal GpuMatVector corners, @ByVal Mat ids, @ByVal Mat counter,
                                         @Ptr Board board, @ByVal Size imageSize, @ByVal Mat cameraMatrix,
                                         @ByVal Mat distCoeffs, @ByVal(nullValue = "cv::OutputArrayOfArrays(cv::noArray())") GpuMatVector rvecs,
                                         @ByVal(nullValue = "cv::OutputArrayOfArrays(cv::noArray())") GpuMatVector tvecs, int flags/*=0*/,
                                         @Const @ByRef(nullValue = "cv::TermCriteria(cv::TermCriteria::COUNT + cv::TermCriteria::EPS,"
                                                                                      + "30, DBL_EPSILON)") TermCriteria criteria);
@Namespace("cv::aruco") public static native double calibrateCameraAruco(@ByVal GpuMatVector corners, @ByVal Mat ids, @ByVal Mat counter,
                                         @Ptr Board board, @ByVal Size imageSize, @ByVal Mat cameraMatrix,
                                         @ByVal Mat distCoeffs);
@Namespace("cv::aruco") public static native double calibrateCameraAruco(@ByVal MatVector corners, @ByVal UMat ids, @ByVal UMat counter,
                                         @Ptr Board board, @ByVal Size imageSize, @ByVal UMat cameraMatrix,
                                         @ByVal UMat distCoeffs, @ByVal(nullValue = "cv::OutputArrayOfArrays(cv::noArray())") MatVector rvecs,
                                         @ByVal(nullValue = "cv::OutputArrayOfArrays(cv::noArray())") MatVector tvecs, int flags/*=0*/,
                                         @Const @ByRef(nullValue = "cv::TermCriteria(cv::TermCriteria::COUNT + cv::TermCriteria::EPS,"
                                                                                      + "30, DBL_EPSILON)") TermCriteria criteria);
@Namespace("cv::aruco") public static native double calibrateCameraAruco(@ByVal MatVector corners, @ByVal UMat ids, @ByVal UMat counter,
                                         @Ptr Board board, @ByVal Size imageSize, @ByVal UMat cameraMatrix,
                                         @ByVal UMat distCoeffs);
@Namespace("cv::aruco") public static native double calibrateCameraAruco(@ByVal UMatVector corners, @ByVal UMat ids, @ByVal UMat counter,
                                         @Ptr Board board, @ByVal Size imageSize, @ByVal UMat cameraMatrix,
                                         @ByVal UMat distCoeffs, @ByVal(nullValue = "cv::OutputArrayOfArrays(cv::noArray())") UMatVector rvecs,
                                         @ByVal(nullValue = "cv::OutputArrayOfArrays(cv::noArray())") UMatVector tvecs, int flags/*=0*/,
                                         @Const @ByRef(nullValue = "cv::TermCriteria(cv::TermCriteria::COUNT + cv::TermCriteria::EPS,"
                                                                                      + "30, DBL_EPSILON)") TermCriteria criteria);
@Namespace("cv::aruco") public static native double calibrateCameraAruco(@ByVal UMatVector corners, @ByVal UMat ids, @ByVal UMat counter,
                                         @Ptr Board board, @ByVal Size imageSize, @ByVal UMat cameraMatrix,
                                         @ByVal UMat distCoeffs);
@Namespace("cv::aruco") public static native double calibrateCameraAruco(@ByVal GpuMatVector corners, @ByVal UMat ids, @ByVal UMat counter,
                                         @Ptr Board board, @ByVal Size imageSize, @ByVal UMat cameraMatrix,
                                         @ByVal UMat distCoeffs, @ByVal(nullValue = "cv::OutputArrayOfArrays(cv::noArray())") GpuMatVector rvecs,
                                         @ByVal(nullValue = "cv::OutputArrayOfArrays(cv::noArray())") GpuMatVector tvecs, int flags/*=0*/,
                                         @Const @ByRef(nullValue = "cv::TermCriteria(cv::TermCriteria::COUNT + cv::TermCriteria::EPS,"
                                                                                      + "30, DBL_EPSILON)") TermCriteria criteria);
@Namespace("cv::aruco") public static native double calibrateCameraAruco(@ByVal GpuMatVector corners, @ByVal UMat ids, @ByVal UMat counter,
                                         @Ptr Board board, @ByVal Size imageSize, @ByVal UMat cameraMatrix,
                                         @ByVal UMat distCoeffs);
@Namespace("cv::aruco") public static native double calibrateCameraAruco(@ByVal MatVector corners, @ByVal GpuMat ids, @ByVal GpuMat counter,
                                         @Ptr Board board, @ByVal Size imageSize, @ByVal GpuMat cameraMatrix,
                                         @ByVal GpuMat distCoeffs, @ByVal(nullValue = "cv::OutputArrayOfArrays(cv::noArray())") MatVector rvecs,
                                         @ByVal(nullValue = "cv::OutputArrayOfArrays(cv::noArray())") MatVector tvecs, int flags/*=0*/,
                                         @Const @ByRef(nullValue = "cv::TermCriteria(cv::TermCriteria::COUNT + cv::TermCriteria::EPS,"
                                                                                      + "30, DBL_EPSILON)") TermCriteria criteria);
@Namespace("cv::aruco") public static native double calibrateCameraAruco(@ByVal MatVector corners, @ByVal GpuMat ids, @ByVal GpuMat counter,
                                         @Ptr Board board, @ByVal Size imageSize, @ByVal GpuMat cameraMatrix,
                                         @ByVal GpuMat distCoeffs);
@Namespace("cv::aruco") public static native double calibrateCameraAruco(@ByVal UMatVector corners, @ByVal GpuMat ids, @ByVal GpuMat counter,
                                         @Ptr Board board, @ByVal Size imageSize, @ByVal GpuMat cameraMatrix,
                                         @ByVal GpuMat distCoeffs, @ByVal(nullValue = "cv::OutputArrayOfArrays(cv::noArray())") UMatVector rvecs,
                                         @ByVal(nullValue = "cv::OutputArrayOfArrays(cv::noArray())") UMatVector tvecs, int flags/*=0*/,
                                         @Const @ByRef(nullValue = "cv::TermCriteria(cv::TermCriteria::COUNT + cv::TermCriteria::EPS,"
                                                                                      + "30, DBL_EPSILON)") TermCriteria criteria);
@Namespace("cv::aruco") public static native double calibrateCameraAruco(@ByVal UMatVector corners, @ByVal GpuMat ids, @ByVal GpuMat counter,
                                         @Ptr Board board, @ByVal Size imageSize, @ByVal GpuMat cameraMatrix,
                                         @ByVal GpuMat distCoeffs);
@Namespace("cv::aruco") public static native double calibrateCameraAruco(@ByVal GpuMatVector corners, @ByVal GpuMat ids, @ByVal GpuMat counter,
                                         @Ptr Board board, @ByVal Size imageSize, @ByVal GpuMat cameraMatrix,
                                         @ByVal GpuMat distCoeffs, @ByVal(nullValue = "cv::OutputArrayOfArrays(cv::noArray())") GpuMatVector rvecs,
                                         @ByVal(nullValue = "cv::OutputArrayOfArrays(cv::noArray())") GpuMatVector tvecs, int flags/*=0*/,
                                         @Const @ByRef(nullValue = "cv::TermCriteria(cv::TermCriteria::COUNT + cv::TermCriteria::EPS,"
                                                                                      + "30, DBL_EPSILON)") TermCriteria criteria);
@Namespace("cv::aruco") public static native double calibrateCameraAruco(@ByVal GpuMatVector corners, @ByVal GpuMat ids, @ByVal GpuMat counter,
                                         @Ptr Board board, @ByVal Size imageSize, @ByVal GpuMat cameraMatrix,
                                         @ByVal GpuMat distCoeffs);


/**
 * \brief Calibrate a camera using Charuco corners
 *
 * @param charucoCorners vector of detected charuco corners per frame
 * @param charucoIds list of identifiers for each corner in charucoCorners per frame
 * @param board Marker Board layout
 * @param imageSize input image size
 * @param cameraMatrix Output 3x3 floating-point camera matrix
 * {@code A = \vecthreethree{f_x}{0}{c_x}{0}{f_y}{c_y}{0}{0}{1}} . If CV\_CALIB\_USE\_INTRINSIC\_GUESS
 * and/or CV_CALIB_FIX_ASPECT_RATIO are specified, some or all of fx, fy, cx, cy must be
 * initialized before calling the function.
 * @param distCoeffs Output vector of distortion coefficients
 * {@code (k_1, k_2, p_1, p_2[, k_3[, k_4, k_5, k_6],[s_1, s_2, s_3, s_4]])} of 4, 5, 8 or 12 elements
 * @param rvecs Output vector of rotation vectors (see Rodrigues ) estimated for each board view
 * (e.g. std::vector<cv::Mat>>). That is, each k-th rotation vector together with the corresponding
 * k-th translation vector (see the next output parameter description) brings the board pattern
 * from the model coordinate space (in which object points are specified) to the world coordinate
 * space, that is, a real position of the board pattern in the k-th pattern view (k=0.. *M* -1).
 * @param tvecs Output vector of translation vectors estimated for each pattern view.
 * @param stdDeviationsIntrinsics Output vector of standard deviations estimated for intrinsic parameters.
 * Order of deviations values:
 * {@code (f_x, f_y, c_x, c_y, k_1, k_2, p_1, p_2, k_3, k_4, k_5, k_6 , s_1, s_2, s_3,
 * s_4, \tau_x, \tau_y)} If one of parameters is not estimated, it's deviation is equals to zero.
 * @param stdDeviationsExtrinsics Output vector of standard deviations estimated for extrinsic parameters.
 * Order of deviations values: {@code (R_1, T_1, \dotsc , R_M, T_M)} where M is number of pattern views,
 * {@code R_i, T_i} are concatenated 1x3 vectors.
 * @param perViewErrors Output vector of average re-projection errors estimated for each pattern view.
 * @param flags flags Different flags  for the calibration process (see #calibrateCamera for details).
 * @param criteria Termination criteria for the iterative optimization algorithm.
 *
 * This function calibrates a camera using a set of corners of a  Charuco Board. The function
 * receives a list of detected corners and its identifiers from several views of the Board.
 * The function returns the final re-projection error.
 */
@Namespace("cv::aruco") public static native @Name("calibrateCameraCharuco") double calibrateCameraCharucoExtended(@ByVal MatVector charucoCorners, @ByVal MatVector charucoIds,
                              @Ptr CharucoBoard board, @ByVal Size imageSize, @ByVal Mat cameraMatrix,
                              @ByVal Mat distCoeffs, @ByVal MatVector rvecs, @ByVal MatVector tvecs,
                              @ByVal Mat stdDeviationsIntrinsics, @ByVal Mat stdDeviationsExtrinsics,
                              @ByVal Mat perViewErrors, int flags/*=0*/, @Const @ByRef(nullValue = "cv::TermCriteria("
                               + "cv::TermCriteria::COUNT + cv::TermCriteria::EPS, 30, DBL_EPSILON)") TermCriteria criteria);
@Namespace("cv::aruco") public static native @Name("calibrateCameraCharuco") double calibrateCameraCharucoExtended(@ByVal MatVector charucoCorners, @ByVal MatVector charucoIds,
                              @Ptr CharucoBoard board, @ByVal Size imageSize, @ByVal Mat cameraMatrix,
                              @ByVal Mat distCoeffs, @ByVal MatVector rvecs, @ByVal MatVector tvecs,
                              @ByVal Mat stdDeviationsIntrinsics, @ByVal Mat stdDeviationsExtrinsics,
                              @ByVal Mat perViewErrors);
@Namespace("cv::aruco") public static native @Name("calibrateCameraCharuco") double calibrateCameraCharucoExtended(@ByVal UMatVector charucoCorners, @ByVal UMatVector charucoIds,
                              @Ptr CharucoBoard board, @ByVal Size imageSize, @ByVal Mat cameraMatrix,
                              @ByVal Mat distCoeffs, @ByVal UMatVector rvecs, @ByVal UMatVector tvecs,
                              @ByVal Mat stdDeviationsIntrinsics, @ByVal Mat stdDeviationsExtrinsics,
                              @ByVal Mat perViewErrors, int flags/*=0*/, @Const @ByRef(nullValue = "cv::TermCriteria("
                               + "cv::TermCriteria::COUNT + cv::TermCriteria::EPS, 30, DBL_EPSILON)") TermCriteria criteria);
@Namespace("cv::aruco") public static native @Name("calibrateCameraCharuco") double calibrateCameraCharucoExtended(@ByVal UMatVector charucoCorners, @ByVal UMatVector charucoIds,
                              @Ptr CharucoBoard board, @ByVal Size imageSize, @ByVal Mat cameraMatrix,
                              @ByVal Mat distCoeffs, @ByVal UMatVector rvecs, @ByVal UMatVector tvecs,
                              @ByVal Mat stdDeviationsIntrinsics, @ByVal Mat stdDeviationsExtrinsics,
                              @ByVal Mat perViewErrors);
@Namespace("cv::aruco") public static native @Name("calibrateCameraCharuco") double calibrateCameraCharucoExtended(@ByVal GpuMatVector charucoCorners, @ByVal GpuMatVector charucoIds,
                              @Ptr CharucoBoard board, @ByVal Size imageSize, @ByVal Mat cameraMatrix,
                              @ByVal Mat distCoeffs, @ByVal GpuMatVector rvecs, @ByVal GpuMatVector tvecs,
                              @ByVal Mat stdDeviationsIntrinsics, @ByVal Mat stdDeviationsExtrinsics,
                              @ByVal Mat perViewErrors, int flags/*=0*/, @Const @ByRef(nullValue = "cv::TermCriteria("
                               + "cv::TermCriteria::COUNT + cv::TermCriteria::EPS, 30, DBL_EPSILON)") TermCriteria criteria);
@Namespace("cv::aruco") public static native @Name("calibrateCameraCharuco") double calibrateCameraCharucoExtended(@ByVal GpuMatVector charucoCorners, @ByVal GpuMatVector charucoIds,
                              @Ptr CharucoBoard board, @ByVal Size imageSize, @ByVal Mat cameraMatrix,
                              @ByVal Mat distCoeffs, @ByVal GpuMatVector rvecs, @ByVal GpuMatVector tvecs,
                              @ByVal Mat stdDeviationsIntrinsics, @ByVal Mat stdDeviationsExtrinsics,
                              @ByVal Mat perViewErrors);
@Namespace("cv::aruco") public static native @Name("calibrateCameraCharuco") double calibrateCameraCharucoExtended(@ByVal MatVector charucoCorners, @ByVal MatVector charucoIds,
                              @Ptr CharucoBoard board, @ByVal Size imageSize, @ByVal UMat cameraMatrix,
                              @ByVal UMat distCoeffs, @ByVal MatVector rvecs, @ByVal MatVector tvecs,
                              @ByVal UMat stdDeviationsIntrinsics, @ByVal UMat stdDeviationsExtrinsics,
                              @ByVal UMat perViewErrors, int flags/*=0*/, @Const @ByRef(nullValue = "cv::TermCriteria("
                               + "cv::TermCriteria::COUNT + cv::TermCriteria::EPS, 30, DBL_EPSILON)") TermCriteria criteria);
@Namespace("cv::aruco") public static native @Name("calibrateCameraCharuco") double calibrateCameraCharucoExtended(@ByVal MatVector charucoCorners, @ByVal MatVector charucoIds,
                              @Ptr CharucoBoard board, @ByVal Size imageSize, @ByVal UMat cameraMatrix,
                              @ByVal UMat distCoeffs, @ByVal MatVector rvecs, @ByVal MatVector tvecs,
                              @ByVal UMat stdDeviationsIntrinsics, @ByVal UMat stdDeviationsExtrinsics,
                              @ByVal UMat perViewErrors);
@Namespace("cv::aruco") public static native @Name("calibrateCameraCharuco") double calibrateCameraCharucoExtended(@ByVal UMatVector charucoCorners, @ByVal UMatVector charucoIds,
                              @Ptr CharucoBoard board, @ByVal Size imageSize, @ByVal UMat cameraMatrix,
                              @ByVal UMat distCoeffs, @ByVal UMatVector rvecs, @ByVal UMatVector tvecs,
                              @ByVal UMat stdDeviationsIntrinsics, @ByVal UMat stdDeviationsExtrinsics,
                              @ByVal UMat perViewErrors, int flags/*=0*/, @Const @ByRef(nullValue = "cv::TermCriteria("
                               + "cv::TermCriteria::COUNT + cv::TermCriteria::EPS, 30, DBL_EPSILON)") TermCriteria criteria);
@Namespace("cv::aruco") public static native @Name("calibrateCameraCharuco") double calibrateCameraCharucoExtended(@ByVal UMatVector charucoCorners, @ByVal UMatVector charucoIds,
                              @Ptr CharucoBoard board, @ByVal Size imageSize, @ByVal UMat cameraMatrix,
                              @ByVal UMat distCoeffs, @ByVal UMatVector rvecs, @ByVal UMatVector tvecs,
                              @ByVal UMat stdDeviationsIntrinsics, @ByVal UMat stdDeviationsExtrinsics,
                              @ByVal UMat perViewErrors);
@Namespace("cv::aruco") public static native @Name("calibrateCameraCharuco") double calibrateCameraCharucoExtended(@ByVal GpuMatVector charucoCorners, @ByVal GpuMatVector charucoIds,
                              @Ptr CharucoBoard board, @ByVal Size imageSize, @ByVal UMat cameraMatrix,
                              @ByVal UMat distCoeffs, @ByVal GpuMatVector rvecs, @ByVal GpuMatVector tvecs,
                              @ByVal UMat stdDeviationsIntrinsics, @ByVal UMat stdDeviationsExtrinsics,
                              @ByVal UMat perViewErrors, int flags/*=0*/, @Const @ByRef(nullValue = "cv::TermCriteria("
                               + "cv::TermCriteria::COUNT + cv::TermCriteria::EPS, 30, DBL_EPSILON)") TermCriteria criteria);
@Namespace("cv::aruco") public static native @Name("calibrateCameraCharuco") double calibrateCameraCharucoExtended(@ByVal GpuMatVector charucoCorners, @ByVal GpuMatVector charucoIds,
                              @Ptr CharucoBoard board, @ByVal Size imageSize, @ByVal UMat cameraMatrix,
                              @ByVal UMat distCoeffs, @ByVal GpuMatVector rvecs, @ByVal GpuMatVector tvecs,
                              @ByVal UMat stdDeviationsIntrinsics, @ByVal UMat stdDeviationsExtrinsics,
                              @ByVal UMat perViewErrors);
@Namespace("cv::aruco") public static native @Name("calibrateCameraCharuco") double calibrateCameraCharucoExtended(@ByVal MatVector charucoCorners, @ByVal MatVector charucoIds,
                              @Ptr CharucoBoard board, @ByVal Size imageSize, @ByVal GpuMat cameraMatrix,
                              @ByVal GpuMat distCoeffs, @ByVal MatVector rvecs, @ByVal MatVector tvecs,
                              @ByVal GpuMat stdDeviationsIntrinsics, @ByVal GpuMat stdDeviationsExtrinsics,
                              @ByVal GpuMat perViewErrors, int flags/*=0*/, @Const @ByRef(nullValue = "cv::TermCriteria("
                               + "cv::TermCriteria::COUNT + cv::TermCriteria::EPS, 30, DBL_EPSILON)") TermCriteria criteria);
@Namespace("cv::aruco") public static native @Name("calibrateCameraCharuco") double calibrateCameraCharucoExtended(@ByVal MatVector charucoCorners, @ByVal MatVector charucoIds,
                              @Ptr CharucoBoard board, @ByVal Size imageSize, @ByVal GpuMat cameraMatrix,
                              @ByVal GpuMat distCoeffs, @ByVal MatVector rvecs, @ByVal MatVector tvecs,
                              @ByVal GpuMat stdDeviationsIntrinsics, @ByVal GpuMat stdDeviationsExtrinsics,
                              @ByVal GpuMat perViewErrors);
@Namespace("cv::aruco") public static native @Name("calibrateCameraCharuco") double calibrateCameraCharucoExtended(@ByVal UMatVector charucoCorners, @ByVal UMatVector charucoIds,
                              @Ptr CharucoBoard board, @ByVal Size imageSize, @ByVal GpuMat cameraMatrix,
                              @ByVal GpuMat distCoeffs, @ByVal UMatVector rvecs, @ByVal UMatVector tvecs,
                              @ByVal GpuMat stdDeviationsIntrinsics, @ByVal GpuMat stdDeviationsExtrinsics,
                              @ByVal GpuMat perViewErrors, int flags/*=0*/, @Const @ByRef(nullValue = "cv::TermCriteria("
                               + "cv::TermCriteria::COUNT + cv::TermCriteria::EPS, 30, DBL_EPSILON)") TermCriteria criteria);
@Namespace("cv::aruco") public static native @Name("calibrateCameraCharuco") double calibrateCameraCharucoExtended(@ByVal UMatVector charucoCorners, @ByVal UMatVector charucoIds,
                              @Ptr CharucoBoard board, @ByVal Size imageSize, @ByVal GpuMat cameraMatrix,
                              @ByVal GpuMat distCoeffs, @ByVal UMatVector rvecs, @ByVal UMatVector tvecs,
                              @ByVal GpuMat stdDeviationsIntrinsics, @ByVal GpuMat stdDeviationsExtrinsics,
                              @ByVal GpuMat perViewErrors);
@Namespace("cv::aruco") public static native @Name("calibrateCameraCharuco") double calibrateCameraCharucoExtended(@ByVal GpuMatVector charucoCorners, @ByVal GpuMatVector charucoIds,
                              @Ptr CharucoBoard board, @ByVal Size imageSize, @ByVal GpuMat cameraMatrix,
                              @ByVal GpuMat distCoeffs, @ByVal GpuMatVector rvecs, @ByVal GpuMatVector tvecs,
                              @ByVal GpuMat stdDeviationsIntrinsics, @ByVal GpuMat stdDeviationsExtrinsics,
                              @ByVal GpuMat perViewErrors, int flags/*=0*/, @Const @ByRef(nullValue = "cv::TermCriteria("
                               + "cv::TermCriteria::COUNT + cv::TermCriteria::EPS, 30, DBL_EPSILON)") TermCriteria criteria);
@Namespace("cv::aruco") public static native @Name("calibrateCameraCharuco") double calibrateCameraCharucoExtended(@ByVal GpuMatVector charucoCorners, @ByVal GpuMatVector charucoIds,
                              @Ptr CharucoBoard board, @ByVal Size imageSize, @ByVal GpuMat cameraMatrix,
                              @ByVal GpuMat distCoeffs, @ByVal GpuMatVector rvecs, @ByVal GpuMatVector tvecs,
                              @ByVal GpuMat stdDeviationsIntrinsics, @ByVal GpuMat stdDeviationsExtrinsics,
                              @ByVal GpuMat perViewErrors);

/**
 * \brief It's the same function as #calibrateCameraCharuco but without calibration error estimation.
 */
@Namespace("cv::aruco") public static native double calibrateCameraCharuco(@ByVal MatVector charucoCorners, @ByVal MatVector charucoIds,
                                           @Ptr CharucoBoard board, @ByVal Size imageSize,
                                           @ByVal Mat cameraMatrix, @ByVal Mat distCoeffs,
                                           @ByVal(nullValue = "cv::OutputArrayOfArrays(cv::noArray())") MatVector rvecs,
                                           @ByVal(nullValue = "cv::OutputArrayOfArrays(cv::noArray())") MatVector tvecs, int flags/*=0*/,
                                           @Const @ByRef(nullValue = "cv::TermCriteria(cv::TermCriteria::COUNT +"
                                                                  + "cv::TermCriteria::EPS, 30, DBL_EPSILON)") TermCriteria criteria);
@Namespace("cv::aruco") public static native double calibrateCameraCharuco(@ByVal MatVector charucoCorners, @ByVal MatVector charucoIds,
                                           @Ptr CharucoBoard board, @ByVal Size imageSize,
                                           @ByVal Mat cameraMatrix, @ByVal Mat distCoeffs);
@Namespace("cv::aruco") public static native double calibrateCameraCharuco(@ByVal UMatVector charucoCorners, @ByVal UMatVector charucoIds,
                                           @Ptr CharucoBoard board, @ByVal Size imageSize,
                                           @ByVal Mat cameraMatrix, @ByVal Mat distCoeffs,
                                           @ByVal(nullValue = "cv::OutputArrayOfArrays(cv::noArray())") UMatVector rvecs,
                                           @ByVal(nullValue = "cv::OutputArrayOfArrays(cv::noArray())") UMatVector tvecs, int flags/*=0*/,
                                           @Const @ByRef(nullValue = "cv::TermCriteria(cv::TermCriteria::COUNT +"
                                                                  + "cv::TermCriteria::EPS, 30, DBL_EPSILON)") TermCriteria criteria);
@Namespace("cv::aruco") public static native double calibrateCameraCharuco(@ByVal UMatVector charucoCorners, @ByVal UMatVector charucoIds,
                                           @Ptr CharucoBoard board, @ByVal Size imageSize,
                                           @ByVal Mat cameraMatrix, @ByVal Mat distCoeffs);
@Namespace("cv::aruco") public static native double calibrateCameraCharuco(@ByVal GpuMatVector charucoCorners, @ByVal GpuMatVector charucoIds,
                                           @Ptr CharucoBoard board, @ByVal Size imageSize,
                                           @ByVal Mat cameraMatrix, @ByVal Mat distCoeffs,
                                           @ByVal(nullValue = "cv::OutputArrayOfArrays(cv::noArray())") GpuMatVector rvecs,
                                           @ByVal(nullValue = "cv::OutputArrayOfArrays(cv::noArray())") GpuMatVector tvecs, int flags/*=0*/,
                                           @Const @ByRef(nullValue = "cv::TermCriteria(cv::TermCriteria::COUNT +"
                                                                  + "cv::TermCriteria::EPS, 30, DBL_EPSILON)") TermCriteria criteria);
@Namespace("cv::aruco") public static native double calibrateCameraCharuco(@ByVal GpuMatVector charucoCorners, @ByVal GpuMatVector charucoIds,
                                           @Ptr CharucoBoard board, @ByVal Size imageSize,
                                           @ByVal Mat cameraMatrix, @ByVal Mat distCoeffs);
@Namespace("cv::aruco") public static native double calibrateCameraCharuco(@ByVal MatVector charucoCorners, @ByVal MatVector charucoIds,
                                           @Ptr CharucoBoard board, @ByVal Size imageSize,
                                           @ByVal UMat cameraMatrix, @ByVal UMat distCoeffs,
                                           @ByVal(nullValue = "cv::OutputArrayOfArrays(cv::noArray())") MatVector rvecs,
                                           @ByVal(nullValue = "cv::OutputArrayOfArrays(cv::noArray())") MatVector tvecs, int flags/*=0*/,
                                           @Const @ByRef(nullValue = "cv::TermCriteria(cv::TermCriteria::COUNT +"
                                                                  + "cv::TermCriteria::EPS, 30, DBL_EPSILON)") TermCriteria criteria);
@Namespace("cv::aruco") public static native double calibrateCameraCharuco(@ByVal MatVector charucoCorners, @ByVal MatVector charucoIds,
                                           @Ptr CharucoBoard board, @ByVal Size imageSize,
                                           @ByVal UMat cameraMatrix, @ByVal UMat distCoeffs);
@Namespace("cv::aruco") public static native double calibrateCameraCharuco(@ByVal UMatVector charucoCorners, @ByVal UMatVector charucoIds,
                                           @Ptr CharucoBoard board, @ByVal Size imageSize,
                                           @ByVal UMat cameraMatrix, @ByVal UMat distCoeffs,
                                           @ByVal(nullValue = "cv::OutputArrayOfArrays(cv::noArray())") UMatVector rvecs,
                                           @ByVal(nullValue = "cv::OutputArrayOfArrays(cv::noArray())") UMatVector tvecs, int flags/*=0*/,
                                           @Const @ByRef(nullValue = "cv::TermCriteria(cv::TermCriteria::COUNT +"
                                                                  + "cv::TermCriteria::EPS, 30, DBL_EPSILON)") TermCriteria criteria);
@Namespace("cv::aruco") public static native double calibrateCameraCharuco(@ByVal UMatVector charucoCorners, @ByVal UMatVector charucoIds,
                                           @Ptr CharucoBoard board, @ByVal Size imageSize,
                                           @ByVal UMat cameraMatrix, @ByVal UMat distCoeffs);
@Namespace("cv::aruco") public static native double calibrateCameraCharuco(@ByVal GpuMatVector charucoCorners, @ByVal GpuMatVector charucoIds,
                                           @Ptr CharucoBoard board, @ByVal Size imageSize,
                                           @ByVal UMat cameraMatrix, @ByVal UMat distCoeffs,
                                           @ByVal(nullValue = "cv::OutputArrayOfArrays(cv::noArray())") GpuMatVector rvecs,
                                           @ByVal(nullValue = "cv::OutputArrayOfArrays(cv::noArray())") GpuMatVector tvecs, int flags/*=0*/,
                                           @Const @ByRef(nullValue = "cv::TermCriteria(cv::TermCriteria::COUNT +"
                                                                  + "cv::TermCriteria::EPS, 30, DBL_EPSILON)") TermCriteria criteria);
@Namespace("cv::aruco") public static native double calibrateCameraCharuco(@ByVal GpuMatVector charucoCorners, @ByVal GpuMatVector charucoIds,
                                           @Ptr CharucoBoard board, @ByVal Size imageSize,
                                           @ByVal UMat cameraMatrix, @ByVal UMat distCoeffs);
@Namespace("cv::aruco") public static native double calibrateCameraCharuco(@ByVal MatVector charucoCorners, @ByVal MatVector charucoIds,
                                           @Ptr CharucoBoard board, @ByVal Size imageSize,
                                           @ByVal GpuMat cameraMatrix, @ByVal GpuMat distCoeffs,
                                           @ByVal(nullValue = "cv::OutputArrayOfArrays(cv::noArray())") MatVector rvecs,
                                           @ByVal(nullValue = "cv::OutputArrayOfArrays(cv::noArray())") MatVector tvecs, int flags/*=0*/,
                                           @Const @ByRef(nullValue = "cv::TermCriteria(cv::TermCriteria::COUNT +"
                                                                  + "cv::TermCriteria::EPS, 30, DBL_EPSILON)") TermCriteria criteria);
@Namespace("cv::aruco") public static native double calibrateCameraCharuco(@ByVal MatVector charucoCorners, @ByVal MatVector charucoIds,
                                           @Ptr CharucoBoard board, @ByVal Size imageSize,
                                           @ByVal GpuMat cameraMatrix, @ByVal GpuMat distCoeffs);
@Namespace("cv::aruco") public static native double calibrateCameraCharuco(@ByVal UMatVector charucoCorners, @ByVal UMatVector charucoIds,
                                           @Ptr CharucoBoard board, @ByVal Size imageSize,
                                           @ByVal GpuMat cameraMatrix, @ByVal GpuMat distCoeffs,
                                           @ByVal(nullValue = "cv::OutputArrayOfArrays(cv::noArray())") UMatVector rvecs,
                                           @ByVal(nullValue = "cv::OutputArrayOfArrays(cv::noArray())") UMatVector tvecs, int flags/*=0*/,
                                           @Const @ByRef(nullValue = "cv::TermCriteria(cv::TermCriteria::COUNT +"
                                                                  + "cv::TermCriteria::EPS, 30, DBL_EPSILON)") TermCriteria criteria);
@Namespace("cv::aruco") public static native double calibrateCameraCharuco(@ByVal UMatVector charucoCorners, @ByVal UMatVector charucoIds,
                                           @Ptr CharucoBoard board, @ByVal Size imageSize,
                                           @ByVal GpuMat cameraMatrix, @ByVal GpuMat distCoeffs);
@Namespace("cv::aruco") public static native double calibrateCameraCharuco(@ByVal GpuMatVector charucoCorners, @ByVal GpuMatVector charucoIds,
                                           @Ptr CharucoBoard board, @ByVal Size imageSize,
                                           @ByVal GpuMat cameraMatrix, @ByVal GpuMat distCoeffs,
                                           @ByVal(nullValue = "cv::OutputArrayOfArrays(cv::noArray())") GpuMatVector rvecs,
                                           @ByVal(nullValue = "cv::OutputArrayOfArrays(cv::noArray())") GpuMatVector tvecs, int flags/*=0*/,
                                           @Const @ByRef(nullValue = "cv::TermCriteria(cv::TermCriteria::COUNT +"
                                                                  + "cv::TermCriteria::EPS, 30, DBL_EPSILON)") TermCriteria criteria);
@Namespace("cv::aruco") public static native double calibrateCameraCharuco(@ByVal GpuMatVector charucoCorners, @ByVal GpuMatVector charucoIds,
                                           @Ptr CharucoBoard board, @ByVal Size imageSize,
                                           @ByVal GpuMat cameraMatrix, @ByVal GpuMat distCoeffs);
/** \} */



// #endif


// Parsed from <opencv2/aruco/charuco.hpp>

// This file is part of OpenCV project.
// It is subject to the license terms in the LICENSE file found in the top-level directory
// of this distribution and at http://opencv.org/license.html
// #ifndef OPENCV_CHARUCO_HPP
// #define OPENCV_CHARUCO_HPP

// #include <opencv2/core.hpp>
// #include <vector>
// #include <opencv2/aruco.hpp>
// #include <opencv2/objdetect/charuco_detector.hpp>
// #include <opencv2/aruco/aruco_calib.hpp>

/** \addtogroup aruco
 *  \{
<p>
/**
 * \brief Interpolate position of ChArUco board corners
 * @param markerCorners vector of already detected markers corners. For each marker, its four
 * corners are provided, (e.g std::vector<std::vector<cv::Point2f> > ). For N detected markers, the
 * dimensions of this array should be Nx4. The order of the corners should be clockwise.
 * @param markerIds list of identifiers for each marker in corners
 * @param image input image necesary for corner refinement. Note that markers are not detected and
 * should be sent in corners and ids parameters.
 * @param board layout of ChArUco board.
 * @param charucoCorners interpolated chessboard corners
 * @param charucoIds interpolated chessboard corners identifiers
 * @param cameraMatrix optional 3x3 floating-point camera matrix
 * {@code A = \vecthreethree{f_x}{0}{c_x}{0}{f_y}{c_y}{0}{0}{1}}
 * @param distCoeffs optional vector of distortion coefficients
 * {@code (k_1, k_2, p_1, p_2[, k_3[, k_4, k_5, k_6],[s_1, s_2, s_3, s_4]])} of 4, 5, 8 or 12 elements
 * @param minMarkers number of adjacent markers that must be detected to return a charuco corner
 *
 * This function receives the detected markers and returns the 2D position of the chessboard corners
 * from a ChArUco board using the detected Aruco markers. If camera parameters are provided,
 * the process is based in an approximated pose estimation, else it is based on local homography.
 * Only visible corners are returned. For each corner, its corresponding identifier is
 * also returned in charucoIds.
 * The function returns the number of interpolated corners.
 *
 * @deprecated Use CharucoDetector::detectBoard
 */
@Namespace("cv::aruco") public static native int interpolateCornersCharuco(@ByVal MatVector markerCorners, @ByVal Mat markerIds,
                                           @ByVal Mat image, @Ptr CharucoBoard board,
                                           @ByVal Mat charucoCorners, @ByVal Mat charucoIds,
                                           @ByVal(nullValue = "cv::InputArray(cv::noArray())") Mat cameraMatrix,
                                           @ByVal(nullValue = "cv::InputArray(cv::noArray())") Mat distCoeffs, int minMarkers/*=2*/);
@Namespace("cv::aruco") public static native int interpolateCornersCharuco(@ByVal MatVector markerCorners, @ByVal Mat markerIds,
                                           @ByVal Mat image, @Ptr CharucoBoard board,
                                           @ByVal Mat charucoCorners, @ByVal Mat charucoIds);
@Namespace("cv::aruco") public static native int interpolateCornersCharuco(@ByVal UMatVector markerCorners, @ByVal Mat markerIds,
                                           @ByVal Mat image, @Ptr CharucoBoard board,
                                           @ByVal Mat charucoCorners, @ByVal Mat charucoIds,
                                           @ByVal(nullValue = "cv::InputArray(cv::noArray())") Mat cameraMatrix,
                                           @ByVal(nullValue = "cv::InputArray(cv::noArray())") Mat distCoeffs, int minMarkers/*=2*/);
@Namespace("cv::aruco") public static native int interpolateCornersCharuco(@ByVal UMatVector markerCorners, @ByVal Mat markerIds,
                                           @ByVal Mat image, @Ptr CharucoBoard board,
                                           @ByVal Mat charucoCorners, @ByVal Mat charucoIds);
@Namespace("cv::aruco") public static native int interpolateCornersCharuco(@ByVal GpuMatVector markerCorners, @ByVal Mat markerIds,
                                           @ByVal Mat image, @Ptr CharucoBoard board,
                                           @ByVal Mat charucoCorners, @ByVal Mat charucoIds,
                                           @ByVal(nullValue = "cv::InputArray(cv::noArray())") Mat cameraMatrix,
                                           @ByVal(nullValue = "cv::InputArray(cv::noArray())") Mat distCoeffs, int minMarkers/*=2*/);
@Namespace("cv::aruco") public static native int interpolateCornersCharuco(@ByVal GpuMatVector markerCorners, @ByVal Mat markerIds,
                                           @ByVal Mat image, @Ptr CharucoBoard board,
                                           @ByVal Mat charucoCorners, @ByVal Mat charucoIds);
@Namespace("cv::aruco") public static native int interpolateCornersCharuco(@ByVal MatVector markerCorners, @ByVal UMat markerIds,
                                           @ByVal UMat image, @Ptr CharucoBoard board,
                                           @ByVal UMat charucoCorners, @ByVal UMat charucoIds,
                                           @ByVal(nullValue = "cv::InputArray(cv::noArray())") UMat cameraMatrix,
                                           @ByVal(nullValue = "cv::InputArray(cv::noArray())") UMat distCoeffs, int minMarkers/*=2*/);
@Namespace("cv::aruco") public static native int interpolateCornersCharuco(@ByVal MatVector markerCorners, @ByVal UMat markerIds,
                                           @ByVal UMat image, @Ptr CharucoBoard board,
                                           @ByVal UMat charucoCorners, @ByVal UMat charucoIds);
@Namespace("cv::aruco") public static native int interpolateCornersCharuco(@ByVal UMatVector markerCorners, @ByVal UMat markerIds,
                                           @ByVal UMat image, @Ptr CharucoBoard board,
                                           @ByVal UMat charucoCorners, @ByVal UMat charucoIds,
                                           @ByVal(nullValue = "cv::InputArray(cv::noArray())") UMat cameraMatrix,
                                           @ByVal(nullValue = "cv::InputArray(cv::noArray())") UMat distCoeffs, int minMarkers/*=2*/);
@Namespace("cv::aruco") public static native int interpolateCornersCharuco(@ByVal UMatVector markerCorners, @ByVal UMat markerIds,
                                           @ByVal UMat image, @Ptr CharucoBoard board,
                                           @ByVal UMat charucoCorners, @ByVal UMat charucoIds);
@Namespace("cv::aruco") public static native int interpolateCornersCharuco(@ByVal GpuMatVector markerCorners, @ByVal UMat markerIds,
                                           @ByVal UMat image, @Ptr CharucoBoard board,
                                           @ByVal UMat charucoCorners, @ByVal UMat charucoIds,
                                           @ByVal(nullValue = "cv::InputArray(cv::noArray())") UMat cameraMatrix,
                                           @ByVal(nullValue = "cv::InputArray(cv::noArray())") UMat distCoeffs, int minMarkers/*=2*/);
@Namespace("cv::aruco") public static native int interpolateCornersCharuco(@ByVal GpuMatVector markerCorners, @ByVal UMat markerIds,
                                           @ByVal UMat image, @Ptr CharucoBoard board,
                                           @ByVal UMat charucoCorners, @ByVal UMat charucoIds);
@Namespace("cv::aruco") public static native int interpolateCornersCharuco(@ByVal MatVector markerCorners, @ByVal GpuMat markerIds,
                                           @ByVal GpuMat image, @Ptr CharucoBoard board,
                                           @ByVal GpuMat charucoCorners, @ByVal GpuMat charucoIds,
                                           @ByVal(nullValue = "cv::InputArray(cv::noArray())") GpuMat cameraMatrix,
                                           @ByVal(nullValue = "cv::InputArray(cv::noArray())") GpuMat distCoeffs, int minMarkers/*=2*/);
@Namespace("cv::aruco") public static native int interpolateCornersCharuco(@ByVal MatVector markerCorners, @ByVal GpuMat markerIds,
                                           @ByVal GpuMat image, @Ptr CharucoBoard board,
                                           @ByVal GpuMat charucoCorners, @ByVal GpuMat charucoIds);
@Namespace("cv::aruco") public static native int interpolateCornersCharuco(@ByVal UMatVector markerCorners, @ByVal GpuMat markerIds,
                                           @ByVal GpuMat image, @Ptr CharucoBoard board,
                                           @ByVal GpuMat charucoCorners, @ByVal GpuMat charucoIds,
                                           @ByVal(nullValue = "cv::InputArray(cv::noArray())") GpuMat cameraMatrix,
                                           @ByVal(nullValue = "cv::InputArray(cv::noArray())") GpuMat distCoeffs, int minMarkers/*=2*/);
@Namespace("cv::aruco") public static native int interpolateCornersCharuco(@ByVal UMatVector markerCorners, @ByVal GpuMat markerIds,
                                           @ByVal GpuMat image, @Ptr CharucoBoard board,
                                           @ByVal GpuMat charucoCorners, @ByVal GpuMat charucoIds);
@Namespace("cv::aruco") public static native int interpolateCornersCharuco(@ByVal GpuMatVector markerCorners, @ByVal GpuMat markerIds,
                                           @ByVal GpuMat image, @Ptr CharucoBoard board,
                                           @ByVal GpuMat charucoCorners, @ByVal GpuMat charucoIds,
                                           @ByVal(nullValue = "cv::InputArray(cv::noArray())") GpuMat cameraMatrix,
                                           @ByVal(nullValue = "cv::InputArray(cv::noArray())") GpuMat distCoeffs, int minMarkers/*=2*/);
@Namespace("cv::aruco") public static native int interpolateCornersCharuco(@ByVal GpuMatVector markerCorners, @ByVal GpuMat markerIds,
                                           @ByVal GpuMat image, @Ptr CharucoBoard board,
                                           @ByVal GpuMat charucoCorners, @ByVal GpuMat charucoIds);

/**
 * \brief Detect ChArUco Diamond markers
 *
 * @param image input image necessary for corner subpixel.
 * @param markerCorners list of detected marker corners from detectMarkers function.
 * @param markerIds list of marker ids in markerCorners.
 * @param squareMarkerLengthRate rate between square and marker length:
 * squareMarkerLengthRate = squareLength/markerLength. The real units are not necessary.
 * @param diamondCorners output list of detected diamond corners (4 corners per diamond). The order
 * is the same than in marker corners: top left, top right, bottom right and bottom left. Similar
 * format than the corners returned by detectMarkers (e.g std::vector<std::vector<cv::Point2f> > ).
 * @param diamondIds ids of the diamonds in diamondCorners. The id of each diamond is in fact of
 * type Vec4i, so each diamond has 4 ids, which are the ids of the aruco markers composing the
 * diamond.
 * @param cameraMatrix Optional camera calibration matrix.
 * @param distCoeffs Optional camera distortion coefficients.
 * @param dictionary dictionary of markers indicating the type of markers.
 *
 * This function detects Diamond markers from the previous detected ArUco markers. The diamonds
 * are returned in the diamondCorners and diamondIds parameters. If camera calibration parameters
 * are provided, the diamond search is based on reprojection. If not, diamond search is based on
 * homography. Homography is faster than reprojection, but less accurate.
 *
 * @deprecated Use CharucoDetector::detectDiamonds
 */
@Namespace("cv::aruco") public static native void detectCharucoDiamond(@ByVal Mat image, @ByVal MatVector markerCorners,
                                       @ByVal Mat markerIds, float squareMarkerLengthRate,
                                       @ByVal MatVector diamondCorners, @ByVal Mat diamondIds,
                                       @ByVal(nullValue = "cv::InputArray(cv::noArray())") Mat cameraMatrix,
                                       @ByVal(nullValue = "cv::InputArray(cv::noArray())") Mat distCoeffs,
                                       @Ptr Dictionary dictionary/*=makePtr<cv::aruco::Dictionary>
                                               (getPredefinedDictionary(cv::aruco::PredefinedDictionaryType::DICT_4X4_50))*/);
@Namespace("cv::aruco") public static native void detectCharucoDiamond(@ByVal Mat image, @ByVal MatVector markerCorners,
                                       @ByVal Mat markerIds, float squareMarkerLengthRate,
                                       @ByVal MatVector diamondCorners, @ByVal Mat diamondIds);
@Namespace("cv::aruco") public static native void detectCharucoDiamond(@ByVal Mat image, @ByVal UMatVector markerCorners,
                                       @ByVal Mat markerIds, float squareMarkerLengthRate,
                                       @ByVal UMatVector diamondCorners, @ByVal Mat diamondIds,
                                       @ByVal(nullValue = "cv::InputArray(cv::noArray())") Mat cameraMatrix,
                                       @ByVal(nullValue = "cv::InputArray(cv::noArray())") Mat distCoeffs,
                                       @Ptr Dictionary dictionary/*=makePtr<cv::aruco::Dictionary>
                                               (getPredefinedDictionary(cv::aruco::PredefinedDictionaryType::DICT_4X4_50))*/);
@Namespace("cv::aruco") public static native void detectCharucoDiamond(@ByVal Mat image, @ByVal UMatVector markerCorners,
                                       @ByVal Mat markerIds, float squareMarkerLengthRate,
                                       @ByVal UMatVector diamondCorners, @ByVal Mat diamondIds);
@Namespace("cv::aruco") public static native void detectCharucoDiamond(@ByVal Mat image, @ByVal GpuMatVector markerCorners,
                                       @ByVal Mat markerIds, float squareMarkerLengthRate,
                                       @ByVal GpuMatVector diamondCorners, @ByVal Mat diamondIds,
                                       @ByVal(nullValue = "cv::InputArray(cv::noArray())") Mat cameraMatrix,
                                       @ByVal(nullValue = "cv::InputArray(cv::noArray())") Mat distCoeffs,
                                       @Ptr Dictionary dictionary/*=makePtr<cv::aruco::Dictionary>
                                               (getPredefinedDictionary(cv::aruco::PredefinedDictionaryType::DICT_4X4_50))*/);
@Namespace("cv::aruco") public static native void detectCharucoDiamond(@ByVal Mat image, @ByVal GpuMatVector markerCorners,
                                       @ByVal Mat markerIds, float squareMarkerLengthRate,
                                       @ByVal GpuMatVector diamondCorners, @ByVal Mat diamondIds);
@Namespace("cv::aruco") public static native void detectCharucoDiamond(@ByVal UMat image, @ByVal MatVector markerCorners,
                                       @ByVal UMat markerIds, float squareMarkerLengthRate,
                                       @ByVal MatVector diamondCorners, @ByVal UMat diamondIds,
                                       @ByVal(nullValue = "cv::InputArray(cv::noArray())") UMat cameraMatrix,
                                       @ByVal(nullValue = "cv::InputArray(cv::noArray())") UMat distCoeffs,
                                       @Ptr Dictionary dictionary/*=makePtr<cv::aruco::Dictionary>
                                               (getPredefinedDictionary(cv::aruco::PredefinedDictionaryType::DICT_4X4_50))*/);
@Namespace("cv::aruco") public static native void detectCharucoDiamond(@ByVal UMat image, @ByVal MatVector markerCorners,
                                       @ByVal UMat markerIds, float squareMarkerLengthRate,
                                       @ByVal MatVector diamondCorners, @ByVal UMat diamondIds);
@Namespace("cv::aruco") public static native void detectCharucoDiamond(@ByVal UMat image, @ByVal UMatVector markerCorners,
                                       @ByVal UMat markerIds, float squareMarkerLengthRate,
                                       @ByVal UMatVector diamondCorners, @ByVal UMat diamondIds,
                                       @ByVal(nullValue = "cv::InputArray(cv::noArray())") UMat cameraMatrix,
                                       @ByVal(nullValue = "cv::InputArray(cv::noArray())") UMat distCoeffs,
                                       @Ptr Dictionary dictionary/*=makePtr<cv::aruco::Dictionary>
                                               (getPredefinedDictionary(cv::aruco::PredefinedDictionaryType::DICT_4X4_50))*/);
@Namespace("cv::aruco") public static native void detectCharucoDiamond(@ByVal UMat image, @ByVal UMatVector markerCorners,
                                       @ByVal UMat markerIds, float squareMarkerLengthRate,
                                       @ByVal UMatVector diamondCorners, @ByVal UMat diamondIds);
@Namespace("cv::aruco") public static native void detectCharucoDiamond(@ByVal UMat image, @ByVal GpuMatVector markerCorners,
                                       @ByVal UMat markerIds, float squareMarkerLengthRate,
                                       @ByVal GpuMatVector diamondCorners, @ByVal UMat diamondIds,
                                       @ByVal(nullValue = "cv::InputArray(cv::noArray())") UMat cameraMatrix,
                                       @ByVal(nullValue = "cv::InputArray(cv::noArray())") UMat distCoeffs,
                                       @Ptr Dictionary dictionary/*=makePtr<cv::aruco::Dictionary>
                                               (getPredefinedDictionary(cv::aruco::PredefinedDictionaryType::DICT_4X4_50))*/);
@Namespace("cv::aruco") public static native void detectCharucoDiamond(@ByVal UMat image, @ByVal GpuMatVector markerCorners,
                                       @ByVal UMat markerIds, float squareMarkerLengthRate,
                                       @ByVal GpuMatVector diamondCorners, @ByVal UMat diamondIds);
@Namespace("cv::aruco") public static native void detectCharucoDiamond(@ByVal GpuMat image, @ByVal MatVector markerCorners,
                                       @ByVal GpuMat markerIds, float squareMarkerLengthRate,
                                       @ByVal MatVector diamondCorners, @ByVal GpuMat diamondIds,
                                       @ByVal(nullValue = "cv::InputArray(cv::noArray())") GpuMat cameraMatrix,
                                       @ByVal(nullValue = "cv::InputArray(cv::noArray())") GpuMat distCoeffs,
                                       @Ptr Dictionary dictionary/*=makePtr<cv::aruco::Dictionary>
                                               (getPredefinedDictionary(cv::aruco::PredefinedDictionaryType::DICT_4X4_50))*/);
@Namespace("cv::aruco") public static native void detectCharucoDiamond(@ByVal GpuMat image, @ByVal MatVector markerCorners,
                                       @ByVal GpuMat markerIds, float squareMarkerLengthRate,
                                       @ByVal MatVector diamondCorners, @ByVal GpuMat diamondIds);
@Namespace("cv::aruco") public static native void detectCharucoDiamond(@ByVal GpuMat image, @ByVal UMatVector markerCorners,
                                       @ByVal GpuMat markerIds, float squareMarkerLengthRate,
                                       @ByVal UMatVector diamondCorners, @ByVal GpuMat diamondIds,
                                       @ByVal(nullValue = "cv::InputArray(cv::noArray())") GpuMat cameraMatrix,
                                       @ByVal(nullValue = "cv::InputArray(cv::noArray())") GpuMat distCoeffs,
                                       @Ptr Dictionary dictionary/*=makePtr<cv::aruco::Dictionary>
                                               (getPredefinedDictionary(cv::aruco::PredefinedDictionaryType::DICT_4X4_50))*/);
@Namespace("cv::aruco") public static native void detectCharucoDiamond(@ByVal GpuMat image, @ByVal UMatVector markerCorners,
                                       @ByVal GpuMat markerIds, float squareMarkerLengthRate,
                                       @ByVal UMatVector diamondCorners, @ByVal GpuMat diamondIds);
@Namespace("cv::aruco") public static native void detectCharucoDiamond(@ByVal GpuMat image, @ByVal GpuMatVector markerCorners,
                                       @ByVal GpuMat markerIds, float squareMarkerLengthRate,
                                       @ByVal GpuMatVector diamondCorners, @ByVal GpuMat diamondIds,
                                       @ByVal(nullValue = "cv::InputArray(cv::noArray())") GpuMat cameraMatrix,
                                       @ByVal(nullValue = "cv::InputArray(cv::noArray())") GpuMat distCoeffs,
                                       @Ptr Dictionary dictionary/*=makePtr<cv::aruco::Dictionary>
                                               (getPredefinedDictionary(cv::aruco::PredefinedDictionaryType::DICT_4X4_50))*/);
@Namespace("cv::aruco") public static native void detectCharucoDiamond(@ByVal GpuMat image, @ByVal GpuMatVector markerCorners,
                                       @ByVal GpuMat markerIds, float squareMarkerLengthRate,
                                       @ByVal GpuMatVector diamondCorners, @ByVal GpuMat diamondIds);


/**
 * \brief Draw a ChArUco Diamond marker
 *
 * @param dictionary dictionary of markers indicating the type of markers.
 * @param ids list of 4 ids for each ArUco marker in the ChArUco marker.
 * @param squareLength size of the chessboard squares in pixels.
 * @param markerLength size of the markers in pixels.
 * @param img output image with the marker. The size of this image will be
 * 3*squareLength + 2*marginSize,.
 * @param marginSize minimum margins (in pixels) of the marker in the output image
 * @param borderBits width of the marker borders.
 *
 * This function return the image of a ChArUco marker, ready to be printed.
 */
@Namespace("cv::aruco") public static native void drawCharucoDiamond(@Ptr Dictionary dictionary, @ByVal @Cast("cv::Vec4i*") Scalar4i ids, int squareLength,
                                     int markerLength, @ByVal Mat img, int marginSize/*=0*/,
                                     int borderBits/*=1*/);
@Namespace("cv::aruco") public static native void drawCharucoDiamond(@Ptr Dictionary dictionary, @ByVal @Cast("cv::Vec4i*") Scalar4i ids, int squareLength,
                                     int markerLength, @ByVal Mat img);
@Namespace("cv::aruco") public static native void drawCharucoDiamond(@Ptr Dictionary dictionary, @ByVal @Cast("cv::Vec4i*") Scalar4i ids, int squareLength,
                                     int markerLength, @ByVal UMat img, int marginSize/*=0*/,
                                     int borderBits/*=1*/);
@Namespace("cv::aruco") public static native void drawCharucoDiamond(@Ptr Dictionary dictionary, @ByVal @Cast("cv::Vec4i*") Scalar4i ids, int squareLength,
                                     int markerLength, @ByVal UMat img);
@Namespace("cv::aruco") public static native void drawCharucoDiamond(@Ptr Dictionary dictionary, @ByVal @Cast("cv::Vec4i*") Scalar4i ids, int squareLength,
                                     int markerLength, @ByVal GpuMat img, int marginSize/*=0*/,
                                     int borderBits/*=1*/);
@Namespace("cv::aruco") public static native void drawCharucoDiamond(@Ptr Dictionary dictionary, @ByVal @Cast("cv::Vec4i*") Scalar4i ids, int squareLength,
                                     int markerLength, @ByVal GpuMat img);

/** \} */



// #endif


}
