// Targeted by JavaCPP version 1.5.1: DO NOT EDIT THIS FILE

package org.bytedeco.librealsense.global;

import org.bytedeco.librealsense.*;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

public class RealSense extends org.bytedeco.librealsense.presets.RealSense {
    static { Loader.load(); }

// Parsed from <librealsense/rs.h>

/* License: Apache 2.0. See LICENSE file in root directory.
   Copyright(c) 2015 Intel Corporation. All Rights Reserved. */

// #ifndef LIBREALSENSE_RS_H
// #define LIBREALSENSE_RS_H

// #ifdef __cplusplus
// #endif

public static final int RS_API_MAJOR_VERSION =    1;
public static final int RS_API_MINOR_VERSION =    12;
public static final int RS_API_PATCH_VERSION =    1;

// #define STRINGIFY(arg) #arg
// #define VAR_ARG_STRING(arg) STRINGIFY(arg)

/* Versioning rules            : For each release at least one of [MJR/MNR/PTCH] triple is promoted                                             */
/*                             : Versions that differ by RS_API_PATCH_VERSION only are interface-compatible, i.e. no user-code changes required */
/*                             : Versions that differ by MAJOR/MINOR VERSION component can introduce API changes                                */
/* Version in encoded integer format (1,9,x) -> 01090x. note that each component is limited into [0-99] range by design                         */
public static final int RS_API_VERSION =  (((RS_API_MAJOR_VERSION) * 10000) + ((RS_API_MINOR_VERSION) * 100) + (RS_API_PATCH_VERSION));
/* Return version in "X.Y.Z" format */
public static native @MemberGetter String RS_API_VERSION_STR();
public static final String RS_API_VERSION_STR = RS_API_VERSION_STR();

/* streams are different types of data provided by RealSense devices */
/** enum rs_stream */
public static final int
    /** Native stream of depth data produced by RealSense device */
    RS_STREAM_DEPTH = 0,
    /** Native stream of color data captured by RealSense device */
    RS_STREAM_COLOR = 1,
    /** Native stream of infrared data captured by RealSense device */
    RS_STREAM_INFRARED = 2,
    /** Native stream of infrared data captured from a second viewpoint by RealSense device */
    RS_STREAM_INFRARED2 = 3,
    /** Native stream of fish-eye (wide) data captured from the dedicate motion camera */
    RS_STREAM_FISHEYE = 4,
    /** Synthetic stream containing point cloud data generated by deprojecting the depth image */
    RS_STREAM_POINTS = 5,
    /** Synthetic stream containing undistorted color data with no extrinsic rotation from the depth stream */
    RS_STREAM_RECTIFIED_COLOR = 6,
    /** Synthetic stream containing color data but sharing intrinsic of depth stream */
    RS_STREAM_COLOR_ALIGNED_TO_DEPTH = 7,
    /** Synthetic stream containing second viewpoint infrared data but sharing intrinsic of depth stream */
    RS_STREAM_INFRARED2_ALIGNED_TO_DEPTH = 8,
    /** Synthetic stream containing depth data but sharing intrinsic of color stream */
    RS_STREAM_DEPTH_ALIGNED_TO_COLOR = 9,
    /** Synthetic stream containing depth data but sharing intrinsic of rectified color stream */
    RS_STREAM_DEPTH_ALIGNED_TO_RECTIFIED_COLOR = 10,
    /** Synthetic stream containing depth data but sharing intrinsic of second viewpoint infrared stream */
    RS_STREAM_DEPTH_ALIGNED_TO_INFRARED2 = 11,
    RS_STREAM_COUNT = 12;

/*  formats define how each stream can be encoded
    rs_format is closely relateed to Linux pixel-formats, but is trying to abstract away the platform specific constructs */
/** enum rs_format */
public static final int
    /** When passed to enable stream, librealsense will try to provide best suited format */
    RS_FORMAT_ANY = 0,
    /** 16 bit linear depth values. The depth is meters is equal to depth scale * pixel value */
    RS_FORMAT_Z16 = 1,
    /** 16 bit linear disparity values. The depth in meters is equal to depth scale / pixel value */
    RS_FORMAT_DISPARITY16 = 2,
    /** 32 bit floating point 3D coordinates. */
    RS_FORMAT_XYZ32F = 3,
    /** Standard YUV pixel format as described in https://en.wikipedia.org/wiki/YUV */
    RS_FORMAT_YUYV = 4,
    /** 8-bit Red, Green and Blue channels */
    RS_FORMAT_RGB8 = 5,
    /** 8-bit Blue, Green and Red channels, suitable for OpenCV */
    RS_FORMAT_BGR8 = 6,
    /** 8-bit Red, Green, Blue channels + constant alpha channel equal to FF */
    RS_FORMAT_RGBA8 = 7,
    /** 8-bit Blue, Green, Red channels + constant alpha channel equal to FF */
    RS_FORMAT_BGRA8 = 8,
    /** 8-bit per-pixel grayscale image */
    RS_FORMAT_Y8 = 9,
    /** 16-bit per-pixel grayscale image */
    RS_FORMAT_Y16 = 10,
    /** Four 10-bit luminance values encoded into a 5-byte macropixel */
    RS_FORMAT_RAW10 = 11,
    /** 16-bit raw image */
    RS_FORMAT_RAW16 = 12,
    /** 8-bit raw image */
    RS_FORMAT_RAW8 = 13,
    RS_FORMAT_COUNT = 14;

/* Output buffer format sets how librealsense will work with frame memory */
/** enum rs_output_buffer_format */
public static final int
    /** Makes sure that the output frame is exposed as a single continuous buffer */
    RS_OUTPUT_BUFFER_FORMAT_CONTINUOUS = 0,
    /** Don't convert buffer to continuous, the user has to handle pitch manually */
    RS_OUTPUT_BUFFER_FORMAT_NATIVE = 1,
    RS_OUTPUT_BUFFER_FORMAT_COUNT = 2;

/* Presets hint general preference that is translated by librealsense into concrete resultion and fps */
/** enum rs_preset */
public static final int
    /** Prefer best overall quality */
    RS_PRESET_BEST_QUALITY = 0,
    /** Prefer largest image size */
    RS_PRESET_LARGEST_IMAGE = 1,
    /** Prefer highest framerate */
    RS_PRESET_HIGHEST_FRAMERATE = 2,
    RS_PRESET_COUNT = 3;

/* Source allows the user to choose between available hardware subdevices */
/** enum rs_source */
public static final int
    /** Video streaming of depth, infrared, color or fish-eye */
    RS_SOURCE_VIDEO = 0,
    /** Motion tracking from Gyro and Accelerometer */
    RS_SOURCE_MOTION_TRACKING = 1,
    /** Enable everything together */
    RS_SOURCE_ALL = 2,
    RS_SOURCE_COUNT = 3;

/* Distortion model define how pixel coordinates should be mapped to sensor coordinates */
/** enum rs_distortion */
public static final int
    /** Rectilinear images, no distortion compensation required */
    RS_DISTORTION_NONE = 0,
    /** Equivalent to Brown-Conrady distortion, except that tangential distortion is applied to radially distorted points */
    RS_DISTORTION_MODIFIED_BROWN_CONRADY = 1,
    /** Equivalent to Brown-Conrady distortion, except undistorts image instead of distorting it */
    RS_DISTORTION_INVERSE_BROWN_CONRADY = 2,
    /** Distortion model of the fish-eye camera */
    RS_DISTORTION_FTHETA = 3,
    RS_DISTORTION_COUNT = 4;

/* For SR300 device, ivcam_presets provide optimized settings for specific types of usage */
/** enum rs_ivcam_preset */
public static final int
    RS_IVCAM_PRESET_SHORT_RANGE = 0,
    RS_IVCAM_PRESET_LONG_RANGE = 1,
    RS_IVCAM_PRESET_BACKGROUND_SEGMENTATION = 2,
    RS_IVCAM_PRESET_GESTURE_RECOGNITION = 3,
    RS_IVCAM_PRESET_OBJECT_SCANNING = 4,
    RS_IVCAM_PRESET_FACE_ANALYTICS = 5,
    RS_IVCAM_PRESET_FACE_LOGIN = 6,
    RS_IVCAM_PRESET_GR_CURSOR = 7,
    RS_IVCAM_PRESET_DEFAULT = 8,
    RS_IVCAM_PRESET_MID_RANGE = 9,
    RS_IVCAM_PRESET_IR_ONLY = 10,
    RS_IVCAM_PRESET_COUNT = 11;

/* Camera options define general configuration controls. 
   These can generally be mapped to camera UVC controls, and unless stated otherwise can be set/queried at any time */
/** enum rs_option */
public static final int
    /** Enable / disable color backlight compensation*/
    RS_OPTION_COLOR_BACKLIGHT_COMPENSATION = 0,
    /** Color image brightness*/
    RS_OPTION_COLOR_BRIGHTNESS = 1,
    /** Color image contrast*/
    RS_OPTION_COLOR_CONTRAST = 2,
    /** Controls exposure time of color camera. Setting any value will disable auto exposure*/
    RS_OPTION_COLOR_EXPOSURE = 3,
    /** Color image gain*/
    RS_OPTION_COLOR_GAIN = 4,
    /** Color image gamma setting*/
    RS_OPTION_COLOR_GAMMA = 5,
    /** Color image hue*/
    RS_OPTION_COLOR_HUE = 6,
    /** Color image saturation setting*/
    RS_OPTION_COLOR_SATURATION = 7,
    /** Color image sharpness setting*/
    RS_OPTION_COLOR_SHARPNESS = 8,
    /** Controls white balance of color image. Setting any value will disable auto white balance*/
    RS_OPTION_COLOR_WHITE_BALANCE = 9,
    /** Enable / disable color image auto-exposure*/
    RS_OPTION_COLOR_ENABLE_AUTO_EXPOSURE = 10,
    /** Enable / disable color image auto-white-balance*/
    RS_OPTION_COLOR_ENABLE_AUTO_WHITE_BALANCE = 11,
    /** Power of the F200 / SR300 projector, with 0 meaning projector off*/
    RS_OPTION_F200_LASER_POWER = 12,
    /** Set the number of patterns projected per frame. The higher the accuracy value the more patterns projected. Increasing the number of patterns help to achieve better accuracy. Note that this control is affecting the Depth FPS */
    RS_OPTION_F200_ACCURACY = 13,
    /** Motion vs. Range trade-off, with lower values allowing for better motion sensitivity and higher values allowing for better depth range*/
    RS_OPTION_F200_MOTION_RANGE = 14,
    /** Set the filter to apply to each depth frame. Each one of the filter is optimized per the application requirements*/
    RS_OPTION_F200_FILTER_OPTION = 15,
    /** The confidence level threshold used by the Depth algorithm pipe to set whether a pixel will get a valid range or will be marked with invalid range*/
    RS_OPTION_F200_CONFIDENCE_THRESHOLD = 16,
    /** (F200-only) Allows to reduce FPS without restarting streaming. Valid values are {2, 5, 15, 30, 60}*/
    RS_OPTION_F200_DYNAMIC_FPS = 17,
    /** Configures SR300 Depth Auto-Range setting. Should not be used directly but through set IVCAM preset method*/
    RS_OPTION_SR300_AUTO_RANGE_ENABLE_MOTION_VERSUS_RANGE = 18,
    /** Configures SR300 Depth Auto-Range setting. Should not be used directly but through set IVCAM preset method*/
    RS_OPTION_SR300_AUTO_RANGE_ENABLE_LASER = 19,
    /** Configures SR300 Depth Auto-Range setting. Should not be used directly but through set IVCAM preset method*/
    RS_OPTION_SR300_AUTO_RANGE_MIN_MOTION_VERSUS_RANGE = 20,
    /** Configures SR300 Depth Auto-Range setting. Should not be used directly but through set IVCAM preset method*/
    RS_OPTION_SR300_AUTO_RANGE_MAX_MOTION_VERSUS_RANGE = 21,
    /** Configures SR300 Depth Auto-Range setting. Should not be used directly but through set IVCAM preset method*/
    RS_OPTION_SR300_AUTO_RANGE_START_MOTION_VERSUS_RANGE = 22,
    /** Configures SR300 Depth Auto-Range setting. Should not be used directly but through set IVCAM preset method*/
    RS_OPTION_SR300_AUTO_RANGE_MIN_LASER = 23,
    /** Configures SR300 Depth Auto-Range setting. Should not be used directly but through set IVCAM preset method*/
    RS_OPTION_SR300_AUTO_RANGE_MAX_LASER = 24,
    /** Configures SR300 Depth Auto-Range setting. Should not be used directly but through set IVCAM preset method*/
    RS_OPTION_SR300_AUTO_RANGE_START_LASER = 25,
    /** Configures SR300 Depth Auto-Range setting. Should not be used directly but through set IVCAM preset method*/
    RS_OPTION_SR300_AUTO_RANGE_UPPER_THRESHOLD = 26,
    /** Configures SR300 Depth Auto-Range setting. Should not be used directly but through set IVCAM preset method*/
    RS_OPTION_SR300_AUTO_RANGE_LOWER_THRESHOLD = 27,
    /** Enables / disables R200 auto-exposure. This will affect both IR and depth image.*/
    RS_OPTION_R200_LR_AUTO_EXPOSURE_ENABLED = 28,
    /** IR image gain*/
    RS_OPTION_R200_LR_GAIN = 29,
    /** This control allows manual adjustment of the exposure time value for the L/R imagers*/
    RS_OPTION_R200_LR_EXPOSURE = 30,
    /** Enables / disables R200 emitter*/
    RS_OPTION_R200_EMITTER_ENABLED = 31,
    /** Micrometers per increment in integer depth values, 1000 is default (mm scale). Set before streaming*/
    RS_OPTION_R200_DEPTH_UNITS = 32,
    /** Minimum depth in current depth units that will be output. Any values less than Min Depth will be mapped to 0 during the conversion between disparity and depth. Set before streaming*/
    RS_OPTION_R200_DEPTH_CLAMP_MIN = 33,
    /** Maximum depth in current depth units that will be output. Any values greater than Max Depth will be mapped to 0 during the conversion between disparity and depth. Set before streaming*/
    RS_OPTION_R200_DEPTH_CLAMP_MAX = 34,
    /** The disparity scale factor used when in disparity output mode. Can only be set before streaming*/
    RS_OPTION_R200_DISPARITY_MULTIPLIER = 35,
    /** {0 - 512}. Can only be set before streaming starts*/
    RS_OPTION_R200_DISPARITY_SHIFT = 36,
    /** (Requires LR-Auto-Exposure ON) Mean intensity set point*/
    RS_OPTION_R200_AUTO_EXPOSURE_MEAN_INTENSITY_SET_POINT = 37,
    /** (Requires LR-Auto-Exposure ON) Bright ratio set point*/
    RS_OPTION_R200_AUTO_EXPOSURE_BRIGHT_RATIO_SET_POINT = 38,
    /** (Requires LR-Auto-Exposure ON) Kp Gain*/
    RS_OPTION_R200_AUTO_EXPOSURE_KP_GAIN = 39,
    /** (Requires LR-Auto-Exposure ON) Kp Exposure*/
    RS_OPTION_R200_AUTO_EXPOSURE_KP_EXPOSURE = 40,
    /** (Requires LR-Auto-Exposure ON) Kp Dark Threshold*/
    RS_OPTION_R200_AUTO_EXPOSURE_KP_DARK_THRESHOLD = 41,
    /** (Requires LR-Auto-Exposure ON) Auto-Exposure region-of-interest top edge (in pixels)*/
    RS_OPTION_R200_AUTO_EXPOSURE_TOP_EDGE = 42,
    /** (Requires LR-Auto-Exposure ON) Auto-Exposure region-of-interest bottom edge (in pixels)*/
    RS_OPTION_R200_AUTO_EXPOSURE_BOTTOM_EDGE = 43,
    /** (Requires LR-Auto-Exposure ON) Auto-Exposure region-of-interest left edge (in pixels)*/
    RS_OPTION_R200_AUTO_EXPOSURE_LEFT_EDGE = 44,
    /** (Requires LR-Auto-Exposure ON) Auto-Exposure region-of-interest right edge (in pixels)*/
    RS_OPTION_R200_AUTO_EXPOSURE_RIGHT_EDGE = 45,
    /** Value to subtract when estimating the median of the correlation surface*/
    RS_OPTION_R200_DEPTH_CONTROL_ESTIMATE_MEDIAN_DECREMENT = 46,
    /** Value to add when estimating the median of the correlation surface*/
    RS_OPTION_R200_DEPTH_CONTROL_ESTIMATE_MEDIAN_INCREMENT = 47,
    /** A threshold by how much the winning score must beat the median*/
    RS_OPTION_R200_DEPTH_CONTROL_MEDIAN_THRESHOLD = 48,
    /** The minimum correlation score that is considered acceptable*/
    RS_OPTION_R200_DEPTH_CONTROL_SCORE_MINIMUM_THRESHOLD = 49,
    /** The maximum correlation score that is considered acceptable*/
    RS_OPTION_R200_DEPTH_CONTROL_SCORE_MAXIMUM_THRESHOLD = 50,
    /** A parameter for determining whether the texture in the region is sufficient to justify a depth result*/
    RS_OPTION_R200_DEPTH_CONTROL_TEXTURE_COUNT_THRESHOLD = 51,
    /** A parameter for determining whether the texture in the region is sufficient to justify a depth result*/
    RS_OPTION_R200_DEPTH_CONTROL_TEXTURE_DIFFERENCE_THRESHOLD = 52,
    /** A threshold on how much the minimum correlation score must differ from the next best score*/
    RS_OPTION_R200_DEPTH_CONTROL_SECOND_PEAK_THRESHOLD = 53,
    /** Neighbor threshold value for depth calculation*/
    RS_OPTION_R200_DEPTH_CONTROL_NEIGHBOR_THRESHOLD = 54,
    /** Left-Right threshold value for depth calculation*/
    RS_OPTION_R200_DEPTH_CONTROL_LR_THRESHOLD = 55,
    /** Fisheye image exposure time in msec*/
    RS_OPTION_FISHEYE_EXPOSURE = 56,
    /** Fisheye image gain*/
    RS_OPTION_FISHEYE_GAIN = 57,
    /** Enables / disables fisheye strobe. When enabled this will align timestamps to common clock-domain with the motion events*/
    RS_OPTION_FISHEYE_STROBE = 58,
    /** Enables / disables fisheye external trigger mode. When enabled fisheye image will be aquired in-sync with the depth image*/
    RS_OPTION_FISHEYE_EXTERNAL_TRIGGER = 59,
    /** Enable / disable fisheye auto-exposure */
    RS_OPTION_FISHEYE_ENABLE_AUTO_EXPOSURE = 60,
    /** 0 - static auto-exposure, 1 - anti-flicker auto-exposure, 2 - hybrid */
    RS_OPTION_FISHEYE_AUTO_EXPOSURE_MODE = 61,
    /** Fisheye auto-exposure anti-flicker rate, can be 50 or 60 Hz */
    RS_OPTION_FISHEYE_AUTO_EXPOSURE_ANTIFLICKER_RATE = 62,
    /** In Fisheye auto-exposure sample frame every given number of pixels */
    RS_OPTION_FISHEYE_AUTO_EXPOSURE_PIXEL_SAMPLE_RATE = 63,
    /** In Fisheye auto-exposure sample every given number of frames */
    RS_OPTION_FISHEYE_AUTO_EXPOSURE_SKIP_FRAMES = 64,
    /** Number of frames the user is allowed to keep per stream. Trying to hold-on to more frames will cause frame-drops.*/
    RS_OPTION_FRAMES_QUEUE_SIZE = 65,
    /** Enable / disable fetching log data from the device */
    RS_OPTION_HARDWARE_LOGGER_ENABLED = 66,
    /** Total number of detected frame drops from all streams */
    RS_OPTION_TOTAL_FRAME_DROPS = 67,
    RS_OPTION_COUNT = 68;

/* frame metadata enum discriminates between the different types of values provided from the device with each frame */
/** enum rs_frame_metadata */
public static final int
    /** actual exposure that the frame was captured with */
    RS_FRAME_METADATA_ACTUAL_EXPOSURE = 0,
    /** actual fps at the time of capture */
    RS_FRAME_METADATA_ACTUAL_FPS = 1,
    RS_FRAME_METADATA_COUNT = 2;

/* rs_capabilities defines the full set of functionality that a RealSense device might provide
   to check what functionality is supported by a particular device at runtime call dev->supports(capability) */
/** enum rs_capabilities */
public static final int
    /** provides depth stream */
    RS_CAPABILITIES_DEPTH = 0,
    /** provides color stream */
    RS_CAPABILITIES_COLOR = 1,
    /** provides infrared stream */
    RS_CAPABILITIES_INFRARED = 2,
    /** provides second infrared stream */
    RS_CAPABILITIES_INFRARED2 = 3,
    /** provides wide field of view (fish-eye) stream */
    RS_CAPABILITIES_FISH_EYE = 4,
    /** provides gyro and accelorometer events */
    RS_CAPABILITIES_MOTION_EVENTS = 5,
    /** provides method for upgrading motion module firmware */
    RS_CAPABILITIES_MOTION_MODULE_FW_UPDATE = 6,
    /** interanlly includes MIPI to USB adapter */
    RS_CAPABILITIES_ADAPTER_BOARD = 7,
    /** provides enough basic functionality to be considered supported. this to catch at runtime various outdated engineering samples */
    RS_CAPABILITIES_ENUMERATION = 8,
    RS_CAPABILITIES_COUNT = 9;

/* This type defines proprietary formats for direct communication with device firmware */
/** enum rs_blob_type */
public static final int
    /** By using this option, new firmware can be uploaded to the ZR300 motion-module */
    RS_BLOB_TYPE_MOTION_MODULE_FIRMWARE_UPDATE = 0,
    RS_BLOB_TYPE_COUNT = 1;

/* Camera Info feilds are read-only strings that can be queried from the device
   Not all info feilds are available on all camera types
   This information is mainly available for camera debug and troubleshooting and should not be used in applications */
/** enum rs_camera_info */
public static final int
    /** Device friendly name */
    RS_CAMERA_INFO_DEVICE_NAME = 0,
    /** Device serial number */
    RS_CAMERA_INFO_DEVICE_SERIAL_NUMBER = 1,
    /** Primary firmware version */
    RS_CAMERA_INFO_CAMERA_FIRMWARE_VERSION = 2,
    /** MIPI-to-USB Adapter board firmware version if such board is present */
    RS_CAMERA_INFO_ADAPTER_BOARD_FIRMWARE_VERSION = 3,
    /** Motion module firmware version if motion module is present */
    RS_CAMERA_INFO_MOTION_MODULE_FIRMWARE_VERSION = 4,
    /** R200 / LR200 / ZR300 camera type */
    RS_CAMERA_INFO_CAMERA_TYPE = 5,
    /** OEM ID */
    RS_CAMERA_INFO_OEM_ID = 6,
    /** ISP firmware version when available */
    RS_CAMERA_INFO_ISP_FW_VERSION = 7,
    /** R200 / LR200 / ZR300 content version */
    RS_CAMERA_INFO_CONTENT_VERSION = 8,
    /** R200 / LR200 / ZR300 module version */
    RS_CAMERA_INFO_MODULE_VERSION = 9,
    /** Primary imager model number */
    RS_CAMERA_INFO_IMAGER_MODEL_NUMBER = 10,
    /** Device build date */
    RS_CAMERA_INFO_BUILD_DATE = 11,
    /** Primary calibration date */
    RS_CAMERA_INFO_CALIBRATION_DATE = 12,
    /** R200 / LR200 / ZR300 Program date */
    RS_CAMERA_INFO_PROGRAM_DATE = 13,
    /** Focus calibration date */
    RS_CAMERA_INFO_FOCUS_ALIGNMENT_DATE = 14,
    /** R200 / LR200 / ZR300 emitter type */
    RS_CAMERA_INFO_EMITTER_TYPE = 15,
    /** Result of the focus calibration */
    RS_CAMERA_INFO_FOCUS_VALUE = 16,
    /** Primary lens type */
    RS_CAMERA_INFO_LENS_TYPE = 17,
    /** Color imager lens type */
    RS_CAMERA_INFO_3RD_LENS_TYPE = 18,
    /** Lens coating type */
    RS_CAMERA_INFO_LENS_COATING__TYPE = 19,
    /** Color coating type */
    RS_CAMERA_INFO_3RD_LENS_COATING_TYPE = 20,
    /** Nominal baseline */
    RS_CAMERA_INFO_NOMINAL_BASELINE = 21,
    /** Color Nominal baseline */
    RS_CAMERA_INFO_3RD_NOMINAL_BASELINE = 22,
    RS_CAMERA_INFO_COUNT = 23;

/* Severity of the librealsense logger */
/** enum rs_log_severity */
public static final int
    /** Detailed information about ordinary operations */
    RS_LOG_SEVERITY_DEBUG = 0,
    /** Terse information about ordinary operations */
    RS_LOG_SEVERITY_INFO = 1,
    /** Indication of possible failure */
    RS_LOG_SEVERITY_WARN = 2,
    /** Indication of definite failure */
    RS_LOG_SEVERITY_ERROR = 3,
    /** Indication of unrecoverable failure */
    RS_LOG_SEVERITY_FATAL = 4,
    /** No logging will occur */
    RS_LOG_SEVERITY_NONE = 5,
    RS_LOG_SEVERITY_COUNT = 6;

/* Source device that tiggered specific timestamp event from the motion module */
/** enum rs_event_source */
public static final int
    /** Event from accelerometer */
    RS_EVENT_IMU_ACCEL = 0,
    /** Event from the gyroscope */
    RS_EVENT_IMU_GYRO = 1,
    /** Event from depth camera (depth / IR frame) */
    RS_EVENT_IMU_DEPTH_CAM = 2,
    /** Event from the fish-eye camera */
    RS_EVENT_IMU_MOTION_CAM = 3,
    /** Event from external GPIO 0 */
    RS_EVENT_G0_SYNC = 4,
    /** Event from external GPIO 1 */
    RS_EVENT_G1_SYNC = 5,
    /** Event from external GPIO 2 */
    RS_EVENT_G2_SYNC = 6,
    RS_EVENT_SOURCE_COUNT = 7;

/* When working with motion microcontroller, motion data timestamps are always in microcontroller timestamp domain. 
   Some frames, however, might not succesfully receive microcontroller timestamp and will be marked as camera domain */
/** enum rs_timestamp_domain */
public static final int
    /** Frame timestamp was measured in relation to the camera clock */
    RS_TIMESTAMP_DOMAIN_CAMERA = 0,
    /** Frame timestamp was measured in relation to the microcontroller clock */
    RS_TIMESTAMP_DOMAIN_MICROCONTROLLER = 1,
    RS_TIMESTAMP_DOMAIN_COUNT = 2;
// Targeting ../rs_intrinsics.java


// Targeting ../rs_motion_device_intrinsic.java


// Targeting ../rs_motion_intrinsics.java


// Targeting ../rs_extrinsics.java


// Targeting ../rs_timestamp_data.java


// Targeting ../rs_motion_data.java


// Targeting ../rs_error.java


// Targeting ../rs_frameset.java


// Targeting ../rs_frame_callback_ptr.java


// Targeting ../rs_motion_callback_ptr.java


// Targeting ../rs_timestamp_callback_ptr.java


// Targeting ../rs_log_callback_ptr.java



/**
* create realsense context required for rest of the API
* @param api_version [in] the user is expected to pass his version of RS_API_VERSION to make sure he is running with correct librealsense version
* @param error [out]  if non-null, receives any error that occurs during this call, otherwise, errors are ignored
* @return            context object
*/
public static native rs_context rs_create_context(int api_version, @Cast("rs_error**") PointerPointer error);
public static native rs_context rs_create_context(int api_version, @ByPtrPtr rs_error error);

/**
* frees the relevant context object, this might invalidate rs_device pointers created from this context
* @param context [in] the object that is no longer needed
* @param error [out]  if non-null, receives any error that occurs during this call, otherwise, errors are ignored
*/
public static native void rs_delete_context(rs_context context, @Cast("rs_error**") PointerPointer error);
public static native void rs_delete_context(rs_context context, @ByPtrPtr rs_error error);

/**
 * determine number of connected devices
 * @param error [out]  if non-null, receives any error that occurs during this call, otherwise, errors are ignored
 * @return            the count of devices
 */
public static native int rs_get_device_count(@Const rs_context context, @Cast("rs_error**") PointerPointer error);
public static native int rs_get_device_count(@Const rs_context context, @ByPtrPtr rs_error error);

/**
 * retrieve connected device by index
 * @param index [in]   the zero based index of device to retrieve
 * @param error [out]  if non-null, receives any error that occurs during this call, otherwise, errors are ignored
 * @return            the requested device
 */
public static native rs_device rs_get_device(rs_context context, int index, @Cast("rs_error**") PointerPointer error);
public static native rs_device rs_get_device(rs_context context, int index, @ByPtrPtr rs_error error);

/**
 * retrieve a human readable device model string
 * @param error [out]  if non-null, receives any error that occurs during this call, otherwise, errors are ignored
 * @return            the model string, such as "Intel RealSense F200" or "Intel RealSense R200"
 */
public static native @Cast("const char*") BytePointer rs_get_device_name(@Const rs_device device, @Cast("rs_error**") PointerPointer error);
public static native @Cast("const char*") BytePointer rs_get_device_name(@Const rs_device device, @ByPtrPtr rs_error error);

/**
 * retrieve the unique serial number of the device
 * @param error [out]  if non-null, receives any error that occurs during this call, otherwise, errors are ignored
 * @return            the serial number, in a format specific to the device model
 */
public static native @Cast("const char*") BytePointer rs_get_device_serial(@Const rs_device device, @Cast("rs_error**") PointerPointer error);
public static native @Cast("const char*") BytePointer rs_get_device_serial(@Const rs_device device, @ByPtrPtr rs_error error);

/**
* retrieve camera specific information, like versions of various internal componnents
* @param error [out]  if non-null, receives any error that occurs during this call, otherwise, errors are ignored
* @return            the requested camera info string, in a format specific to the device model
*/
public static native @Cast("const char*") BytePointer rs_get_device_info(@Const rs_device device, @Cast("rs_camera_info") int info, @Cast("rs_error**") PointerPointer error);
public static native @Cast("const char*") BytePointer rs_get_device_info(@Const rs_device device, @Cast("rs_camera_info") int info, @ByPtrPtr rs_error error);

/**
 * retrieve the USB port number of the device
 * @param error [out]  if non-null, receives any error that occurs during this call, otherwise, errors are ignored
 * @return            the USB port number in a string form "##-##"
 */
public static native @Cast("const char*") BytePointer rs_get_device_usb_port_id(@Const rs_device device, @Cast("rs_error**") PointerPointer error);
public static native @Cast("const char*") BytePointer rs_get_device_usb_port_id(@Const rs_device device, @ByPtrPtr rs_error error);

/**
 * retrieve the version of the firmware currently installed on the device
 * @param error [out]  if non-null, receives any error that occurs during this call, otherwise, errors are ignored
 * @return            firmware version string, in a format is specific to device model
 */
public static native @Cast("const char*") BytePointer rs_get_device_firmware_version(@Const rs_device device, @Cast("rs_error**") PointerPointer error);
public static native @Cast("const char*") BytePointer rs_get_device_firmware_version(@Const rs_device device, @ByPtrPtr rs_error error);

/**
 * retrieve extrinsic transformation between the viewpoints of two different streams
 * @param from_stream [in]  stream whose coordinate space we will transform from
 * @param to_stream [in]    stream whose coordinate space we will transform to
 * @param extrin [out]      the transformation between the two streams
 * @param error [out]       if non-null, receives any error that occurs during this call, otherwise, errors are ignored
 */
public static native void rs_get_device_extrinsics(@Const rs_device device, @Cast("rs_stream") int from_stream, @Cast("rs_stream") int to_stream, rs_extrinsics extrin, @Cast("rs_error**") PointerPointer error);
public static native void rs_get_device_extrinsics(@Const rs_device device, @Cast("rs_stream") int from_stream, @Cast("rs_stream") int to_stream, rs_extrinsics extrin, @ByPtrPtr rs_error error);

/**
* retrieve extrinsic transformation between specific stream and the motion module
* @param from_stream [in]  stream whose coordinate space we will transform from
* @param extrin [out]      the transformation between the specific stream and motion module
* @param error [out]       if non-null, receives any error that occurs during this call, otherwise, errors are ignored
*/
public static native void rs_get_motion_extrinsics_from(@Const rs_device device, @Cast("rs_stream") int from, rs_extrinsics extrin, @Cast("rs_error**") PointerPointer error);
public static native void rs_get_motion_extrinsics_from(@Const rs_device device, @Cast("rs_stream") int from, rs_extrinsics extrin, @ByPtrPtr rs_error error);

/**
 * retrieve mapping between the units of the depth image and meters
 * @param error [out]  if non-null, receives any error that occurs during this call, otherwise, errors are ignored
 * @return            depth in meters corresponding to a depth value of 1
 */
public static native float rs_get_device_depth_scale(@Const rs_device device, @Cast("rs_error**") PointerPointer error);
public static native float rs_get_device_depth_scale(@Const rs_device device, @ByPtrPtr rs_error error);

/**
 * determine if the device allows a specific option to be queried and set
 * @param option [in]  the option to check for support
 * @param error [out]  if non-null, receives any error that occurs during this call, otherwise, errors are ignored
 * @return            true if the option can be queried and set
 */
public static native int rs_device_supports_option(@Const rs_device device, @Cast("rs_option") int option, @Cast("rs_error**") PointerPointer error);
public static native int rs_device_supports_option(@Const rs_device device, @Cast("rs_option") int option, @ByPtrPtr rs_error error);

/**
 * determine the number of streaming modes available for a given stream
 * @param stream [in]  the stream whose modes will be enumerated
 * @param error [out]  if non-null, receives any error that occurs during this call, otherwise, errors are ignored
 * @return            the count of available modes
 */
public static native int rs_get_stream_mode_count(@Const rs_device device, @Cast("rs_stream") int stream, @Cast("rs_error**") PointerPointer error);
public static native int rs_get_stream_mode_count(@Const rs_device device, @Cast("rs_stream") int stream, @ByPtrPtr rs_error error);

/**
 * determine the properties of a specific streaming mode
 * @param stream [in]      the stream whose mode will be queried
 * @param index [in]       the zero based index of the streaming mode
 * @param width [out]      the width of a frame image in pixels
 * @param height [out]     the height of a frame image in pixels
 * @param format [out]     the pixel format of a frame image
 * @param framerate [out]  the number of frames which will be streamed per second
 * @param error [out]      if non-null, receives any error that occurs during this call, otherwise, errors are ignored
 */
public static native void rs_get_stream_mode(@Const rs_device device, @Cast("rs_stream") int stream, int index, IntPointer width, IntPointer height, @Cast("rs_format*") IntPointer format, IntPointer framerate, @Cast("rs_error**") PointerPointer error);
public static native void rs_get_stream_mode(@Const rs_device device, @Cast("rs_stream") int stream, int index, IntPointer width, IntPointer height, @Cast("rs_format*") IntPointer format, IntPointer framerate, @ByPtrPtr rs_error error);
public static native void rs_get_stream_mode(@Const rs_device device, @Cast("rs_stream") int stream, int index, IntBuffer width, IntBuffer height, @Cast("rs_format*") IntBuffer format, IntBuffer framerate, @ByPtrPtr rs_error error);
public static native void rs_get_stream_mode(@Const rs_device device, @Cast("rs_stream") int stream, int index, int[] width, int[] height, @Cast("rs_format*") int[] format, int[] framerate, @ByPtrPtr rs_error error);

/**
 * enable a specific stream and request specific properties
 * @param stream [in]         the stream to enable
 * @param width [in]          the desired width of a frame image in pixels, or 0 if any width is acceptable
 * @param height [in]         the desired height of a frame image in pixels, or 0 if any height is acceptable
 * @param format [in]         the pixel format of a frame image, or ANY if any format is acceptable
 * @param framerate [in]      the number of frames which will be streamed per second, or 0 if any framerate is acceptable
 * @param output_format [in]  output buffer format (contious in memory / native with pitch)
 * @param error [out]     if non-null, receives any error that occurs during this call, otherwise, errors are ignored
 */
public static native void rs_enable_stream_ex(rs_device device, @Cast("rs_stream") int stream, int width, int height, @Cast("rs_format") int format, int framerate, @Cast("rs_output_buffer_format") int output_format, @Cast("rs_error**") PointerPointer error);
public static native void rs_enable_stream_ex(rs_device device, @Cast("rs_stream") int stream, int width, int height, @Cast("rs_format") int format, int framerate, @Cast("rs_output_buffer_format") int output_format, @ByPtrPtr rs_error error);

/**
* enable a specific stream and request specific properties
* @param stream [in]         the stream to enable
* @param width [in]          the desired width of a frame image in pixels, or 0 if any width is acceptable
* @param height [in]         the desired height of a frame image in pixels, or 0 if any height is acceptable
* @param format [in]         the pixel format of a frame image, or ANY if any format is acceptable
* @param framerate [in]      the number of frames which will be streamed per second, or 0 if any framerate is acceptable
* @param error [out]     if non-null, receives any error that occurs during this call, otherwise, errors are ignored
*/
public static native void rs_enable_stream(rs_device device, @Cast("rs_stream") int stream, int width, int height, @Cast("rs_format") int format, int framerate, @Cast("rs_error**") PointerPointer error);
public static native void rs_enable_stream(rs_device device, @Cast("rs_stream") int stream, int width, int height, @Cast("rs_format") int format, int framerate, @ByPtrPtr rs_error error);

/**
 * enable a specific stream and request properties using a preset
 * @param stream [in]  the stream to enable
 * @param preset [in]  the preset to use to enable the stream
 * @param error [out]  if non-null, receives any error that occurs during this call, otherwise, errors are ignored
 */
public static native void rs_enable_stream_preset(rs_device device, @Cast("rs_stream") int stream, @Cast("rs_preset") int preset, @Cast("rs_error**") PointerPointer error);
public static native void rs_enable_stream_preset(rs_device device, @Cast("rs_stream") int stream, @Cast("rs_preset") int preset, @ByPtrPtr rs_error error);

/**
 * disable a specific stream
 * @param stream [in]  the stream to disable
 * @param error [out]  if non-null, receives any error that occurs during this call, otherwise, errors are ignored
 */
public static native void rs_disable_stream(rs_device device, @Cast("rs_stream") int stream, @Cast("rs_error**") PointerPointer error);
public static native void rs_disable_stream(rs_device device, @Cast("rs_stream") int stream, @ByPtrPtr rs_error error);

/**
 * determine if a specific stream is enabled
 * @param stream [in]  the stream to check
 * @param error [out]  if non-null, receives any error that occurs during this call, otherwise, errors are ignored
 * @return            true if the stream is currently enabled
 */
public static native int rs_is_stream_enabled(@Const rs_device device, @Cast("rs_stream") int stream, @Cast("rs_error**") PointerPointer error);
public static native int rs_is_stream_enabled(@Const rs_device device, @Cast("rs_stream") int stream, @ByPtrPtr rs_error error);

/**
 * retrieve the width in pixels of a specific stream, equivalent to the width field from the stream's intrinsic
 * @param stream [in]  the stream whose width to retrieve
 * @param error [out]  if non-null, receives any error that occurs during this call, otherwise, errors are ignored
 * @return            the width in pixels of images from this stream
 */
public static native int rs_get_stream_width(@Const rs_device device, @Cast("rs_stream") int stream, @Cast("rs_error**") PointerPointer error);
public static native int rs_get_stream_width(@Const rs_device device, @Cast("rs_stream") int stream, @ByPtrPtr rs_error error);

/**
 * retrieve the height in pixels of a specific stream, equivalent to the height field from the stream's intrinsic
 * @param stream [in]  the stream whose height to retrieve
 * @param error [out]  if non-null, receives any error that occurs during this call, otherwise, errors are ignored
 * @return            the height in pixels of images from this stream
 */
public static native int rs_get_stream_height(@Const rs_device device, @Cast("rs_stream") int stream, @Cast("rs_error**") PointerPointer error);
public static native int rs_get_stream_height(@Const rs_device device, @Cast("rs_stream") int stream, @ByPtrPtr rs_error error);

/**
 * retrieve the pixel format for a specific stream
 * @param stream [in]  the stream whose format to retrieve
 * @param error [out]  if non-null, receives any error that occurs during this call, otherwise, errors are ignored
 * @return            the pixel format of the stream
 */
public static native @Cast("rs_format") int rs_get_stream_format(@Const rs_device device, @Cast("rs_stream") int stream, @Cast("rs_error**") PointerPointer error);
public static native @Cast("rs_format") int rs_get_stream_format(@Const rs_device device, @Cast("rs_stream") int stream, @ByPtrPtr rs_error error);

/**
 * retrieve the framerate for a specific stream
 * @param stream [in]  the stream whose framerate to retrieve
 * @param error [out]  if non-null, receives any error that occurs during this call, otherwise, errors are ignored
 * @return            the framerate of the stream, in frames per second
 */
public static native int rs_get_stream_framerate(@Const rs_device device, @Cast("rs_stream") int stream, @Cast("rs_error**") PointerPointer error);
public static native int rs_get_stream_framerate(@Const rs_device device, @Cast("rs_stream") int stream, @ByPtrPtr rs_error error);

/**
 * retrieve intrinsic camera parameters for a specific stream
 * @param stream [in]   the stream whose parameters to retrieve
 * @param intrin [out]  the intrinsic parameters of the stream
 * @param error [out]   if non-null, receives any error that occurs during this call, otherwise, errors are ignored
 */
public static native void rs_get_stream_intrinsics(@Const rs_device device, @Cast("rs_stream") int stream, rs_intrinsics intrin, @Cast("rs_error**") PointerPointer error);
public static native void rs_get_stream_intrinsics(@Const rs_device device, @Cast("rs_stream") int stream, rs_intrinsics intrin, @ByPtrPtr rs_error error);

/**
* retrieve intrinsic camera parameters for a motion module
* @param intrinsic [out]  the intrinsic parameters
* @param error [out]   if non-null, receives any error that occurs during this call, otherwise, errors are ignored
*/
public static native void rs_get_motion_intrinsics(@Const rs_device device, rs_motion_intrinsics intrinsic, @Cast("rs_error**") PointerPointer error);
public static native void rs_get_motion_intrinsics(@Const rs_device device, rs_motion_intrinsics intrinsic, @ByPtrPtr rs_error error);

/**
* set up a frame callback that will be called immediately when an image is available, with no synchronization logic applied
* @param stream [in]    the stream for whose images the callback should be registered
* @param on_frame [in]  the callback which will receive the frame data and timestamp
* @param user [in]      a user data point to be passed to the callback
* @param error [out]    if non-null, receives any error that occurs during this call, otherwise, errors are ignored
*/
public static native void rs_set_frame_callback(rs_device device, @Cast("rs_stream") int stream, rs_frame_callback_ptr on_frame, Pointer user, @Cast("rs_error**") PointerPointer error);
public static native void rs_set_frame_callback(rs_device device, @Cast("rs_stream") int stream, rs_frame_callback_ptr on_frame, Pointer user, @ByPtrPtr rs_error error);

/**
* enable and configure motion-tracking data handlers
* @param on_motion_event [in]    user-defined routine to be invoked when a motion data arrives
* @param motion_handler [in]     a user data point to be passed to the motion event callback
* @param on_timestamp_event [in] user-defined routine to be invoked on timestamp
* @param timestamp_handler [in]  a user data point to be passed to the motion event callback
* @param error [out]             if non-null, receives any error that occurs during this call, otherwise, errors are ignored
*/
public static native void rs_enable_motion_tracking(rs_device device,
    rs_motion_callback_ptr on_motion_event, Pointer motion_handler,
    rs_timestamp_callback_ptr on_timestamp_event, Pointer timestamp_handler,
    @Cast("rs_error**") PointerPointer error);
public static native void rs_enable_motion_tracking(rs_device device,
    rs_motion_callback_ptr on_motion_event, Pointer motion_handler,
    rs_timestamp_callback_ptr on_timestamp_event, Pointer timestamp_handler,
    @ByPtrPtr rs_error error);

/**
* enable and configure motion-tracking data handlers
* Note: rs_enable_motion_tracking is responsible for activating the motion module on-board the device. One of the services it provides is producing shared and high-resolution timestamps for all component hooked-up to it. Usually, librealsense takes care of that and copies the timestamps on the relevant frames.
* However, when the user has an external device (like a compass) and wishes to synchronize it precisely with image and motion stream he can connect the sensor to a GPIO avaialbe on some devices. Every time sensor will signal, the user will get a timestamp callback with a frame number, source ID and a timestamp.
* This would allow advanced user to synchronize his compass events (presumably coming though I2C or some other method) with realsense data.
* (This variant is provided specifically to enable passing lambdas with capture lists safely into the library)
* @param motion_callback [in]    user-defined routine to be invoked when a motion data arrives
* @param timestamp_callback [in] user-defined routine to be invoked on timestamp
* @param error [out]             if non-null, receives any error that occurs during this call, otherwise, errors are ignored
*/
public static native void rs_enable_motion_tracking_cpp(rs_device device,
    rs_motion_callback motion_callback,
    rs_timestamp_callback timestamp_callback,
    @Cast("rs_error**") PointerPointer error);
public static native void rs_enable_motion_tracking_cpp(rs_device device,
    rs_motion_callback motion_callback,
    rs_timestamp_callback timestamp_callback,
    @ByPtrPtr rs_error error);

/**
 * set up a frame callback that will be called immediately when an image is available, with no synchronization logic applied
 * (This variant is provided specificly to enable passing lambdas with capture lists safely into the library)
 * @param stream [in]    the stream for whose images the callback should be registered
 * @param callback [in]  the callback which will receive the frame data and timestamp
 * @param error [out]    if non-null, receives any error that occurs during this call, otherwise, errors are ignored
 */
public static native void rs_set_frame_callback_cpp(rs_device device, @Cast("rs_stream") int stream, rs_frame_callback callback, @Cast("rs_error**") PointerPointer error);
public static native void rs_set_frame_callback_cpp(rs_device device, @Cast("rs_stream") int stream, rs_frame_callback callback, @ByPtrPtr rs_error error);

/**
* disable motion-tracking handlers
*/
public static native void rs_disable_motion_tracking(rs_device device, @Cast("rs_error**") PointerPointer error);
public static native void rs_disable_motion_tracking(rs_device device, @ByPtrPtr rs_error error);

/**
* check if data acquisition is active
*/
public static native int rs_is_motion_tracking_active(rs_device device, @Cast("rs_error**") PointerPointer error);
public static native int rs_is_motion_tracking_active(rs_device device, @ByPtrPtr rs_error error);


/**
 * begin streaming on all enabled streams for this device
 * @param error [out]  if non-null, receives any error that occurs during this call, otherwise, errors are ignored
 */
public static native void rs_start_device(rs_device device, @Cast("rs_error**") PointerPointer error);
public static native void rs_start_device(rs_device device, @ByPtrPtr rs_error error);

/**
 * end data acquisition for the specified source providers
 * @param error [out]  if non-null, receives any error that occurs during this call, otherwise, errors are ignored
 */
public static native void rs_stop_device(rs_device device, @Cast("rs_error**") PointerPointer error);
public static native void rs_stop_device(rs_device device, @ByPtrPtr rs_error error);

/**
 * begin streaming on all enabled streams for this device
 * @param source [in]  the data source to be activated
 * @param error [out]  if non-null, receives any error that occurs during this call, otherwise, errors are ignored
 */
public static native void rs_start_source(rs_device device, @Cast("rs_source") int source, @Cast("rs_error**") PointerPointer error);
public static native void rs_start_source(rs_device device, @Cast("rs_source") int source, @ByPtrPtr rs_error error);

/**
 * end data acquisition for the specified source providers
 * @param source [in]  the data source to be terminated
 * @param error [out]  if non-null, receives any error that occurs during this call, otherwise, errors are ignored
 */
public static native void rs_stop_source(rs_device device, @Cast("rs_source") int source, @Cast("rs_error**") PointerPointer error);
public static native void rs_stop_source(rs_device device, @Cast("rs_source") int source, @ByPtrPtr rs_error error);

/**
 * determine if the device is currently streaming
 * @param error [out]  if non-null, receives any error that occurs during this call, otherwise, errors are ignored
 * @return            true if the device is currently streaming
 */
public static native int rs_is_device_streaming(@Const rs_device device, @Cast("rs_error**") PointerPointer error);
public static native int rs_is_device_streaming(@Const rs_device device, @ByPtrPtr rs_error error);

/**
 * retrieve the available range of values of a supported option
 * @param option [in]  the option whose range should be queried
 * @param min [out]    the minimum value which will be accepted for this option
 * @param max [out]    the maximum value which will be accepted for this option
 * @param step [out]   the granularity of options which accept discrete values, or zero if the option accepts continuous values
 * @param error [out]  if non-null, receives any error that occurs during this call, otherwise, errors are ignored
 */
public static native void rs_get_device_option_range(rs_device device, @Cast("rs_option") int option, DoublePointer min, DoublePointer max, DoublePointer step, @Cast("rs_error**") PointerPointer error);
public static native void rs_get_device_option_range(rs_device device, @Cast("rs_option") int option, DoublePointer min, DoublePointer max, DoublePointer step, @ByPtrPtr rs_error error);
public static native void rs_get_device_option_range(rs_device device, @Cast("rs_option") int option, DoubleBuffer min, DoubleBuffer max, DoubleBuffer step, @ByPtrPtr rs_error error);
public static native void rs_get_device_option_range(rs_device device, @Cast("rs_option") int option, double[] min, double[] max, double[] step, @ByPtrPtr rs_error error);

/**
 * retrieve the available range of values of a supported option
 * @param option [in]  the option whose range should be queried
 * @param min [out]    the minimum value which will be accepted for this option
 * @param max [out]    the maximum value which will be accepted for this option
 * @param step [out]   the granularity of options which accept discrete values, or zero if the option accepts continuous values
 * @param def [out]    the default value of the option
 * @param error [out]  if non-null, receives any error that occurs during this call, otherwise, errors are ignored
 */
public static native void rs_get_device_option_range_ex(rs_device device, @Cast("rs_option") int option, DoublePointer min, DoublePointer max, DoublePointer step, DoublePointer def, @Cast("rs_error**") PointerPointer error);
public static native void rs_get_device_option_range_ex(rs_device device, @Cast("rs_option") int option, DoublePointer min, DoublePointer max, DoublePointer step, DoublePointer def, @ByPtrPtr rs_error error);
public static native void rs_get_device_option_range_ex(rs_device device, @Cast("rs_option") int option, DoubleBuffer min, DoubleBuffer max, DoubleBuffer step, DoubleBuffer def, @ByPtrPtr rs_error error);
public static native void rs_get_device_option_range_ex(rs_device device, @Cast("rs_option") int option, double[] min, double[] max, double[] step, double[] def, @ByPtrPtr rs_error error);

/**
 * efficiently retrieve the value of an arbitrary number of options, using minimal hardware IO
 * @param options [in]  the array of options which should be queried
 * @param count [in]    the length of the options and values arrays
 * @param values [out]  the array which will receive the values of the queried options
 * @param error [out]   if non-null, receives any error that occurs during this call, otherwise, errors are ignored
 */
public static native void rs_get_device_options(rs_device device, @Cast("const rs_option*") IntPointer options, @Cast("unsigned int") int count, DoublePointer values, @Cast("rs_error**") PointerPointer error);
public static native void rs_get_device_options(rs_device device, @Cast("const rs_option*") IntPointer options, @Cast("unsigned int") int count, DoublePointer values, @ByPtrPtr rs_error error);
public static native void rs_get_device_options(rs_device device, @Cast("const rs_option*") IntBuffer options, @Cast("unsigned int") int count, DoubleBuffer values, @ByPtrPtr rs_error error);
public static native void rs_get_device_options(rs_device device, @Cast("const rs_option*") int[] options, @Cast("unsigned int") int count, double[] values, @ByPtrPtr rs_error error);

/**
 * efficiently set the value of an arbitrary number of options, using minimal hardware IO
 * @param options [in]  the array of options which should be set
 * @param count [in]    the length of the options and values arrays
 * @param values [in]   the array of values to which the options should be set
 * @param error [out]   if non-null, receives any error that occurs during this call, otherwise, errors are ignored
 */
public static native void rs_set_device_options(rs_device device, @Cast("const rs_option*") IntPointer options, @Cast("unsigned int") int count, @Const DoublePointer values, @Cast("rs_error**") PointerPointer error);
public static native void rs_set_device_options(rs_device device, @Cast("const rs_option*") IntPointer options, @Cast("unsigned int") int count, @Const DoublePointer values, @ByPtrPtr rs_error error);
public static native void rs_set_device_options(rs_device device, @Cast("const rs_option*") IntBuffer options, @Cast("unsigned int") int count, @Const DoubleBuffer values, @ByPtrPtr rs_error error);
public static native void rs_set_device_options(rs_device device, @Cast("const rs_option*") int[] options, @Cast("unsigned int") int count, @Const double[] values, @ByPtrPtr rs_error error);

/**
* efficiently reset the value of an arbitrary number of options to default
* @param options [in]  the array of options which should be set to default
* @param count [in]    the length of the options array
* @param error [out]   if non-null, receives any error that occurs during this call, otherwise, errors are ignored
*/
public static native void rs_reset_device_options_to_default(rs_device device, @Cast("const rs_option*") IntPointer options, int count, @Cast("rs_error**") PointerPointer error);
public static native void rs_reset_device_options_to_default(rs_device device, @Cast("const rs_option*") IntPointer options, int count, @ByPtrPtr rs_error error);
public static native void rs_reset_device_options_to_default(rs_device device, @Cast("const rs_option*") IntBuffer options, int count, @ByPtrPtr rs_error error);
public static native void rs_reset_device_options_to_default(rs_device device, @Cast("const rs_option*") int[] options, int count, @ByPtrPtr rs_error error);

/**
 * retrieve the current value of a single option
 * @param option [in]  the option whose value should be retrieved
 * @param error [out]  if non-null, receives any error that occurs during this call, otherwise, errors are ignored
 * @return            the value of the option
 */
public static native double rs_get_device_option(rs_device device, @Cast("rs_option") int option, @Cast("rs_error**") PointerPointer error);
public static native double rs_get_device_option(rs_device device, @Cast("rs_option") int option, @ByPtrPtr rs_error error);


/**
 * retrieve a static description of what a particular option does on given device
 * @param option [in]  the option whose description should be retrieved
 * @param error [out]  if non-null, receives any error that occurs during this call, otherwise, errors are ignored
 * @return            the value of the option
 */
public static native @Cast("const char*") BytePointer rs_get_device_option_description(rs_device device, @Cast("rs_option") int option, @Cast("rs_error**") PointerPointer error);
public static native @Cast("const char*") BytePointer rs_get_device_option_description(rs_device device, @Cast("rs_option") int option, @ByPtrPtr rs_error error);


/**
 * set the current value of a single option
 * @param option [in]  the option whose value should be set
 * @param value [in]   the value of the option
 * @param error [out]  if non-null, receives any error that occurs during this call, otherwise, errors are ignored
 */
public static native void rs_set_device_option(rs_device device, @Cast("rs_option") int option, double value, @Cast("rs_error**") PointerPointer error);
public static native void rs_set_device_option(rs_device device, @Cast("rs_option") int option, double value, @ByPtrPtr rs_error error);

/**
 * block until new frames are available
 * @param error [out]  if non-null, receives any error that occurs during this call, otherwise, errors are ignored
 */
public static native void rs_wait_for_frames(rs_device device, @Cast("rs_error**") PointerPointer error);
public static native void rs_wait_for_frames(rs_device device, @ByPtrPtr rs_error error);

/**
 * check if new frames are available, without blocking
 * @param error [out]  if non-null, receives any error that occurs during this call, otherwise, errors are ignored
 * @return            1 if new frames are available, 0 if no new frames have arrived
 */
public static native int rs_poll_for_frames(rs_device device, @Cast("rs_error**") PointerPointer error);
public static native int rs_poll_for_frames(rs_device device, @ByPtrPtr rs_error error);

/**
 * determine device capabilities
 * @param capability [in]  the capability to check for support
 * @return                true if device has this capability
 */
public static native int rs_supports(rs_device device, @Cast("rs_capabilities") int capability, @Cast("rs_error**") PointerPointer error);
public static native int rs_supports(rs_device device, @Cast("rs_capabilities") int capability, @ByPtrPtr rs_error error);

/**
* specialization over generic support to verify camera header block support
* @param info_param [in]  the parameter to check for support
* @return                true if the parameter both exist and well-defined for the specific device
*/
public static native int rs_supports_camera_info(rs_device device, @Cast("rs_camera_info") int info_param, @Cast("rs_error**") PointerPointer error);
public static native int rs_supports_camera_info(rs_device device, @Cast("rs_camera_info") int info_param, @ByPtrPtr rs_error error);

/**
* retrive metadata from safe frame handle, returned from detach, clone_ref or from frame callback
* @param stream [in]  the stream whose latest frame we are interested in
* @param frame_metadata [in]  the rs_frame_metadata whose latest frame we are interested in
* @return            the metadata value
*/
public static native double rs_get_detached_frame_metadata(@Const rs_frame_ref frame, @Cast("rs_frame_metadata") int frame_metadata, @Cast("rs_error**") PointerPointer error);
public static native double rs_get_detached_frame_metadata(@Const rs_frame_ref frame, @Cast("rs_frame_metadata") int frame_metadata, @ByPtrPtr rs_error error);

/**
* determine device metadata
* @param metadata [in]  the metadata to check for support
* @return                true if device has this metadata
*/
public static native int rs_supports_frame_metadata(@Const rs_frame_ref frame, @Cast("rs_frame_metadata") int frame_metadata, @Cast("rs_error**") PointerPointer error);
public static native int rs_supports_frame_metadata(@Const rs_frame_ref frame, @Cast("rs_frame_metadata") int frame_metadata, @ByPtrPtr rs_error error);

/**
 * retrieve the time at which the latest frame on a stream was captured
 * @param stream [in]  the stream whose latest frame we are interested in
 * @param error [out]  if non-null, receives any error that occurs during this call, otherwise, errors are ignored
 * @return            the timestamp of the frame, in milliseconds since the device was started
 */
public static native double rs_get_frame_timestamp(@Const rs_device device, @Cast("rs_stream") int stream, @Cast("rs_error**") PointerPointer error);
public static native double rs_get_frame_timestamp(@Const rs_device device, @Cast("rs_stream") int stream, @ByPtrPtr rs_error error);

/**
* retrieve the frame number
* @param stream [in]  the stream whose latest frame we are interested in
* @param error [out]  if non-null, receives any error that occurs during this call, otherwise, errors are ignored
* @return            the frame number
*/
public static native @Cast("unsigned long long") long rs_get_frame_number(@Const rs_device device, @Cast("rs_stream") int stream, @Cast("rs_error**") PointerPointer error);
public static native @Cast("unsigned long long") long rs_get_frame_number(@Const rs_device device, @Cast("rs_stream") int stream, @ByPtrPtr rs_error error);

/**
 * retrieve the contents of the latest frame on a stream
 * @param stream [in]  the stream whose latest frame we are interested in
 * @param error [out]  if non-null, receives any error that occurs during this call, otherwise, errors are ignored
 * @return            the pointer to the start of the frame data
 */
public static native @Const Pointer rs_get_frame_data(@Const rs_device device, @Cast("rs_stream") int stream, @Cast("rs_error**") PointerPointer error);
public static native @Const Pointer rs_get_frame_data(@Const rs_device device, @Cast("rs_stream") int stream, @ByPtrPtr rs_error error);

/**
* relases the frame handle
* @param frame [in] handle returned either detach, clone_ref or from frame callback
* @param error [out]  if non-null, receives any error that occurs during this call, otherwise, errors are ignored
* @return            the pointer to the start of the frame data
*/
public static native void rs_release_frame(rs_device device, rs_frame_ref frame, @Cast("rs_error**") PointerPointer error);
public static native void rs_release_frame(rs_device device, rs_frame_ref frame, @ByPtrPtr rs_error error);

/**
* retrive timestamp from safe frame handle, returned from detach, clone_ref or from frame callback
* @param error [out]  if non-null, receives any error that occurs during this call, otherwise, errors are ignored
* @return            the timestamp of the frame, in milliseconds since the device was started
*/
public static native double rs_get_detached_frame_timestamp(@Const rs_frame_ref frame, @Cast("rs_error**") PointerPointer error);
public static native double rs_get_detached_frame_timestamp(@Const rs_frame_ref frame, @ByPtrPtr rs_error error);

/**
* retrive timestamp domain from safe frame handle, returned from detach, clone_ref or from frame callback
* this method is used to check if two timestamp values are comparable (generated from the same clock)
* @param error [out]  if non-null, receives any error that occurs during this call, otherwise, errors are ignored
* @return            the timestamp domain of the frame (camera/ microcontroller)
*/
public static native @Cast("rs_timestamp_domain") int rs_get_detached_frame_timestamp_domain(@Const rs_frame_ref frameset, @Cast("rs_error**") PointerPointer error);
public static native @Cast("rs_timestamp_domain") int rs_get_detached_frame_timestamp_domain(@Const rs_frame_ref frameset, @ByPtrPtr rs_error error);

/**
* retrive frame number from safe frame handle, returned from detach, clone_ref or from frame callback
* @param error [out]  if non-null, receives any error that occurs during this call, otherwise, errors are ignored
* @return            the frame nubmer of the frame, in milliseconds since the device was started
*/
public static native @Cast("unsigned long long") long rs_get_detached_frame_number(@Const rs_frame_ref frame, @Cast("rs_error**") PointerPointer error);
public static native @Cast("unsigned long long") long rs_get_detached_frame_number(@Const rs_frame_ref frame, @ByPtrPtr rs_error error);

/**
* retrive data from safe frame handle, returned from detach, clone_ref or from frame callback
* @param error [out]  if non-null, receives any error that occurs during this call, otherwise, errors are ignored
* @return            the pointer to the start of the frame data
*/
public static native @Const Pointer rs_get_detached_frame_data(@Const rs_frame_ref frame, @Cast("rs_error**") PointerPointer error);
public static native @Const Pointer rs_get_detached_frame_data(@Const rs_frame_ref frame, @ByPtrPtr rs_error error);

/**
* retrive frame intrinsic width in pixels
* @param error [out]  if non-null, receives any error that occurs during this call, otherwise, errors are ignored
* @return            intrinsic width
*/
public static native int rs_get_detached_frame_width(@Const rs_frame_ref frame, @Cast("rs_error**") PointerPointer error);
public static native int rs_get_detached_frame_width(@Const rs_frame_ref frame, @ByPtrPtr rs_error error);

/**
* retrive frame intrinsic height
* @param error [out]  if non-null, receives any error that occurs during this call, otherwise, errors are ignored
* @return            intrinsic height
*/
public static native int rs_get_detached_frame_height(@Const rs_frame_ref frame, @Cast("rs_error**") PointerPointer error);
public static native int rs_get_detached_frame_height(@Const rs_frame_ref frame, @ByPtrPtr rs_error error);

/**
* retrive frame intrinsic framerate
* @param error [out]  if non-null, receives any error that occurs during this call, otherwise, errors are ignored
* @return            intrinsic framerate
*/
public static native int rs_get_detached_framerate(@Const rs_frame_ref frameset, @Cast("rs_error**") PointerPointer error);
public static native int rs_get_detached_framerate(@Const rs_frame_ref frameset, @ByPtrPtr rs_error error);

/**
* retrive frame stride, meaning the actual line width in memory in bytes (not the logical image width)
* @param error [out]  if non-null, receives any error that occurs during this call, otherwise, errors are ignored
* @return            frame pad crop
*/
public static native int rs_get_detached_frame_stride(@Const rs_frame_ref frame, @Cast("rs_error**") PointerPointer error);
public static native int rs_get_detached_frame_stride(@Const rs_frame_ref frame, @ByPtrPtr rs_error error);

/**
* retrive frame **bits** per pixel
* @param error [out]  if non-null, receives any error that occurs during this call, otherwise, errors are ignored
* @return            frame pad crop
*/
public static native int rs_get_detached_frame_bpp(@Const rs_frame_ref frame, @Cast("rs_error**") PointerPointer error);
public static native int rs_get_detached_frame_bpp(@Const rs_frame_ref frame, @ByPtrPtr rs_error error);

/**
* retrive frame format
* @param error [out]  if non-null, receives any error that occurs during this call, otherwise, errors are ignored
* @return            frame format
*/
public static native @Cast("rs_format") int rs_get_detached_frame_format(@Const rs_frame_ref frame, @Cast("rs_error**") PointerPointer error);
public static native @Cast("rs_format") int rs_get_detached_frame_format(@Const rs_frame_ref frame, @ByPtrPtr rs_error error);

/**
* retrive frame stream type
* @param error [out]  if non-null, receives any error that occurs during this call, otherwise, errors are ignored
* @return            stream type
*/
public static native @Cast("rs_stream") int rs_get_detached_frame_stream_type(@Const rs_frame_ref frameset, @Cast("rs_error**") PointerPointer error);
public static native @Cast("rs_stream") int rs_get_detached_frame_stream_type(@Const rs_frame_ref frameset, @ByPtrPtr rs_error error);

/**
* send a blob of data to the device. at the moment only RS_BLOB_TYPE_MOTION_MODULE_FIRMWARE_UPDATE is support 
* of the motiohn module.
* @param firmware [in] data.
* @param error [out]  if non-null, receives any error that occurs during this call, otherwise, errors are ignored
*/
public static native void rs_send_blob_to_device(rs_device device, @Cast("rs_blob_type") int type, Pointer data, int size, @Cast("rs_error**") PointerPointer error);
public static native void rs_send_blob_to_device(rs_device device, @Cast("rs_blob_type") int type, Pointer data, int size, @ByPtrPtr rs_error error);

/**
* retrieve the API version from the source code. Evaluate that the value is conformant to the established policies
* @param error [out]  if non-null, receives any error that occurs during this call, otherwise, errors are ignored
* @return            the version API encoded into integer value "1.9.3" -> 10903
*/
public static native int rs_get_api_version(@Cast("rs_error**") PointerPointer error);
public static native int rs_get_api_version(@ByPtrPtr rs_error error);

/**
* returns static pointer to the name of failing function in case of error
* @param error [in]   error object allocated by realsense API function
* @return            pointer to function name (memory manager by the error object)
*/
public static native @Cast("const char*") BytePointer rs_get_failed_function(@Const rs_error error);

/**
* returns static pointer to the arguments of failing function in case of error
* @param error [in]   error object allocated by realsense API function
* @return            pointer to arguments string (memory manager by the error object)
*/
public static native @Cast("const char*") BytePointer rs_get_failed_args(@Const rs_error error);

/**
* returns static pointer to the error message
* @param error [in]   error object allocated by realsense API function
* @return            pointer to the error message (memory manager by the error object)
*/
public static native @Cast("const char*") BytePointer rs_get_error_message(@Const rs_error error);

/**
* frees memory of an error object
* @param error [in]   error object allocated by realsense API function
*/
public static native void rs_free_error(rs_error error);

public static native @Cast("const char*") BytePointer rs_stream_to_string(@Cast("rs_stream") int stream); 
public static native @Cast("const char*") BytePointer rs_format_to_string(@Cast("rs_format") int format);
public static native @Cast("const char*") BytePointer rs_preset_to_string(@Cast("rs_preset") int preset);
public static native @Cast("const char*") BytePointer rs_distortion_to_string(@Cast("rs_distortion") int distortion);
public static native @Cast("const char*") BytePointer rs_option_to_string(@Cast("rs_option") int option);
public static native @Cast("const char*") BytePointer rs_capabilities_to_string(@Cast("rs_capabilities") int capability);
public static native @Cast("const char*") BytePointer rs_source_to_string(@Cast("rs_source") int source);
public static native @Cast("const char*") BytePointer rs_event_to_string(@Cast("rs_event_source") int event);
public static native @Cast("const char*") BytePointer rs_blob_type_to_string(@Cast("rs_blob_type") int type);
public static native @Cast("const char*") BytePointer rs_camera_info_to_string(@Cast("rs_camera_info") int info);
public static native @Cast("const char*") BytePointer rs_timestamp_domain_to_string(@Cast("rs_timestamp_domain") int info);
public static native @Cast("const char*") BytePointer rs_frame_metadata_to_string(@Cast("rs_frame_metadata") int md);

/**
* start logging to console
* @param min_severity [in] the minimum severity to be logged
* @param error [out]  if non-null, receives any error that occurs during this call, otherwise, errors are ignored
*/
public static native void rs_log_to_console(@Cast("rs_log_severity") int min_severity, @Cast("rs_error**") PointerPointer error);
public static native void rs_log_to_console(@Cast("rs_log_severity") int min_severity, @ByPtrPtr rs_error error);

/**
* start logging to file
* @param file_path [in] relative filename to log to, in case file exists it will be appended to
* @param min_severity [in] the minimum severity to be logged
* @param error [out]  if non-null, receives any error that occurs during this call, otherwise, errors are ignored
*/
public static native void rs_log_to_file(@Cast("rs_log_severity") int min_severity, @Cast("const char*") BytePointer file_path, @Cast("rs_error**") PointerPointer error);
public static native void rs_log_to_file(@Cast("rs_log_severity") int min_severity, @Cast("const char*") BytePointer file_path, @ByPtrPtr rs_error error);
public static native void rs_log_to_file(@Cast("rs_log_severity") int min_severity, String file_path, @ByPtrPtr rs_error error);

/**
* start logging to user provided callback
* @param callback [in] pointer to log into (must be created and used from C++) 
* @param min_severity [in] the minimum severity to be logged
* @param error [out]  if non-null, receives any error that occurs during this call, otherwise, errors are ignored
*/
public static native void rs_log_to_callback_cpp(@Cast("rs_log_severity") int min_severity, rs_log_callback callback, @Cast("rs_error**") PointerPointer error);
public static native void rs_log_to_callback_cpp(@Cast("rs_log_severity") int min_severity, rs_log_callback callback, @ByPtrPtr rs_error error);

/**
* start logging to user provided callback (C version)
* @param on_log [in] callback function pointer
* @param min_severity [in] the minimum severity to be logged
* @param user [in] custom pointer for the callback
* @param error [out]  if non-null, receives any error that occurs during this call, otherwise, errors are ignored
*/
public static native void rs_log_to_callback(@Cast("rs_log_severity") int min_severity, rs_log_callback_ptr on_log, Pointer user, @Cast("rs_error**") PointerPointer error);
public static native void rs_log_to_callback(@Cast("rs_log_severity") int min_severity, rs_log_callback_ptr on_log, Pointer user, @ByPtrPtr rs_error error);

// #ifdef __cplusplus
// #endif
// #endif


// Parsed from <librealsense/rs.hpp>

// License: Apache 2.0. See LICENSE file in root directory.
// Copyright(c) 2015 Intel Corporation. All Rights Reserved.

// #ifndef LIBREALSENSE_RS_HPP
// #define LIBREALSENSE_RS_HPP

// #include "rsutil.h"
// #include "rscore.hpp"
// #include <cmath>
// #include <cstdint>
// #include <cstring>
// #include <sstream>
// #include <stdexcept>
// #include <functional>
// #include <vector>
    /* streams are different types of data provided by RealSense devices */
    /** enum class rs::stream */
    public static final int
        /** Native stream of fish-eye (wide) data captured from the dedicate motion camera */
        fisheye = 4,
        /** Synthetic stream containing point cloud data generated by deprojecting the depth image */
        points = 5,
        /** Synthetic stream containing undistorted color data with no extrinsic rotation from the depth stream */
        rectified_color = 6,
        /** Synthetic stream containing color data but sharing intrinsic of depth stream */
        color_aligned_to_depth = 7,
        /** Synthetic stream containing second viewpoint infrared data but sharing intrinsic of depth stream */
        infrared2_aligned_to_depth = 8,
        /** Synthetic stream containing depth data but sharing intrinsic of color stream */
        depth_aligned_to_color = 9,
        /** Synthetic stream containing depth data but sharing intrinsic of rectified color stream */
        depth_aligned_to_rectified_color = 10,
        /** Synthetic stream containing depth data but sharing intrinsic of second viewpoint infrared stream */
        depth_aligned_to_infrared2 = 11;

    /*  formats define how each stream can be encoded
        format is closely relateed to Linux pixel-formats, but is trying to abstract away the platform specific constructs */
    /** enum class rs::format */
    public static final int
        /** When passed to enable stream, librealsense will try to provide best suited format */
        any = 0,
        /** 16 bit linear depth values. The depth is meters is equal to depth scale * pixel value */
        z16 = 1,
        /** 16 bit linear disparity values. The depth in meters is equal to depth scale / pixel value */
        disparity16 = 2,
        /** 32 bit floating point 3D coordinates. */
        xyz32f = 3,
        /** Standard YUV pixel format as described in https://en.wikipedia.org/wiki/YUV */
        yuyv = 4,
        /** 8-bit Red, Green and Blue channels */
        rgb8 = 5,
        /** 8-bit Blue, Green and Red channels, suitable for OpenCV */
        bgr8 = 6,
        /** 8-bit Red, Green, Blue channels + constant alpha channel equal to FF */
        rgba8 = 7,
        /** 8-bit Blue, Green, Red channels + constant alpha channel equal to FF */
        bgra8 = 8,
        /** 8-bit per-pixel grayscale image */
        y8 = 9,
        /** 16-bit per-pixel grayscale image */
        y16 = 10,
        /** Four 10-bit luminance values encoded into a 5-byte macropixel */
        raw10 = 11,
        /** 16-bit raw image */
        raw16 = 12,
        /** 8-bit raw image */
        raw8 = 13;

    /* Output buffer format sets how librealsense will work with frame memory */
    /** enum class rs::output_buffer_format */
    public static final int
        /** Makes sure that the output frame is exposed as a single continuous buffer */
        continous = 0,
        /** Don't convert buffer to continuous, the user has to handle pitch manually */
        output_native = 1;

    /* Presets hint general preference that is translated by librealsense into concrete resultion and fps */
    /** enum class rs::preset */
    public static final int
        /** Prefer best overall quality */
        best_quality = 0,
        /** Prefer largest image size */
        largest_image = 1,
        /** Prefer highest framerate */
        highest_framerate = 2;

    /* Distortion model define how pixel coordinates should be mapped to sensor coordinates */
    /** enum class rs::distortion */
    public static final int
        /** Rectilinear images, no distortion compensation required */
        none = 0,
        /** Equivalent to Brown-Conrady distortion, except that tangential distortion is applied to radially distorted points */
        modified_brown_conrady = 1,
        /** Equivalent to Brown-Conrady distortion, except undistorts image instead of distorting it */
        inverse_brown_conrady = 2,
        /** Distortion model of the fish-eye camera */
        distortion_ftheta = 3;

    /* Camera options define general configuration controls.
    These can generally be mapped to camera UVC controls, and unless stated otherwise can be set/queried at any time */
    /** enum class rs::option */
    public static final int
        /** Enable / disable color backlight compensation*/
        color_backlight_compensation = 0,
        /** Color image brightness*/
        color_brightness = 1,
        /** Color image contrast*/
        color_contrast = 2,
        /** Controls exposure time of color camera. Setting any value will disable auto exposure*/
        color_exposure = 3,
        /** Color image gain*/
        color_gain = 4,
        /** Color image gamma setting*/
        color_gamma = 5,
        /** Color image hue*/
        color_hue = 6,
        /** Color image saturation setting*/
        color_saturation = 7,
        /** Color image sharpness setting*/
        color_sharpness = 8,
        /** Controls white balance of color image. Setting any value will disable auto white balance*/
        color_white_balance = 9,
        /** Enable / disable color image auto-exposure*/
        color_enable_auto_exposure = 10,
        /** Enable / disable color image auto-white-balance*/
        color_enable_auto_white_balance = 11,
        /** Power of the F200 / SR300 projector, with 0 meaning projector off*/
        f200_laser_power = 12,
        /** Set the number of patterns projected per frame. The higher the accuracy value the more patterns projected. Increasing the number of patterns help to achieve better accuracy. Note that this control is affecting the Depth FPS */
        f200_accuracy = 13,
        /** Motion vs. Range trade-off, with lower values allowing for better motion sensitivity and higher values allowing for better depth range*/
        f200_motion_range = 14,
        /** Set the filter to apply to each depth frame. Each one of the filter is optimized per the application requirements*/
        f200_filter_option = 15,
        /** The confidence level threshold used by the Depth algorithm pipe to set whether a pixel will get a valid range or will be marked with invalid range*/
        f200_confidence_threshold = 16,
        /** (F200-only) Allows to reduce FPS without restarting streaming. Valid values are {2, 5, 15, 30, 60}*/
        f200_dynamic_fps = 17,
        /** Configures SR300 Depth Auto-Range setting. Should not be used directly but through set IVCAM preset method*/
        sr300_auto_range_enable_motion_versus_range = 18,
        /** Configures SR300 Depth Auto-Range setting. Should not be used directly but through set IVCAM preset method*/
        sr300_auto_range_enable_laser = 19,
        /** Configures SR300 Depth Auto-Range setting. Should not be used directly but through set IVCAM preset method*/
        sr300_auto_range_min_motion_versus_range = 20,
        /** Configures SR300 Depth Auto-Range setting. Should not be used directly but through set IVCAM preset method*/
        sr300_auto_range_max_motion_versus_range = 21,
        /** Configures SR300 Depth Auto-Range setting. Should not be used directly but through set IVCAM preset method*/
        sr300_auto_range_start_motion_versus_range = 22,
        /** Configures SR300 Depth Auto-Range setting. Should not be used directly but through set IVCAM preset method*/
        sr300_auto_range_min_laser = 23,
        /** Configures SR300 Depth Auto-Range setting. Should not be used directly but through set IVCAM preset method*/
        sr300_auto_range_max_laser = 24,
        /** Configures SR300 Depth Auto-Range setting. Should not be used directly but through set IVCAM preset method*/
        sr300_auto_range_start_laser = 25,
        /** Configures SR300 Depth Auto-Range setting. Should not be used directly but through set IVCAM preset method*/
        sr300_auto_range_upper_threshold = 26,
        /** Configures SR300 Depth Auto-Range setting. Should not be used directly but through set IVCAM preset method*/
        sr300_auto_range_lower_threshold = 27,
        /** Enables / disables R200 auto-exposure. This will affect both IR and depth image.*/
        r200_lr_auto_exposure_enabled = 28,
        /** IR image gain*/
        r200_lr_gain = 29,
        /** This control allows manual adjustment of the exposure time value for the L/R imagers*/
        r200_lr_exposure = 30,
        /** Enables / disables R200 emitter*/
        r200_emitter_enabled = 31,
        /** Micrometers per increment in integer depth values, 1000 is default (mm scale). Set before streaming*/
        r200_depth_units = 32,
        /** Minimum depth in current depth units that will be output. Any values less than Min Depth will be mapped to 0 during the conversion between disparity and depth. Set before streaming*/
        r200_depth_clamp_min = 33,
        /** Maximum depth in current depth units that will be output. Any values greater than Max Depth will be mapped to 0 during the conversion between disparity and depth. Set before streaming*/
        r200_depth_clamp_max = 34,
        /** The disparity scale factor used when in disparity output mode. Can only be set before streaming*/
        r200_disparity_multiplier = 35,
        /** {0 - 512}. Can only be set before streaming starts*/
        r200_disparity_shift = 36,
        /** (Requires LR-Auto-Exposure ON) Mean intensity set point*/
        r200_auto_exposure_mean_intensity_set_point = 37,
        /** (Requires LR-Auto-Exposure ON) Bright ratio set point*/
        r200_auto_exposure_bright_ratio_set_point = 38,
        /** (Requires LR-Auto-Exposure ON) Kp Gain*/
        r200_auto_exposure_kp_gain = 39,
        /** (Requires LR-Auto-Exposure ON) Kp Exposure*/
        r200_auto_exposure_kp_exposure = 40,
        /** (Requires LR-Auto-Exposure ON) Kp Dark Threshold*/
        r200_auto_exposure_kp_dark_threshold = 41,
        /** (Requires LR-Auto-Exposure ON) Auto-Exposure region-of-interest top edge (in pixels)*/
        r200_auto_exposure_top_edge = 42,
        /** (Requires LR-Auto-Exposure ON) Auto-Exposure region-of-interest bottom edge (in pixels)*/
        r200_auto_exposure_bottom_edge = 43,
        /** (Requires LR-Auto-Exposure ON) Auto-Exposure region-of-interest left edge (in pixels)*/
        r200_auto_exposure_left_edge = 44,
        /** (Requires LR-Auto-Exposure ON) Auto-Exposure region-of-interest right edge (in pixels)*/
        r200_auto_exposure_right_edge = 45,
        /** Value to subtract when estimating the median of the correlation surface*/
        r200_depth_control_estimate_median_decrement = 46,
        /** Value to add when estimating the median of the correlation surface*/
        r200_depth_control_estimate_median_increment = 47,
        /** A threshold by how much the winning score must beat the median*/
        r200_depth_control_median_threshold = 48,
        /** The minimum correlation score that is considered acceptable*/
        r200_depth_control_score_minimum_threshold = 49,
        /** The maximum correlation score that is considered acceptable*/
        r200_depth_control_score_maximum_threshold = 50,
        /** A parameter for determining whether the texture in the region is sufficient to justify a depth result*/
        r200_depth_control_texture_count_threshold = 51,
        /** A parameter for determining whether the texture in the region is sufficient to justify a depth result*/
        r200_depth_control_texture_difference_threshold = 52,
        /** A threshold on how much the minimum correlation score must differ from the next best score*/
        r200_depth_control_second_peak_threshold = 53,
        /** Neighbor threshold value for depth calculation*/
        r200_depth_control_neighbor_threshold = 54,
        /** Left-Right threshold value for depth calculation*/
        r200_depth_control_lr_threshold = 55,
        /** Fisheye image exposure time in msec*/
        fisheye_exposure = 56,
        /** Fisheye image gain*/
        fisheye_gain = 57,
        /** Enables / disables fisheye strobe. When enabled this will align timestamps to common clock-domain with the motion events*/
        fisheye_strobe = 58,
        /** Enables / disables fisheye external trigger mode. When enabled fisheye image will be aquired in-sync with the depth image*/
        fisheye_external_trigger = 59,
        /** Enable / disable fisheye auto-exposure */
        fisheye_color_auto_exposure = 60,
        /** 0 - static auto-exposure, 1 - anti-flicker auto-exposure, 2 - hybrid */
        fisheye_color_auto_exposure_mode = 61,
        /** Fisheye auto-exposure anti-flicker rate, can be 50 or 60 Hz */
        fisheye_color_auto_exposure_rate = 62,
        /** In Fisheye auto-exposure sample frame every given number of pixels */
        fisheye_color_auto_exposure_sample_rate = 63,
        /** In Fisheye auto-exposure sample every given number of frames */
        fisheye_color_auto_exposure_skip_frames = 64,
        /** Number of frames the user is allowed to keep per stream. Trying to hold-on to more frames will cause frame-drops.*/
        frames_queue_size = 65,
        /** Enable / disable fetching log data from the device */
        hardware_logger_enabled = 66,
        /** Total number of detected frame drops from all streams*/
        total_frame_drops = 67;

    /* frame metadata enum discriminates between the different types of values provided from the device with each frame */
    /** enum class rs::frame_metadata */
    public static final int
        /** actual exposure that the frame was captured with */
        actual_exposure = 0,
        /** actual fps at the time of capture */
        actual_fps = 1;

    /* rs_capabilities defines the full set of functionality that a RealSense device might provide
    to check what functionality is supported by a particular device at runtime call dev->supports(capability) */
    /** enum class rs::capabilities */
    public static final int
        /** provides depth stream */
        depth = 0,
        /** provides color stream */
        color = 1,
        /** provides infrared stream */
        infrared = 2,
        /** provides second infrared stream */
        infrared2 = 3,
        /** provides wide field of view (fish-eye) stream */
        fish_eye = 4,
        /** provides gyro and accelorometer events */
        motion_events = 5,
        /** provides method for upgrading motion module firmware */
        motion_module_fw_update = 6,
        /** interanlly includes MIPI to USB adapter */
        adapter_board = 7,
        /** provides enough basic functionality to be considered supported. this to catch at runtime various outdated engineering samples */
        enumeration = 8;

    /* This type defines proprietary formats for direct communication with device firmware */
    /** enum class rs::blob_type */
    public static final int
        /** By using this option, new firmware can be uploaded to the ZR300 motion-module */
        motion_module_firmware_update = 0;

    /* Camera Info feilds are read-only strings that can be queried from the device
       Not all info feilds are available on all camera types
       This information is mainly available for camera debug and troubleshooting and should not be used in applications */
    /** enum class rs::camera_info */
    public static final int
        /** Device friendly name */
        device_name = 0,
        /** Device serial number */
        serial_number = 1,
        /** Primary firmware version */
        camera_firmware_version = 2,
        /** MIPI-to-USB Adapter board firmware version if such board is present */
        adapter_board_firmware_version = 3,
        /** Motion module firmware version if motion module is present */
        motion_module_firmware_version = 4,
        /** R200 / LR200 / ZR300 camera type */
        camera_type = 5,
        /** OEM ID */
        oem_id = 6,
        /** ISP firmware version when available */
        isp_fw_version = 7,
        /** R200 / LR200 / ZR300 content version */
        content_version = 8,
        /** R200 / LR200 / ZR300 module version */
        module_version = 9,
        /** Primary imager model number */
        imager_model_number = 10,
        /** Device build date */
        build_date = 11,
        /** Primary calibration date */
        calibration_date = 12,
        /** R200 / LR200 / ZR300 Program date */
        program_date = 13,
        /** Focus calibration date */
        focus_alignment_date = 14,
        /** R200 / LR200 / ZR300 emitter type */
        emitter_type = 15,
        /** Result of the focus calibration */
        focus_value = 16,
        /** Primary lens type */
        lens_type = 17,
        /** Color imager lens type */
        third_lens_type = 18,
        /** Lens coating type */
        lens_coating_type = 19,
        /** Color coating type */
        third_lens_coating_type = 20,
        /** Nominal baseline */
        lens_nominal_baseline = 21,
        /** Color Nominal baseline */
        third_lens_nominal_baseline = 22;

    /* Source allows the user to choose between available hardware subdevices */
    /** enum class rs::source */
    public static final byte
        /** Video streaming of depth, infrared, color or fish-eye */
        video = 0,
        /** Motion tracking from Gyro and Accelerometer */
        motion_data = 1,
        /** Enable everything together */
        all_sources = 2;

    /* Source device that tiggered specific timestamp event from the motion module */
    /** enum class rs::event */
    public static final byte
        /** Event from accelerometer */
        event_imu_accel = 0,
        /** Event from the gyroscope */
        event_imu_gyro = 1,
        /** Event from depth camera (depth / IR frame) */
        event_imu_depth_cam = 2,
        /** Event from the fish-eye camera */
        event_imu_motion_cam = 3,
        /** Event from external GPIO 0 */
        event_imu_g0_sync = 4,
        /** Event from external GPIO 1 */
        event_imu_g1_sync = 5,
        /** Event from external GPIO 2 */
        event_imu_g2_sync = 6;

    /* When working with motion microcontroller, motion data timestamps are always in microcontroller timestamp domain.
       Some frames, however, might not succesfully receive microcontroller timestamp and will be marked as camera domain */
    /** enum class rs::timestamp_domain */
    public static final int
        /** Frame timestamp was measured in relation to the camera clock */
        camera = 0,
        /** Frame timestamp was measured in relation to the microcontroller clock */
        microcontroller = 1;
// Targeting ../float2.java


// Targeting ../float3.java


// Targeting ../intrinsics.java


// Targeting ../motion_intrinsics.java


// Targeting ../extrinsics.java


// Targeting ../timestamp_data.java


// Targeting ../motion_data.java


// Targeting ../error.java


// Targeting ../context.java


// Targeting ../motion_callback.java


// Targeting ../timestamp_callback.java


// Targeting ../frame.java


// Targeting ../frame_callback.java


// Targeting ../device.java



    @Namespace("rs") public static native @Cast("std::ostream*") @ByRef @Name("operator <<") Pointer shiftLeft(@Cast("std::ostream*") @ByRef Pointer o, @Cast("rs::stream") int stream);
    @Namespace("rs") public static native @Cast("std::ostream*") @ByRef @Name("operator <<") Pointer shiftLeft(@Cast("std::ostream*") @ByRef Pointer o, @Cast("rs::source") byte src);

    /* Severity of the librealsense logger */
    /** enum class rs::log_severity */
    public static final int
        /** Detailed information about ordinary operations */
        debug = 0,
        /** Terse information about ordinary operations */
        info  = 1,
        /** Indication of possible failure */
        warn  = 2,
        /** Indication of definite failure */
        error = 3,
        /** Indication of unrecoverable failure */
        fatal = 4,
        /** No logging will occur */
        log_none  = 5;
// Targeting ../log_callback.java



    @Namespace("rs") public static native void log_to_console(@Cast("rs::log_severity") int min_severity);

    @Namespace("rs") public static native void log_to_file(@Cast("rs::log_severity") int min_severity, @Cast("const char*") BytePointer file_path);
    @Namespace("rs") public static native void log_to_file(@Cast("rs::log_severity") int min_severity, String file_path);

    @Namespace("rs") public static native void log_to_callback(@Cast("rs::log_severity") int min_severity, @ByVal LogCallbackFunction callback);

    // Additional utilities
    @Namespace("rs") public static native void apply_depth_control_preset(device device, int preset);
    @Namespace("rs") public static native void apply_ivcam_preset(device device, @Cast("rs_ivcam_preset") int preset); // duplicate for better backward compatibility with existing applications

// #endif


// Parsed from <librealsense/rscore.hpp>

// License: Apache 2.0. See LICENSE file in root directory.
// Copyright(c) 2015 Intel Corporation. All Rights Reserved.

// #ifndef LIBREALSENSE_RSCORE_HPP
// #define LIBREALSENSE_RSCORE_HPP

// #include "rs.h"
// #include <cstdint>
// #include <cstddef>
// #include <mutex>
// Targeting ../rs_stream_interface.java


// Targeting ../rs_frame_ref.java


// Targeting ../rs_device.java


// Targeting ../rs_context.java


// Targeting ../rs_motion_callback.java


// Targeting ../rs_frame_callback.java


// Targeting ../rs_timestamp_callback.java


// Targeting ../rs_log_callback.java



// #endif


// Parsed from <librealsense/rsutil.h>

/* License: Apache 2.0. See LICENSE file in root directory.
   Copyright(c) 2015 Intel Corporation. All Rights Reserved. */

// #ifndef LIBREALSENSE_RSUTIL_H
// #define LIBREALSENSE_RSUTIL_H

// #include "rs.h"
// #include "assert.h"

/* Given a point in 3D space, compute the corresponding pixel coordinates in an image with no distortion or forward distortion coefficients produced by the same camera */
public static native void rs_project_point_to_pixel(FloatPointer pixel, @Const rs_intrinsics intrin, @Const FloatPointer point);
public static native void rs_project_point_to_pixel(FloatBuffer pixel, @Const rs_intrinsics intrin, @Const FloatBuffer point);
public static native void rs_project_point_to_pixel(float[] pixel, @Const rs_intrinsics intrin, @Const float[] point);

/* Given pixel coordinates and depth in an image with no distortion or inverse distortion coefficients, compute the corresponding point in 3D space relative to the same camera */
public static native void rs_deproject_pixel_to_point(FloatPointer point, @Const rs_intrinsics intrin, @Const FloatPointer pixel, float depth);
public static native void rs_deproject_pixel_to_point(FloatBuffer point, @Const rs_intrinsics intrin, @Const FloatBuffer pixel, float depth);
public static native void rs_deproject_pixel_to_point(float[] point, @Const rs_intrinsics intrin, @Const float[] pixel, float depth);

/* Transform 3D coordinates relative to one sensor to 3D coordinates relative to another viewpoint */
public static native void rs_transform_point_to_point(FloatPointer to_point, @Const rs_extrinsics extrin, @Const FloatPointer from_point);
public static native void rs_transform_point_to_point(FloatBuffer to_point, @Const rs_extrinsics extrin, @Const FloatBuffer from_point);
public static native void rs_transform_point_to_point(float[] to_point, @Const rs_extrinsics extrin, @Const float[] from_point);

/* Provide access to several recommend sets of depth control parameters */
public static native void rs_apply_depth_control_preset(rs_device device, int preset);

/* Provide access to several recommend sets of option presets for ivcam */
public static native void rs_apply_ivcam_preset(rs_device device, @Cast("rs_ivcam_preset") int preset);

// #endif


}
