/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.provider;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Key;
import java.security.KeyStoreException;
import java.security.KeyStoreSpi;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.BERConstructedOctetString;
import org.bouncycastle.asn1.BEROutputStream;
import org.bouncycastle.asn1.DERBMPString;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DEREncodableVector;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.DERTags;
import org.bouncycastle.asn1.pkcs.AuthenticatedSafe;
import org.bouncycastle.asn1.pkcs.CertBag;
import org.bouncycastle.asn1.pkcs.ContentInfo;
import org.bouncycastle.asn1.pkcs.EncryptedData;
import org.bouncycastle.asn1.pkcs.EncryptedPrivateKeyInfo;
import org.bouncycastle.asn1.pkcs.MacData;
import org.bouncycastle.asn1.pkcs.PKCS12PBEParams;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.Pfx;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.pkcs.SafeBag;
import org.bouncycastle.asn1.util.ASN1Dump;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.AuthorityKeyIdentifier;
import org.bouncycastle.asn1.x509.DigestInfo;
import org.bouncycastle.asn1.x509.SubjectKeyIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x509.X509Extensions;
import org.bouncycastle.asn1.x509.X509ObjectIdentifiers;
import org.bouncycastle.jce.interfaces.BCKeyStore;
import org.bouncycastle.jce.interfaces.PKCS12BagAttributeCarrier;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.provider.JCEPBEKey;
import org.bouncycastle.jce.provider.JDKKeyFactory;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Strings;
import org.bouncycastle.util.encoders.Hex;

public class JDKPKCS12KeyStore
extends KeyStoreSpi
implements PKCSObjectIdentifiers,
X509ObjectIdentifiers,
BCKeyStore {
    private static final int SALT_SIZE = 20;
    private static final int MIN_ITERATIONS = 1024;
    private static final Provider bcProvider = new BouncyCastleProvider();
    private IgnoresCaseHashtable keys = new IgnoresCaseHashtable();
    private Hashtable localIds = new Hashtable();
    private IgnoresCaseHashtable certs = new IgnoresCaseHashtable();
    private Hashtable chainCerts = new Hashtable();
    private Hashtable keyCerts = new Hashtable();
    static final int NULL = 0;
    static final int CERTIFICATE = 1;
    static final int KEY = 2;
    static final int SECRET = 3;
    static final int SEALED = 4;
    static final int KEY_PRIVATE = 0;
    static final int KEY_PUBLIC = 1;
    static final int KEY_SECRET = 2;
    protected SecureRandom random = new SecureRandom();
    private CertificateFactory certFact;
    private DERObjectIdentifier keyAlgorithm;
    private DERObjectIdentifier certAlgorithm;

    public JDKPKCS12KeyStore(Provider provider, DERObjectIdentifier dERObjectIdentifier, DERObjectIdentifier dERObjectIdentifier2) {
        this.keyAlgorithm = dERObjectIdentifier;
        this.certAlgorithm = dERObjectIdentifier2;
        try {
            this.certFact = provider != null ? CertificateFactory.getInstance("X.509", provider) : CertificateFactory.getInstance("X.509");
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("can't create cert factory - " + exception.toString());
        }
    }

    private SubjectKeyIdentifier createSubjectKeyId(PublicKey publicKey) {
        try {
            SubjectPublicKeyInfo subjectPublicKeyInfo = new SubjectPublicKeyInfo((ASN1Sequence)ASN1Object.fromByteArray(publicKey.getEncoded()));
            return new SubjectKeyIdentifier(subjectPublicKeyInfo);
        }
        catch (Exception exception) {
            throw new RuntimeException("error creating key");
        }
    }

    public void setRandom(SecureRandom secureRandom) {
        this.random = secureRandom;
    }

    public Enumeration engineAliases() {
        Hashtable<Object, String> hashtable = new Hashtable<Object, String>();
        Enumeration enumeration = this.certs.keys();
        while (enumeration.hasMoreElements()) {
            hashtable.put(enumeration.nextElement(), "cert");
        }
        enumeration = this.keys.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (hashtable.get(string) != null) continue;
            hashtable.put(string, "key");
        }
        return hashtable.keys();
    }

    public boolean engineContainsAlias(String string) {
        return this.certs.get(string) != null || this.keys.get(string) != null;
    }

    public void engineDeleteEntry(String string) throws KeyStoreException {
        Key key = (Key)this.keys.remove(string);
        Certificate certificate = (Certificate)this.certs.remove(string);
        if (certificate != null) {
            this.chainCerts.remove(new CertId(certificate.getPublicKey()));
        }
        if (key != null) {
            String string2 = (String)this.localIds.remove(string);
            if (string2 != null) {
                certificate = (Certificate)this.keyCerts.remove(string2);
            }
            if (certificate != null) {
                this.chainCerts.remove(new CertId(certificate.getPublicKey()));
            }
        }
        if (certificate == null && key == null) {
            throw new KeyStoreException("no such entry as " + string);
        }
    }

    public Certificate engineGetCertificate(String string) {
        if (string == null) {
            throw new IllegalArgumentException("null alias passed to getCertificate.");
        }
        Certificate certificate = (Certificate)this.certs.get(string);
        if (certificate == null) {
            String string2 = (String)this.localIds.get(string);
            certificate = string2 != null ? (Certificate)this.keyCerts.get(string2) : (Certificate)this.keyCerts.get(string);
        }
        return certificate;
    }

    public String engineGetCertificateAlias(Certificate certificate) {
        String string;
        Certificate certificate2;
        Enumeration enumeration = this.certs.elements();
        Enumeration enumeration2 = this.certs.keys();
        while (enumeration.hasMoreElements()) {
            certificate2 = (Certificate)enumeration.nextElement();
            string = (String)enumeration2.nextElement();
            if (!certificate2.equals(certificate)) continue;
            return string;
        }
        enumeration = this.keyCerts.elements();
        enumeration2 = this.keyCerts.keys();
        while (enumeration.hasMoreElements()) {
            certificate2 = (Certificate)enumeration.nextElement();
            string = (String)enumeration2.nextElement();
            if (!certificate2.equals(certificate)) continue;
            return string;
        }
        return null;
    }

    public Certificate[] engineGetCertificateChain(String string) {
        if (string == null) {
            throw new IllegalArgumentException("null alias passed to getCertificateChain.");
        }
        if (!this.engineIsKeyEntry(string)) {
            return null;
        }
        Certificate certificate = this.engineGetCertificate(string);
        if (certificate != null) {
            Certificate[] certificateArray;
            Vector<Certificate> vector = new Vector<Certificate>();
            while (certificate != null) {
                Object object;
                Object object2;
                Object object3;
                certificateArray = (Certificate[])certificate;
                Certificate certificate2 = null;
                byte[] byArray = certificateArray.getExtensionValue(X509Extensions.AuthorityKeyIdentifier.getId());
                if (byArray != null) {
                    try {
                        object3 = new ASN1InputStream(byArray);
                        object2 = ((ASN1OctetString)((ASN1InputStream)object3).readObject()).getOctets();
                        object3 = new ASN1InputStream((byte[])object2);
                        object = new AuthorityKeyIdentifier((ASN1Sequence)((ASN1InputStream)object3).readObject());
                        if (((AuthorityKeyIdentifier)object).getKeyIdentifier() != null) {
                            certificate2 = (Certificate)this.chainCerts.get(new CertId(((AuthorityKeyIdentifier)object).getKeyIdentifier()));
                        }
                    }
                    catch (IOException iOException) {
                        throw new RuntimeException(iOException.toString());
                    }
                }
                if (certificate2 == null && !(object3 = certificateArray.getIssuerDN()).equals(object2 = certificateArray.getSubjectDN())) {
                    object = this.chainCerts.keys();
                    while (object.hasMoreElements()) {
                        X509Certificate x509Certificate = (X509Certificate)this.chainCerts.get(object.nextElement());
                        Principal principal = x509Certificate.getSubjectDN();
                        if (!((Object)principal).equals(object3)) continue;
                        try {
                            certificateArray.verify(x509Certificate.getPublicKey());
                            certificate2 = x509Certificate;
                            break;
                        }
                        catch (Exception exception) {
                        }
                    }
                }
                vector.addElement(certificate);
                if (certificate2 != certificate) {
                    certificate = certificate2;
                    continue;
                }
                certificate = null;
            }
            certificateArray = new Certificate[vector.size()];
            for (int i = 0; i != certificateArray.length; ++i) {
                certificateArray[i] = (Certificate)vector.elementAt(i);
            }
            return certificateArray;
        }
        return null;
    }

    public Date engineGetCreationDate(String string) {
        return new Date();
    }

    public Key engineGetKey(String string, char[] cArray) throws NoSuchAlgorithmException, UnrecoverableKeyException {
        if (string == null) {
            throw new IllegalArgumentException("null alias passed to getKey.");
        }
        return (Key)this.keys.get(string);
    }

    public boolean engineIsCertificateEntry(String string) {
        return this.certs.get(string) != null && this.keys.get(string) == null;
    }

    public boolean engineIsKeyEntry(String string) {
        return this.keys.get(string) != null;
    }

    public void engineSetCertificateEntry(String string, Certificate certificate) throws KeyStoreException {
        if (this.keys.get(string) != null) {
            throw new KeyStoreException("There is a key entry with the name " + string + ".");
        }
        this.certs.put(string, certificate);
        this.chainCerts.put(new CertId(certificate.getPublicKey()), certificate);
    }

    public void engineSetKeyEntry(String string, byte[] byArray, Certificate[] certificateArray) throws KeyStoreException {
        throw new RuntimeException("operation not supported");
    }

    public void engineSetKeyEntry(String string, Key key, char[] cArray, Certificate[] certificateArray) throws KeyStoreException {
        if (key instanceof PrivateKey && certificateArray == null) {
            throw new KeyStoreException("no certificate chain for private key");
        }
        if (this.keys.get(string) != null) {
            this.engineDeleteEntry(string);
        }
        this.keys.put(string, key);
        this.certs.put(string, certificateArray[0]);
        for (int i = 0; i != certificateArray.length; ++i) {
            this.chainCerts.put(new CertId(certificateArray[i].getPublicKey()), certificateArray[i]);
        }
    }

    public int engineSize() {
        Hashtable<Object, String> hashtable = new Hashtable<Object, String>();
        Enumeration enumeration = this.certs.keys();
        while (enumeration.hasMoreElements()) {
            hashtable.put(enumeration.nextElement(), "cert");
        }
        enumeration = this.keys.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (hashtable.get(string) != null) continue;
            hashtable.put(string, "key");
        }
        return hashtable.size();
    }

    protected PrivateKey unwrapKey(AlgorithmIdentifier algorithmIdentifier, byte[] byArray, char[] cArray, boolean bl) throws IOException {
        PrivateKey privateKey;
        String string = algorithmIdentifier.getObjectId().getId();
        PKCS12PBEParams pKCS12PBEParams = new PKCS12PBEParams((ASN1Sequence)algorithmIdentifier.getParameters());
        PBEKeySpec pBEKeySpec = new PBEKeySpec(cArray);
        try {
            SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance(string, bcProvider);
            PBEParameterSpec pBEParameterSpec = new PBEParameterSpec(pKCS12PBEParams.getIV(), pKCS12PBEParams.getIterations().intValue());
            SecretKey secretKey = secretKeyFactory.generateSecret(pBEKeySpec);
            ((JCEPBEKey)secretKey).setTryWrongPKCS12Zero(bl);
            Cipher cipher = Cipher.getInstance(string, bcProvider);
            cipher.init(4, (Key)secretKey, pBEParameterSpec);
            privateKey = (PrivateKey)cipher.unwrap(byArray, "", 2);
        }
        catch (Exception exception) {
            throw new IOException("exception unwrapping private key - " + exception.toString());
        }
        return privateKey;
    }

    protected byte[] wrapKey(String string, Key key, PKCS12PBEParams pKCS12PBEParams, char[] cArray) throws IOException {
        byte[] byArray;
        PBEKeySpec pBEKeySpec = new PBEKeySpec(cArray);
        try {
            SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance(string, bcProvider);
            PBEParameterSpec pBEParameterSpec = new PBEParameterSpec(pKCS12PBEParams.getIV(), pKCS12PBEParams.getIterations().intValue());
            Cipher cipher = Cipher.getInstance(string, bcProvider);
            cipher.init(3, (Key)secretKeyFactory.generateSecret(pBEKeySpec), pBEParameterSpec);
            byArray = cipher.wrap(key);
        }
        catch (Exception exception) {
            throw new IOException("exception encrypting data - " + exception.toString());
        }
        return byArray;
    }

    protected byte[] cryptData(boolean bl, AlgorithmIdentifier algorithmIdentifier, char[] cArray, boolean bl2, byte[] byArray) throws IOException {
        String string = algorithmIdentifier.getObjectId().getId();
        PKCS12PBEParams pKCS12PBEParams = new PKCS12PBEParams((ASN1Sequence)algorithmIdentifier.getParameters());
        PBEKeySpec pBEKeySpec = new PBEKeySpec(cArray);
        try {
            SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance(string, bcProvider);
            PBEParameterSpec pBEParameterSpec = new PBEParameterSpec(pKCS12PBEParams.getIV(), pKCS12PBEParams.getIterations().intValue());
            JCEPBEKey jCEPBEKey = (JCEPBEKey)secretKeyFactory.generateSecret(pBEKeySpec);
            jCEPBEKey.setTryWrongPKCS12Zero(bl2);
            Cipher cipher = Cipher.getInstance(string, bcProvider);
            int n = bl ? 1 : 2;
            cipher.init(n, (Key)jCEPBEKey, pBEParameterSpec);
            return cipher.doFinal(byArray);
        }
        catch (Exception exception) {
            throw new IOException("exception decrypting data - " + exception.toString());
        }
    }

    public void engineLoad(InputStream inputStream, char[] cArray) throws IOException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        Object object7;
        ASN1Encodable aSN1Encodable;
        if (inputStream == null) {
            return;
        }
        if (cArray == null) {
            throw new NullPointerException("No password supplied for PKCS#12 KeyStore.");
        }
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
        bufferedInputStream.mark(10);
        int n = bufferedInputStream.read();
        if (n != 48) {
            throw new IOException("stream does not represent a PKCS12 key store");
        }
        bufferedInputStream.reset();
        ASN1InputStream aSN1InputStream = new ASN1InputStream(bufferedInputStream);
        ASN1Sequence aSN1Sequence = (ASN1Sequence)aSN1InputStream.readObject();
        Pfx pfx = new Pfx(aSN1Sequence);
        ContentInfo contentInfo = pfx.getAuthSafe();
        Vector<Object> vector = new Vector<Object>();
        boolean bl = false;
        boolean bl2 = false;
        if (pfx.getMacData() != null) {
            aSN1Encodable = pfx.getMacData();
            object7 = ((MacData)aSN1Encodable).getMac();
            AlgorithmIdentifier algorithmIdentifier = ((DigestInfo)object7).getAlgorithmId();
            object6 = ((MacData)aSN1Encodable).getSalt();
            int n2 = ((MacData)aSN1Encodable).getIterationCount().intValue();
            byte[] byArray = ((ASN1OctetString)contentInfo.getContent()).getOctets();
            try {
                object5 = JDKPKCS12KeyStore.calculatePbeMac(algorithmIdentifier.getObjectId(), (byte[])object6, n2, cArray, false, byArray);
                object4 = ((DigestInfo)object7).getDigest();
                if (!Arrays.areEqual(object5, (byte[])object4)) {
                    if (cArray.length > 0) {
                        throw new IOException("PKCS12 key store mac invalid - wrong password or corrupted file.");
                    }
                    object5 = JDKPKCS12KeyStore.calculatePbeMac(algorithmIdentifier.getObjectId(), (byte[])object6, n2, cArray, true, byArray);
                    if (!Arrays.areEqual(object5, (byte[])object4)) {
                        throw new IOException("PKCS12 key store mac invalid - wrong password or corrupted file.");
                    }
                    bl2 = true;
                }
            }
            catch (IOException iOException) {
                throw iOException;
            }
            catch (Exception exception) {
                throw new IOException("error constructing MAC: " + exception.toString());
            }
        }
        this.keys = new IgnoresCaseHashtable();
        this.localIds = new Hashtable();
        if (contentInfo.getContentType().equals(data)) {
            aSN1InputStream = new ASN1InputStream(((ASN1OctetString)contentInfo.getContent()).getOctets());
            aSN1Encodable = new AuthenticatedSafe((ASN1Sequence)aSN1InputStream.readObject());
            object7 = ((AuthenticatedSafe)aSN1Encodable).getContentInfo();
            for (int i = 0; i != ((ContentInfo[])object7).length; ++i) {
                DERObject dERObject;
                ASN1Object aSN1Object;
                Object object8;
                Object object9;
                Object object10;
                Object object11;
                Object object12;
                if (object7[i].getContentType().equals(data)) {
                    object6 = new ASN1InputStream(((ASN1OctetString)((ContentInfo)object7[i]).getContent()).getOctets());
                    object12 = (ASN1Sequence)((ASN1InputStream)object6).readObject();
                    for (int j = 0; j != ((ASN1Sequence)object12).size(); ++j) {
                        object5 = new SafeBag((ASN1Sequence)((ASN1Sequence)object12).getObjectAt(j));
                        if (object5.getBagId().equals(pkcs8ShroudedKeyBag)) {
                            object4 = new EncryptedPrivateKeyInfo((ASN1Sequence)object5.getBagValue());
                            object3 = this.unwrapKey(((EncryptedPrivateKeyInfo)object4).getEncryptionAlgorithm(), ((EncryptedPrivateKeyInfo)object4).getEncryptedData(), cArray, bl2);
                            object2 = (PKCS12BagAttributeCarrier)object3;
                            object = null;
                            object11 = null;
                            if (object5.getBagAttributes() != null) {
                                object10 = object5.getBagAttributes().getObjects();
                                while (object10.hasMoreElements()) {
                                    object9 = (ASN1Sequence)object10.nextElement();
                                    object8 = (DERObjectIdentifier)((ASN1Sequence)object9).getObjectAt(0);
                                    aSN1Object = (ASN1Set)((ASN1Sequence)object9).getObjectAt(1);
                                    dERObject = null;
                                    if (((ASN1Set)aSN1Object).size() > 0) {
                                        dERObject = (DERObject)((ASN1Set)aSN1Object).getObjectAt(0);
                                        object2.setBagAttribute((DERObjectIdentifier)object8, dERObject);
                                    }
                                    if (((ASN1Object)object8).equals(pkcs_9_at_friendlyName)) {
                                        object = ((DERBMPString)dERObject).getString();
                                        this.keys.put((String)object, object3);
                                        continue;
                                    }
                                    if (!((ASN1Object)object8).equals(pkcs_9_at_localKeyId)) continue;
                                    object11 = (ASN1OctetString)dERObject;
                                }
                            }
                            if (object11 != null) {
                                object10 = new String(Hex.encode(((ASN1OctetString)object11).getOctets()));
                                if (object == null) {
                                    this.keys.put((String)object10, object3);
                                    continue;
                                }
                                this.localIds.put(object, object10);
                                continue;
                            }
                            bl = true;
                            this.keys.put("unmarked", object3);
                            continue;
                        }
                        if (object5.getBagId().equals(certBag)) {
                            vector.addElement(object5);
                            continue;
                        }
                        System.out.println("extra in data " + object5.getBagId());
                        System.out.println(ASN1Dump.dumpAsString(object5));
                    }
                    continue;
                }
                if (((ContentInfo)object7[i]).getContentType().equals(encryptedData)) {
                    object6 = new EncryptedData((ASN1Sequence)((ContentInfo)object7[i]).getContent());
                    object12 = this.cryptData(false, ((EncryptedData)object6).getEncryptionAlgorithm(), cArray, bl2, ((EncryptedData)object6).getContent().getOctets());
                    ASN1Sequence aSN1Sequence2 = (ASN1Sequence)ASN1Object.fromByteArray((byte[])object12);
                    for (int j = 0; j != aSN1Sequence2.size(); ++j) {
                        DERObject dERObject2;
                        object4 = new SafeBag((ASN1Sequence)aSN1Sequence2.getObjectAt(j));
                        if (((SafeBag)object4).getBagId().equals(certBag)) {
                            vector.addElement(object4);
                            continue;
                        }
                        if (((SafeBag)object4).getBagId().equals(pkcs8ShroudedKeyBag)) {
                            object3 = new EncryptedPrivateKeyInfo((ASN1Sequence)((SafeBag)object4).getBagValue());
                            object2 = this.unwrapKey(((EncryptedPrivateKeyInfo)object3).getEncryptionAlgorithm(), ((EncryptedPrivateKeyInfo)object3).getEncryptedData(), cArray, bl2);
                            object = (PKCS12BagAttributeCarrier)object2;
                            object11 = null;
                            object10 = null;
                            object9 = ((SafeBag)object4).getBagAttributes().getObjects();
                            while (object9.hasMoreElements()) {
                                object8 = (ASN1Sequence)object9.nextElement();
                                aSN1Object = (DERObjectIdentifier)((ASN1Sequence)object8).getObjectAt(0);
                                dERObject = (ASN1Set)((ASN1Sequence)object8).getObjectAt(1);
                                dERObject2 = null;
                                if (((ASN1Set)dERObject).size() > 0) {
                                    dERObject2 = (DERObject)((ASN1Set)dERObject).getObjectAt(0);
                                    object.setBagAttribute((DERObjectIdentifier)aSN1Object, dERObject2);
                                }
                                if (aSN1Object.equals(pkcs_9_at_friendlyName)) {
                                    object11 = ((DERBMPString)dERObject2).getString();
                                    this.keys.put((String)object11, object2);
                                    continue;
                                }
                                if (!aSN1Object.equals(pkcs_9_at_localKeyId)) continue;
                                object10 = (ASN1OctetString)dERObject2;
                            }
                            object8 = new String(Hex.encode(((ASN1OctetString)object10).getOctets()));
                            if (object11 == null) {
                                this.keys.put((String)object8, object2);
                                continue;
                            }
                            this.localIds.put(object11, object8);
                            continue;
                        }
                        if (((SafeBag)object4).getBagId().equals(keyBag)) {
                            object3 = new PrivateKeyInfo((ASN1Sequence)((SafeBag)object4).getBagValue());
                            object2 = JDKKeyFactory.createPrivateKeyFromPrivateKeyInfo((PrivateKeyInfo)object3);
                            object = (PKCS12BagAttributeCarrier)object2;
                            object11 = null;
                            object10 = null;
                            object9 = ((SafeBag)object4).getBagAttributes().getObjects();
                            while (object9.hasMoreElements()) {
                                object8 = (ASN1Sequence)object9.nextElement();
                                aSN1Object = (DERObjectIdentifier)((ASN1Sequence)object8).getObjectAt(0);
                                dERObject = (ASN1Set)((ASN1Sequence)object8).getObjectAt(1);
                                dERObject2 = null;
                                if (((ASN1Set)dERObject).size() > 0) {
                                    dERObject2 = (DERObject)((ASN1Set)dERObject).getObjectAt(0);
                                    object.setBagAttribute((DERObjectIdentifier)aSN1Object, dERObject2);
                                }
                                if (aSN1Object.equals(pkcs_9_at_friendlyName)) {
                                    object11 = ((DERBMPString)dERObject2).getString();
                                    this.keys.put((String)object11, object2);
                                    continue;
                                }
                                if (!aSN1Object.equals(pkcs_9_at_localKeyId)) continue;
                                object10 = (ASN1OctetString)dERObject2;
                            }
                            object8 = new String(Hex.encode(((ASN1OctetString)object10).getOctets()));
                            if (object11 == null) {
                                this.keys.put((String)object8, object2);
                                continue;
                            }
                            this.localIds.put(object11, object8);
                            continue;
                        }
                        System.out.println("extra in encryptedData " + ((SafeBag)object4).getBagId());
                        System.out.println(ASN1Dump.dumpAsString(object4));
                    }
                    continue;
                }
                System.out.println("extra " + ((ContentInfo)object7[i]).getContentType().getId());
                System.out.println("extra " + ASN1Dump.dumpAsString(((ContentInfo)object7[i]).getContent()));
            }
        }
        this.certs = new IgnoresCaseHashtable();
        this.chainCerts = new Hashtable();
        this.keyCerts = new Hashtable();
        for (int i = 0; i != vector.size(); ++i) {
            Object object13;
            object7 = (SafeBag)vector.elementAt(i);
            CertBag certBag = new CertBag((ASN1Sequence)((SafeBag)object7).getBagValue());
            if (!certBag.getCertId().equals(x509Certificate)) {
                throw new RuntimeException("Unsupported certificate type: " + certBag.getCertId());
            }
            try {
                object13 = new ByteArrayInputStream(((ASN1OctetString)certBag.getCertValue()).getOctets());
                object6 = this.certFact.generateCertificate((InputStream)object13);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception.toString());
            }
            object13 = null;
            String string = null;
            if (((SafeBag)object7).getBagAttributes() != null) {
                object5 = ((SafeBag)object7).getBagAttributes().getObjects();
                while (object5.hasMoreElements()) {
                    object4 = (ASN1Sequence)object5.nextElement();
                    object3 = (DERObjectIdentifier)((ASN1Sequence)object4).getObjectAt(0);
                    object2 = (DERObject)((ASN1Set)((ASN1Sequence)object4).getObjectAt(1)).getObjectAt(0);
                    object = null;
                    if (object6 instanceof PKCS12BagAttributeCarrier) {
                        object = (PKCS12BagAttributeCarrier)object6;
                        object.setBagAttribute((DERObjectIdentifier)object3, (DEREncodable)object2);
                    }
                    if (((ASN1Object)object3).equals(pkcs_9_at_friendlyName)) {
                        string = ((DERBMPString)object2).getString();
                        continue;
                    }
                    if (!((ASN1Object)object3).equals(pkcs_9_at_localKeyId)) continue;
                    object13 = (ASN1OctetString)object2;
                }
            }
            this.chainCerts.put(new CertId(((Certificate)object6).getPublicKey()), object6);
            if (bl) {
                if (!this.keyCerts.isEmpty()) continue;
                object5 = new String(Hex.encode(this.createSubjectKeyId(((Certificate)object6).getPublicKey()).getKeyIdentifier()));
                this.keyCerts.put(object5, object6);
                this.keys.put((String)object5, this.keys.remove("unmarked"));
                continue;
            }
            if (object13 != null) {
                object5 = new String(Hex.encode(((ASN1OctetString)object13).getOctets()));
                this.keyCerts.put(object5, object6);
            }
            if (string == null) continue;
            this.certs.put(string, object6);
        }
    }

    public void engineStore(OutputStream outputStream, char[] cArray) throws IOException {
        MacData macData;
        Object object;
        Object object2;
        ASN1Encodable aSN1Encodable;
        Object object3;
        DERTags dERTags;
        Object object4;
        Object object5;
        ContentInfo[] contentInfoArray;
        Object object6;
        Object object7;
        Object object8;
        AlgorithmIdentifier algorithmIdentifier;
        Object object9;
        Object object10;
        Object object11;
        Object object12;
        byte[] byArray;
        if (cArray == null) {
            throw new NullPointerException("No password supplied for PKCS#12 KeyStore.");
        }
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        Enumeration enumeration = this.keys.keys();
        while (enumeration.hasMoreElements()) {
            Object object13;
            byArray = new byte[20];
            this.random.nextBytes(byArray);
            object12 = (String)enumeration.nextElement();
            object11 = (PrivateKey)this.keys.get((String)object12);
            object10 = new PKCS12PBEParams(byArray, 1024);
            object9 = this.wrapKey(this.keyAlgorithm.getId(), (Key)object11, (PKCS12PBEParams)object10, cArray);
            algorithmIdentifier = new AlgorithmIdentifier(this.keyAlgorithm, ((ASN1Encodable)object10).getDERObject());
            object8 = new EncryptedPrivateKeyInfo(algorithmIdentifier, (byte[])object9);
            boolean bl = false;
            object7 = new ASN1EncodableVector();
            if (object11 instanceof PKCS12BagAttributeCarrier) {
                object6 = (PKCS12BagAttributeCarrier)object11;
                object13 = (DERBMPString)object6.getBagAttribute(pkcs_9_at_friendlyName);
                if (object13 == null || !((DERBMPString)object13).getString().equals(object12)) {
                    object6.setBagAttribute(pkcs_9_at_friendlyName, new DERBMPString((String)object12));
                }
                if (object6.getBagAttribute(pkcs_9_at_localKeyId) == null) {
                    contentInfoArray = this.engineGetCertificate((String)object12);
                    object6.setBagAttribute(pkcs_9_at_localKeyId, this.createSubjectKeyId(contentInfoArray.getPublicKey()));
                }
                contentInfoArray = object6.getBagAttributeKeys();
                while (contentInfoArray.hasMoreElements()) {
                    object5 = (DERObjectIdentifier)contentInfoArray.nextElement();
                    object4 = new ASN1EncodableVector();
                    ((DEREncodableVector)object4).add((DEREncodable)object5);
                    ((DEREncodableVector)object4).add(new DERSet(object6.getBagAttribute((DERObjectIdentifier)object5)));
                    bl = true;
                    ((DEREncodableVector)object7).add(new DERSequence((DEREncodableVector)object4));
                }
            }
            if (!bl) {
                object6 = new ASN1EncodableVector();
                object13 = this.engineGetCertificate((String)object12);
                ((DEREncodableVector)object6).add(pkcs_9_at_localKeyId);
                ((DEREncodableVector)object6).add(new DERSet(this.createSubjectKeyId(((Certificate)object13).getPublicKey())));
                ((DEREncodableVector)object7).add(new DERSequence((DEREncodableVector)object6));
                object6 = new ASN1EncodableVector();
                ((DEREncodableVector)object6).add(pkcs_9_at_friendlyName);
                ((DEREncodableVector)object6).add(new DERSet(new DERBMPString((String)object12)));
                ((DEREncodableVector)object7).add(new DERSequence((DEREncodableVector)object6));
            }
            object6 = new SafeBag(pkcs8ShroudedKeyBag, ((ASN1Encodable)object8).getDERObject(), new DERSet((DEREncodableVector)object7));
            aSN1EncodableVector.add((DEREncodable)object6);
        }
        byArray = new DERSequence(aSN1EncodableVector).getDEREncoded();
        object12 = new BERConstructedOctetString(byArray);
        object11 = new byte[20];
        this.random.nextBytes((byte[])object11);
        object10 = new ASN1EncodableVector();
        object9 = new PKCS12PBEParams((byte[])object11, 1024);
        algorithmIdentifier = new AlgorithmIdentifier(this.certAlgorithm, ((ASN1Encodable)object9).getDERObject());
        object8 = new Hashtable();
        Enumeration enumeration2 = this.keys.keys();
        while (enumeration2.hasMoreElements()) {
            try {
                object7 = (String)enumeration2.nextElement();
                object6 = this.engineGetCertificate((String)object7);
                boolean bl = false;
                contentInfoArray = new CertBag(x509Certificate, new DEROctetString(((Certificate)object6).getEncoded()));
                object5 = new ASN1EncodableVector();
                if (object6 instanceof PKCS12BagAttributeCarrier) {
                    object4 = (PKCS12BagAttributeCarrier)object6;
                    dERTags = (DERBMPString)object4.getBagAttribute(pkcs_9_at_friendlyName);
                    if (dERTags == null || !((DERBMPString)dERTags).getString().equals(object7)) {
                        object4.setBagAttribute(pkcs_9_at_friendlyName, new DERBMPString((String)object7));
                    }
                    if (object4.getBagAttribute(pkcs_9_at_localKeyId) == null) {
                        object4.setBagAttribute(pkcs_9_at_localKeyId, this.createSubjectKeyId(((Certificate)object6).getPublicKey()));
                    }
                    object3 = object4.getBagAttributeKeys();
                    while (object3.hasMoreElements()) {
                        aSN1Encodable = (DERObjectIdentifier)object3.nextElement();
                        object2 = new ASN1EncodableVector();
                        ((DEREncodableVector)object2).add(aSN1Encodable);
                        ((DEREncodableVector)object2).add(new DERSet(object4.getBagAttribute((DERObjectIdentifier)aSN1Encodable)));
                        ((DEREncodableVector)object5).add(new DERSequence((DEREncodableVector)object2));
                        bl = true;
                    }
                }
                if (!bl) {
                    object4 = new ASN1EncodableVector();
                    ((DEREncodableVector)object4).add(pkcs_9_at_localKeyId);
                    ((DEREncodableVector)object4).add(new DERSet(this.createSubjectKeyId(((Certificate)object6).getPublicKey())));
                    ((DEREncodableVector)object5).add(new DERSequence((DEREncodableVector)object4));
                    object4 = new ASN1EncodableVector();
                    ((DEREncodableVector)object4).add(pkcs_9_at_friendlyName);
                    ((DEREncodableVector)object4).add(new DERSet(new DERBMPString((String)object7)));
                    ((DEREncodableVector)object5).add(new DERSequence((DEREncodableVector)object4));
                }
                object4 = new SafeBag(certBag, contentInfoArray.getDERObject(), new DERSet((DEREncodableVector)object5));
                ((DEREncodableVector)object10).add((DEREncodable)object4);
                ((Hashtable)object8).put(object6, object6);
            }
            catch (CertificateEncodingException certificateEncodingException) {
                throw new IOException("Error encoding certificate: " + certificateEncodingException.toString());
            }
        }
        enumeration2 = this.certs.keys();
        while (enumeration2.hasMoreElements()) {
            try {
                object7 = (String)enumeration2.nextElement();
                object6 = (Certificate)this.certs.get((String)object7);
                boolean bl = false;
                if (this.keys.get((String)object7) != null) continue;
                contentInfoArray = new CertBag(x509Certificate, new DEROctetString(((Certificate)object6).getEncoded()));
                object5 = new ASN1EncodableVector();
                if (object6 instanceof PKCS12BagAttributeCarrier) {
                    object4 = (PKCS12BagAttributeCarrier)object6;
                    dERTags = (DERBMPString)object4.getBagAttribute(pkcs_9_at_friendlyName);
                    if (dERTags == null || !((DERBMPString)dERTags).getString().equals(object7)) {
                        object4.setBagAttribute(pkcs_9_at_friendlyName, new DERBMPString((String)object7));
                    }
                    object3 = object4.getBagAttributeKeys();
                    while (object3.hasMoreElements()) {
                        aSN1Encodable = (DERObjectIdentifier)object3.nextElement();
                        if (((ASN1Object)aSN1Encodable).equals(PKCSObjectIdentifiers.pkcs_9_at_localKeyId)) continue;
                        object2 = new ASN1EncodableVector();
                        ((DEREncodableVector)object2).add(aSN1Encodable);
                        ((DEREncodableVector)object2).add(new DERSet(object4.getBagAttribute((DERObjectIdentifier)aSN1Encodable)));
                        ((DEREncodableVector)object5).add(new DERSequence((DEREncodableVector)object2));
                        bl = true;
                    }
                }
                if (!bl) {
                    object4 = new ASN1EncodableVector();
                    ((DEREncodableVector)object4).add(pkcs_9_at_friendlyName);
                    ((DEREncodableVector)object4).add(new DERSet(new DERBMPString((String)object7)));
                    ((DEREncodableVector)object5).add(new DERSequence((DEREncodableVector)object4));
                }
                object4 = new SafeBag(certBag, contentInfoArray.getDERObject(), new DERSet((DEREncodableVector)object5));
                ((DEREncodableVector)object10).add((DEREncodable)object4);
                ((Hashtable)object8).put(object6, object6);
            }
            catch (CertificateEncodingException certificateEncodingException) {
                throw new IOException("Error encoding certificate: " + certificateEncodingException.toString());
            }
        }
        enumeration2 = this.chainCerts.keys();
        while (enumeration2.hasMoreElements()) {
            try {
                object7 = (CertId)enumeration2.nextElement();
                object6 = (Certificate)this.chainCerts.get(object7);
                if (((Hashtable)object8).get(object6) != null) continue;
                CertBag certBag = new CertBag(x509Certificate, new DEROctetString(((Certificate)object6).getEncoded()));
                contentInfoArray = new ASN1EncodableVector();
                if (object6 instanceof PKCS12BagAttributeCarrier) {
                    object5 = (PKCS12BagAttributeCarrier)object6;
                    object4 = object5.getBagAttributeKeys();
                    while (object4.hasMoreElements()) {
                        dERTags = (DERObjectIdentifier)object4.nextElement();
                        if (((ASN1Object)dERTags).equals(PKCSObjectIdentifiers.pkcs_9_at_localKeyId)) continue;
                        object3 = new ASN1EncodableVector();
                        ((DEREncodableVector)object3).add((DEREncodable)((Object)dERTags));
                        ((DEREncodableVector)object3).add(new DERSet(object5.getBagAttribute((DERObjectIdentifier)dERTags)));
                        contentInfoArray.add(new DERSequence((DEREncodableVector)object3));
                    }
                }
                object5 = new SafeBag(JDKPKCS12KeyStore.certBag, certBag.getDERObject(), new DERSet((DEREncodableVector)contentInfoArray));
                ((DEREncodableVector)object10).add((DEREncodable)object5);
            }
            catch (CertificateEncodingException certificateEncodingException) {
                throw new IOException("Error encoding certificate: " + certificateEncodingException.toString());
            }
        }
        object7 = new DERSequence((DEREncodableVector)object10).getDEREncoded();
        object6 = this.cryptData(true, algorithmIdentifier, cArray, false, (byte[])object7);
        EncryptedData encryptedData = new EncryptedData(data, algorithmIdentifier, new BERConstructedOctetString((byte[])object6));
        contentInfoArray = new ContentInfo[]{new ContentInfo(data, (DEREncodable)object12), new ContentInfo(JDKPKCS12KeyStore.encryptedData, encryptedData.getDERObject())};
        object5 = new AuthenticatedSafe(contentInfoArray);
        object4 = new ByteArrayOutputStream();
        dERTags = new BEROutputStream((OutputStream)object4);
        ((BEROutputStream)dERTags).writeObject(object5);
        object3 = ((ByteArrayOutputStream)object4).toByteArray();
        aSN1Encodable = new ContentInfo(data, new BERConstructedOctetString((byte[])object3));
        object2 = new byte[20];
        int n = 1024;
        this.random.nextBytes((byte[])object2);
        byte[] byArray2 = ((ASN1OctetString)((ContentInfo)aSN1Encodable).getContent()).getOctets();
        try {
            object = JDKPKCS12KeyStore.calculatePbeMac(id_SHA1, (byte[])object2, n, cArray, false, byArray2);
            AlgorithmIdentifier algorithmIdentifier2 = new AlgorithmIdentifier(id_SHA1, new DERNull());
            DigestInfo digestInfo = new DigestInfo(algorithmIdentifier2, (byte[])object);
            macData = new MacData(digestInfo, (byte[])object2, n);
        }
        catch (Exception exception) {
            throw new IOException("error constructing MAC: " + exception.toString());
        }
        object = new Pfx((ContentInfo)aSN1Encodable, macData);
        dERTags = new BEROutputStream(outputStream);
        ((BEROutputStream)dERTags).writeObject(object);
    }

    private static byte[] calculatePbeMac(DERObjectIdentifier dERObjectIdentifier, byte[] byArray, int n, char[] cArray, boolean bl, byte[] byArray2) throws Exception {
        SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance(dERObjectIdentifier.getId(), bcProvider);
        PBEParameterSpec pBEParameterSpec = new PBEParameterSpec(byArray, n);
        PBEKeySpec pBEKeySpec = new PBEKeySpec(cArray);
        JCEPBEKey jCEPBEKey = (JCEPBEKey)secretKeyFactory.generateSecret(pBEKeySpec);
        jCEPBEKey.setTryWrongPKCS12Zero(bl);
        Mac mac = Mac.getInstance(dERObjectIdentifier.getId(), bcProvider);
        mac.init(jCEPBEKey, pBEParameterSpec);
        mac.update(byArray2);
        return mac.doFinal();
    }

    private static class IgnoresCaseHashtable {
        private Hashtable orig = new Hashtable();
        private Hashtable keys = new Hashtable();

        private IgnoresCaseHashtable() {
        }

        public void put(String string, Object object) {
            String string2 = Strings.toLowerCase(string);
            String string3 = (String)this.keys.get(string2);
            if (string3 != null) {
                this.orig.remove(string3);
            }
            this.keys.put(string2, string);
            this.orig.put(string, object);
        }

        public Enumeration keys() {
            return this.orig.keys();
        }

        public Object remove(String string) {
            String string2 = (String)this.keys.remove(Strings.toLowerCase(string));
            if (string2 == null) {
                return null;
            }
            return this.orig.remove(string2);
        }

        public Object get(String string) {
            String string2 = (String)this.keys.get(Strings.toLowerCase(string));
            if (string2 == null) {
                return null;
            }
            return this.orig.get(string2);
        }

        public Enumeration elements() {
            return this.orig.elements();
        }
    }

    public static class DefPKCS12KeyStore3DES
    extends JDKPKCS12KeyStore {
        public DefPKCS12KeyStore3DES() {
            super(null, pbeWithSHAAnd3_KeyTripleDES_CBC, pbeWithSHAAnd3_KeyTripleDES_CBC);
        }
    }

    public static class DefPKCS12KeyStore
    extends JDKPKCS12KeyStore {
        public DefPKCS12KeyStore() {
            super(null, pbeWithSHAAnd3_KeyTripleDES_CBC, pbewithSHAAnd40BitRC2_CBC);
        }
    }

    public static class BCPKCS12KeyStore3DES
    extends JDKPKCS12KeyStore {
        public BCPKCS12KeyStore3DES() {
            super(bcProvider, pbeWithSHAAnd3_KeyTripleDES_CBC, pbeWithSHAAnd3_KeyTripleDES_CBC);
        }
    }

    public static class BCPKCS12KeyStore
    extends JDKPKCS12KeyStore {
        public BCPKCS12KeyStore() {
            super(bcProvider, pbeWithSHAAnd3_KeyTripleDES_CBC, pbewithSHAAnd40BitRC2_CBC);
        }
    }

    private class CertId {
        byte[] id;

        CertId(PublicKey publicKey) {
            this.id = JDKPKCS12KeyStore.this.createSubjectKeyId(publicKey).getKeyIdentifier();
        }

        CertId(byte[] byArray) {
            this.id = byArray;
        }

        public int hashCode() {
            return Arrays.hashCode(this.id);
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof CertId)) {
                return false;
            }
            CertId certId = (CertId)object;
            return Arrays.areEqual(this.id, certId.id);
        }
    }
}

