/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.general;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.SecureRandom;
import org.bouncycastle.crypto.Algorithm;
import org.bouncycastle.crypto.AsymmetricPrivateKey;
import org.bouncycastle.crypto.AsymmetricPublicKey;
import org.bouncycastle.crypto.DigestAlgorithm;
import org.bouncycastle.crypto.OutputSigner;
import org.bouncycastle.crypto.OutputVerifier;
import org.bouncycastle.crypto.asymmetric.AsymmetricECPrivateKey;
import org.bouncycastle.crypto.asymmetric.AsymmetricECPublicKey;
import org.bouncycastle.crypto.asymmetric.AsymmetricKeyPair;
import org.bouncycastle.crypto.asymmetric.ECDomainParameters;
import org.bouncycastle.crypto.asymmetric.NamedECDomainParameters;
import org.bouncycastle.crypto.fips.FipsEC;
import org.bouncycastle.crypto.fips.FipsSHS;
import org.bouncycastle.crypto.general.DSAOutputSigner;
import org.bouncycastle.crypto.general.DSAOutputVerifier;
import org.bouncycastle.crypto.general.EcDsaSigner;
import org.bouncycastle.crypto.general.GeneralAlgorithm;
import org.bouncycastle.crypto.general.GeneralParameters;
import org.bouncycastle.crypto.general.GuardedAsymmetricKeyPairGenerator;
import org.bouncycastle.crypto.general.GuardedSignatureOperatorFactory;
import org.bouncycastle.crypto.general.HMacDsaKCalculator;
import org.bouncycastle.crypto.general.NullDigest;
import org.bouncycastle.crypto.general.RandomDsaKCalculator;
import org.bouncycastle.crypto.general.Register;
import org.bouncycastle.crypto.internal.DSA;
import org.bouncycastle.crypto.internal.Digest;
import org.bouncycastle.crypto.internal.params.EcDomainParameters;
import org.bouncycastle.crypto.internal.params.EcNamedDomainParameters;
import org.bouncycastle.crypto.internal.params.EcPrivateKeyParameters;
import org.bouncycastle.crypto.internal.params.EcPublicKeyParameters;
import org.bouncycastle.crypto.internal.params.ParametersWithRandom;
import org.bouncycastle.util.Properties;

public final class EC {
    public static final Algorithm ALGORITHM = FipsEC.ALGORITHM;
    public static final DSAParameters DSA = new DSAParameters(new GeneralAlgorithm(ALGORITHM.getName(), (Enum)Variations.ECDSA), FipsSHS.Algorithm.SHA1);
    public static final DSAParameters DDSA = new DSAParameters(new GeneralAlgorithm(ALGORITHM.getName(), (Enum)Variations.ECDDSA), FipsSHS.Algorithm.SHA1);

    private EC() {
    }

    private static void checkEnabled() {
        if (Properties.isOverrideSet("org.bouncycastle.ec.disable")) {
            throw new UnsupportedOperationException("EC has been disabled by setting \"org.bouncycastle.ec.disable\"");
        }
    }

    private static EcDomainParameters getDomainParams(ECDomainParameters eCDomainParameters) {
        if (eCDomainParameters instanceof NamedECDomainParameters) {
            return new EcNamedDomainParameters((NamedECDomainParameters)eCDomainParameters);
        }
        return new EcDomainParameters(eCDomainParameters);
    }

    private static EcPrivateKeyParameters getLwKey(final AsymmetricECPrivateKey asymmetricECPrivateKey) {
        return AccessController.doPrivileged(new PrivilegedAction<EcPrivateKeyParameters>(){

            @Override
            public EcPrivateKeyParameters run() {
                return new EcPrivateKeyParameters(asymmetricECPrivateKey.getS(), EC.getDomainParams(asymmetricECPrivateKey.getDomainParameters()));
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class DSAOperatorFactory
    extends GuardedSignatureOperatorFactory<DSAParameters> {
        public DSAOperatorFactory() {
            EC.checkEnabled();
        }

        @Override
        protected OutputSigner<DSAParameters> doCreateSigner(AsymmetricPrivateKey asymmetricPrivateKey, DSAParameters dSAParameters) {
            AsymmetricECPrivateKey asymmetricECPrivateKey = (AsymmetricECPrivateKey)asymmetricPrivateKey;
            Digest digest = dSAParameters.digestAlgorithm != null ? Register.createDigest(dSAParameters.digestAlgorithm) : new NullDigest();
            EcDsaSigner ecDsaSigner = dSAParameters.getAlgorithm() == DSA.getDigestAlgorithm() ? new EcDsaSigner(new RandomDsaKCalculator()) : new EcDsaSigner(new HMacDsaKCalculator(Register.createDigest(dSAParameters.digestAlgorithm)));
            final EcPrivateKeyParameters ecPrivateKeyParameters = EC.getLwKey(asymmetricECPrivateKey);
            return new DSAOutputSigner<DSAParameters>(ecDsaSigner, digest, dSAParameters, new DSAOutputSigner.Initializer(){

                public void initialize(DSA dSA, SecureRandom secureRandom) {
                    dSA.init(true, new ParametersWithRandom(ecPrivateKeyParameters, secureRandom));
                }
            });
        }

        @Override
        protected OutputVerifier<DSAParameters> doCreateVerifier(AsymmetricPublicKey asymmetricPublicKey, DSAParameters dSAParameters) {
            EcDsaSigner ecDsaSigner = new EcDsaSigner();
            Digest digest = dSAParameters.digestAlgorithm != null ? Register.createDigest(dSAParameters.digestAlgorithm) : new NullDigest();
            AsymmetricECPublicKey asymmetricECPublicKey = (AsymmetricECPublicKey)asymmetricPublicKey;
            EcPublicKeyParameters ecPublicKeyParameters = new EcPublicKeyParameters(asymmetricECPublicKey.getW(), EC.getDomainParams(asymmetricECPublicKey.getDomainParameters()));
            ecDsaSigner.init(false, ecPublicKeyParameters);
            return new DSAOutputVerifier<DSAParameters>(ecDsaSigner, digest, dSAParameters);
        }
    }

    public static final class DSAParameters
    extends GeneralParameters {
        private final DigestAlgorithm digestAlgorithm;

        DSAParameters(GeneralAlgorithm generalAlgorithm, DigestAlgorithm digestAlgorithm) {
            super(generalAlgorithm);
            if (generalAlgorithm.basicVariation() == Variations.ECDDSA && digestAlgorithm == null) {
                throw new IllegalArgumentException("ECDDSA cannot be used with a NULL digest");
            }
            this.digestAlgorithm = digestAlgorithm;
        }

        public DigestAlgorithm getDigestAlgorithm() {
            return this.digestAlgorithm;
        }

        public DSAParameters withDigestAlgorithm(DigestAlgorithm digestAlgorithm) {
            return new DSAParameters((GeneralAlgorithm)this.getAlgorithm(), digestAlgorithm);
        }
    }

    public static final class KeyGenParameters
    extends GeneralParameters {
        private final ECDomainParameters domainParameters;

        public KeyGenParameters(ECDomainParameters eCDomainParameters) {
            this(ALGORITHM, eCDomainParameters);
        }

        public KeyGenParameters(DSAParameters dSAParameters, ECDomainParameters eCDomainParameters) {
            this((Algorithm)dSAParameters.getAlgorithm(), eCDomainParameters);
        }

        private KeyGenParameters(Algorithm algorithm, ECDomainParameters eCDomainParameters) {
            super(algorithm);
            this.domainParameters = eCDomainParameters;
        }

        public ECDomainParameters getDomainParameters() {
            return this.domainParameters;
        }
    }

    public static final class KeyPairGenerator
    extends GuardedAsymmetricKeyPairGenerator {
        private final FipsEC.KeyPairGenerator kpGen;

        public KeyPairGenerator(KeyGenParameters keyGenParameters, SecureRandom secureRandom) {
            super(keyGenParameters);
            EC.checkEnabled();
            this.kpGen = new FipsEC.KeyPairGenerator(new FipsEC.KeyGenParameters(keyGenParameters.domainParameters), secureRandom);
        }

        protected AsymmetricKeyPair doGenerateKeyPair() {
            AsymmetricKeyPair<AsymmetricECPublicKey, AsymmetricECPrivateKey> asymmetricKeyPair = this.kpGen.generateKeyPair();
            final Algorithm algorithm = this.getParameters().getAlgorithm();
            final AsymmetricECPublicKey asymmetricECPublicKey = asymmetricKeyPair.getPublicKey();
            final AsymmetricECPrivateKey asymmetricECPrivateKey = asymmetricKeyPair.getPrivateKey();
            return AccessController.doPrivileged(new PrivilegedAction<AsymmetricKeyPair>(){

                @Override
                public AsymmetricKeyPair run() {
                    return new AsymmetricKeyPair<AsymmetricECPublicKey, AsymmetricECPrivateKey>(new AsymmetricECPublicKey(algorithm, asymmetricECPublicKey.getDomainParameters(), asymmetricECPublicKey.getW()), new AsymmetricECPrivateKey(algorithm, asymmetricECPrivateKey.getDomainParameters(), asymmetricECPrivateKey.getS(), asymmetricECPublicKey.getW()));
                }
            });
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Variations {
        ECDSA,
        ECDDSA;

    }
}

