/*
 * Decompiled with CFR 0.152.
 */
package org.jose4j.mac;

import java.security.Key;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import org.jose4j.lang.InvalidKeyException;
import org.jose4j.lang.UncheckedJoseException;

public class MacUtil {
    public static final String HMAC_SHA256 = "HmacSHA256";
    public static final String HMAC_SHA384 = "HmacSHA384";
    public static final String HMAC_SHA512 = "HmacSHA512";

    public static Mac getInitializedMac(String algorithm, Key key) throws InvalidKeyException {
        Mac mac = MacUtil.getMac(algorithm);
        MacUtil.initMacWithKey(mac, key);
        return mac;
    }

    public static Mac getMac(String algorithm) {
        try {
            return Mac.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new UncheckedJoseException("Unable to get a MAC implementation of algorithm name: " + algorithm, e);
        }
    }

    public static void initMacWithKey(Mac mac, Key key) throws InvalidKeyException {
        try {
            mac.init(key);
        }
        catch (java.security.InvalidKeyException e) {
            throw new InvalidKeyException("Key is not valid for " + mac.getAlgorithm(), e);
        }
    }
}

