/*
 * Decompiled with CFR 0.152.
 */
package org.jose4j.jwt.consumer;

import org.jose4j.jwt.MalformedClaimException;
import org.jose4j.jwt.consumer.JwtContext;
import org.jose4j.jwt.consumer.Validator;

public class IssValidator
implements Validator {
    private String expectedIssuer;
    private boolean requireIssuer;

    public IssValidator(String expectedIssuer, boolean requireIssuer) {
        this.expectedIssuer = expectedIssuer;
        this.requireIssuer = requireIssuer;
    }

    @Override
    public String validate(JwtContext jwtContext) throws MalformedClaimException {
        String issuer = jwtContext.getJwtClaims().getIssuer();
        if (issuer == null) {
            return this.requireIssuer ? "No Issuer (iss) claim present but was expecting " + this.expectedIssuer : null;
        }
        if (this.expectedIssuer != null && !issuer.equals(this.expectedIssuer)) {
            return "Issuer (iss) claim value (" + issuer + ") doesn't match expected value of " + this.expectedIssuer;
        }
        return null;
    }
}

