/*
 * Decompiled with CFR 0.152.
 */
package org.jose4j.jwe;

import java.security.NoSuchAlgorithmException;
import javax.crypto.Cipher;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jose4j.lang.ByteUtil;

public class CipherStrengthSupport {
    private static Log log = LogFactory.getLog(CipherStrengthSupport.class);

    public static boolean isAvailable(String algorithm, int keyByteLength) {
        boolean isAvailable;
        int bitKeyLength = ByteUtil.bitLength(keyByteLength);
        try {
            int maxAllowedKeyLength = Cipher.getMaxAllowedKeyLength(algorithm);
            boolean bl = isAvailable = bitKeyLength <= maxAllowedKeyLength;
            if (!isAvailable) {
                log.debug((Object)("max allowed key length for " + algorithm + " is " + maxAllowedKeyLength));
            }
        }
        catch (NoSuchAlgorithmException e) {
            log.debug((Object)("Unknown/unsupported algorithm," + algorithm + " " + e));
            isAvailable = false;
        }
        return isAvailable;
    }
}

