/*
 * Decompiled with CFR 0.152.
 */
package bsh;

import bsh.BSHAmbiguousName;
import bsh.CallStack;
import bsh.EvalError;
import bsh.Interpreter;
import bsh.NameSpace;
import bsh.Primitive;
import bsh.SimpleNode;
import bsh.UtilEvalError;

class BSHImportDeclaration
extends SimpleNode {
    public boolean importPackage;
    public boolean staticImport;
    public boolean superImport;

    BSHImportDeclaration(int n) {
        super(n);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object eval(CallStack callStack, Interpreter interpreter) throws EvalError {
        NameSpace nameSpace = callStack.top();
        if (this.superImport) {
            try {
                nameSpace.doSuperImport();
                return Primitive.VOID;
            }
            catch (UtilEvalError utilEvalError) {
                throw utilEvalError.toEvalError(this, callStack);
            }
        } else if (this.staticImport) {
            if (!this.importPackage) throw new EvalError("static field imports not supported yet", this, callStack);
            Class clazz = ((BSHAmbiguousName)this.jjtGetChild(0)).toClass(callStack, interpreter);
            nameSpace.importStatic(clazz);
            return Primitive.VOID;
        } else {
            String string = ((BSHAmbiguousName)this.jjtGetChild((int)0)).text;
            if (this.importPackage) {
                nameSpace.importPackage(string);
                return Primitive.VOID;
            } else {
                nameSpace.importClass(string);
            }
        }
        return Primitive.VOID;
    }
}

