/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render;

import java.awt.Color;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.List;
import java.util.Map;
import org.apache.batik.parser.AWTTransformProducer;
import org.apache.fop.area.Area;
import org.apache.fop.area.Block;
import org.apache.fop.area.BlockViewport;
import org.apache.fop.area.CTM;
import org.apache.fop.area.NormalFlow;
import org.apache.fop.area.RegionViewport;
import org.apache.fop.area.Trait;
import org.apache.fop.area.inline.ForeignObject;
import org.apache.fop.area.inline.InlineArea;
import org.apache.fop.area.inline.Viewport;
import org.apache.fop.fonts.FontMetrics;
import org.apache.fop.render.PrintRenderer;
import org.apache.fop.traits.BorderProps;
import org.apache.fop.util.QName;
import org.apache.xmlgraphics.image.loader.ImageSize;
import org.w3c.dom.Document;

public abstract class AbstractPathOrientedRenderer
extends PrintRenderer {
    private static final QName FOX_TRANSFORM = new QName("http://xmlgraphics.apache.org/fop/extensions", "fox:transform");

    protected void handleBlockTraits(Block block) {
        int borderPaddingStart = block.getBorderAndPaddingWidthStart();
        int borderPaddingBefore = block.getBorderAndPaddingWidthBefore();
        float startx = (float)this.currentIPPosition / 1000.0f;
        float starty = (float)this.currentBPPosition / 1000.0f;
        float width = (float)block.getIPD() / 1000.0f;
        float height = (float)block.getBPD() / 1000.0f;
        startx += (float)block.getStartIndent() / 1000.0f;
        width += (float)borderPaddingStart / 1000.0f;
        height += (float)borderPaddingBefore / 1000.0f;
        this.drawBackAndBorders(block, startx -= (float)block.getBorderAndPaddingWidthStart() / 1000.0f, starty, width += (float)block.getBorderAndPaddingWidthEnd() / 1000.0f, height += (float)block.getBorderAndPaddingWidthAfter() / 1000.0f);
    }

    protected void handleRegionTraits(RegionViewport region) {
        Rectangle2D viewArea = region.getViewArea();
        float startx = (float)(viewArea.getX() / 1000.0);
        float starty = (float)(viewArea.getY() / 1000.0);
        float width = (float)(viewArea.getWidth() / 1000.0);
        float height = (float)(viewArea.getHeight() / 1000.0);
        if (region.getRegionReference().getRegionClass() == 36) {
            this.currentBPPosition = region.getBorderAndPaddingWidthBefore();
            this.currentIPPosition = region.getBorderAndPaddingWidthStart();
        }
        this.drawBackAndBorders(region, startx, starty, width, height);
    }

    protected void drawBackAndBorders(Area area, float startx, float starty, float width, float height) {
        BorderProps bpsBefore = (BorderProps)area.getTrait(Trait.BORDER_BEFORE);
        BorderProps bpsAfter = (BorderProps)area.getTrait(Trait.BORDER_AFTER);
        BorderProps bpsStart = (BorderProps)area.getTrait(Trait.BORDER_START);
        BorderProps bpsEnd = (BorderProps)area.getTrait(Trait.BORDER_END);
        Trait.Background back = (Trait.Background)area.getTrait(Trait.BACKGROUND);
        if (back != null) {
            this.endTextObject();
            float sx = startx;
            float sy = starty;
            float paddRectWidth = width;
            float paddRectHeight = height;
            if (bpsStart != null) {
                sx += (float)bpsStart.width / 1000.0f;
                paddRectWidth -= (float)bpsStart.width / 1000.0f;
            }
            if (bpsBefore != null) {
                sy += (float)bpsBefore.width / 1000.0f;
                paddRectHeight -= (float)bpsBefore.width / 1000.0f;
            }
            if (bpsEnd != null) {
                paddRectWidth -= (float)bpsEnd.width / 1000.0f;
            }
            if (bpsAfter != null) {
                paddRectHeight -= (float)bpsAfter.width / 1000.0f;
            }
            if (back.getColor() != null) {
                this.updateColor(back.getColor(), true);
                this.fillRect(sx, sy, paddRectWidth, paddRectHeight);
            }
            if (back.getImageInfo() != null) {
                ImageSize imageSize = back.getImageInfo().getSize();
                this.saveGraphicsState();
                this.clipRect(sx, sy, paddRectWidth, paddRectHeight);
                int horzCount = (int)(paddRectWidth * 1000.0f / (float)imageSize.getWidthMpt() + 1.0f);
                int vertCount = (int)(paddRectHeight * 1000.0f / (float)imageSize.getHeightMpt() + 1.0f);
                if (back.getRepeat() == 96) {
                    horzCount = 1;
                    vertCount = 1;
                } else if (back.getRepeat() == 113) {
                    vertCount = 1;
                } else if (back.getRepeat() == 114) {
                    horzCount = 1;
                }
                sx *= 1000.0f;
                sy *= 1000.0f;
                if (horzCount == 1) {
                    sx += (float)back.getHoriz();
                }
                if (vertCount == 1) {
                    sy += (float)back.getVertical();
                }
                for (int x = 0; x < horzCount; ++x) {
                    for (int y = 0; y < vertCount; ++y) {
                        Rectangle2D.Float pos = new Rectangle2D.Float(sx - (float)this.currentIPPosition + (float)(x * imageSize.getWidthMpt()), sy - (float)this.currentBPPosition + (float)(y * imageSize.getHeightMpt()), imageSize.getWidthMpt(), imageSize.getHeightMpt());
                        this.drawImage(back.getURL(), pos);
                    }
                }
                this.restoreGraphicsState();
            }
        }
        Rectangle2D.Float borderRect = new Rectangle2D.Float(startx, starty, width, height);
        this.drawBorders(borderRect, bpsBefore, bpsAfter, bpsStart, bpsEnd);
    }

    protected void drawBorders(Rectangle2D.Float borderRect, BorderProps bpsBefore, BorderProps bpsAfter, BorderProps bpsStart, BorderProps bpsEnd) {
        float ey1a;
        float sy1a;
        float innerx;
        float clipx;
        float outerx;
        float ey2;
        float ey1;
        float sy2;
        float sy1;
        float ex1a;
        float sx1a;
        float innery;
        float clipy;
        float outery;
        float ex2;
        float ex1;
        float sx2;
        float sx1;
        float startx = borderRect.x;
        float starty = borderRect.y;
        float width = borderRect.width;
        float height = borderRect.height;
        boolean[] b = new boolean[]{bpsBefore != null, bpsEnd != null, bpsAfter != null, bpsStart != null};
        if (!(b[0] || b[1] || b[2] || b[3])) {
            return;
        }
        float[] bw = new float[]{b[0] ? (float)bpsBefore.width / 1000.0f : 0.0f, b[1] ? (float)bpsEnd.width / 1000.0f : 0.0f, b[2] ? (float)bpsAfter.width / 1000.0f : 0.0f, b[3] ? (float)bpsStart.width / 1000.0f : 0.0f};
        float[] clipw = new float[]{(float)BorderProps.getClippedWidth(bpsBefore) / 1000.0f, (float)BorderProps.getClippedWidth(bpsEnd) / 1000.0f, (float)BorderProps.getClippedWidth(bpsAfter) / 1000.0f, (float)BorderProps.getClippedWidth(bpsStart) / 1000.0f};
        starty += clipw[0];
        height -= clipw[0];
        height -= clipw[2];
        startx += clipw[3];
        width -= clipw[3];
        width -= clipw[1];
        boolean[] slant = new boolean[]{b[3] && b[0], b[0] && b[1], b[1] && b[2], b[2] && b[3]};
        if (bpsBefore != null) {
            this.endTextObject();
            sx1 = startx;
            sx2 = slant[0] ? sx1 + bw[3] - clipw[3] : sx1;
            ex1 = startx + width;
            ex2 = slant[1] ? ex1 - bw[1] + clipw[1] : ex1;
            outery = starty - clipw[0];
            clipy = outery + clipw[0];
            innery = outery + bw[0];
            this.saveGraphicsState();
            this.moveTo(sx1, clipy);
            sx1a = sx1;
            ex1a = ex1;
            if (bpsBefore.mode == 2) {
                if (bpsStart != null && bpsStart.mode == 2) {
                    sx1a -= clipw[3];
                }
                if (bpsEnd != null && bpsEnd.mode == 2) {
                    ex1a += clipw[1];
                }
                this.lineTo(sx1a, outery);
                this.lineTo(ex1a, outery);
            }
            this.lineTo(ex1, clipy);
            this.lineTo(ex2, innery);
            this.lineTo(sx2, innery);
            this.closePath();
            this.clip();
            this.drawBorderLine(sx1a, outery, ex1a, innery, true, true, bpsBefore.style, bpsBefore.color);
            this.restoreGraphicsState();
        }
        if (bpsEnd != null) {
            this.endTextObject();
            sy1 = starty;
            sy2 = slant[1] ? sy1 + bw[0] - clipw[0] : sy1;
            ey1 = starty + height;
            ey2 = slant[2] ? ey1 - bw[2] + clipw[2] : ey1;
            outerx = startx + width + clipw[1];
            clipx = outerx - clipw[1];
            innerx = outerx - bw[1];
            this.saveGraphicsState();
            this.moveTo(clipx, sy1);
            sy1a = sy1;
            ey1a = ey1;
            if (bpsEnd.mode == 2) {
                if (bpsBefore != null && bpsBefore.mode == 2) {
                    sy1a -= clipw[0];
                }
                if (bpsAfter != null && bpsAfter.mode == 2) {
                    ey1a += clipw[2];
                }
                this.lineTo(outerx, sy1a);
                this.lineTo(outerx, ey1a);
            }
            this.lineTo(clipx, ey1);
            this.lineTo(innerx, ey2);
            this.lineTo(innerx, sy2);
            this.closePath();
            this.clip();
            this.drawBorderLine(innerx, sy1a, outerx, ey1a, false, false, bpsEnd.style, bpsEnd.color);
            this.restoreGraphicsState();
        }
        if (bpsAfter != null) {
            this.endTextObject();
            sx1 = startx;
            sx2 = slant[3] ? sx1 + bw[3] - clipw[3] : sx1;
            ex1 = startx + width;
            ex2 = slant[2] ? ex1 - bw[1] + clipw[1] : ex1;
            outery = starty + height + clipw[2];
            clipy = outery - clipw[2];
            innery = outery - bw[2];
            this.saveGraphicsState();
            this.moveTo(ex1, clipy);
            sx1a = sx1;
            ex1a = ex1;
            if (bpsAfter.mode == 2) {
                if (bpsStart != null && bpsStart.mode == 2) {
                    sx1a -= clipw[3];
                }
                if (bpsEnd != null && bpsEnd.mode == 2) {
                    ex1a += clipw[1];
                }
                this.lineTo(ex1a, outery);
                this.lineTo(sx1a, outery);
            }
            this.lineTo(sx1, clipy);
            this.lineTo(sx2, innery);
            this.lineTo(ex2, innery);
            this.closePath();
            this.clip();
            this.drawBorderLine(sx1a, innery, ex1a, outery, true, false, bpsAfter.style, bpsAfter.color);
            this.restoreGraphicsState();
        }
        if (bpsStart != null) {
            this.endTextObject();
            sy1 = starty;
            sy2 = slant[0] ? sy1 + bw[0] - clipw[0] : sy1;
            ey1 = sy1 + height;
            ey2 = slant[3] ? ey1 - bw[2] + clipw[2] : ey1;
            outerx = startx - clipw[3];
            clipx = outerx + clipw[3];
            innerx = outerx + bw[3];
            this.saveGraphicsState();
            this.moveTo(clipx, ey1);
            sy1a = sy1;
            ey1a = ey1;
            if (bpsStart.mode == 2) {
                if (bpsBefore != null && bpsBefore.mode == 2) {
                    sy1a -= clipw[0];
                }
                if (bpsAfter != null && bpsAfter.mode == 2) {
                    ey1a += clipw[2];
                }
                this.lineTo(outerx, ey1a);
                this.lineTo(outerx, sy1a);
            }
            this.lineTo(clipx, sy1);
            this.lineTo(innerx, sy2);
            this.lineTo(innerx, ey2);
            this.closePath();
            this.clip();
            this.drawBorderLine(outerx, sy1a, innerx, ey1a, false, true, bpsStart.style, bpsStart.color);
            this.restoreGraphicsState();
        }
    }

    protected void renderInlineAreaBackAndBorders(InlineArea area) {
        float x = (float)this.currentIPPosition / 1000.0f;
        float y = (float)(this.currentBPPosition + area.getOffset()) / 1000.0f;
        float width = (float)area.getIPD() / 1000.0f;
        float height = (float)area.getBPD() / 1000.0f;
        float borderPaddingStart = (float)area.getBorderAndPaddingWidthStart() / 1000.0f;
        float borderPaddingBefore = (float)area.getBorderAndPaddingWidthBefore() / 1000.0f;
        float bpwidth = borderPaddingStart + (float)area.getBorderAndPaddingWidthEnd() / 1000.0f;
        float bpheight = borderPaddingBefore + (float)area.getBorderAndPaddingWidthAfter() / 1000.0f;
        if (height != 0.0f || bpheight != 0.0f && bpwidth != 0.0f) {
            this.drawBackAndBorders(area, x, y - borderPaddingBefore, width + bpwidth, height + bpheight);
        }
    }

    protected void renderBlockViewport(BlockViewport bv, List children) {
        int saveIP = this.currentIPPosition;
        int saveBP = this.currentBPPosition;
        CTM ctm = bv.getCTM();
        int borderPaddingStart = bv.getBorderAndPaddingWidthStart();
        int borderPaddingBefore = bv.getBorderAndPaddingWidthBefore();
        float width = (float)bv.getIPD() / 1000.0f;
        float height = (float)bv.getBPD() / 1000.0f;
        if (bv.getPositioning() == 2 || bv.getPositioning() == 3) {
            List breakOutList = null;
            if (bv.getPositioning() == 3) {
                breakOutList = this.breakOutOfStateStack();
            }
            AffineTransform positionTransform = new AffineTransform();
            positionTransform.translate(bv.getXOffset(), bv.getYOffset());
            positionTransform.translate(-borderPaddingStart, -borderPaddingBefore);
            String transf = bv.getForeignAttributeValue(FOX_TRANSFORM);
            if (transf != null) {
                AffineTransform freeTransform = AWTTransformProducer.createAffineTransform((String)transf);
                positionTransform.concatenate(freeTransform);
            }
            this.saveGraphicsState();
            this.concatenateTransformationMatrix(this.mptToPt(positionTransform));
            float bpwidth = (float)(borderPaddingStart + bv.getBorderAndPaddingWidthEnd()) / 1000.0f;
            float bpheight = (float)(borderPaddingBefore + bv.getBorderAndPaddingWidthAfter()) / 1000.0f;
            this.drawBackAndBorders(bv, 0.0f, 0.0f, width + bpwidth, height + bpheight);
            AffineTransform contentRectTransform = new AffineTransform();
            contentRectTransform.translate(borderPaddingStart, borderPaddingBefore);
            this.concatenateTransformationMatrix(this.mptToPt(contentRectTransform));
            if (bv.getClip()) {
                this.clipRect(0.0f, 0.0f, width, height);
            }
            this.saveGraphicsState();
            AffineTransform contentTransform = ctm.toAffineTransform();
            this.concatenateTransformationMatrix(this.mptToPt(contentTransform));
            this.currentIPPosition = 0;
            this.currentBPPosition = 0;
            this.renderBlocks(bv, children);
            this.restoreGraphicsState();
            this.restoreGraphicsState();
            if (breakOutList != null) {
                this.restoreStateStackAfterBreakOut(breakOutList);
            }
            this.currentIPPosition = saveIP;
            this.currentBPPosition = saveBP;
        } else {
            this.currentBPPosition += bv.getSpaceBefore();
            this.handleBlockTraits(bv);
            this.currentIPPosition += bv.getStartIndent();
            CTM tempctm = new CTM(this.containingIPPosition, this.currentBPPosition);
            ctm = tempctm.multiply(ctm);
            this.currentBPPosition += borderPaddingBefore;
            Rectangle clippingRect = null;
            if (bv.getClip()) {
                clippingRect = new Rectangle(this.currentIPPosition, this.currentBPPosition, bv.getIPD(), bv.getBPD());
            }
            this.startVParea(ctm, clippingRect);
            this.currentIPPosition = 0;
            this.currentBPPosition = 0;
            this.renderBlocks(bv, children);
            this.endVParea();
            this.currentIPPosition = saveIP;
            this.currentBPPosition = saveBP;
            this.currentBPPosition += bv.getAllocBPD();
        }
    }

    protected void renderReferenceArea(Block block) {
        int saveIP = this.currentIPPosition;
        int saveBP = this.currentBPPosition;
        AffineTransform at = new AffineTransform();
        at.translate(this.currentIPPosition, this.currentBPPosition);
        at.translate(block.getXOffset(), block.getYOffset());
        at.translate(0.0, block.getSpaceBefore());
        if (!at.isIdentity()) {
            this.saveGraphicsState();
            this.concatenateTransformationMatrix(this.mptToPt(at));
        }
        this.currentIPPosition = 0;
        this.currentBPPosition = 0;
        this.handleBlockTraits(block);
        List children = block.getChildAreas();
        if (children != null) {
            this.renderBlocks(block, children);
        }
        if (!at.isIdentity()) {
            this.restoreGraphicsState();
        }
        this.currentIPPosition = saveIP;
        this.currentBPPosition = saveBP;
    }

    protected void renderFlow(NormalFlow flow) {
        int saveIP = this.currentIPPosition;
        int saveBP = this.currentBPPosition;
        AffineTransform at = new AffineTransform();
        at.translate(this.currentIPPosition, this.currentBPPosition);
        if (!at.isIdentity()) {
            this.saveGraphicsState();
            this.concatenateTransformationMatrix(this.mptToPt(at));
        }
        this.currentIPPosition = 0;
        this.currentBPPosition = 0;
        super.renderFlow(flow);
        if (!at.isIdentity()) {
            this.restoreGraphicsState();
        }
        this.currentIPPosition = saveIP;
        this.currentBPPosition = saveBP;
    }

    protected abstract void concatenateTransformationMatrix(AffineTransform var1);

    public void renderViewport(Viewport viewport) {
        float x = (float)this.currentIPPosition / 1000.0f;
        float y = (float)(this.currentBPPosition + viewport.getOffset()) / 1000.0f;
        float width = (float)viewport.getIPD() / 1000.0f;
        float height = (float)viewport.getBPD() / 1000.0f;
        float borderPaddingStart = (float)viewport.getBorderAndPaddingWidthStart() / 1000.0f;
        float borderPaddingBefore = (float)viewport.getBorderAndPaddingWidthBefore() / 1000.0f;
        float bpwidth = borderPaddingStart + (float)viewport.getBorderAndPaddingWidthEnd() / 1000.0f;
        float bpheight = borderPaddingBefore + (float)viewport.getBorderAndPaddingWidthAfter() / 1000.0f;
        this.drawBackAndBorders(viewport, x, y, width + bpwidth, height + bpheight);
        if (viewport.getClip()) {
            this.saveGraphicsState();
            this.clipRect(x + borderPaddingStart, y + borderPaddingBefore, width, height);
        }
        super.renderViewport(viewport);
        if (viewport.getClip()) {
            this.restoreGraphicsState();
        }
    }

    protected abstract void restoreStateStackAfterBreakOut(List var1);

    protected abstract List breakOutOfStateStack();

    protected abstract void saveGraphicsState();

    protected abstract void restoreGraphicsState();

    protected abstract void beginTextObject();

    protected abstract void endTextObject();

    protected void renderTextDecoration(FontMetrics fm, int fontsize, InlineArea inline, int baseline, int startx) {
        boolean hasTextDeco;
        boolean bl = hasTextDeco = inline.hasUnderline() || inline.hasOverline() || inline.hasLineThrough();
        if (hasTextDeco) {
            float y;
            Color ct;
            this.endTextObject();
            float descender = (float)fm.getDescender(fontsize) / 1000.0f;
            float capHeight = (float)fm.getCapHeight(fontsize) / 1000.0f;
            float halfLineWidth = descender / -8.0f / 2.0f;
            float endx = (float)(startx + inline.getIPD()) / 1000.0f;
            if (inline.hasUnderline()) {
                ct = (Color)inline.getTrait(Trait.UNDERLINE_COLOR);
                y = (float)baseline - descender / 2.0f;
                this.drawBorderLine((float)startx / 1000.0f, (y - halfLineWidth) / 1000.0f, endx, (y + halfLineWidth) / 1000.0f, true, true, 133, ct);
            }
            if (inline.hasOverline()) {
                ct = (Color)inline.getTrait(Trait.OVERLINE_COLOR);
                y = (float)((double)baseline - 1.1 * (double)capHeight);
                this.drawBorderLine((float)startx / 1000.0f, (y - halfLineWidth) / 1000.0f, endx, (y + halfLineWidth) / 1000.0f, true, true, 133, ct);
            }
            if (inline.hasLineThrough()) {
                ct = (Color)inline.getTrait(Trait.LINETHROUGH_COLOR);
                y = (float)((double)baseline - 0.45 * (double)capHeight);
                this.drawBorderLine((float)startx / 1000.0f, (y - halfLineWidth) / 1000.0f, endx, (y + halfLineWidth) / 1000.0f, true, true, 133, ct);
            }
        }
    }

    protected abstract void clip();

    protected abstract void clipRect(float var1, float var2, float var3, float var4);

    protected abstract void moveTo(float var1, float var2);

    protected abstract void lineTo(float var1, float var2);

    protected abstract void closePath();

    protected abstract void fillRect(float var1, float var2, float var3, float var4);

    protected abstract void updateColor(Color var1, boolean var2);

    protected abstract void drawImage(String var1, Rectangle2D var2, Map var3);

    protected final void drawImage(String url, Rectangle2D pos) {
        this.drawImage(url, pos, null);
    }

    protected abstract void drawBorderLine(float var1, float var2, float var3, float var4, boolean var5, boolean var6, int var7, Color var8);

    public void renderForeignObject(ForeignObject fo, Rectangle2D pos) {
        this.endTextObject();
        Document doc = fo.getDocument();
        String ns = fo.getNameSpace();
        this.renderDocument(doc, ns, pos, fo.getForeignAttributes());
    }
}

