/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fonts;

import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.fonts.CodePointMapping;
import org.apache.fop.fonts.CustomFont;
import org.apache.xmlgraphics.fonts.Glyphs;

public class SingleByteFont
extends CustomFont {
    private static Log log = LogFactory.getLog((Class)SingleByteFont.class);
    private CodePointMapping mapping;
    private int[] width = null;
    private Set warnedChars;

    public SingleByteFont() {
        this.setEncoding("WinAnsiEncoding");
    }

    public boolean isEmbeddable() {
        return this.getEmbedFileName() != null || this.getEmbedResourceName() != null;
    }

    public String getEncoding() {
        return this.mapping.getName();
    }

    public CodePointMapping getCodePointMapping() {
        return this.mapping;
    }

    public int getWidth(int i, int size) {
        int idx = i - this.getFirstChar();
        if (idx >= 0 && idx < this.width.length) {
            return size * this.width[i - this.getFirstChar()];
        }
        return 0;
    }

    public int[] getWidths() {
        int[] arr = new int[this.width.length];
        System.arraycopy(this.width, 0, arr, 0, this.width.length - 1);
        return arr;
    }

    public char mapChar(char c) {
        this.notifyMapOperation();
        char d = this.mapping.mapChar(c);
        if (d != '\u0000') {
            return d;
        }
        Character ch = new Character(c);
        if (this.warnedChars == null) {
            this.warnedChars = new HashSet();
        }
        if (this.warnedChars.size() < 8 && !this.warnedChars.contains(ch)) {
            this.warnedChars.add(ch);
            if (this.warnedChars.size() == 8) {
                log.warn((Object)("Many requested glyphs are not available in font " + this.getFontName()));
            } else {
                log.warn((Object)("Glyph " + c + " (0x" + Integer.toHexString(c) + ", " + Glyphs.charToGlyphName((char)c) + ") not available in font " + this.getFontName()));
            }
        }
        return '#';
    }

    public boolean hasChar(char c) {
        return this.mapping.mapChar(c) > '\u0000';
    }

    protected void updateMapping(String encoding) {
        try {
            this.mapping = CodePointMapping.getMapping(encoding);
        }
        catch (UnsupportedOperationException e) {
            log.error((Object)("Font '" + super.getFontName() + "': " + e.getMessage()));
        }
    }

    public void setEncoding(String encoding) {
        this.updateMapping(encoding);
    }

    public void setEncoding(CodePointMapping encoding) {
        this.mapping = encoding;
    }

    public void setWidth(int index, int width) {
        if (this.width == null) {
            this.width = new int[this.getLastChar() - this.getFirstChar() + 1];
        }
        this.width[index - this.getFirstChar()] = width;
    }
}

