/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.apache.fop.fo.CharIterator;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.FObjMixed;
import org.apache.fop.fo.RecursiveCharIterator;
import org.apache.fop.fo.flow.Block;
import org.apache.fop.util.CharUtilities;

public class XMLWhiteSpaceHandler {
    private boolean inWhiteSpace = false;
    private boolean afterLinefeed = true;
    private int nonWhiteSpaceCount;
    private int linefeedTreatment;
    private int whiteSpaceTreatment;
    private int whiteSpaceCollapse;
    private boolean endOfBlock;
    private boolean nextChildIsBlockLevel;
    private RecursiveCharIterator charIter;
    private List pendingInlines;
    private Stack nestedBlockStack = new Stack();
    private CharIterator firstWhiteSpaceInSeq;

    public void handleWhiteSpace(FObjMixed fo, FONode firstTextNode, FONode nextChild) {
        int nextChildId;
        Block currentBlock = null;
        int foId = fo.getNameId();
        if (foId == 3) {
            currentBlock = (Block)fo;
            if (this.nestedBlockStack.isEmpty() || fo != this.nestedBlockStack.peek()) {
                if (nextChild != null) {
                    this.nestedBlockStack.push(currentBlock);
                }
            } else if (nextChild == null) {
                this.nestedBlockStack.pop();
            }
        } else if (foId == 41) {
            FONode ancestor = fo;
            while ((ancestor = ancestor.getParent()).getNameId() != 3 && ancestor.getNameId() != 45) {
            }
            if (ancestor.getNameId() == 3) {
                currentBlock = (Block)ancestor;
            }
        } else if (!this.nestedBlockStack.isEmpty()) {
            currentBlock = (Block)this.nestedBlockStack.peek();
        }
        if (currentBlock != null) {
            this.linefeedTreatment = currentBlock.getLinefeedTreatment();
            this.whiteSpaceCollapse = currentBlock.getWhitespaceCollapse();
            this.whiteSpaceTreatment = currentBlock.getWhitespaceTreatment();
        } else {
            this.linefeedTreatment = 147;
            this.whiteSpaceCollapse = 149;
            this.whiteSpaceTreatment = 63;
        }
        if (firstTextNode == null) {
            return;
        }
        this.charIter = new RecursiveCharIterator(fo, firstTextNode);
        this.inWhiteSpace = false;
        if (fo == currentBlock || currentBlock == null || foId == 41 && fo.getParent() == currentBlock) {
            this.afterLinefeed = firstTextNode == fo.firstChild || firstTextNode.siblings[0].getNameId() == 3;
        }
        boolean bl = this.endOfBlock = nextChild == null && fo == currentBlock;
        this.nextChildIsBlockLevel = nextChild != null ? (nextChildId = nextChild.getNameId()) == 3 || nextChildId == 47 || nextChildId == 46 || nextChildId == 20 || nextChildId == 4 : false;
        this.handleWhiteSpace();
        if (fo == currentBlock && this.pendingInlines != null && !this.pendingInlines.isEmpty() && (this.endOfBlock || this.nextChildIsBlockLevel)) {
            if (this.nonWhiteSpaceCount == 0) {
                int i = this.pendingInlines.size();
                while (--i >= 0) {
                    PendingInline p = (PendingInline)this.pendingInlines.get(i);
                    this.charIter = (RecursiveCharIterator)p.firstTrailingWhiteSpace;
                    this.handleWhiteSpace();
                    this.pendingInlines.remove(p);
                }
            } else {
                this.pendingInlines.clear();
            }
        }
        if (nextChild == null) {
            if (fo != currentBlock) {
                if (this.nonWhiteSpaceCount > 0 && this.pendingInlines != null) {
                    this.pendingInlines.clear();
                }
                if (this.inWhiteSpace) {
                    this.addPendingInline(fo);
                }
            } else {
                currentBlock = !this.nestedBlockStack.empty() ? (Block)this.nestedBlockStack.pop() : null;
                this.charIter = null;
            }
        }
    }

    public void handleWhiteSpace(FObjMixed fo, FONode firstTextNode) {
        this.handleWhiteSpace(fo, firstTextNode, null);
    }

    private void handleWhiteSpace() {
        EOLchecker lfCheck = new EOLchecker(this.charIter);
        this.nonWhiteSpaceCount = 0;
        block16: while (this.charIter.hasNext()) {
            char currentChar;
            int currentCharClass;
            if (!this.inWhiteSpace) {
                this.firstWhiteSpaceInSeq = this.charIter.mark();
            }
            if ((currentCharClass = CharUtilities.classOf(currentChar = this.charIter.nextChar())) == 1 && this.linefeedTreatment == 147) {
                currentChar = ' ';
                this.charIter.replaceChar(' ');
                currentCharClass = CharUtilities.classOf(currentChar);
            }
            block0 : switch (CharUtilities.classOf(currentChar)) {
                case 4: {
                    if (this.inWhiteSpace && this.whiteSpaceCollapse == 149) {
                        this.charIter.remove();
                        break;
                    }
                    boolean bIgnore = false;
                    switch (this.whiteSpaceTreatment) {
                        case 60: {
                            bIgnore = true;
                            break;
                        }
                        case 62: {
                            bIgnore = lfCheck.beforeLinefeed();
                            break;
                        }
                        case 63: {
                            bIgnore = this.afterLinefeed || lfCheck.beforeLinefeed();
                            break;
                        }
                        case 61: {
                            bIgnore = this.afterLinefeed;
                            break;
                        }
                        case 108: {
                            break;
                        }
                    }
                    if (bIgnore) {
                        this.charIter.remove();
                        break;
                    }
                    this.inWhiteSpace = true;
                    if (currentChar == 32) continue block16;
                    this.charIter.replaceChar(' ');
                    break;
                }
                case 1: {
                    switch (this.linefeedTreatment) {
                        case 60: {
                            this.charIter.remove();
                            break block0;
                        }
                        case 148: {
                            this.charIter.replaceChar('\u200b');
                            this.inWhiteSpace = false;
                            break block0;
                        }
                        case 108: {
                            lfCheck.reset();
                            this.inWhiteSpace = false;
                            this.afterLinefeed = true;
                            break block0;
                        }
                    }
                    break;
                }
                default: {
                    this.inWhiteSpace = false;
                    this.afterLinefeed = false;
                    ++this.nonWhiteSpaceCount;
                    lfCheck.reset();
                }
            }
        }
    }

    private void addPendingInline(FObjMixed fo) {
        if (this.pendingInlines == null) {
            this.pendingInlines = new ArrayList(5);
        }
        this.pendingInlines.add(new PendingInline(fo, this.firstWhiteSpaceInSeq));
    }

    private class PendingInline {
        protected FObjMixed fo;
        protected CharIterator firstTrailingWhiteSpace;

        PendingInline(FObjMixed fo, CharIterator firstTrailingWhiteSpace) {
            this.fo = fo;
            this.firstTrailingWhiteSpace = firstTrailingWhiteSpace;
        }
    }

    private class EOLchecker {
        private boolean nextIsEOL = false;
        private RecursiveCharIterator charIter;

        EOLchecker(CharIterator charIter) {
            this.charIter = (RecursiveCharIterator)charIter;
        }

        boolean beforeLinefeed() {
            if (!this.nextIsEOL) {
                CharIterator lfIter = this.charIter.mark();
                while (lfIter.hasNext()) {
                    int charClass = CharUtilities.classOf(lfIter.nextChar());
                    if (charClass == 1) {
                        if (XMLWhiteSpaceHandler.this.linefeedTreatment != 108) continue;
                        this.nextIsEOL = true;
                        return this.nextIsEOL;
                    }
                    if (charClass == 4) continue;
                    return this.nextIsEOL;
                }
                this.nextIsEOL = XMLWhiteSpaceHandler.this.nextChildIsBlockLevel || XMLWhiteSpaceHandler.this.endOfBlock;
            }
            return this.nextIsEOL;
        }

        void reset() {
            this.nextIsEOL = false;
        }
    }
}

