/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.hwp;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.poi.util.LittleEndian;
import org.apache.tika.io.IOUtils;

public class HwpStreamReader {
    private byte[] skipBuffer = new byte[4096];
    private InputStream input;
    private byte[] buf;

    public HwpStreamReader(InputStream inputStream) {
        this.input = inputStream;
        this.buf = new byte[4];
    }

    public short uint8() throws IOException {
        int read = org.apache.poi.util.IOUtils.readFully((InputStream)this.input, (byte[])this.buf, (int)0, (int)1);
        if (read == -1) {
            return -1;
        }
        return LittleEndian.getUByte((byte[])this.buf);
    }

    public int uint16() throws IOException {
        int read = org.apache.poi.util.IOUtils.readFully((InputStream)this.input, (byte[])this.buf, (int)0, (int)2);
        if (read == -1) {
            return -1;
        }
        if (read < 2) {
            throw new EOFException();
        }
        return LittleEndian.getUShort((byte[])this.buf);
    }

    public int[] uint16(int i) throws IOException {
        if (i <= 0) {
            throw new IllegalArgumentException();
        }
        byte[] buf = new byte[i * 2];
        int read = org.apache.poi.util.IOUtils.readFully((InputStream)this.input, (byte[])buf, (int)0, (int)(i * 2));
        if (read != i * 2) {
            throw new EOFException();
        }
        int[] uints = new int[i];
        for (int ii = 0; ii < i; ++ii) {
            uints[ii] = LittleEndian.getUShort((byte[])buf, (int)(ii * 2));
        }
        return uints;
    }

    public long uint32() throws IOException {
        int read = org.apache.poi.util.IOUtils.readFully((InputStream)this.input, (byte[])this.buf, (int)0, (int)4);
        if (read == -1) {
            return -1L;
        }
        if (read < 4) {
            throw new EOFException();
        }
        return LittleEndian.getUInt((byte[])this.buf);
    }

    public void ensureSkip(long n) throws IOException {
        long skipped = IOUtils.skip((InputStream)this.input, (long)n, (byte[])this.skipBuffer);
        if (skipped != n) {
            throw new EOFException();
        }
    }
}

