/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.library.common.task.local.output;

import com.google.common.base.Preconditions;
import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.LocalDirAllocator;
import org.apache.hadoop.fs.Path;
import org.apache.tez.runtime.library.common.shuffle.ShuffleUtils;
import org.apache.tez.runtime.library.common.task.local.output.TezTaskOutput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class TezTaskOutputFiles
extends TezTaskOutput {
    private static final Logger LOG = LoggerFactory.getLogger(TezTaskOutputFiles.class);
    private static final String SPILL_FILE_DIR_PATTERN = "%s_%d";
    private static final String SPILL_FILE_PATTERN = "%s_src_%d_spill_%d.out";
    private final LocalDirAllocator lDirAlloc = new LocalDirAllocator("tez.runtime.framework.local.dirs");

    public TezTaskOutputFiles(Configuration conf, String uniqueId, int dagID) {
        super(conf, uniqueId, dagID);
    }

    private Path getAttemptOutputDir() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("getAttemptOutputDir: output/" + this.uniqueId);
        }
        String dagPath = this.getDagOutputDir("output");
        return new Path(dagPath, this.uniqueId);
    }

    @Override
    public Path getOutputFileForWrite(long size) throws IOException {
        Path attemptOutput = new Path(this.getAttemptOutputDir(), "file.out");
        return this.lDirAlloc.getLocalPathForWrite(attemptOutput.toString(), size, this.conf);
    }

    @Override
    public Path getOutputFileForWrite() throws IOException {
        Path attemptOutput = new Path(this.getAttemptOutputDir(), "file.out");
        return this.lDirAlloc.getLocalPathForWrite(attemptOutput.toString(), this.conf);
    }

    @Override
    public Path getOutputFileForWriteInVolume(Path existing) {
        Preconditions.checkArgument((existing.getParent().getParent() != null ? 1 : 0) != 0, (Object)"Parent directory's parent can not be null");
        Path attemptDir = new Path(existing.getParent().getParent(), this.uniqueId);
        return new Path(attemptDir, "file.out");
    }

    @Override
    public Path getOutputIndexFileForWrite(long size) throws IOException {
        Path attemptIndexOutput = new Path(this.getAttemptOutputDir(), "file.out.index");
        return this.lDirAlloc.getLocalPathForWrite(attemptIndexOutput.toString(), size, this.conf);
    }

    @Override
    public Path getOutputIndexFileForWriteInVolume(Path existing) {
        Preconditions.checkArgument((existing.getParent().getParent() != null ? 1 : 0) != 0, (Object)"Parent directory's parent can not be null");
        Path attemptDir = new Path(existing.getParent().getParent(), this.uniqueId);
        return new Path(attemptDir, "file.out.index");
    }

    @Override
    public Path getSpillFileForWrite(int spillNumber, long size) throws IOException {
        Preconditions.checkArgument((spillNumber >= 0 ? 1 : 0) != 0, (Object)("Provide a valid spill number " + spillNumber));
        String dagPath = this.getDagOutputDir("output");
        Path taskAttemptDir = new Path(dagPath, String.format(SPILL_FILE_DIR_PATTERN, this.uniqueId, spillNumber));
        Path outputDir = new Path(taskAttemptDir, "file.out");
        return this.lDirAlloc.getLocalPathForWrite(outputDir.toString(), size, this.conf);
    }

    @Override
    public Path getSpillIndexFileForWrite(int spillNumber, long size) throws IOException {
        Preconditions.checkArgument((spillNumber >= 0 ? 1 : 0) != 0, (Object)("Provide a valid spill number " + spillNumber));
        String dagPath = this.getDagOutputDir("output");
        Path taskAttemptDir = new Path(dagPath, String.format(SPILL_FILE_DIR_PATTERN, this.uniqueId, spillNumber));
        Path outputDir = new Path(taskAttemptDir, "file.out.index");
        return this.lDirAlloc.getLocalPathForWrite(outputDir.toString(), size, this.conf);
    }

    @Override
    public Path getInputFileForWrite(int srcIdentifier, int spillNum, long size) throws IOException {
        String dagPath = this.getDagOutputDir(this.getSpillFileName(srcIdentifier, spillNum));
        return this.lDirAlloc.getLocalPathForWrite(dagPath, size, this.conf);
    }

    @Override
    public String getSpillFileName(int srcId, int spillNum) {
        return String.format(SPILL_FILE_PATTERN, this.uniqueId, srcId, spillNum);
    }

    private String getDagOutputDir(String child) {
        return ShuffleUtils.isTezShuffleHandler(this.conf) ? this.dagId.concat(child) : child;
    }
}

