/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.yarn.security;

import java.io.DataInputStream;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.spark.SparkConf;
import org.apache.spark.deploy.SparkHadoopUtil$;
import org.apache.spark.deploy.yarn.config.package$;
import org.apache.spark.deploy.yarn.security.ConfigurableCredentialManager;
import org.apache.spark.deploy.yarn.security.CredentialUpdater$;
import org.apache.spark.internal.Logging;
import org.apache.spark.util.ThreadUtils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015c!B\u0001\u0003\u0001!q!!E\"sK\u0012,g\u000e^5bYV\u0003H-\u0019;fe*\u00111\u0001B\u0001\tg\u0016\u001cWO]5us*\u0011QAB\u0001\u0005s\u0006\u0014hN\u0003\u0002\b\u0011\u00051A-\u001a9m_fT!!\u0003\u0006\u0002\u000bM\u0004\u0018M]6\u000b\u0005-a\u0011AB1qC\u000eDWMC\u0001\u000e\u0003\ry'oZ\n\u0004\u0001=)\u0002C\u0001\t\u0014\u001b\u0005\t\"\"\u0001\n\u0002\u000bM\u001c\u0017\r\\1\n\u0005Q\t\"AB!osJ+g\r\u0005\u0002\u001735\tqC\u0003\u0002\u0019\u0011\u0005A\u0011N\u001c;fe:\fG.\u0003\u0002\u001b/\t9Aj\\4hS:<\u0007\u0002\u0003\u000f\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0010\u0002\u0013M\u0004\u0018M]6D_:47\u0001\u0001\t\u0003?\u0001j\u0011\u0001C\u0005\u0003C!\u0011\u0011b\u00159be.\u001cuN\u001c4\t\u0011\r\u0002!\u0011!Q\u0001\n\u0011\n!\u0002[1e_>\u00048i\u001c8g!\t)#&D\u0001'\u0015\t9\u0003&\u0001\u0003d_:4'BA\u0015\u000b\u0003\u0019A\u0017\rZ8pa&\u00111F\n\u0002\u000e\u0007>tg-[4ve\u0006$\u0018n\u001c8\t\u00115\u0002!\u0011!Q\u0001\n9\n\u0011c\u0019:fI\u0016tG/[1m\u001b\u0006t\u0017mZ3s!\ty\u0003'D\u0001\u0003\u0013\t\t$AA\u000fD_:4\u0017nZ;sC\ndWm\u0011:fI\u0016tG/[1m\u001b\u0006t\u0017mZ3s\u0011\u0015\u0019\u0004\u0001\"\u00015\u0003\u0019a\u0014N\\5u}Q!QGN\u001c9!\ty\u0003\u0001C\u0003\u001de\u0001\u0007a\u0004C\u0003$e\u0001\u0007A\u0005C\u0003.e\u0001\u0007a\u0006C\u0004;\u0001\u0001\u0007I\u0011B\u001e\u000231\f7\u000f^\"sK\u0012,g\u000e^5bYN4\u0015\u000e\\3Tk\u001a4\u0017\u000e_\u000b\u0002yA\u0011\u0001#P\u0005\u0003}E\u00111!\u00138u\u0011\u001d\u0001\u0005\u00011A\u0005\n\u0005\u000bQ\u0004\\1ti\u000e\u0013X\rZ3oi&\fGn\u001d$jY\u0016\u001cVO\u001a4jq~#S-\u001d\u000b\u0003\u0005\u0016\u0003\"\u0001E\"\n\u0005\u0011\u000b\"\u0001B+oSRDqAR \u0002\u0002\u0003\u0007A(A\u0002yIEBa\u0001\u0013\u0001!B\u0013a\u0014A\u00077bgR\u001c%/\u001a3f]RL\u0017\r\\:GS2,7+\u001e4gSb\u0004\u0003FA$K!\t\u00012*\u0003\u0002M#\tAao\u001c7bi&dW\rC\u0004O\u0001\t\u0007I\u0011B(\u0002\u001f\r\u0014X\rZ3oi&\fGn\u001d$jY\u0016,\u0012\u0001\u0015\t\u0003#Rs!\u0001\u0005*\n\u0005M\u000b\u0012A\u0002)sK\u0012,g-\u0003\u0002V-\n11\u000b\u001e:j]\u001eT!aU\t\t\ra\u0003\u0001\u0015!\u0003Q\u0003A\u0019'/\u001a3f]RL\u0017\r\\:GS2,\u0007\u0005C\u0004[\u0001\t\u0007I\u0011B.\u0002\u001f\u0019\u0014Xm\u001d5IC\u0012|w\u000e]\"p]\u001a,\u0012\u0001\n\u0005\u0007;\u0002\u0001\u000b\u0011\u0002\u0013\u0002!\u0019\u0014Xm\u001d5IC\u0012|w\u000e]\"p]\u001a\u0004\u0003bB0\u0001\u0005\u0004%I\u0001Y\u0001\u0012GJ,G-\u001a8uS\u0006dW\u000b\u001d3bi\u0016\u0014X#A1\u0011\u0005\tLW\"A2\u000b\u0005\u0011,\u0017AC2p]\u000e,(O]3oi*\u0011amZ\u0001\u0005kRLGNC\u0001i\u0003\u0011Q\u0017M^1\n\u0005)\u001c'\u0001G*dQ\u0016$W\u000f\\3e\u000bb,7-\u001e;peN+'O^5dK\"1A\u000e\u0001Q\u0001\n\u0005\f!c\u0019:fI\u0016tG/[1m+B$\u0017\r^3sA!9a\u000e\u0001b\u0001\n\u0013y\u0017!G2sK\u0012,g\u000e^5bYV\u0003H-\u0019;feJ+hN\\1cY\u0016,\u0012\u0001\u001d\n\u0004cV\\h\u0001\u0002:t\u0001A\u0014A\u0002\u0010:fM&tW-\\3oizBa\u0001\u001e\u0001!\u0002\u0013\u0001\u0018AG2sK\u0012,g\u000e^5bYV\u0003H-\u0019;feJ+hN\\1cY\u0016\u0004\u0003C\u0001<z\u001b\u00059(B\u0001=h\u0003\u0011a\u0017M\\4\n\u0005i<(AB(cU\u0016\u001cG\u000f\u0005\u0002wy&\u0011Qp\u001e\u0002\t%Vtg.\u00192mK\"1q\u0010\u0001C\u0001\u0003\u0003\tQa\u001d;beR$\u0012A\u0011\u0005\b\u0003\u000b\u0001A\u0011BA\u0001\u0003m)\b\u000fZ1uK\u000e\u0013X\rZ3oi&\fGn]%g%\u0016\fX/\u001b:fI\"9\u0011\u0011\u0002\u0001\u0005\n\u0005-\u0011AG4fi\u000e\u0013X\rZ3oi&\fGn\u001d$s_6DEIR*GS2,GCBA\u0007\u0003/\t9\u0003\u0005\u0003\u0002\u0010\u0005MQBAA\t\u0015\t\u0019\u0001&\u0003\u0003\u0002\u0016\u0005E!aC\"sK\u0012,g\u000e^5bYND\u0001\"!\u0007\u0002\b\u0001\u0007\u00111D\u0001\te\u0016lw\u000e^3GgB!\u0011QDA\u0012\u001b\t\tyBC\u0002\u0002\"!\n!AZ:\n\t\u0005\u0015\u0012q\u0004\u0002\u000b\r&dWmU=ti\u0016l\u0007\u0002CA\u0015\u0003\u000f\u0001\r!a\u000b\u0002\u0013Q|7.\u001a8QCRD\u0007\u0003BA\u000f\u0003[IA!a\f\u0002 \t!\u0001+\u0019;i\u0011\u001d\t\u0019\u0004\u0001C\u0005\u0003k\tqdZ3u)&lWm\u00144OKb$X\u000b\u001d3bi\u00164%o\\7GS2,g*Y7f)\u0011\t9$!\u0010\u0011\u0007A\tI$C\u0002\u0002<E\u0011A\u0001T8oO\"A\u0011qHA\u0019\u0001\u0004\tY#A\bde\u0016$WM\u001c;jC2\u001c\b+\u0019;i\u0011\u001d\t\u0019\u0005\u0001C\u0001\u0003\u0003\tAa\u001d;pa\u0002")
public class CredentialUpdater
implements Logging {
    private final SparkConf sparkConf;
    private volatile int org$apache$spark$deploy$yarn$security$CredentialUpdater$$lastCredentialsFileSuffix;
    private final String credentialsFile;
    private final Configuration freshHadoopConf;
    private final ScheduledExecutorService credentialUpdater;
    private final Runnable credentialUpdaterRunnable;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public int org$apache$spark$deploy$yarn$security$CredentialUpdater$$lastCredentialsFileSuffix() {
        return this.org$apache$spark$deploy$yarn$security$CredentialUpdater$$lastCredentialsFileSuffix;
    }

    public void org$apache$spark$deploy$yarn$security$CredentialUpdater$$lastCredentialsFileSuffix_$eq(int x$1) {
        this.org$apache$spark$deploy$yarn$security$CredentialUpdater$$lastCredentialsFileSuffix = x$1;
    }

    private String credentialsFile() {
        return this.credentialsFile;
    }

    private Configuration freshHadoopConf() {
        return this.freshHadoopConf;
    }

    private ScheduledExecutorService credentialUpdater() {
        return this.credentialUpdater;
    }

    private Runnable credentialUpdaterRunnable() {
        return this.credentialUpdaterRunnable;
    }

    public void start() {
        long startTime = BoxesRunTime.unboxToLong((Object)this.sparkConf.get(package$.MODULE$.CREDENTIALS_UPDATE_TIME()));
        long remainingTime = startTime - System.currentTimeMillis();
        if (remainingTime <= 0L) {
            this.credentialUpdater().schedule(this.credentialUpdaterRunnable(), 1L, TimeUnit.MINUTES);
        } else {
            this.logInfo((Function0<String>)new Serializable(this, remainingTime){
                public static final long serialVersionUID = 0L;
                private final long remainingTime$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Scheduling credentials refresh from HDFS in ", " ms."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.remainingTime$1)}));
                }
                {
                    this.remainingTime$1 = remainingTime$1;
                }
            });
            this.credentialUpdater().schedule(this.credentialUpdaterRunnable(), remainingTime, TimeUnit.MILLISECONDS);
        }
    }

    public void org$apache$spark$deploy$yarn$security$CredentialUpdater$$updateCredentialsIfRequired() {
        long l;
        try {
            Path credentialsFilePath = new Path(this.credentialsFile());
            FileSystem remoteFs = FileSystem.get((Configuration)this.freshHadoopConf());
            l = BoxesRunTime.unboxToLong((Object)Predef$.MODULE$.refArrayOps((Object[])SparkHadoopUtil$.MODULE$.get().listFilesSorted(remoteFs, credentialsFilePath.getParent(), credentialsFilePath.getName(), SparkHadoopUtil$.MODULE$.SPARK_YARN_CREDS_TEMP_EXTENSION())).lastOption().map((Function1)new Serializable(this, remoteFs){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ CredentialUpdater $outer;
                private final FileSystem remoteFs$1;

                public final long apply(FileStatus credentialsStatus) {
                    long l;
                    int suffix = SparkHadoopUtil$.MODULE$.get().getSuffixForCredentialsPath(credentialsStatus.getPath());
                    if (suffix > this.$outer.org$apache$spark$deploy$yarn$security$CredentialUpdater$$lastCredentialsFileSuffix()) {
                        this.$outer.logInfo((Function0<String>)new Serializable(this, credentialsStatus){
                            public static final long serialVersionUID = 0L;
                            private final FileStatus credentialsStatus$1;

                            public final String apply() {
                                return new StringBuilder().append((Object)"Reading new credentials from ").append((Object)this.credentialsStatus$1.getPath()).toString();
                            }
                            {
                                this.credentialsStatus$1 = credentialsStatus$1;
                            }
                        });
                        Credentials newCredentials = this.$outer.org$apache$spark$deploy$yarn$security$CredentialUpdater$$getCredentialsFromHDFSFile(this.remoteFs$1, credentialsStatus.getPath());
                        this.$outer.org$apache$spark$deploy$yarn$security$CredentialUpdater$$lastCredentialsFileSuffix_$eq(suffix);
                        UserGroupInformation.getCurrentUser().addCredentials(newCredentials);
                        this.$outer.logInfo((Function0<String>)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final String apply() {
                                return "Credentials updated from credentials file.";
                            }
                        });
                        long remainingTime = this.$outer.org$apache$spark$deploy$yarn$security$CredentialUpdater$$getTimeOfNextUpdateFromFileName(credentialsStatus.getPath()) - System.currentTimeMillis();
                        l = remainingTime <= 0L ? TimeUnit.MINUTES.toMillis(1L) : remainingTime;
                    } else {
                        l = TimeUnit.HOURS.toMillis(1L);
                    }
                    return l;
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.remoteFs$1 = remoteFs$1;
                }
            }).getOrElse((Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final long apply() {
                    return this.apply$mcJ$sp();
                }

                public long apply$mcJ$sp() {
                    return TimeUnit.MINUTES.toMillis(1L);
                }
            }));
        }
        catch (Throwable throwable) {
            long l2;
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            Throwable e = (Throwable)option.get();
            this.logWarning((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Error while trying to update credentials, will try again in 1 hour";
                }
            }, e);
            l = l2 = TimeUnit.HOURS.toMillis(1L);
        }
        long timeToNextUpdate = l;
        this.logInfo((Function0<String>)new Serializable(this, timeToNextUpdate){
            public static final long serialVersionUID = 0L;
            private final long timeToNextUpdate$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Scheduling credentials refresh from HDFS in ", " ms."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.timeToNextUpdate$1)}));
            }
            {
                this.timeToNextUpdate$1 = timeToNextUpdate$1;
            }
        });
        this.credentialUpdater().schedule(this.credentialUpdaterRunnable(), timeToNextUpdate, TimeUnit.MILLISECONDS);
    }

    public Credentials org$apache$spark$deploy$yarn$security$CredentialUpdater$$getCredentialsFromHDFSFile(FileSystem remoteFs, Path tokenPath) {
        FSDataInputStream stream = remoteFs.open(tokenPath);
        try {
            Credentials newCredentials = new Credentials();
            newCredentials.readTokenStorageStream((DataInputStream)stream);
            return newCredentials;
        }
        finally {
            stream.close();
        }
    }

    public long org$apache$spark$deploy$yarn$security$CredentialUpdater$$getTimeOfNextUpdateFromFileName(Path credentialsPath) {
        String name = credentialsPath.getName();
        int index = name.lastIndexOf(SparkHadoopUtil$.MODULE$.SPARK_YARN_CREDS_COUNTER_DELIM());
        String slice = name.substring(0, index);
        int last2index = slice.lastIndexOf(SparkHadoopUtil$.MODULE$.SPARK_YARN_CREDS_COUNTER_DELIM());
        return new StringOps(Predef$.MODULE$.augmentString(name.substring(last2index + 1, index))).toLong();
    }

    public void stop() {
        this.credentialUpdater().shutdown();
    }

    public CredentialUpdater(SparkConf sparkConf, Configuration hadoopConf, ConfigurableCredentialManager credentialManager) {
        this.sparkConf = sparkConf;
        Logging.class.$init$((Logging)this);
        this.org$apache$spark$deploy$yarn$security$CredentialUpdater$$lastCredentialsFileSuffix = 0;
        this.credentialsFile = (String)sparkConf.get(package$.MODULE$.CREDENTIALS_FILE_PATH());
        this.freshHadoopConf = SparkHadoopUtil$.MODULE$.get().getConfBypassingFSCache(hadoopConf, new Path(this.credentialsFile()).toUri().getScheme());
        this.credentialUpdater = Executors.newSingleThreadScheduledExecutor(ThreadUtils$.MODULE$.namedThreadFactory("Credential Refresh Thread"));
        this.credentialUpdaterRunnable = new $anon$1(this);
    }
}

